<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<fmt:bundle basename="localization.DRBackupMessages">
	<table id="browsetable" class="fsdata tablesorter" dt-options="dtOptions" dt-columns="dtColumns">
		<thead id="filetablehead">
			<tr id="browsetableheaderrow">
				<th ng-click="sort('name')" class="col-name"><fmt:message key="tableColumn.name" />
					<span class="glyphicon sort-icon" ng-show="sortKey=='name'" ng-class="{'glyphicon-chevron-down':reverse,'glyphicon-chevron-up':!reverse}"></span>
				</th>
				<th ng-click="sort('timestamp_modified')" class="col-modified"><fmt:message key="tableColumn.modified" />
					<span class="glyphicon sort-icon" ng-show="sortKey=='timestamp_modified'" ng-class="{'glyphicon-chevron-down':reverse,'glyphicon-chevron-up':!reverse}"></span>
				</th>
				<th ng-click="sort('size_bytes')" class="col-size borderless" width='20%'><fmt:message key="tableColumn.size" />
					<span class="glyphicon sort-icon" ng-show="sortKey=='size_bytes'" ng-class="{'glyphicon-chevron-down':reverse,'glyphicon-chevron-up':!reverse}"></span>
				</th>
				<th ng-if="view == SET_VIEW" class="col-size borderless" width='10%'>Actions
				</th>
			</tr>
		</thead>
		<tbody id="filetablebody">
			<tr ng-class="{'row-disabled': (view == FILE_VIEW && !data.access)}" dir-paginate = "data in tableData|orderBy:sortKey:reverse|filter:{name: search}|itemsPerPage:15">
				<td ng-click="(view == FILE_VIEW && !data.access)||go(data.id)" class="file-link">
					<span ng-if="view == COMPANY_VIEW || view == SET_VIEW || view == COMMCELL_VIEW" class="svg-icon">					
						<svg class="svg-icon" width="64px" height="64px" viewBox="0 0 64 64" xmlns="http://www.w3.org/2000/svg">
							<path d="M28.4087,12.1318l-4.771-6.5728l-0.4058-0.5596H1V59h62V12.1318H28.4087z M60.9336,14.1704v5.0938H33.5869l-3.6982-5.0938
								H60.9336z M3.0664,56.9619V7.0381h19.1011l5.167,7.1323h0.0122l4.8462,6.6738c0.2017,0.2783,0.5181,0.4248,0.8403,0.4268v0.0317
								h27.9004v35.6592H3.0664z"/>
						</svg>
					</span>
					<span ng-if="view == FILE_VIEW" class="icon-file">
						<svg class="svg-icon" width="64px" height="64px" viewBox="0 0 64 64" xmlns="http://www.w3.org/2000/svg">
							<g>
								<path d="M45.2988,23.4668H18.7021c-0.5874,0-1.064,0.4766-1.064,1.0664s0.4766,1.0669,1.064,1.0669h26.5967
									c0.5859,0,1.0635-0.4771,1.0635-1.0669S45.8848,23.4668,45.2988,23.4668z"/>
								<path d="M18.7021,17.0669h10.6387c0.5869,0,1.0635-0.4771,1.0635-1.0669s-0.4766-1.0664-1.0635-1.0664H18.7021
									c-0.5874,0-1.064,0.4766-1.064,1.0664S18.1147,17.0669,18.7021,17.0669z"/>
								<path d="M45.2988,32H18.7021c-0.5874,0-1.064,0.4766-1.064,1.0664s0.4766,1.0664,1.064,1.0664h26.5967
									c0.5859,0,1.0635-0.4766,1.0635-1.0664S45.8848,32,45.2988,32z"/>
								<path d="M45.2988,40.5332H18.7021c-0.5874,0-1.064,0.4766-1.064,1.0664s0.4766,1.0664,1.064,1.0664h26.5967
									c0.5859,0,1.0635-0.4766,1.0635-1.0664S45.8848,40.5332,45.2988,40.5332z"/>
								<path d="M45.2988,49.0664H18.7021c-0.5874,0-1.064,0.4766-1.064,1.0664s0.4766,1.0674,1.064,1.0674h26.5967
									c0.5859,0,1.0635-0.4775,1.0635-1.0674S45.8848,49.0664,45.2988,49.0664z"/>
								<path d="M41.4824,0H7v64h50V15.5586L41.4824,0z M42.1055,3.6416l11.2637,11.292H42.1055V3.6416z M9.1279,61.8672V2.1333h30.8506
									v14.9336H54.873v44.8003H9.1279z"/>
							</g>
						</svg>
					</span>
					<span ng-if="view == FILE_VIEW" class="icon-download">	
						<svg class="svg-icon" width="64px" height="64px" viewBox="0 0 64 64" xmlns="http://www.w3.org/2000/svg">
							<path fill="#1E201D" d="M48.4629,33.4434c0.6816-0.6787,0.6816-1.7476,0-2.4263c-0.6582-0.6792-1.7539-0.6792-2.4102,0
								L33.7061,43.2959V2.7231C33.7061,1.7769,32.9512,1,32.0015,1s-1.729,0.7769-1.729,1.7231v40.5728L17.9502,31.0171
								c-0.6812-0.6792-1.7783-0.6792-2.4351,0c-0.6812,0.6787-0.6812,1.7476,0,2.4263l15.2695,15.2158
								c0.6582,0.6553,1.7544,0.6553,2.4351,0L48.4629,33.4434z M60.5664,44.582c0-0.9463,0.7549-1.6982,1.7051-1.6982
								c0.9492,0,1.7285,0.752,1.7285,1.6982v16.6953C64,62.2236,63.2207,63,62.2715,63H1.7046C0.7549,63,0,62.2236,0,61.2773V44.582
								c0-0.9463,0.7549-1.6982,1.7046-1.6982s1.729,0.752,1.729,1.6982v14.9961h57.1328V44.582z"/>
						</svg>
					</span>
					<span class="file" ng-attr-title="{{data.name}}">
						<a><span ng-bind="data.name"></span></a>
						<md-tooltip ng-show="view == FILE_VIEW && data.access_value == access_status.NO_ACCESS" md-direction="top" md-delay="100" md-autohide><fmt:message key="tooltip.must_request" /></md-tooltip>
						<md-tooltip ng-show="view == FILE_VIEW && data.access_value == access_status.SUBMITTED" md-direction="top" md-delay="100" md-autohide><fmt:message key="tooltip.request_submitted" /></md-tooltip>
					</span>
				</td>
				<td class="table-column"><span ng-bind="data.time_modified"></span></td>
				<td class="table-column"><span ng-bind="data.size"></span></td>
				<td ng-if="view == SET_VIEW" class="table-column">
					<span class="grid-action-icon">
						<md-menu md-position-mode="target-left bottom">
							<svg ng-class="{'open': $mdMenuIsOpen}" ng-click="$mdMenu.open($event)" xmlns="http://www.w3.org/2000/svg" version="1.1" x="0" y="0" viewBox="0 0 20 20" xml:space="preserve">
								<path d="M10.1 0C4.6-0.1 0.1 4.4 0 9.9s4.4 10 9.9 10.1 10-4.4 10.1-9.9c0-0.1 0-0.1 0-0.2C19.9 4.5 15.5 0.1 10.1 0zM10.1 18.9c-5 0-9-4-9-9s4-9 9-9 9 4 9 9S15.1 18.9 10.1 18.9L10.1 18.9z"></path>
								<rect x="6.1" y="8.8" width="2" height="2"></rect><rect x="9.1" y="8.8" width="2" height="2"></rect>
								<rect x="12.1" y="8.8" width="2" height="2"></rect>
							</svg>
							<md-menu-content class="md-dense">
							  <md-menu-item ng-show="!rawData.is_approver">
								<md-button ng-click="showRequestPrompt($event, data)"><span
									md-menu-align-target><fmt:message key="menuItem.request_access" /></span>
								</md-button>
							  </md-menu-item>
							  <md-menu-item ng-show="rawData.is_approver">
								<md-button ng-click="showViewRequestsPrompt($event, data)"><span
									md-menu-align-target><fmt:message key="menuItem.view_requests" /></span>
								</md-button>
							  </md-menu-item>
							  <md-menu-item ng-show="rawData.is_approver">
								<md-button ng-click="showHistoryPrompt($event, data)"><span
									md-menu-align-target><fmt:message key="menuItem.access_history" /></span>
								</md-button>
							  </md-menu-item>
							</md-menu-content>
						  </md-menu>
					</span>
				</td>
			</tr>
			<tr ng-show="tableData=='undefined' || tableData=='null' || tableData.length==0" class="no-data">
				<td ng-attr-colspan="{{ view == SET_VIEW ? 4: 3 }}">
					<fmt:message key="notification.noData" />
				</td>
			</tr>
		</tbody>
	</table>
</fmt:bundle>

