
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<jsp:include page="../../common/header.jsp">
	<jsp:param value="Commvault Endpoint Protection Trial" name="titleLocalized" />
	<jsp:param value="${pageContext.request.contextPath}/common/css/headerstyles.css" name="css" />
	<jsp:param value="${pageContext.request.contextPath}/cloud/trials/css/demos-and-trials.css" name="css" />
</jsp:include>

<div class="solution-headline ">
	<div class="container enpoint-headlines-container">
		<div class="row">
			<h1>Try Endpoint Protection</h1>
			<p><p>Commvault protects your data, wherever you store it, with secure, efficient backup and recovery. We help you gain control of endpoint data on laptops, desktops, and other devices with source-side deduplication, opportunistic scheduling, and bandwidth throttling.</p>
		</div>
	</div>
</div>

<div class="highlights">
	<div class="container enpoint-highlights">
		<div class="row same-size">
			<div class="col-h-4">
				<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 257 212.3"><title>Data Cloud</title><path class="blue" d="M217.7,147.2H39.3a39.3,39.3,0,0,1-5.1-78.3,39.4,39.4,0,0,1,39.3-38h2a59,59,0,0,1,102.9-1.5A40.8,40.8,0,0,1,190,27.7a41.5,41.5,0,0,1,41.4,41.4q0,.9,0,1.8a39.3,39.3,0,0,1-13.7,76.2ZM39.3,82.1a25.7,25.7,0,1,0,0,51.5H217.7a25.7,25.7,0,0,0,8-50.2l-2.7-.3a6.8,6.8,0,0,1-5.8-8.2,27.8,27.8,0,0,0-39-30.9,6.8,6.8,0,0,1-9.1-3.4,45.4,45.4,0,0,0-83.2.3,6.8,6.8,0,0,1-7.5,4A25.7,25.7,0,0,0,47.8,70.2a26.2,26.2,0,0,0,.4,4.2A6.8,6.8,0,0,1,41,82.2H39.3Z"/><path class="gray" d="M235.4,174.5l-19.7-20.1a6.8,6.8,0,0,0-9.6-.1,6.3,6.3,0,0,0-.1,9.2l8.6,8.4H193V92.7a7,7,0,0,0-14,0v86.9c0,3.8,3.4,6.4,7.2,6.4h27.7l-8.5,8.7a6.9,6.9,0,0,0,0,9.7,6.8,6.8,0,0,0,4.8,2,6.8,6.8,0,0,0,4.8-2l20.4-20.4A6.8,6.8,0,0,0,235.4,174.5Z"/><path class="gray" d="M77,85.9a7,7,0,0,0-7,6.8V172H48.6l8.6-8.4a6.6,6.6,0,0,0-.1-9.4,6.8,6.8,0,0,0-9.6.2L27.8,174.5a6.8,6.8,0,0,0,0,9.6l20.4,20.4a6.8,6.8,0,0,0,9.6,0,7,7,0,0,0,0-9.8L49.3,186H77c3.8,0,7-2.7,7-6.4V92.7A7,7,0,0,0,77,85.9Z"/><path class="gray" d="M146.6,180.3l-8.6,8.5V91.4a6.5,6.5,0,1,0-13,0v98.1l-9-8.6a7,7,0,0,0-9.7.1,6.8,6.8,0,0,0,0,9.6l20,19.7a6.8,6.8,0,0,0,9.6,0l20.4-20.4a6.8,6.8,0,0,0-9.7-9.6Z"/></svg>
				<h6>Unbeatable Performance</h6>
				<p>Throughput rates that outstrip other solutions</p>
			</div>
			<div class="col-h-4">
				<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 168.6 154.8" class="icon"><title>Real Time Capturing</title><path class="blue" d="M77.9,101.3a6.8,6.8,0,0,1-4.8-2L42,68.2a6.8,6.8,0,1,1,9.6-9.6L77.9,84.9l79-79a6.8,6.8,0,1,1,9.6,9.6L82.7,99.3A6.8,6.8,0,0,1,77.9,101.3Z" transform="translate(0)"/><path class="gray" d="M154.9,77.8a6.7,6.7,0,0,0-.1-.9,77.4,77.4,0,0,0-3.1-21.2,6.8,6.8,0,0,0-8.4-4.6c-3.6,1.1-5.7,4.3-4.6,7.9a77.2,77.2,0,0,1,2.2,11H122.5a7,7,0,0,0,0,14h18.3c-3.4,30-27.8,54.1-58.8,56.9V121a6.5,6.5,0,1,0-13,0v19.7C40,137.3,17.3,114,14,84H33.1a7,7,0,0,0,0-14H13.9A63.2,63.2,0,0,1,69,14.1V32.4a6.5,6.5,0,1,0,13,0V13.9a62.9,62.9,0,0,1,31.8,11.5,7.2,7.2,0,0,0,9.8-1.6,6.8,6.8,0,0,0-1.4-9.5A76.6,76.6,0,0,0,77.3,0h-1a77.4,77.4,0,1,0,78.5,79A6.8,6.8,0,0,0,154.9,77.8Z" transform="translate(0)"/></svg>
				<h6>Comprehensive Protection</h6>
				<p>Backup, archive, and recovery for all of your data, on any device</p>
			</div>
			<div class="col-h-4">
				<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 156.7 190.7"><title>Shield</title><path class="blue" d="M78,190.7a6.8,6.8,0,0,1-2.3-.4c-36.4-6.2-61-32.1-70.9-74.9C-2.5,83.8.7,54.3.8,53a6.8,6.8,0,0,1,6.3-6C37,44.9,64.9,13,71.5,4.9a7.2,7.2,0,0,1,13.7,0c6.6,8.1,34.6,40,64.4,42.1a6.8,6.8,0,0,1,6.3,6c.1,1.2,3.3,30.7-4,62.4-10,42.9-34.5,68.8-71.1,74.9a6.7,6.7,0,0,1-2.4.4ZM13.9,59.9c-.5,9.6-.9,30.9,4.2,52.8C27,150.1,47.2,171.8,78.4,177c31.1-5.2,51.4-26.8,60.2-64.3,5.1-21.8,4.8-43.2,4.2-52.8-28.7-4.9-53.5-29.5-64.4-42C67.4,30.4,42.6,55,13.9,59.9Z" transform="translate(0 0)"/><path class="gray" d="M39,138.6a6.8,6.8,0,0,1-3.8-12.5l91.5-61.2a6.8,6.8,0,0,1,7.6,11.3L42.8,137.4A6.8,6.8,0,0,1,39,138.6Z" transform="translate(0 0)"/></svg>
				<h6>Certified Secure</h6>
				<p>Protect your data with a secure, certified solution that provides optimum data durability</p>
			</div>
			<div class="col-h-4">
				<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 160.6 112.6"><title>Speedometer</title><path class="blue" d="M77.5,110.9a6.8,6.8,0,0,1-6.1-9.7L96.8,47.1a6.8,6.8,0,0,1,12.3,5.8L83.6,107A6.8,6.8,0,0,1,77.5,110.9Z"/><path class="gray" d="M80.3,0A80.4,80.4,0,0,0,3.9,105.2,6.8,6.8,0,0,0,16.9,101a66.7,66.7,0,0,1-2.2-32.5l16.9,4.2,1.6.2a6.8,6.8,0,0,0,1.6-13.4l-16.5-4A66.6,66.6,0,0,1,73,14V31.1a7,7,0,0,0,14,0V13.9a67.4,67.4,0,0,1,55.7,42.4L124.3,65a6.8,6.8,0,0,0,2.9,13,6.7,6.7,0,0,0,2.9-.7l16.1-7.6a66.8,66.8,0,0,1-3.3,33.8,6.8,6.8,0,1,0,12.8,4.7A80.4,80.4,0,0,0,80.3,0Z"/></svg>
				<h6>Total Access</h6>
				<p>Retrieve data and share files on any device, at any time</p>
			</div>
		</div>

	</div>

</div>

<div class="config-container ">
	<div class="container enpoint-config-container solution-center-blue">
		<div class="row">
			<div class="grid-header">
				<h3>Select a Trial Method</h3>
			</div>
		</div>
		<div class="row same-size">
	    	<div class="col-sm-4 configuration-endpoint" >
	        	<img class="img-responsive" src="img/endpoint-protection_image_1.jpg">
	        	<h5>Our Data, Our Server</h5>
	        	<p>Explore Endpoint Data Protection in a preconfigured environment by logging on to our demo site.</p>
	        	<span class="button freetrial showcase" data-sfdc="70140000001217J" data-trial="showcase" >Try Now</span>
	      	</div>
	      	<div class="col-sm-4 configuration-endpoint" >
		        <img class="img-responsive" src="img/endpoint-protection_image_2.jpg">
		        <h5>Your Data, Our Server</h5>
		        <p>Install Endpoint Data Protection on your device and backup your data to our cloud for free with our 30-day trial.</p>
		        <span class="button freetrial cloud" data-sfdc="70140000001217O" data-trial="cloud">Try Now</span>
		    </div>
		    <div class="col-sm-4 configuration-endpoint" >
		        <img class="img-responsive" src="img/endpoint-protection_image_3.jpg">
		        <h5>Your Data, Your Server</h5>
		        <p>Install Endpoint Data Protection on your premises and protect your endpoint data in a private environment for free with our 30-day trial.</p>
		        <span class="button freetrial inhouse" data-sfdc="70140000001217T" data-trial="inhouse">Try Now</span>
		    </div>
		    <div class="col-sm-4 configuration-endpoint" >
		        <img class="img-responsive" src="img/endpoint-protection_image_4.jpg">
		        <h5>Your Data, Your New Server</h5>
		        <p>Install Endpoint Data Protection on your premises with new server and protect your endpoint data in a private environment for free with our 30-day trial.</p>
		        <span class="button freetrial inhouse-server" data-sfdc="70140000001217T" data-trial="inhouse-server">Try Now</span>
		    </div>
	    </div>
	</div>
</div>

<jsp:include page="trial-thank-you.jsp" />

<jsp:include page="../../common/footer.jsp">
	<jsp:param value="${pageContext.request.contextPath}/cloud/trials/js/trials.js" name="js"/>
</jsp:include>