(function(trialsExports) {

	'user strict';

	var commUniId = cvUtil.getParameter('commUniId', 0);
	var respType = {
		UNKNOWN_RESP : 0,
		EMPTY_RESP : 1,
		GENERIC_RESP : 2,
		WORKFLOW_RESP : 3
	};

	function init() {

		$(".virtualization").on('click', function(e) {
			e.stopPropagation();
			submitVirtualizationTrial();
		});

		$(".freetrial").click(function() {
			var trialType = $(this).data("trial");
			var salesForceId = $(this).data("sfdc");
			submitEndpointTrial(trialType, salesForceId);
		});
	}

	function submitVirtualizationTrial() {
		$(".virtualization").addClass('disabled');
		$(".virtualization").text('Processing...');

		var params = {};
		params.commUniId = commUniId;

		var configURL = cvUtil.getContextPath() + '/cloud/trials/processVirtualizationTrail.do';
		cvUtil.loadPageWithPOST(configURL, params, function(resp) {
			if (resp.respType === respType.EMPTY_RESP) {
				cvUtil.errorToast(resp.errorMessage);
			} else if (resp.respType === respType.GENERIC_RESP) {
				if (resp.errorCode > 0) {
					cvUtil.errorToast(resp.errorMessage);
				} else {
					showThankyou();
				}
			} else if (resp.respType === respType.WORKFLOW_RESP) {
				if (resp.status === 4) {
					showThankyou();
				} else {
					cvUtil.errorToast(resp.errorMessage);
				}
			} else if (resp.respType === respType.UNKNOWN_RESP) {
				var xmlDoc = $.trim(resp.resp);
				var xml = $.parseXML(xmlDoc);
				$xml = $(xml);
				$erCode = $xml.find('CVGui_GenericResp').attr('errorCode');
				$erMsg = $xml.find('CVGui_GenericResp').attr('errorMessage');
				if (parseInt($erCode) > 0) {
					cvUtil.errorToast($erMsg);
				}
			}
			$(".virtualization").removeClass('disabled');
			$(".virtualization").text('Try Now');
		}, function(err) {
			console.log(err);
			cvUtil.errorToast(err.responseText);
			$(".virtualization").removeClass('disabled');
			$(".virtualization").text('Try Now');
		});
	}

	function submitEndpointTrial(trialType, salesForceId) {
		$(".freetrial").addClass('disabled');
		$("." + trialType).text('Processing...');
		var params = {};
		params.commUniId = commUniId;
		params.salesForceId = salesForceId;
		if (trialType === 'inhouse-server') {
			params.trialType = 'inhouse';
		} else {
			params.trialType = trialType;
		}

		var configURL = cvUtil.getContextPath() + '/cloud/trials/processEndPointTrail.do';
		cvUtil.loadPageWithPOST(configURL, params, function(resp) {
			if (resp.respType === respType.EMPTY_RESP) {
				cvUtil.errorToast(resp.errorMessage);
			} else if (resp.respType === respType.GENERIC_RESP) {
				if (resp.errorCode > 0) {
					cvUtil.errorToast(resp.errorMessage);
				} else {
					showThankyou();
				}
			} else if (resp.respType === respType.WORKFLOW_RESP) {
				if (resp.status === 4) {
					showThankyou();
				} else {
					cvUtil.errorToast(resp.errorMessage);
				}
			} else if (resp.respType === respType.UNKNOWN_RESP) {
				var xmlDoc = $.trim(resp.resp);
				var xml = $.parseXML(xmlDoc);
				$xml = $(xml);
				$erCode = $xml.find('CVGui_GenericResp').attr('errorCode');
				$erMsg = $xml.find('CVGui_GenericResp').attr('errorMessage');
				if (parseInt($erCode) > 0) {
					cvUtil.errorToast($erMsg);
				}
			}

			$(".freetrial").removeClass('disabled');
			$("." + trialType).text('Try Now');
		}, function(err) {
			console.log(err);
			cvUtil.errorToast(err.responseText);
			$(".freetrial").removeClass('disabled');
			$("." + trialType).text('Try Now');
		});
	}

	function showThankyou() {
		$("#thankyou-container").show();
		$("#thankyou-dialog").dialog({
			width : "40%",
			modal : true,
			resizable : false,
			open : function() {
				jQuery('.ui-widget-overlay').bind('click', function() {
					jQuery('#thankyou-dialog').dialog('close');
				});
			}
		});
		$('.close-button').on('click', function() {
			$("#thankyou-dialog").dialog("close");
		});
		$('.tq-ok').on('click', function() {
			$("#thankyou-dialog").dialog("close");
		});
	}

	init();

	trialsExports.trials = {};

})(window);