var tasksUtil = {};

(function(taskExports) {
	'use restrict';

	function init() {

	}

	function uploadDocuments(ccGroupId, taskId, files) {
		if (files !== undefined && files.length > 0) {
			tasksUploadMain.actualFilePath = taskId;
			tasksUploadMain.ccGroupId = ccGroupId;
			tasksUploadFile.doReStartableUpload();
			tasksUploadFile.taskUploader.onDropPrepareUploadFiles(files);
		}
	}
	init();

	taskExports.tasksUtil = {
		uploadDocuments : uploadDocuments
	};

})(window);

tasksUploadAppType.setUpFlexLayout = function() {

};

tasksUploadAppType.getUploadApi = function() {
	return "tasksFileUploadHandler.do";
};

tasksUploadAppType.getAppType = function() {
	return "SYNCFOLDER";
};

tasksUploadMain.isSyncFolderBrowse = function() {
	return true;
};
tasksUploadMain.refreshTable = function(resort) {
	console.log('Reloading documents after upload.');
};

tasksUploadMain.addUploadFilePlaceholder = function(fileInfo) {

};

tasksUploadMain.setTableBrowseSessionId = function(newBrowseSessionId) {
	if (typeof newBrowseSessionId === "undefined" || newBrowseSessionId === null) {
		tasksUploadMain.clearTableBrowseSessionId();
	} else {
		tasksUploadMain.tableBrowseSessionId = newBrowseSessionId;
		console.debug("Table browse session ID set: " + tasksUploadMain.tableBrowseSessionId);
	}
};

tasksUploadMain.setTreeBrowseSessionId = function(newBrowseSessionId) {
	if (typeof newBrowseSessionId === "undefined" || newBrowseSessionId === null) {
		tasksUploadMain.clearTreeBrowseSessionId();
	} else {
		tasksUploadMain.treeBrowseSessionId = newBrowseSessionId;
		console.debug("Tree browse session ID set: " + tasksUploadMain.treeBrowseSessionId);
	}
};
tasksUploadMain.clearTableBrowseSessionId = function() {
	tasksUploadMain.tableBrowseSessionId = null;
	tasksUploadMain.facetInfoList = null;
	tasksUploadMain.invalidatePie = true;
	console.debug("Table browse session ID cleared");
};

tasksUploadMain.clearTreeBrowseSessionId = function() {
	tasksUploadMain.treeBrowseSessionId = null;
	console.debug("Tree browse session ID cleared");
};

tasksUploadMain.clearBrowseSessionIds = function() {
	tasksUploadMain.clearTableBrowseSessionId();
	tasksUploadMain.clearTreeBrowseSessionId();
	if (task) {
		task.addTagsToAttachments();
	}
};
tasksUploadMain.onUploadFileError = function(fileItem) {
	if (task) {
		task.onUploadFileError(fileItem);
	}
};
