(function(taskUploadExports) {
	'use restrict';

	var taskUploader = null;
	var within_enter = false;
	var fileprogressMap = null;

	function init() {
		if (!!tasksUploadFeatures.uploadAvailable) {
			$("body").on("click", "#uploadLink", function(e) {
				uploadAction(e);
				e.stopPropagation();
			});

			taskUploader = new Uploader({
				target : tasksUploadAppType.getUploadApi(),
				duplicateFile : true
			});
			if (taskUploader != null && taskUploader.isSupported()) {
				taskUploader.assignBrowse($("#uploadLink"), false);
			}

			if ($(".fileProgressContainer").length == 0) {
				var contentDiv = document.createElement("DIV");
				var params = {};
				if (tasksUploadMain.isSyncFolderBrowse()) {
					params.showNoteText = true;
					params.appType = "SYNCFOLDER";
				} else {
					params.showNoteText = true;
				}
				/*
				 * $(contentDiv).load(cvUtil.getContextPath()+"/upload/fileprogress.jsp", params, function() {
				 * $("#progressContainer").append($(contentDiv).find(".fileProgressContainer")); });
				 */
			}
		}
	}

	function doReStartableUpload() {
		console.debug("Start Setting the Uploader...");
		var fullPath = tasksUploadMain.browsePath;
		var uploadQueryParams = {};

		uploadQueryParams["fullPath"] = fullPath;
		uploadQueryParams["destPath"] = fullPath;

		if (typeof tasksUploadMain.profileShareFolderId !== "undefined" &&
				tasksUploadMain.profileShareFolderId !== null && tasksUploadMain.profileShareFolderId !== "") {
			uploadQueryParams["shareFolderId"] = tasksUploadMain.profileShareFolderId;
			uploadQueryParams["clientId"] = tasksUploadMain.clientId;
			uploadQueryParams["ccGroupId"] = tasksUploadMain.ccGroupId;
		} else {
			uploadQueryParams["shareFolderId"] = (cvUtil.getParameterViaHistory("shareFolderId") != "" ? cvUtil
					.getParameterViaHistory("shareFolderId") : 0);
			uploadQueryParams["clientId"] = cvUtil.getParameterViaHistory("clientId");
		}
		if (tasksUploadMain.isSyncFolderBrowse()) {
			if (typeof tasksUploadMain.actualFilePath !== "undefined" && tasksUploadMain.actualFilePath !== null &&
					tasksUploadMain.actualFilePath !== "") {
				uploadQueryParams["actualFilePath"] = tasksUploadMain.actualFilePath;
			}
			if (typeof tasksUploadMain.parentGuid !== "undefined" && tasksUploadMain.parentGuid !== null &&
					tasksUploadMain.parentGuid !== "") {
				uploadQueryParams["guid"] = tasksUploadMain.parentGuid;
			}
		}
		if (taskUploader != null && taskUploader.isSupported()) {
			console.debug("Upload Params: " + JSON.stringify(uploadQueryParams));
			taskUploader.setOptions("query", getUploadParams(uploadQueryParams));
			taskUploader.setOptions("destinationFolder", tasksUploadMain.parentGuid);
			//If its single file share then prevent other files to be uploaded
			if (tasksUploadMain.isSingleFileShareBrowse && tasksUploadMain.browseItems.length == 1) {
				localMsg.maxFileSizeError = localMsg.fileshareOneFileError;
				localMsg.matchFileNameError = localMsg.fileshareNameError;
				taskUploader.setOptions("maxFiles", 1);
				var rowItem = tasksUploadMain.browseItems[0];
				taskUploader.setOptions("matchFileName", rowItem.name);
			}
			attachDownloadProgressBar();
		}
		console.debug("Setting the Uploader Completed.");
	}

	function getUploadParams(uploadQueryParams) {
		if (tasksUploadMain.isSyncFolderBrowse()) {
			var queryFilterParam = function(uploadFileInfo) {
				var fileProgressItem = uploadFileInfo.fileProgressItem;
				if (fileProgressItem.folderUpload != null && fileProgressItem.folderUpload) {
					var queryParams = jQuery.extend(true, {}, uploadQueryParams);
					queryParams["guid"] = null;
					if (typeof fileProgressItem.relativePath !== "undefined" &&
							fileProgressItem.relativePath !== null && fileProgressItem.relativePath !== "") {
						var filePath = queryParams["actualFilePath"];
						var relativePath = fileProgressItem.relativePath;
						if (relativePath != null && relativePath.charAt(0) !== "/") {
							relativePath = "/" + relativePath;
						}
						filePath = filePath + relativePath;
						filePath = filePath.replace(/\//g, "\\");
						var index = filePath.lastIndexOf("\\");
						if (index != null && index > 0) {
							filePath = filePath.substring(0, index);
						}
						queryParams["actualFilePath"] = filePath;
					}
					return queryParams;
				}
				return uploadQueryParams;
			};
			return queryFilterParam;
		} else {
			return uploadQueryParams;
		}
	}

	function attachDownloadProgressBar() {
		attachDownloadProgressBarListeners();
	}

	function attachDownloadProgressBarListeners() {
		if (taskUploader != null && taskUploader.isSupported()) {
			taskUploader.onEvent(taskUploader.EventEnum.UPLOAD_START, function() {
				onUploadStart();
			});

			taskUploader.onEvent(taskUploader.EventEnum.READY_FOR_UPLOAD, function() {
				onUploadReady();
			});

			taskUploader.onEvent(taskUploader.EventEnum.UPLOAD_PROGRESS, function(event, uploadProgress) {
				onUploadProgress(uploadProgress);
			});

			taskUploader.onEvent(taskUploader.EventEnum.FILE_ADDED, function(fileItem) {
				onUploadFileAdd(fileItem);
			});

			taskUploader.onEvent(taskUploader.EventEnum.FILE_ADD_ERROR, function(fileItem) {
				onUploadFileAddError(fileItem);
			});

			taskUploader.onEvent([
					taskUploader.EventEnum.FILE_UPLOAD_STARTING,
					taskUploader.EventEnum.FILE_UPLOAD_INPROGRESS,
					taskUploader.EventEnum.FILE_UPLOAD_CANCELED,
					taskUploader.EventEnum.FILE_UPLOAD_CANCEL_ERROR ], function(fileItem) {
				onProgress(fileItem);
			});

			taskUploader.onEvent(taskUploader.EventEnum.FILE_UPLOAD_COMPLETED, function(fileItem) {
				onUploadFileComplete(fileItem);
			});

			taskUploader.onEvent(taskUploader.EventEnum.FILE_UPLOAD_ERROR, function(fileItem) {
				onUploadFileError(fileItem);
			});

			taskUploader.onEvent(taskUploader.EventEnum.UPLOAD_END, function() {
				onUploadComplete();
			});
		}
	}

	function onUploadStart() {
		$("#uploadLink").addClass("disabledActions");
		fileProgress.initProgressDialog();
	}

	function onUploadFileAdd(fileItem) {
		if (typeof fileItem !== "undefined" && fileItem !== null) {
			if (fileprogressMap == null) {
				fileprogressMap = new HashMap();
			}
			fileprogressMap.put(fileItem.fileID, fileItem);
			if (fileprogressMap.size() % 50 == 0) {
				fileProgress.updateProgress(fileprogressMap);
				fileprogressMap.clear();
				delete fileprogressMap;
				fileprogressMap = null;
			}
		}
	}

	function onUploadFileAddError(fileItem) {
		if (typeof fileItem !== "undefined" && fileItem !== null) {
			if (fileprogressMap == null) {
				fileprogressMap = new HashMap();
			}
			fileprogressMap.put(fileItem.fileID, fileItem);
			fileProgress.updateProgress(fileprogressMap);
			fileprogressMap.clear();
			delete fileprogressMap;
			fileprogressMap = null;
		}
	}

	function onUploadReady() {
		if (taskUploader != null && taskUploader.isSupported()) {
			console.debug("Ready for Upload");
			fileProgress.updateProgress(fileprogressMap);
			delete fileprogressMap;
			fileprogressMap = null;
			console.debug("Starting Upload...");
			taskUploader.startUpload();
			$("#browsetable_info").hide();
		}
	}

	function onProgress(fileItem) {
		if (typeof fileItem !== "undefined" && fileItem !== null) {
			fileProgress.updateRow(fileItem);
		}
	}

	function onUploadProgress(uploadProgress) {
		if (typeof uploadProgress !== "undefined" && uploadProgress !== null) {
			fileProgress.updateHeader(uploadProgress);
		}
	}

	function onUploadFileComplete(fileItem) {
		// browseRefresh.setAutoRefresh(true);
		if (typeof fileItem !== "undefined" && fileItem !== null) {
			if (taskUploader != null && taskUploader.isSupported() &&
					taskUploader.isSameParentPath(fileItem.fileID, tasksUploadMain.browsePath)) {
				tasksUploadMain.addUploadFilePlaceholder(fileItem);
			}
			fileProgress.updateRow(fileItem);
		}
	}

	function onUploadFileError(fileItem) {
		fileProgress.updateRow(fileItem);
		tasksUploadMain.onUploadFileError(fileItem);
	}

	function onUploadComplete() {
		$("#browsetable_info").show();
		$("#uploadLink").removeClass("disabledActions");
		refreshAfterUpload();
		setTimeout(function() {
			$(".fileProgressContainer").removeClass("expanded").addClass("collapsed");
		}, 6000);
		cleanUp();
	}

	function pause(fileId) {
		if (taskUploader != null && taskUploader.isSupported()) {
			taskUploader.pause(fileId);
		}
	}

	function resume(fileId) {
		if (taskUploader != null && taskUploader.isSupported()) {
			taskUploader.resume(fileId);
		}
	}

	function cancel(fileId) {
		if (taskUploader != null && taskUploader.isSupported()) {
			console.debug("Cancelling Upload Request for " + fileId + "...");
			taskUploader.cancel(fileId);
		}
	}

	function cancelAll() {
		if (taskUploader != null && taskUploader.isSupported()) {
			console.debug("Cancelling All Upload Request...");
			taskUploader.cancelAll();
		}
	}

	function cleanUp() {
		within_enter = false;
	}

	function refreshAfterUpload() {
		if (tasksUploadMain.isSyncFolderBrowse()) {
			loadingTableMask = false;
			tasksUploadMain.clearBrowseSessionIds();
		}
		tasksUploadMain.refreshTable(true);
	}

	function isUploadsInProgress() {
		if (taskUploader != null && taskUploader.isSupported()) {
			if (taskUploader != null && taskUploader.uploadProgress != null) {
				return true;
			}
		} else {
			var uploadsInProgress = $(".uploadInProgress");
			for (var i = 0; i < uploadsInProgress.length; i++) {
				if ($(uploadsInProgress[i]).is(":visible")) {
					return true;
				}
			}
		}
	}
	init();

	taskUploadExports.tasksUploadFile = {
		taskUploader : taskUploader,
		doReStartableUpload : doReStartableUpload
	};

})(window);