<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<jsp:include page="../../common/header.jsp">
	<jsp:param value="PS_Estimator" name="title" />
	<jsp:param value="../../common/css/headerstyles.css" name="css" />
	<jsp:param value="../../cloud/pse/css/psecommon.css" name="css" />
	<jsp:param value="true" name="includeSecHeader" />
	<jsp:param value="${requestScope.OPPORTUNITY_CUSTOMER_NAME}" name="headerTitleLocalized" />
	<jsp:param value="Solution Design Tool:pse/index.jsp" name="breadCrumbValues" />
</jsp:include>

<style>
#searchDiv {
    position: absolute;
    top: 100px;
    right: 20px;
}
#searchDiv {
    width: 250px;
}

#grpSearch {
    width: 250px;
}
#searchDiv label {
    display: inline-block;
    line-height: 1.5;
    padding: 5px 0 3px 5px;
}

#closeSearch {
	width: 12px;
	height: 12px;
	position: absolute;
	right: 5px;
	background: url(../../common/css/images/ui-icons_222222_256x240.png);
	background-position: -80px -128px;
	cursor:pointer;
}

.customersForSearch select  {
	position: absolute;
    border: 1px solid #CCCCCC;
    border-radius: 4px 4px 4px 4px;
    display: block;
    margin: 0 10px;
    width: 250px;

}

#searchDiv .customSelection {
	text-overflow: ellipsis;
	overflow-x: hidden;
}

.customerSearch {
	padding: 5px 15px 0 5px;
	background: #f6f6f6;
	font-size: 0.875em;
	border: 1px solid #ccc;
	border-top: 0;
	box-shadow: 0 1px 8px 0px rgba(20,20,20,0.2);
	color: #888;
	width: 234px;
}

.customersForSearch li {
	width: 100%;
	padding: 5px;
	color: #333;
	cursor: pointer;
}

#searchDiv .customersForSearch label {
	width: 60px;
  	overflow-x: hidden;
	padding: 5px 0 0 5px;
}

.customersForSearch li.selectedcustomer {
	background: #ddd;
}


</style>

<div id="holder">
<div id="solutionList">

		<div class="sub-section">
			<ul class="subsec-head">
				<li><img src="../../cloud/pse/img/pse_opportunities.png" alt="allcust"></li>
				<li class="subsec-title">${requestScope.PSE_MYCUSTOMER_GRID_LABEL}</li>
			</ul>
			<div class="subsec-body clientJobs">
				<ul class="secrowhead secrows">
					<c:forEach var="items" items="${requestScope.OPPORTUNITY_GRID_COLUMNS}" varStatus="itemLoop">
					<li class="li${itemLoop.index+1}" style="width:${items.width}">${items.colLabel}</li>
					</c:forEach>
					<li class="li${itemLoop.index+1} lastright"></li>
				</ul>
				<c:choose>
				<c:when test="${fn:length(requestScope.PSE_OPPORTUNITIES) > 0}">
					<div class="browseDataRows">
						<c:forEach var="cust" items="${requestScope.PSE_OPPORTUNITIES}">
							<ul class="secrows">
								<c:forEach var="labels" items="${requestScope.OPPORTUNITY_GRID_COLUMNS}" varStatus="itemLoop">
								<c:choose>
										<c:when test='${fn:toUpperCase(labels.colLabel) != "ACTION"}'>
											<c:set var="lvalue" value="${cust[fn:toLowerCase(fn:replace(labels.colLabel,' ',''))]}" />
											<li class="li${itemLoop.index+1}" id="allcust${lvalue}" value="${cust.id}" style="width:${labels.width}" onclick="">
											<!-- <a class="someLink" title="customizations" href="/webconsole/clientDetails/fsDetails.do?clientId=2&amp;clientName=customizations">customizations</a></li>-->
											<c:choose>
												<c:when test='${fn:toUpperCase(labels.colName) == "OP_TITLE"}'>
													<c:set var="optitle" value="${lvalue}" />
									        		<a class="someLink" title="${lvalue}"
													href="<c:url value='/cloud/pse/solutionTypes.do'>
														<c:param name='title' value='${lvalue}'/>
														<c:param name='customerID' value='${requestScope.CUSTOMER_ID}'/>
														<c:param name='customerName' value='${requestScope.OPPORTUNITY_CUSTOMER_NAME}'/>
														<c:param name='itemID' value='${cust.id}'/>
														<c:param name='newItem' value='no'/>
														</c:url>">${lvalue}</a>
									    		</c:when>
												<c:otherwise>
									        		${lvalue}
									    		</c:otherwise>
											</c:choose>
											</li>
										</c:when>
										<c:otherwise>
											<li class="li${itemLoop.index+1}" id="allcust${lvalue}" value="${cust.id}" style="width:${labels.width}" onclick="">
											<c:choose>
												<c:when test='${cust.isComp == 1}'>
													
									        			<a class="someLink" title="Download" back
															href="<c:url value='/cloud/pse/solutionReportDownload.do'>
																<c:param name='solTitle' value='${optitle}'/>
																<c:param name='customerID' value='${requestScope.CUSTOMER_ID}'/>
																<c:param name='customerName' value='${requestScope.OPPORTUNITY_CUSTOMER_NAME}'/>
																<c:param name='OPID' value='${cust.id}'/>
																</c:url>">View Documents<!--<img src="../../download/img/download.png" alt="View Documents">--></a>
												</c:when>
											</c:choose>
												</li>
												<li class="li${itemLoop.index+1} lastright" id="allcust${lvalue}" value="${cust.id}" onclick="">
													<a class="someLink" title="Delete"
															href="<c:url value='/cloud/pse/solutionDelete.do'>
																<c:param name='solTitle' value='${optitle}'/>
																<c:param name='customerID' value='${requestScope.CUSTOMER_ID}'/>
																<c:param name='customerName' value='${requestScope.OPPORTUNITY_CUSTOMER_NAME}'/>
																<c:param name='OPID' value='${cust.id}'/>
																</c:url>"><img src="img/pse_delete.png" alt="Delete"></a>
												</li>
							    		</c:otherwise>
									</c:choose>
								</c:forEach>
							</ul>
						</c:forEach>
					</div>
				</c:when>
				<c:otherwise>
					<div><fmt:message key="pse.msg.noop" /></div>
				</c:otherwise>
				</c:choose>
			</div>
			
			<div class="AddNewItem">
				<a class="addcustomers addNewItemA" href="<c:url value='/cloud/pse/solutionTypes.do'><c:param name='newItem' value='yes'/>
										<c:param name='customerName' value='${requestScope.OPPORTUNITY_CUSTOMER_NAME}'/>
										<c:param name='customerID' value='${requestScope.CUSTOMER_ID}'/></c:url>">
					<span  class="addWF">
						<img src="../../cloud/pse/img/pse_add_opportunity.png">&nbsp;<fmt:message key="pse.msg.mynewopp" />
					</span>
				</a>
			</div>
			
		</div>

</div>
</div>
<fmt:message key="Search" var="searchKey"/>
<div id="searchDiv">
	<input type="search" id="grpSearch" placeholder="${searchKey}" />
	<div class="hidden" id="closeSearch"></div>
	<img class="deleteText" alt="x" src="../../common/img/close.png">
	<div class="hidden customerSearch">Search in All Customer..<img id="searchload" src="../../common/img/loader_20.gif"/><img id="searchClose" src="../../common/img/close.png" style="color: red;float:right;cursor: pointer;" title="Close" alt="x"><ul class="customersForSearch"></ul></div>
</div>

<div class="hidden nocustomer">
	<fmt:message key="nocustomer" />
</div>

<script nonce="${sessionScope.cspNonce}" >

function managecustomerList(data){
	$("#searchload").hide();
	$(".customersForSearch").html(data);
	if($(".customerSearch").is(':hidden')){
		$(".customerSearch").show();
	}

	$(".customersForSearch li").on("click",function(){
		$(".customersForSearch li").removeClass("selectedcustomer");
		$(this).addClass("selectedcustomer");
		var url = $(".customersForSearch .selectedcustomer").data("searchurl") + $("#grpSearch").val();
		window.location = url;
	});
}
var fVal = "";
$("#grpSearch").focus(function(){
	if(fVal == "")
		fVal = $.trim($("#grpSearch").val());
	else{
		if(fVal != $.trim($("#grpSearch").val())){
			searchCustomer();
		}else{
			if($(".customerSearch").is(':hidden')){
				$(".customerSearch").show();
			}
		}
	}
});


$("#searchClose").click(function(){
	$(".customerSearch").hide();
});
var ajaxTout=0;
$("#grpSearch").keyup(function(event){
	if(ajaxTout != 0){
		clearTimeout(ajaxTout);
	}
	ajaxTout = setTimeout(searchCustomer,500);
});
function searchCustomer(){
	ajaxTout = 0;
	fVal = $.trim($("#grpSearch").val());
	params = {};
	params.Name=$.trim($("#grpSearch").val());
	$("#searchload").show();
	$(".customersForSearch").html("");
	cvUtil.loadPage(cvUtil.getContextPath()+"/server/searchAllCustomer", params, managecustomerList);
}

$("#closeSearch").on("click", function() {
	$(".customersForSearch").hide();
	$("#closeSearch").hide();
});
</script>
<jsp:include page="../../common/footer.jsp">
	<jsp:param value="js/solution.js" name="js" />
	<jsp:param value="../../common/js/jquery.corner.js" name="js" />
</jsp:include>

<c:if test="${not empty sessionScope.LOCALIZED_ERROR_MSG}">
	<script nonce="${sessionScope.cspNonce}" >
		cvUtil.errorToast("${sessionScope.LOCALIZED_ERROR_MSG}", null, null, true);
	</script>
	<c:set var="LOCALIZED_ERROR_MSG" value="" scope="session" />
</c:if>