<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<jsp:include page="../../common/header.jsp">
	<jsp:param value="" name="titleLocalized" />
	<jsp:param value="../../common/css/headerstyles.css" name="css" />
	<jsp:param value="css/psecommon.css" name="css" />
	<jsp:param value="css/psecommonbutton.css" name="css" />
	<jsp:param value="css/pselabels.css" name="css" />
	<jsp:param value="css/psesolopt.css" name="css" />
	<jsp:param value="true" name="includeSecHeader" />
	<jsp:param value="" name="headerTitleLocalized" />
	<jsp:param value="Solution Design Tool:pse/index.jsp,${requestScope.OPPORTUNITY_CUSTOMER_NAME}:pse/opportunityList.do?customerID=${requestScope.CUSTOMER_ID}&customerName=${requestScope.OPPORTUNITY_CUSTOMER_NAME}" name="breadCrumbValues" />
</jsp:include>
<c:set var="qavals" value="${requestScope.OPPORTUNITY_OPTIONS_VALS}" scope="page"/>

<div id="sub-section">

	<div class="subsec-body">
		<div class="pselabel soltitle">
		<div id="solutionname">
			<c:set var="soltitle" value="${requestScope.OPPORTUNITY_TITLE}" scope="page"/>${soltitle}
			<c:if test="${fn:length(soltitle) != 0}">
				<br/>
				<br/>
			</c:if>
			</div>
			
			<c:set var="custname" value="${requestScope.OPPORTUNITY_CUSTOMER_NAME}" scope="page"/>${custname}<br/>
			<script nonce="${sessionScope.cspNonce}" >var pseoptionsVals = {};pseoptionsVals.customerName = '${custname}';pseoptionsVals.itemVal={};pseoptionsVals.parents={}; 
			pseoptionsVals.customerID = '${requestScope.CUSTOMER_ID}';
			pseoptionsVals.OPID = '${requestScope.OPPORTUNITY_ID}';
			pseoptionsVals.solTitle = "${soltitle}";
			</script>
	    </div>
		<div class="soltops">
			<ul class="blockrows">
				<li class="blocktitle maintitle">Simpana Solution Options</li>
			</ul>
			<ul class="blockrows">
				<li class="solopstitle infotype">Solution Title</li>
				<li class="solopstitleinput infodesc"><input type="text" name="solt" id="solt" onkeyup="changeTitle(this);" value="${soltitle}"></li>
				<li class="soltitleborder"></li>
			</ul>
			<ul class="blockrows">
				<c:choose>
					<c:when test="${fn:length(requestScope.OPPORTUNITY_OPTIONS) > 0}">
					<c:set var="prelabel" value="" scope="page"/>
						<c:forEach var="srch" items="${requestScope.OPPORTUNITY_OPTIONS}">
						<c:set var="srchid" value="${fn:trim(srch.ID)}" scope="page"/>
						<c:set var="srchval" value="${(qavals[srchid] == '' || qavals[srchid] == null)? (srch.psedv == null ? '': srch.psedv) : qavals[srchid] }" />
						<script nonce="${sessionScope.cspNonce}" >
						pseoptionsVals.itemVal["${srchid}"]="${srchval}";
						pseoptionsVals.parents["${srch.psepid}"]="${srch.psepid}";
						</script>
								<li class="infotype">${srch.title}</li>
								<li class="infodesc">
							
							<c:choose>
				   				<c:when test = "${fn:toLowerCase(srch.anstype) == 'radio'}">
				   					<c:forEach var="optnsVal" items="${fn:split(srch.pseansvals, ',')}">
				   						<input type="radio" name="opts${srchid}" id="r${srchid}" value="${optnsVal}" ${srchid == 4 ? "" :"disabled"} ${fn:toLowerCase(srchval) == fn:toLowerCase(optnsVal) ? "checked=\"checked\"" :""} onclick="solutionOptionValues(this);" >
										<label for="for${optnsVal}${srchid}">${optnsVal}</label>
				   					</c:forEach>
				   				</c:when>
				   				<c:when test = "${fn:toLowerCase(srch.anstype) == 'input'}">
				  						<input type="text" name="for${optnsVal}${srchid}" id="r${srchid}" value="${srchval}" >
									<label for="for${optnsVal}${srchid}">${optnsVal}</label>
				   				</c:when>
							</c:choose>
								</li>
						</c:forEach>
					</c:when>
					<c:otherwise>
						<li >Coming soon</li>
					</c:otherwise>
				</c:choose>
				<li class="soltitleborder"></li>
			</ul>
		</div>
		<div class="btns">
			<a class="btnsa" href="#" id="cancelb" onclick="solutionDetails(2);">Close</a>
			<a class="btnsa" href="#" id="saveeb" onclick="solutionDetails(1);">Back</a>
			<a class="btnsa" href="#" id="savecb" onclick="solutionDetails(3);">Next</a>
		</div>
	</div>
	<div class="subsec-body"></div>
	
</div>

<jsp:include page="../../common/footer.jsp">
	<jsp:param value="js/psecommon.js" name="js" />
	<jsp:param value="js/psesolopts.js" name="js" />
	<jsp:param value="../../common/js/jquery.corner.js" name="js" />
</jsp:include>


<c:if test="${not empty sessionScope.LOCALIZED_ERROR_MSG}">
	<script nonce="${sessionScope.cspNonce}" >
		cvUtil.errorToast("${sessionScope.LOCALIZED_ERROR_MSG}", null, null, true);
	</script>
	<c:set var="LOCALIZED_ERROR_MSG" value="" scope="session" />
</c:if>
