(function() {
	"use strict";

	var sdt = angular.module("sdt");

	sdt.service('sdtService', [ '$http', '$q', function($http, $q) {

		this.getConfigs = function() {
			return $http.get("getSDTConfigs.do");
		};
		this.getReqDetails = function(reqid, loadConfig) {
			var d = {
				"reqID" : reqid,
				"needConfig" : loadConfig
			};
			return $http.post("getSDTReqDetails.do", d);
		};
		this.createRequest = function(reqJsonStr) {
			var d = {
				"reqData" : reqJsonStr
			};
			return $http.post("createSDTRequest.do", d);
		};

		this.saveRequest = function(reqId, reqDtlJsonStr) {
			var d = {
				"reqID" : reqId,
				"reqDetailsJson" : reqDtlJsonStr
			};
			return $http.post("saveSDTReqDetails.do", d);
		};
		this.deleteSite = function(reqId, siteJsonStr) {
			var d = {
				"reqID" : reqId,
				"siteDetailsJson" : siteJsonStr
			};
			return $http.post("deleteSDTSite.do", d);
		};
		this.runWorkflow = function(reqId) {
			var d = {
				"reqID" : reqId
			};
			return $http.post("runSDTWorkflow.do", d);
		};

	} ]);

})();