
export const sdtConstants = {};

sdtConstants.requestType= {
	SDT : "SDT"
};

sdtConstants.siteType = {
	onPrem : "OnPremise",
	cloud : "Cloud"
}
sdtConstants.common = {
	requestIdParam : "requestId",
	SOWGUID: "dd6f2438-1bae-4fda-8658-8bd0a82e7156",
	SOWPrefix: "SDT SOW ",
	PPTGUID: "147379e3-65d4-4e98-972e-791bf1d4fb2b",
	PPTPrefix: "SDT PPT "
}
export class Customer{
	constructor(id,name){
		this.id=id;
		this.name=name;
	}
	setCustomerName(name){
		this.name = name;
	}
	setCustomerId(id){
		this.id=id;
	}
	
}

export class RetentionInfo{
	constructor(dBackup, yModel){
		this.dbkp=dBackup;
		this.ymodel=yModel;
	}
}

export class DCInfo{
	constructor(compression, change, grth, dedup){
		if (typeof compression === 'string' || compression instanceof String){
			compression = compression.trim();
		}
		if (typeof change === 'string' || change instanceof String){
			change = change.trim();
		}
		if (typeof grth === 'string' || grth instanceof String){
			grth = grth.trim();
		}
		if (typeof dedup === 'string' || dedup instanceof String){
			dedup = dedup.trim();
		}
		this.compression = Number(compression);
		this.changerate = Number(change);
		this.growthrate = Number(grth);
		this.dedupratio = Number(dedup);
	}
}
export class MATypes{
	constructor(name, id, showmodels){
		this.name=name;
		this.id = id;
		this.showModels = (showmodels === true? true: false);
		this.models = [];
	}
	addModels(models){
		if(models){
			this.models = models;
		}
	}
	addModel(model){
		if(model){
			this.models.push(model);
		}
	}
	
}
class ReplicationSite{
	constructor(id, percentage, orderid){
		this.repSite = {};
		this.repSite.id = id;
		this.replicationPrecentage = percentage;
		this.orderNumber = orderid;
	}
	getId(){
		if(this.repSite.id) {
			return this.repSite.id;
		}
		return -1;
	}
}

class Servers{
	constructor(count, config){
		this.count = count;
		this.config = config;
		
	}
}
class MAHardware{
	constructor(type, years, xlcount, largecount){
		this.type = type;
		this.years = years;
		this.xlcount = count;
		this.largecount = count;		
	}
}




export class SDTApp {
	constructor(id) {
		if(!(Number.isInteger(id) && id > 0)){
			id = 0
		}
		this.request = new SDTRequest(id);		
		this.defaultMAs = {};
		this.defaultDCInfo = [];
		this.defaultRetention = null;
		this.defaultReplRetention = null;
		this.defaultSolutions = {};
		this.wizardTemplateURL = "";
		this.wizardstate = null;
		this.isModify = false;
		this.wizardstates = {
			addsol:{
				isdone: false,
				nextstate: "modbet",
				title: "Add Solution",
				template: "template/sdtaddsol.jsp",
				cssclass: "",
				name: "addsol",
				clickable: false
			},
			modbet:{
				isdone: false,
				nextstate: "addrep",
				title: "Modify Storage Settings",
				template: "template/sdtmodbet.jsp",
				cssclass: "",
				name: "modbet",
				clickable: false
			},
			addrep:{
				isdone: false,
				nextstate: "completed",
				title: "Add Replication Site",
				template: "template/sdtaddrepsite.jsp",
				cssclass: "",
				name: "addrep",
				clickable: false
			},
			completed:{
				isdone: false,
				title: "Done",
				template: "template/sdtwizdone.jsp",
				cssclass: "",
				name: "completed",
				clickable: false
			}
		}
	}
	wizardClicked(wzrd){
		if(wzrd){
			this.wizardstate = wzrd;
		}
		this.setWizardClass();
	}
	setWizardClass(){
		var c = "";
		if(this.isModify === true){
			c += "clickable "
		}
		for(var w in this.wizardstates){
			var wc = c;
			if(this.wizardstates[w].isdone && this.isModify === false){
				wc += "done ";
			}
			if(this.wizardstate && this.wizardstate.name === w){
				wc += "current ";
			}
			if(this.wizardstates[w].clickable){
				wc += "clickable ";
			}
			if(w=="completed" && this.isModify === true){
				wc = "hide";
			}
			this.wizardstates[w].cssclass = wc;
		}
	}
	resetWizards(){
		for(var w in this.wizardstates){
			if(this.isModify === true){
				this.wizardstates[w].clickable = true;
			}else{
				this.wizardstates[w].clickable = false;
				this.wizardstates[w].isdone = false;
			}
		}
	}
	wizardDone(){
		this.resetWizards();
		this.wizardstate = null;
		//hide the wizard
		this.wizardTemplateURL = "";
	}
	wizardCancelled(){
		this.wizardDone();
	}
	goToNextWizard(){
		if(this.wizardstate){
			this.wizardstate.isdone = true;
			this.wizardstate.clickable = true;
			if(this.wizardstate.nextstate){
				this.wizardstate = this.wizardstates[this.wizardstate.nextstate];
				this.wizardstate.cssclass = "current";
			}else{
				//wizard done, close the wizard.
				this.wizardDone();
			}
		}
		this.setWizardClass();
	}
	startNewSiteWizard(){
		this.wizardTemplateURL = "template/sdtwizard.jsp";
		/*
		 * if(!this.wizardstate){ this.wizardstate = this.wizardstates.addsol; }
		 */
		this.wizardstate = this.wizardstates.addsol;
		this.resetWizards();
		this.setWizardClass();
	}
	hideNewSiteWizard(){
		this.wizardTemplateURL = "";
	}
	getRequest(){
		return this.request;
	}
	loadRequestData(jsonData){
		if(jsonData){
			this.loadRequestDetailsFromResp(jsonData);
		}
	}
	setConfig(config, init){
		this.config = config;
		if(init && init === true){
			
			//loop through configs and initialize request.
			if(this.config.hardware){
				this.setMaHardwareTypes(this.config.hardware);
			}
			if(this.config.datachange){
				this.setDefaultDataChangeInfo(this.config.datachange);
			}
			if(this.config.retention){
				this.setDefaultRetentionInfo(this.config.retention);
			}
			if(this.config.replicationRet){
				this.setDefaultReplRetentionInfo(this.config.replicationRet);
			}
			if(this.config.solutions){
				this.setDefaultSolutions(this.config.solutions);
			}
		}
		console.log(config);
	}
	
	setMaHardwareTypes(maTypes){
		if(maTypes){
			for(var i=0;i<maTypes.length;i++){
				var ma = maTypes[i];
				if(ma){
					this.addDefaultMA(ma);
				}
			}
		}
	}
	addDefaultMA(ma){
		var anMa = this.defaultMAs[ma.id];
		if(!anMa){
			anMa = new MATypes(ma.name, ma.id, ma.showModels);
			this.defaultMAs[ma.id] = anMa;
		}
		
		if(ma.diskCount && ma.diskSizes){
            anMa.addDiskInfo(ma.diskCount, ma.diskSizes);
		}
		if(ma.models){
		    anMa.addModels(ma.models);
		}
	}
	getMAModelsByMAId(id){
		var anMa = this.defaultMAs[id];
		if(anMa){
			return anMa.models;
		}
		return [];
	}
	getMANameByMAID(id){
		var anMa = this.defaultMAs[id];
		if(anMa){
			return anMa.name;
		}
		return "";
	}
	getMAModelName(maid,modelid){
		var ma = this.getMAModelsByMAId(maid);
		if(ma && modelid){
			for(var i=0;i<ma.length;i++){
				var mdl = ma[i];
				if(mdl.id === modelid){
					return mdl.name;
				}
			}
		}
		return "";
	}
	getSiteMAModelsName(sitema){
		var modelNames = [];
		if(sitema && sitema.id){
			if(sitema.models){
				for(var j=0;j<sitema.models.length;j++){
					var mdl = sitema.models[j];
					var mdlname = this.getMAModelName(sitema.id, mdl.id);
					if(mdlname){
						modelNames.push(mdlname);
					}
				}
			}
		}
		return modelNames;
	}
	setDefaultDataChangeInfo(dataChange){
		if(dataChange){
			var dcTypes = Object.keys(dataChange);
			for(var i=0;i<dcTypes.length;i++){
				var dc = dataChange[dcTypes[i]];
				var aDC = new DCInfo((''+dc.compressionRatio).trim(), (''+dc.actualChangeRate).trim(), (''+dc.actualGrowthRate).trim(), (''+dc.dedup).trim());
				this.defaultDCInfo[dcTypes[i]] = aDC;
			}
		}
	}
	setDefaultRetentionInfo(ret){
		if(ret){
			var aRt = new RetentionInfo(ret.dailybackup, ret.ymodel);
			this.defaultRetention = aRt;
		}
	}
	setDefaultReplRetentionInfo(repRet){
		if(repRet){
			//var aRt = new ReplicationRetInfo(repRet.dailybackup);
			this.defaultReplRetention = repRet;
		}
		
	}
	setDefaultSolutions(sols){
		if(sols){
			for(var i=0;i<sols.length;i++){
				var sol = sols[i];
				if(sol.solname && sol.solid){
					this.addDefaultSolution(sol);
				}
			}
		}
	}
	addDefaultSolution(sol){
		var solution;
		if(this.defaultSolutions[sol.solid]){
			solution = this.defaultSolutions[sol.solid];
		}else{
			solution = this.createSolution(sol.solid, sol.solname);
			this.defaultSolutions[sol.solid] = solution;
		}
		solution.setType(sol.soltype);
		solution.setDataChangeInfo(this.defaultDCInfo[sol.soltype]);
		if(sol.questions){
			for(var i=0;i<sol.questions.length;i++){
				var q = sol.questions[i];
				solution.addQuestion(q.qname, q.qtype, q.qid, q.qattrid,q.calF, q.qval, q.summary, q.ordernumber);
			}
		}
		
	}
	getDefaultSolutionById(solid){
		return this.defaultSolutions[solid];
	}
	createSolution(id, name){
		return new Solution(id, name);
	}
	
	getSiteObjFromRepSite(repSite){
		var siteObj;
		if(repSite instanceof ReplicationSite){
			var sites = this.getRequest().sites;
			for(var i=0;i<sites.length;i++){
				var aSite = sites[i];
				if(aSite.isReplicationSite()){
					if(aSite.getId() === repSite.getId()){
						siteObj = aSite;
						break;
					}
				}
			}
		}
		return siteObj;
	}	
	loadSitesFromResp(sites){
		for(var i=0;i<sites.length;i++){
			var asite = sites[i];
			var aSiteObj = this.getRequest().createASite(asite.id, asite.name, asite.location, asite.type, asite.isreplicationsite, asite.ordernumber);
			aSiteObj.updateRetentionInfo(asite.dailyBackupRet,asite.yearsToModel);
			
			if(asite.ma){aSiteObj.addMAFromRespObj(asite.ma);}
			
			if(asite.solutions){aSiteObj.addSolutionsFromRespObj(asite.solutions);}
			
			if(asite.replicationSites){aSiteObj.addReplicationSitesFromRespObj(asite.replicationSites);}
		}
	}
	loadRequestDetailsFromResp(respObj){
		if(respObj.sites){
			this.loadSitesFromResp(respObj.sites);
		}
		if(respObj.requestId){
			this.getRequest().setId(respObj.requestId);
		}
		if(respObj.company){
			this.getRequest().setCustomer(new Customer(0,respObj.company))
		}
		
		if(respObj.lastModifiedUserEmail){
			this.getRequest().setModifiedBy(respObj.lastModifiedUserEmail);
		}
		if(respObj.lastModifiedUserEmail){
			this.getRequest().setModifiedBy(respObj.lastModifiedUserEmail);
		}
		if(respObj.contact){
			this.getRequest().setCreatedBy(respObj.contact);
		}
		if(respObj.comments){
			this.getRequest().setSummary(respObj.comments);
		}
	}
	getAllSolutions(aSite){
		var sols = angular.copy(this.defaultSolutions, {});
		console.log(sols);
		//var reqSo = aSite.getSolutions().length;
		for( var solidx in sols){
			var sol = sols[solidx];
			var siteSol = aSite.getSolutionById(sol.getId());
			if(siteSol){
				siteSol.setName(sol.getName());
				sols[sol.getId()] = siteSol;
			}
		}
		return sols;
	}
	
}

export class SDTRequest {
	constructor(id) {
		this.id = id;
		this.config = {};
		this.customer = new Customer();
		this.sites = [];
		this.summary="";
		this.createdby = "";
		this.modifiedby = "";
	}
	getId() {
		return this.id;
	}
	setId(id){
		if(Number.isInteger(id)){
			this.id = id;
		}
	}
	isSiteAdded(){
		if(this.sites.length > 0) {
			return true;
		}
		return false;
	}
	setModifiedBy(mod){
		this.modifiedby = mod;
	}
	setCreatedBy(crted){
		this.createdby = crted;
	}
	
	xxcreateAgent(id, name){
		return new Agent(id, name);
	}
	getConfig(){
		return this.config;
	}
	
	getSiteIdPrefix(){
		return "sdtSite";
	}
	getCustomer(){
		return this.customer;
	}
	setCustomer(cust){
		if(cust instanceof Customer){this.customer = cust;}
	}
	
	getSummary (){
		return this.summary;
	}
	setSummary (summary){
		this.summary = summary;
	}
	clearSites (){
		this.sites = [];
	}
	getLengthIndx(){
		return this.sites.length + 1;
	}
	createSiteId(){
		//var indx = this.sites.length + 1;
		return "newSite"+Date.now();
	}
	createASite(siteid, siteName, location, siteType, isRepSite, ordernumber) {
		if(!siteid){
			siteid = this.createSiteId();
		}
		if(!siteType){
			siteType = sdtConstants.siteType.onPrem;
		}
		if(!siteName){
			siteName = "Site "+this.getLengthIndx();
		}
		if(!location){
			location = "";//siteName;
		}
		if(!isRepSite){
			isRepSite = false;
		}
		if(!ordernumber){
			ordernumber = this.getLengthIndx();
		}
		var site = new Site(siteid, siteName, location, siteType, isRepSite, ordernumber);
		this.addSite(site);
		return site;
	}
	addSite(aSite) {
		if (aSite instanceof Site) {
			this.sites.push(aSite);
		}
	}
	removeSite(aSite){
		
		if (aSite instanceof Site) {
			//delete this.sites[aSite.getId()]
			this.removeSiteById(aSite.getId());
			this.checkAndRemoveIfOnlyReplicationSites();
		}
	}
	removeSiteById(id){
		if(id){
			for(var i=0;i<this.sites.length; i++){
				var aSite = this.sites[i];			
				if(aSite){
					if(aSite.getId() == id){
						//remove repsite reference from each primary site, then remove the site from this site.
						for(var j=0;j<this.sites.length; j++){
							var primarySite = this.sites[j];
							if(primarySite){primarySite.removeReplicationSiteById(aSite.getId());}
						}
						this.sites.splice(i,1);
						break;
					}
				}
			}
		}
		
	}
	
	checkAndRemoveIfOnlyReplicationSites(){
		var anyPrimarySite = false;
		for(var i=0;i<this.sites.length; i++){
			var aSite = this.sites[i];			
			if(aSite){
				if(aSite.isReplicationSite() === false){
					anyPrimarySite = true;
					break;
				}
			}
		}
		//if no primary sites, then remove all replication sites also.
		if(anyPrimarySite === false){
			this.sites = [];
		}
		
		
	}
	
	getSiteNameById(siteid){
		
		for (var s=0; s<this.sites.length; s++) {
			
		    var aSite = this.sites[s];
		    if(aSite.getId() == siteid){
		    	return aSite.getName()+"-"+aSite.getLocation();
		    }
		}
		return "";
	}
}


export class Site {
	constructor(id, name, location, type, isRepSite, ordernumber) {
		this.id = id;
		this.name = name;
		this.location = location;
		this.type = type;
		if(isRepSite){
			this.isreplicationsite = true;
		}else{
			this.isreplicationsite = false;
		}
		this.ordernumber = ordernumber;
		//this.maHardwareType = {};
		this.ma = {};
		this.solutions = [];
		this.replicationSites = []; // this will have ReplicationSite object
		this.dailyBackupRet = 30;
		this.yearsToModel = 1;
	}

	getId() {
		return this.id;
	}
	setId (id){
		this.id = id;
	}
	getName() {
		return this.name
	}
	isReplicationSite(){
		return this.isreplicationsite;
	}
	getLocation(){
		return this.location;
	}
	getSolutions(){
		return this.solutions;
	}
	addSolution(id, name) {
		var sol = this.getSolutionById(id);
		if(!sol){
			sol = new Solution(id, name);
			this.addSolutionObj(sol);
		}
		return sol;
	}
	addMA(name, id){
		var maType = new MATypes(name, id);
		this.setMA(maType);
		return maType;
		
	}
	getMA(){
		return this.ma;
	}
	setMA(ma){
		if(ma instanceof MATypes){
			this.ma = ma;
		}
	}
	setAsReplicationSite(){
		this.isreplicationsite = true;
	}
	addSolutionObj(sol) {
		if (sol instanceof Solution) {
			var solIdx = this.getSolIndexByID(sol.getId());
			if(solIdx === -1){
				this.getSolutions().push(sol);
			} else {this.getSolutions()[solIdx] = sol;}
		}
	}
	removeSolution(solid) {
		if (solid) {
			var solIdx = this.getSolIndexByID(solid);
			if(solIdx === -1){
				return;
			} else {
				this.getSolutions().splice(solIdx,1);
			}
		}
	}
	setName (name){
		this.name = name;
	}
	addReplicationSite(id, percent, order) {
		var repsite;
		if(this.replicationSites[id]){
			repsite = this.replicationSites[id];
		}else{
			//id, percentage, orderid
			repsite = new ReplicationSite(id, percent, order);
			this.addReplicationSiteObj(repsite);
		}
		return repsite;
	}

	addReplicationSiteObj(repsite) {
		if (repsite instanceof ReplicationSite) {
			this.replicationSites.push(repsite);
		}
	}
	addSiteObjAsReplicationSite(repsite) {
		if (repsite instanceof Site) {
			this.addReplicationSite(repsite.getId(), repsite.percentage, repsite.order);
		}
	}
	
	removeReplicationSiteById(id){
		if(id){
			for(var i=0;i<this.replicationSites.length; i++){
				var rs = this.replicationSites[i];
				if(rs.getId() == id){
					this.replicationSites.splice(i,1);
					break;
				}
			}
		}
		
	}
	loopThroughSolutions(callBack) {
		for (var as = 0; as < this.getSolutions().length; as++) {
			var aSol = this.getSolutions()[as];
			callBack(aSol, as);
		}
	}
	getSolutionById(solID) {
		var solById = null;
		var idx = this.getSolIndexByID(solID);
		if(idx >= 0){
			solById = this.getSolutions()[idx];
		}
		return solById;
	}
	getSolIndexByID(solid){
		var solIdx = -1;
		this.loopThroughSolutions(function(sol, indx) {
			if (sol.getId() === solid) {
				solIdx = indx;
				return;
			}
		});
		return solIdx;
	}
	updateRetentionInfo(dailyBackup, years){
		this.dailyBackupRet = dailyBackup;
		this.yearsToModel = years;
	}
	addMAFromRespObj(ma){
		if(ma){
			var maTypeObj = this.addMA(ma.name, ma.id);
			if(ma.maModels){maTypeObj.addModels(ma.maModels)};
		}
		
	}
	
	addSolutionsFromRespObj(solutions){
		if(solutions){
			
			for(var i=0;i<solutions.length;i++){
				var asol = solutions[i];
				var aSolObj = this.addSolution(asol.id, "");
				if(asol.dataChangeInfo){aSolObj.updateDataChangeInfoFromRespObj(asol.dataChangeInfo);}
				if(asol.totalFET){
					aSolObj.setFetVal(asol.totalFET);
				}
				if(asol.questions){
					aSolObj.updateQuestionsFromRespObj(asol.questions);
				}
			}
			
		}
	}
	addReplicationSitesFromRespObj(repsites){
		//replicationSites.orderNumber, replicationPrecentage
		for(var repl=0;repl<repsites.length;repl++){
			var aRepSite = repsites[repl];
			this.addReplicationSite(aRepSite.repSite.id, aRepSite.replicationPrecentage, aRepSite.orderNumber)
		}
		//repSite.id
		
	}
}


export class Solution{
	constructor(id, name) {
		this.id = id;
		this.name = name;
		this.description = "";
		this.questions = [];
		this.type="FS";
		this.totalFET = 0;
		this.fetFunc = "";
		this.dataChangeInfo = new DCInfo();
	}
	getId() {
		return this.id;
	}
	getName() {
		return this.name;
	}
	getFet(){
		return this.totalFET;
	}
	getDataChangeInfo(){
		return this.dataChangeInfo;
	}
	getType(){
		return this.type;
	}
	setType(type){
		if(type.toLowerCase()=="db"){
			this.type = "DB";
		}else{
			this.type = "FS";
		}	
	}
	setName(name){
		this.name = name;
	}
	setDataChangeInfo(d){
		if(d instanceof DCInfo){this.dataChangeInfo = d;}
	}
	loopThroughQuestions(callBack) {
		for (var as = 0; as < this.getQuestions().length; as++) {
			var aQ = this.getQuestions()[as];
			callBack(aQ, as);
		}
	}
	addQuestion(question, type, id, attrid, calF, val, summary, order) {
		var q1 = new Question(question, type, id, attrid, calF, val, summary, order);
		this.getQuestions().push(q1);
		return q1;
	}
	getQuestions() {
		return this.questions;
	}
	getQuestionSummary(){
		var qS = "";
		this.loopThroughQuestions(function(q) {
			if(qS.length > 1){
				qS += ",";
			}
			qS += q.getSummaryWithValue();
		});
		return qS;
	}
	getDescription() {
		return this.description;
	}
	setFetCalFunction(fnc) {
		this.fetFunc = fnc
	}
	updateDataChangeInfoFromRespObj(respObj){
		this.setDataChangeInfo(new DCInfo(respObj.compression, respObj.changerate, respObj.growthrate, respObj.dedupratio));
		
	}
	getFetCalFunction() {
		return this.fetFunc;
	}
	calculateFET() {
		var f = this.getFetCalFunction();
		if (f && f !== "") {
			var sol = this;
			var func = new Function('sol', '"use strict";' + f);
			func(sol);
		}
		return this.getFet();
	}
	getQVal(qId) {
		var qVal = 0;
		this.loopThroughQuestions(function(q) {
			if (q.getId() === qId) {
				qVal = q.getAnswer();
			}
		});
		return qVal;
	}
	setQVal(qId, qVal) {
		if (!qVal) {
			qVal = "";
		}
		this.loopThroughQuestions(function(q) {
			if (q.getId() === qId) {
				q.setAnswer(qVal);
			}
		});
		return qVal;
	}
	setFetVal(fetVal) {
		this.totalFET = fetVal;
	}
	updateQuestionsFromRespObj(qs){
		if(qs){
			for(var j=0;j<qs.length;j++){
				var aq = qs[j];
				this.addQuestion(aq.question, aq.type, aq.id, aq.qvarname, aq.calF, aq.qval, aq.summary, aq.ordernumber);
			}
		}
	}
	
}

export class Question{
	constructor(q, type, id, attrid, calF, val, summary,ordernumber) {
		this.ordernumber = ordernumber
		this.question = q;
		this.type = type;
		this.id = id;
		this.qvarname = attrid;
		this.qval = (val?val:0);
		this.qCalF = calF;
		this.summary = summary;
	}
	getId(){
		return this.id;
	}
	getAttrId(){
		return this.qvarname;
	}
	getSummary(){
		return this.summary;
	}
	getSummaryWithValue(){
		var s = this.summary.replace("#QVAL#", this.getAnswer());
		return s;
	}
	setAnswer(ans) {
		//we can check the type and error out
		this.qval = ans;
	}
	getAnswer() {
		return this.qval;
	}
	getCalculationFunction() {
		return this.qCalF;
	}
	getQuestion() {
		return this.question;
	}
}
