import { SDTApp, sdtConstants } from './sdtModel.js';
import { sdtExportServices } from './sdtExport.js';
(function() {
	
	"use strict";
	
	var app = angular.module("sdt");
	
	app.controller("sdtCtrl", [
			"$scope",
			"sdtUtilSvc",
			"$interval",
			"$timeout",
			'$rootScope',
			"sdtService",
			"sdtUrlService",
			"$uibModal",
			function($scope, sdtUtilSvc, $interval, $timeout, $rootScope, sdtService, sdtUrlService, $uibModal) {
				if (typeof cv !== "undefined") {
					$scope.cv
				}
				
				$scope.showNewDesignPage = true;
				$scope.showAdvanceSettings = false;
				$scope.maskEle = "sdtapp";
				$scope.designoutput = "After adding a site, hit Calculate to see results.";
				$scope.errorToast = function(msg, delay) {
					sdtUtilSvc.errorToast(msg, delay);
				},

				$scope.toast = function(msg, delay) {
					sdtUtilSvc.toast(msg, delay);
				}
				//var cr = angular.copy(reportDef, {}); /for deep copy

				$scope.sayHi = function() {
					sdtUtilSvc.toast("Hi Somnath");
					console.log($scope.sdt);
				}
				$scope.modifySite = function(site){
					console.log("Modify site", site);
					$scope.sdt.isModify = true;
					$scope.aSite = site;
					//$scope.aSite.selectedModels = [];
					$scope.sdt.startNewSiteWizard();
				}
				$scope.removeSite = function(site){
					console.log("Remove site", site);
					//$scope.aSite.selectedModels = [];
					$scope.openConfirmModal("Confirm to remove the site - " + site.name,"Are you sure to remove the site?",function(){
						$scope.sdt.getRequest().removeSite(site);
						sdtUtilSvc.mask($scope.maskEle,true,"Deleting the site...");
						var siteData = {};
						siteData.id = site.id;
						siteData.replicationSites = site.replicationSites;
						sdtService.deleteSite($scope.requestid, JSON.stringify(siteData)).then(function(data) {
							console.log(data);
							sdtUtilSvc.unMask($scope.maskEle,true);
							$scope.sdt.sdtData.recalculate = 1;
							//var dtls = data.data.data.details;
						});
					});
					
				}
				$scope.removeRepSite = function(site){
					console.log("Remove rep site", site);
					//$scope.aSite.selectedModels = [];
					$scope.openConfirmModal("Confirm to remove the Replication site - " + site.name,"Are you sure to remove this replication site?",function(){
						$scope.sdt.getRequest().removeSite(site);
						//sdt.getRequest().removeSiteById(repSiteSite.id)
					});
					
				}
				$scope.addNewSiteWizard = function(){
					var newSite = $scope.sdt.getRequest().createASite();
					$scope.aSite = newSite;
					$scope.sdt.startNewSiteWizard();
				}
				$scope.cancelWizard = function(){
					if($scope.sdt.isModify === false && $scope.aSite){
						$scope.sdt.getRequest().removeSite($scope.aSite);
					}
					$scope.sdt.isModify = false;
					$scope.sdt.wizardCancelled();
				}
				
				$scope.nextWizardStep = function(){
					if($scope.sdt.isModify === true || !$scope.sdt.wizardstate.nextstate){
						$scope.saveCloudSDTRequest();
					}else{
						$scope.sdt.goToNextWizard();
					}
					//$scope.sdt.hideNewSiteWizard();
				}
				
				$scope.advanceSettingsClicked = function(){
					$scope.showAdvanceSettings = !$scope.showAdvanceSettings;
				}
				$scope.init = function(){
					$scope.requestid = parseInt(sdtUrlService.getParameterByName(sdtConstants.common.requestIdParam, 0)) || 0;
					$scope.sdt = new SDTApp($scope.requestid);
					$scope.sdtRequest = $scope.sdt.getRequest();
					
					if($scope.requestid > 0){
						$scope.loadReqDtlsTemplate();
						$scope.loadData(true);
					}else{
						$scope.getConfigs();
						$scope.loadNewReqTemplate();
					}
				}
				$scope.edits = {};
				$scope.toggelEditable = function(name){
					if($scope.edits[name]){
						$scope.edits[name] = false;
					}else{
						$scope.edits[name] = true;
					}
					
				};
				$scope.saveSummary = function(){
					$scope.toggelEditable('summary');
					sdtUtilSvc.mask($scope.maskEle,true,"Saving summary...");
					var d = {};
					d.summary = $scope.sdt.request.summary;
					d.saveprop = "1";					
					sdtService.saveRequest($scope.sdtRequest.getId(), JSON.stringify(d)).then(function(data) {
						console.log(data);
						sdtUtilSvc.unMask($scope.maskEle,true);
						
					},function(error){
						console.log(error);
						sdtUtilSvc.unMask($scope.maskEle,true);
						sdtUtilSvc.errorToast("Unable to save summary.");
					});
				};
				$scope.loadData = function(loadConfig){
					//load request details
					sdtUtilSvc.mask($scope.maskEle,true,"Loading details ...");
					sdtService.getReqDetails($scope.requestid, loadConfig).then(function(data) {
						console.log(data);
						sdtUtilSvc.unMask($scope.maskEle,true);
						var data = data.data.data;
						var dtls = data.details;
						var output = data.wfResponse;
						if(data.isErrorResponse === true ){
							
							if(data.errorCode == -2){
								//request does not exists, show error toast and then go to home page.
								$scope.redirectToSDTHomePage();
							}else{
								sdtUtilSvc.errorToast(data.errorMessage || "Unable to get details, please try later.");
							}
						}
						if(dtls){
							
							if(loadConfig === true){
								if(dtls.additionaldata && dtls.additionaldata.REQ_CONFIGS){
									$scope.sdt.configs = sdtUtilSvc.getAsJson(dtls.additionaldata.REQ_CONFIGS);
									$scope.sdt.setConfig($scope.sdt.configs, true);
								}
							}							
							if(dtls.additionaldata && dtls.additionaldata.SDT_DATA){
								var sdtData = dtls;
								sdtData.sites = sdtUtilSvc.getAsJson(dtls.additionaldata.SDT_DATA);
								if(sdtData.sites.retCode && sdtData.sites.retCode != 0){
									if(sdtData.sites.retCode == -2){
										$scope.redirectToSDTHomePage();
									}else{
										sdtUtilSvc.errorToast(sdtData.sites.errString ||"Invalid request id.");
									}
								}else{
									sdtData.recalculate = sdtData.sites.recalculate;
									sdtData.sites = sdtData.sites.sites;									
									$scope.sdt.sdtData = sdtData;
									console.log($scope.sdt.sdtData);
									$scope.sdt.loadRequestDetailsFromResp($scope.sdt.sdtData);
								}
							}else{
								//This is a new req, having no SDT data yet.
								var sdtData = dtls;
								$scope.sdt.sdtData = sdtData;
								//console.log($scope.sdt.sdtData);
								$scope.sdt.loadRequestDetailsFromResp($scope.sdt.sdtData);
							}
							
							if(sdtData.additionaldata){
								sdtData.additionaldata = null;
							}
							
						}
						
						if(output){
							//we have output saved in db.
							$scope.processOutputData(output);
						}
					}, function(error) {
						console.log(error);
						sdtUtilSvc.unMask($scope.maskEle,true);
						sdtUtilSvc.errorToast("Unable to load request data from server.");
					});
				}
				$scope.redirectToSDTHomePage = function(){
					sdtUtilSvc.errorToast("Request does not exists, redirecting to Solution Desing Tool home page.");
					window.location.replace("/webconsole/reportsplus/reportViewer.jsp?reportId=SDTRequests");
				}
				$scope.getRequestDetails = function(){
					//TO DO
					//if not a valid request id show new design page.
					//$scope.loadNewReqTemplate();
				}
				$scope.loadReqDtlsTemplate = function(){
					$scope.templateURL = "template/sdtreqdtls.jsp";
				}
				$scope.loadNewReqTemplate = function(){
					$scope.templateURL = "template/sdtindex.jsp";
				}
				$scope.loadNewSiteWizardTemplate = function(){
					$scope.wizardTemplateURL = "template/sdtwizard.jsp";
					$scope.wizardStepTemplateURL = "template/sdtaddsol.jsp";
				}
				$scope.hideSiteWizardTemplate = function(){
					$scope.wizardTemplateURL = "";
				}
				$scope.openAddSolutionModal = function(){
					var modalInstance = $uibModal.open({
			               templateUrl:  "template/sdtsolmodal.jsp",
			               controller: "sdtAddSolutionModalCtrl",
			               //windowClass: 'aceEditorModalWindow reportModal',
			               backdrop  : 'static',
			               resolve: {
			                    modalTitle : function() {
			                        return "Add Solution";
			                    },
			                    solutions : function() {
			                        return  $scope.sdt.getAllSolutions($scope.aSite);
			                    },
			                    selectedSolutions : function() {
			                        return $scope.sdt.selectedSolution;
			                    }
			               }
			            });

			            modalInstance.result.then(function (solutionAdded){
			            	if(solutionAdded){
			            		$scope.aSite.addSolutionObj(solutionAdded);
			            		//$scope.sdt.selectedSolution = solutionAdded;
			            	}			            	
			                console.log(solutionAdded);
			           }, function () {
			        	      console.log("Modal Canceled.");
			           });

				}
				
				$scope.solutionAdded = function(){
					if($scope.aSite.getSolutions().length > 0){
						//solution added, mark the wizard step 1 complete and go to next step.
						$scope.wizardStepTemplateURL = "template/sdtaddrepsite.jsp";
					}else{
						sdtUtilSvc.errorToast("Please add one solution to continue.");
					}
				}
				
				$scope.getConfigs = function(){
					sdtService.getConfigs().then(function(data) {
						console.log(data);
						if(data.data.data.configs){
							$scope.sdt.setConfig(JSON.parse(data.data.data.configs), true);
						}else{
							sdtUtilSvc.errorToast("Unable to load cofiguration data from server.");
						}
						
					}, function(error) {
						console.log(error);
						sdtUtilSvc.errorToast("Unable to load cofiguration data from server.");
					});
				}
				$scope.createCloudSDTRequest = function(){
					sdtService.createRequest(JSON.stringify($scope.sdtRequest)).then(function(data) {
						console.log(data);
						data = data.data.data;
						$scope.sdtRequest.setId(data.requestid)
						sdtUrlService.updateUrl({"requestCreated":data.requestid},sdtConstants.common.requestIdParam+"="+data.requestid);
						$scope.loadReqDtlsTemplate();
						//$route.updateParams({requestId: data.data.data.requestid});
						//$scope.templateURL = "template/red.html";
					}, function(error) {
						console.log(error);
						sdtUtilSvc.errorToast("Unable to load initial data from server.");
					});
				}
				$scope.showReplicationSiteModal = function(primSite){
					$scope.repSiteModalData = $scope.getRepSiteModalData(false, primSite);
					$scope.openAddRepSiteModal();
				}
				$scope.addNewReplicationSite = function(repSite){
					if(repSite){
						var newSite = $scope.sdt.getRequest().createASite(null, repSite.name, repSite.location, 
								repSite.type, true);
						newSite.updateRetentionInfo(repSite.dailyBackupRet, repSite.yearsToModel);
						newSite.addMAFromRespObj(repSite.ma);
						newSite.percentage = repSite.percentage;
						repSite.id = newSite.getId();
						$scope.aSite.addSiteObjAsReplicationSite(newSite);
					}
				}
				$scope.cancelNewReplicationSite = function(repSite){
					if(repSite && repSite.id){
						$scope.aSite.removeReplicationSiteById(repSite.id);
						$scope.sdt.getRequest().removeSiteById(repSite.id);
					}
				}
				
				$scope.maTypeChanged = function(){
					$scope.aSite.ma.models = [];
				}
				$scope.multiSelectMAModelsSettings = {
					showCheckAll : false,
					showUncheckAll : false,
					smartButtonMaxItems: 3,
					externalIdProp : 'id',
					displayProp : 'name',
					selectionLimit: 2,
					//checkBoxes: true,
					scrollable: true,
					//enableSearch: true,
					scrollableHeight: "150px",
					selectedToTop: true,
					buttonClasses: "btn btn-default form-control",
				};
				$scope.selectMAModelsEventSettings = {
					onItemSelect: function (item) {
						console.log(item);
						/*
						 * if(!$scope.aSite.selectedModels){ $scope.aSite.selectedModels = []; }
						 * $scope.aSite.selectedModels.push(item); $scope.aSite.ma.models = [];
						 * $scope.aSite.selectedModels;
						 */
					},
					onItemDeselect : function(item){
						/*
						 * var idx = $scope.aSite.selectedModels.indexOf(item);
						 * $scope.aSite.selectedModels.splice(idx, 1);
						 */
					}
				};
				$scope.saveCloudSDTRequest = function(){
					sdtUtilSvc.mask($scope.maskEle,true,"Saving data ...");
					sdtService.saveRequest($scope.sdtRequest.getId(), JSON.stringify($scope.sdtRequest)).then(function(data) {
						console.log(data);
						sdtUtilSvc.unMask($scope.maskEle,true);
						if($scope.sdt.isModify === false){
							//$scope.sdt.wizardDone();
							//right now doing reload, but we should 
							//just parse the response and update the site id created in DB, so that we dont need reload.
							window.location.reload();
						}
						$scope.sdt.sdtData.recalculate = 1;
						
					}, function(error) {
						console.log(error);
						sdtUtilSvc.unMask($scope.maskEle,true);
						sdtUtilSvc.errorToast("Unable to save request data, please try again later or check with site administrator.");
						
					});
				}
				$scope.generateSOW = function(){
					var localdataguid = $scope.getSOWGUID();
					sdtExportServices.exportLocalDoc(sdtConstants.common.SOWGUID, sdtConstants.common.SOWPrefix, localdataguid);
				}
				$scope.getSOWGUID = function(){
					return $scope.sowGUID;
					//return "somnath-test-docx-guid-sow";
				}
				$scope.generatePPT = function(){
					var localdataguid = $scope.getPPTGUID();
					sdtExportServices.exportLocalPpt(sdtConstants.common.PPTGUID, sdtConstants.common.PPTPrefix, localdataguid);
				}
				$scope.getPPTGUID = function(){
					return $scope.pptGUID;
					//return "somnath-test-docx-guid-sow";
				}
				$scope.calculate = function(){
					if($scope.sdtRequest.isSiteAdded() === false){
						sdtUtilSvc.errorToast("No site added for calculations.");
						return;
					}
					$scope.designoutput = "Please wait...";
					sdtUtilSvc.mask($scope.maskEle,true,"Please wait...");
					sdtService.runWorkflow($scope.sdtRequest.getId()).then(function(data) {
						console.log("worfklow execution data: ", data);
						sdtUtilSvc.unMask($scope.maskEle,true);
						var data = data.data.data;
						if(data.isErrorResponse === false && data.wfResponse){
							//success in calculations.
							$scope.sdt.sdtData.recalculate = 0;
							$scope.processOutputData(data.wfResponse);
						}
						//$scope.designoutput = "Test Data";
					}, function(error) {
						console.log(error);
						sdtUtilSvc.unMask($scope.maskEle,true);
						sdtUtilSvc.errorToast("Unable to calculate, please try again later or check with site administrator.");
						
					});
					
				}
				$scope.processOutputData = function(data){
					console.log("Output Data", data);
					//designCSS
					$scope.designoutput = $scope.sdt.config.designCSS + data.output.htmlData;
					$scope.sowGUID = data.SDT_SOW_GUID;
					$scope.pptGUID = data.SDT_PPT_GUID;
				};
				$scope.showTestRecommendData = function(){
					$scope.designoutput = "<table class=\"table\"><caption><b>Commserv Server</b></caption><thead><tr><th>OS</th><th>CPU Core</th><th>RAM</th><th>Disk</th></tr></thead><tbody><tr><td>Windows</td><td>16</td><td>128 GB</td><td>500 GB SSD</td></tr></tbody></table><table class=\"table\"><caption><b>WebServer server</b> <a href=\"javascript:void();\" id=\"webstip\" data-toggle=\"tooltip\" class=\"sprite icon-info\" title=\"<br>Please follow <a target='_new' href='https://documentation.commvault.com/commvault/v11/article?p=1662.htm'>this link</a> for reference.<br>&nbsp;\">  </a></caption><thead><tr><th>OS</th><th>Type</th><th>No of servers</th><th>CPU Core</th><th>RAM</th><th>Disk</th></tr></thead><tbody><tr><td>Windows</td><td>Large</td><td>1</td><td>16</td><td>64 GB</td><td>1 TB</td></tr></tbody></table><table class=\"table\"><caption><b>Web Console / Command Center</b> <a href=\"javascript:void();\" id=\"webctip\" data-toggle=\"tooltip\" class=\"sprite icon-info\" title=\"<br>Network Gateway (Proxy) can be installed on the same machine.<br>For environments with multiple domains, use one Web Console for each user domain.<br>For external access for use with mobile applications, use a dedicated Web Console.<br>Please follow <a target='_new' href='https://documentation.commvault.com/commvault/v11_sp18/article?p=41179.htm'>this link</a> for reference.<br>&nbsp;\">  </a></caption><thead><tr><th>OS</th><th>No of Servers</th><th>CPU Core</th><th>RAM</th><th>Disk</th></tr></thead><tbody><tr><td>Linux</td><td>2</td><td>8</td><td>2  GB</td><td>500 GB</td></tr></tbody></table><table class=\"table\"><caption><b>Site 1 -- VSA proxies</b> <a href=\"javascript:void();\" id=\"vsatip\" data-toggle=\"tooltip\" class=\"sprite icon-info\" title=\"<br>Please follow <a target='_new' href='https://documentation.commvault.com/commvault/v11_sp18/article?p=32813.htm'>this link</a> for reference.<br>&nbsp;\">  </a></caption><thead><tr><th>Agent</th><th>Proxy Type</th><th>No of Proxies</th><th>CPU Core (Per Proxy)</th><th>RAM (Per Proxy)</th><th>FET (Per Proxy)</th></tr></thead><tbody><tr><td rowspan=\"1\">VMWare</td><td>Small</td><td>1</td><td>4</td><td>24 GB</td><td>20</td></tr><tr><td rowspan=\"1\">Amazon</td><td>Medium</td><td>1</td><td>8</td><td>32 GB</td><td>30</td></tr><tr><td rowspan=\"1\">HyperV</td><td>Extra Small</td><td>1</td><td>2</td><td>16 GB</td><td>1</td></tr></tbody></table><table class=\"table\"><caption><b>Site 1 -- Media Agent (Traditional Hardware) </b> <a href=\"javascript:void();\" id=\"matip\" data-toggle=\"tooltip\" class=\"sprite icon-info\" title=\"<br>Please follow <a target='_new' href='https://documentation.commvault.com/commvault/v11_sp18/article?p=1650_1.htm'>this link</a> for reference.<br> &nbsp;\">  </a><br>To change default BET settings <a href=\"BETPrediction.jsp?requestId=90604\">Click here</a>.</caption><thead><tr><th>OS</th><th>Years</th><th>Back End TB Storage Requirement</th><th>Media Agents</th></tr></thead><tbody><tr><td>Linux or Windows</td><td>1</td><td>275</td><td>1 Large  <b>OR</b>  1 Extra Large</td><td><tr></tbody></table><table class=\"table\"><caption><b>Site 2 -- Media Agent (Traditional Hardware) </b> <a href=\"javascript:void();\" id=\"matip\" data-toggle=\"tooltip\" class=\"sprite icon-info\" title=\"<br>Please follow <a target='_new' href='https://documentation.commvault.com/commvault/v11_sp18/article?p=1650_1.htm'>this link</a> for reference.<br> &nbsp;\">  </a><br>To change default BET settings <a href=\"BETPrediction.jsp?requestId=90604\">Click here</a>.</caption><thead><tr><th>OS</th><th>Years</th><th>Back End TB Storage Requirement</th><th>Media Agents</th></tr></thead><tbody><tr><td>Linux or Windows</td><td>1</td><td>37</td><td>1 Large  <b>OR</b>  1 Extra Large</td><td><tr></tbody></table><script nonce=\"\">$(document).ready(function() {   console.log(\"kjsndkfsndkf hi &&&&&&&&***************************\");    $(\"#commstip,#webstip,#webctip,#vsatip,#matip\").tooltip({html: true});});</script>";
				};
				$scope.modifyReplicationSite = function(siteObj, repSiteObj){
					$scope.repSiteModalData = $scope.getRepSiteModalData(true, siteObj, repSiteObj);
					$scope.openAddRepSiteModal();
				}
				$scope.getRepSiteModalData = function(isModify, site, repsite){
					var repSiteModalData = {};
					repSiteModalData.modify = (isModify===true?true:false);
					
					repSiteModalData.site = {};
					repSiteModalData.repSite = {};
					if(site){
						if(repSiteModalData.modify){
							repSiteModalData.site = site;
						}else{
							repSiteModalData.site.dailyBackupRet = site.dailyBackupRet;
							repSiteModalData.site.yearsToModel = site.yearsToModel;
						}
						if(repsite){
							repSiteModalData.site.percentage = repsite.replicationPrecentage;
							repSiteModalData.repSite = repsite
						}
					}
					
					return repSiteModalData;
				}
				$scope.openAddRepSiteModal = function(){
					var modalInstance = $uibModal.open({
			               templateUrl:  "template/sdtrepsitemodal.jsp",
			               controller: "sdtAddRepSiteModalCtrl",
			               //windowClass: 'aceEditorModalWindow reportModal',
			               backdrop  : 'static',
			               resolve: {
			                    modalTitle : function() {
			                        return "Add Solution";
			                    },
			                    sdt : function() {
			                        return  $scope.sdt;
			                    },
			                    modaldata : function() {
			                        return $scope.repSiteModalData;
			                    }
			               }
			            });

			            modalInstance.result.then(function (repSiteData){
			            	if(repSiteData){
			            		$scope.repSiteModalData = repSiteData;
			            		if($scope.repSiteModalData.modify ===  false){
				            		$scope.addNewReplicationSite($scope.repSiteModalData.site);
			            		}else{
			            			$scope.repSiteModalData.repSite.replicationPrecentage = $scope.repSiteModalData.site.percentage;
			            		}
			            	}			            	
			                
			           }, function (repSiteData) {
			        	   if(repSiteData){
			            		$scope.repSiteModalData = repSiteData;
			            		if($scope.repSiteModalData.modify ===  false){
			            			$scope.cancelNewReplicationSite($scope.repSiteModalData.site);
			            		}
			            	}
			        	   console.log("Add Rep Site Modal Canceled.");
			           });

				}
				
				$scope.openConfirmModal = function(title, msg, callback){
					//$scope.sdt.confirmModalCallBack = callback;
					var modalInstance = $uibModal.open({
			               templateUrl:  "template/sdtconfirmmodal.jsp",
			               controller: "sdtConfirmModalCtrl",
			               //windowClass: 'aceEditorModalWindow reportModal',
			               backdrop  : 'static',
			               size : 'sm',
			               resolve: {
			                    modalTitle : function() {
			                    	if(title) {
										return title;
									}
			                        return "Please Confirm";
			                    },
			                    modalMsg : function() {
			                    	if(msg) {
										return msg;
									}
			                    	return "Are you sure?";
			                    }
			               }
			            });

			            modalInstance.result.then(function (confirmed){
			            	if(confirmed === true){
			            		if(callback){
			            			callback();
			            		}
			            	}			            	
			                
			           }, function () {
			        	   return;
			           });

				}



		} ]);
	app.controller("sdtAddSolutionModalCtrl", [
		"$scope",
		"$uibModalInstance",
		"modalTitle",
		"solutions",
		"selectedSolutions",
		function($scope, $uibModalInstance, modalTitle, solutions, selectedSolutions) {
			$scope.selectedSol = selectedSolutions;
			$scope.modalTitle = modalTitle;
			$scope.solutions = solutions;
			$scope.ok = function() {	
  				$uibModalInstance.close($scope.selectedSol);
			};

			$scope.cancel = function() {
				$uibModalInstance.dismiss()
			}
		
		}]);
	app.controller("sdtAddRepSiteModalCtrl", [
		"$scope",
		"$uibModalInstance",
		"modalTitle",
		"sdt",
		"modaldata",
		function($scope, $uibModalInstance, modalTitle, sdt, modaldata) {
			$scope.sdt = sdt;
			$scope.modalTitle = modalTitle;
			$scope.modaldata = modaldata;
			$scope.aNewRepSite = modaldata.site;
			$scope.aNewRepSite.percentage = modaldata.site.percentage;
			console.log(modaldata);
			$scope.multiSelectMAModelsSettings = {
				showCheckAll : false,
				showUncheckAll : false,
				smartButtonMaxItems: 3,
				externalIdProp : 'id',
				displayProp : 'name',
				selectionLimit: 2,
				//checkBoxes: true,
				scrollable: true,
				//enableSearch: true,
				scrollableHeight: "150px",
				selectedToTop: true,
				buttonClasses: "btn btn-default form-control",
			};
			$scope.ok = function() {	
  				$uibModalInstance.close($scope.modaldata);
			};

			$scope.cancel = function() {
				$uibModalInstance.dismiss($scope.modaldata)
			};
			
			$scope.selectMAModelsEventSettings = {
				onItemSelect: function (item) {
					console.log(item);
				},
				onItemDeselect : function(item){
					
				}
			};
			$scope.maTypeChanged = function(){
				if($scope.aNewRepSite.ma){
					$scope.aNewRepSite.ma.models = [];
				}else{
					$scope.aNewRepSite.ma = {};
					$scope.aNewRepSite.ma.models = [];
				}
				
				var maModels = $scope.sdt.getMAModelsByMAId($scope.aNewRepSite.ma.id);
				if(maModels.length <= 2){
					$scope.aNewRepSite.ma.models = maModels;
				}
			}
		
		}]);
	app.controller("sdtConfirmModalCtrl", [
		"$scope",
		"$uibModalInstance",
		"modalTitle",
		"modalMsg",
		function($scope, $uibModalInstance, modalTitle, modalMsg) {
			
			$scope.modalTitle = modalTitle;
			$scope.confirmMsg = modalMsg;
			$scope.ok = function() {	
  				$uibModalInstance.close(true);
			};

			$scope.cancel = function() {
				$uibModalInstance.dismiss(false)
			};
			
					
		}]);
		
})();
