(function() {
	"use strict";
	var app = angular.module("sdt", [ "ui.bootstrap", "angularjs-dropdown-multiselect", "ngTable", "ngSanitize" ]);

	window.sdtPendingRequests = 0;
	app.run([ "$http", function(http) {
		http.defaults.headers.common["X-Requested-With"] = "XMLHttpRequest"
	} ]);
	app.config([ '$httpProvider', '$sceProvider', '$provide', function($httpProvider, $sceProvider, $provide) {

		$httpProvider.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded;charset=utf-8';
		//$locationProvider.html5Mode(true);
		$sceProvider.enabled(false);
		// this is a workaround for the issue where we get into infinite digest loops when using history api with angular.js
		$provide.decorator('$location', [ '$delegate', '$browser', function($delegate, $browser) {
			$delegate.absUrl = function() {
				return $browser.url();
			};
			return $delegate;
		} ]);
		// Override $http service's default transformRequest
		$httpProvider.defaults.transformRequest = [ function(data) {
			/**
			 * The workhorse; converts an object to x-www-form-urlencoded serialization.
			 * 
			 * @param {Object}
			 *            obj
			 * @return {String}
			 */

			var param = function(obj) {
				var query = '';
				var name, value, fullSubName, subName, subValue, innerObj, i;
				for (name in obj) {
					value = obj[name];
					if (value instanceof Array) {
						for (i = 0; i < value.length; ++i) {
							subValue = value[i];
							fullSubName = name + '[' + i + ']';
							innerObj = {};
							innerObj[fullSubName] = subValue;
							query += param(innerObj) + '&';
						}
					} else if (value instanceof Object) {
						for (subName in value) {
							subValue = value[subName];
							fullSubName = name + '[' + subName + ']';
							innerObj = {};
							innerObj[fullSubName] = subValue;
							query += param(innerObj) + '&';
						}
					} else if (value !== undefined && value !== null) {
						query += encodeURIComponent(name) + '=' + encodeURIComponent(value) + '&';
					}
				}
				return query.length ? query.substr(0, query.length - 1) : query;
			};
			return angular.isObject(data) && String(data) !== '[object File]' ? param(data) : data;
		} ];

		$httpProvider.interceptors.push([ '$q', "sdtUtilSvc", function($q, sdtUtilSvc) {
			return {
				response : function(response) {
					window.sdtPendingRequests--;
					return response;
				},
				responseError : function(rejection) {
					window.sdtPendingRequests--;
					return $q.reject(rejection);
				},
				request : function(config) {
					window.sdtPendingRequests++;
					var csrfParam = sdtUtilSvc.readCookie('csrf');
					config.headers['X-CSRF-Token'] = csrfParam;
					return config;
				},
				requestError : function(rejection) {
					window.sdtPendingRequests--;
					return $q.reject(rejection);
				}
			};
		} ]);
	} ]);

	app.service("sdtUrlService", [ "$location", function($location) {
		return {
			updateUrl : function(params, url) {
				$location.path(url);
				history.pushState(params, document.title, "?" + url);
			},
			readUrlParams : function() {
				return $location.search();
			},
			getUrlParams : function(url) {
				var urlParams = {};
				var defaultUrl = window.location.search.substring(1);
				var e, a = /\+/g, r = /([^&=]+)=?([^&]*)/g, d = function(s) {
					return decodeURIComponent(s.replace(a, " "));
				}, q = url || defaultUrl;

				while (e = r.exec(q)) {
					urlParams[d(e[1])] = d(e[2]);
				}
				return urlParams;
			},
			getParameter : function(name, url, defaultValue) {
				name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
				var regexS = "[\\?&]" + name + "=([^&#]*)";
				var regex = new RegExp(regexS);
				if (typeof url === "undefined" || url === null) {
					url = window.location.href;

				}
				var results = regex.exec(url);
				if (results === null) {
					if (typeof defaultValue !== 'undefined') {
						return defaultValue;
					} else {
						return "";
					}
				} else {
					return decodeURIComponent(results[1].replace(/\+/g, " "));
				}
			},

			getParameterByName : function(name, defaultValue) {
				return this.getParameter(name, null, defaultValue, true);
			}

		};

	} ]);

	app.factory('cvToaster', [ function() {
		var toaster = {};

		toaster.showErrorMessageWithDetails = function(ops) {
			cvUtil.errorWithDetailsToast(ops.intialText.trim(), ops.endText.trim(), ops.more, ops.less, true);
		};

		toaster.showInfoMessageWithDetails = function(ops) {
			cvUtil.infoToastWithDetails(ops.intialText.trim(), ops.endText.trim(), ops.more, ops.less, true);
		};

		toaster.showWarnMessage = function(ops) {
			cvUtil.toast(ops.message, ops.delay);
		};

		toaster.showErrorMessage = function(ops) {
			cvUtil.errorToast(ops.message, ops.delay);
		};

		toaster.showInfoMessage = function(ops) {
			cvUtil.toast(ops.message, ops.delay);
		};

		toaster.showSuccessMessage = function(ops) {
			cvUtil.toast(ops.message, ops.delay);
		};

		return toaster;
	} ]);
	app.service("sdtUtilSvc", [ '$timeout', 'cvToaster', function($timeout, cvToaster) {
		this.readCookie = function(name) {
			var nameEQ = name + "=";
			var ca = document.cookie.split(';');
			for (var i = 0; i < ca.length; i++) {
				var c = ca[i];
				while (c.charAt(0) == ' ') {
					c = c.substring(1, c.length);
				}
				if (c.indexOf(nameEQ) == 0) {
					return c.substring(nameEQ.length, c.length);
				}
			}
			return null;
		};
		this.mask = function(div, isId, message) {
			var preFix = (isId == true) ? "#" : ".";
			$(preFix + div).mask(message);
		}

		this.unMask = function(div, isId) {
			var preFix = isId == true ? "#" : ".";
			$(preFix + div).unmask();
		}
		this.errorToast = function(msg, delay) {
			var message = {
				message : msg,
				delay : !delay ? 3000 : delay,
				ttl : 5000
			};
			cvToaster.showErrorMessage(message);
		}

		this.toast = function(msg, delay) {
			var message = {
				message : msg,
				delay : !delay ? 3000 : delay,
				ttl : 5000
			};
			cvToaster.showInfoMessage(message);
		}

		this.errorWithDetailsToast = function(intialText, endText, more, less) {
			var message = {
				intialText : intialText,
				endText : endText,
				more : more,
				less : less,
				ttl : 5000
			};
			cvToaster.showErrorMessageWithDetails(message);
		}

		this.infoWithDetailsToast = function(intialText, endText, more, less) {
			var message = {
				intialText : intialText,
				endText : endText,
				more : more,
				less : less,
				ttl : 5000
			};
			cvToaster.showInfoMessageWithDetails(message);
		}
		this.getAsJson = function(data) {
			if (typeof data === 'string' || data instanceof String) {
				data = JSON.parse(data);
			} else {
				if (!data) {
					data = {};
				}
			}
			return data;
		}

	} ]);

})();