$(document).ready(function() {

	cvUtil.loadPage(cvUtil.getContextPath() + '/server/searchtoolpage', opDetails, function(data) {
		$(".searchToolsDetails").html(data);
		$("#ajaxBusyMail").html("");
		initializeControl();
		var cDiv = 0;
		$(".searchToolsDetails").children().each(function() {
			cDiv += $(this).children().length;
		});
		if (cDiv == 0) {
			$(".nocustomer").show();
		}
		bindEvents();
		$(".psebubblenotes").tipTip({
			maxWidth : "49%",
			defaultPosition : "top",
			edgeOffset : 10
		});
	});
});

var initializeControl = function() {
	if (opDetails.parents != undefined) {
		for (ap in opDetails.parents) {
			if (ap != 4) {
				if (opDetails.itemVal != undefined) {
					if (opDetails.itemVal[ap] != "" || opDetails.itemVal[ap] != undefined) {
						if (opDetails.itemVal[ap].toLowerCase() == "no")
							controlDiv(".label" + ap, "no");
						else
							controlDiv(".label" + ap, "yes");
					}
				}
			}
		}
	}
};

var controlDiv = function(labelClass, val) {
	if (val == "no") {
		$(labelClass).hide();
	} else
		$(labelClass).show();
};

function searchToolOptionControl(ev) {
	controlDiv(".label" + ev.target.id.slice(1), ev.target.value.toLowerCase());
	solutionOptionValues(ev);
}

var solutionOptionValues = function(e, isNumCheck) {
	var idx = e.target.id.slice(1);
	if (isNumCheck != undefined && isNumCheck) {
		$(e.target).val(replaceNonNumericChar(replaceCommasFromNUmbers(e.target.value)));
	}
	opDetails.itemVal[idx] = replaceCommasFromNUmbers(e.target.value);
};

var solutionDetails = function(type) {
	opDetails.type = type.toString();
	checkParentsAndClearValues();
	if (!solutionOptionsEmptyCheck()) {
		alert("Please check inputs, those are in red.");
		return;
	}
	if (type == 3) {
		if (noOptionsSelected()) {
			alert("Please select atleast one search option as yes, all are selected as no.");
			return;
		}
	}
	opDetails.childparent = "";
	var locurl = cvUtil.getContextPath() + '/server/solutionDetails.do?steps=' + steps + '&currentstep=' + currentstep +
			'&opDetails=' + JSON.stringify(opDetails);
	window.location = locurl;
};

var checkParentsAndClearValues = function() {
	if (opDetails.childparent != undefined) {
		for (achild in opDetails.childparent) {
			if (!(opDetails.childparent[achild] == 4 || opDetails.childparent[achild] == 0)) {
				if (opDetails.itemVal != undefined) {
					if (opDetails.itemVal[opDetails.childparent[achild]].toString().toLowerCase() == "no") {
						opDetails.itemVal[achild] = "";
					}
				}
			}
		}
	}
};

var checkboxhandle = function(ev, el) {
	var v = "";
	if ($(el.firstChild).hasClass("chcked")) {
		//that is checked.So remove checked and the value from opDetails.
		$(el.children[1]).removeClass('chckedtext');
		$(el.firstChild).removeClass("chcked");
		savecheckboxvalue(el, "rem");
	} else {
		//it was not checked, check it now and then save the value.
		$(el.firstChild).addClass("chcked");
		$(el.children[1]).addClass('chckedtext');
		savecheckboxvalue(el, "add");
	}
};
var savecheckboxvalue = function(el, res) {
	var idx = el.id.slice(3);
	var elv = opDetails.itemVal[idx].split(",");
	if ($(el).attr('value')) {
		var v = $(el).attr('value');
		var remindex = -1;
		for (var i = 0; i < elv.length; i++) {
			if (elv[i].toLowerCase() == v.toLowerCase()) {
				remindex = i;
			}
		}
		if (res == "add") {
			if (remindex == -1)//means its not added.
				elv.push($(el).attr('value'));
		} else if (res == "rem") {
			if (remindex != -1)//means its there we have to remove it.
			{
				var secArr = new Array();
				for (var i = 0; i < elv.length; i++) {
					if (i == remindex)
						continue;
					secArr.push(elv[i]);
				}
				elv = secArr;
			}
		}
	}
	opDetails.itemVal[idx] = elv.join(",");

};
var controlInfoDiv = function(fors, e) {
	$c = $("." + fors);
	if ($(e.target).attr("action") == "hide") {
		//show the div
		$($c).show();
		$(e.target).attr("action", "show");
		$(e.target).html("x");
		$(e.target).removeClass("psebadge-info");
		$(e.target).addClass("psebadge-inverse");
	} else if ($(e.target).attr("action") == "show") {
		$($c).hide();
		$(e.target).attr("action", "hide");
		$(e.target).html("i");
		$(e.target).removeClass("psebadge-inverse");
		$(e.target).addClass("psebadge-info");
	}
};
var removeValErrClass = function(ev) {
	if ($(ev.target).hasClass("psevalidationerror")) {
		$(ev.target).removeClass("psevalidationerror");
	} else if ($(ev.target).parent().parent().hasClass("psevalidationerror")) {
		$(ev.target).parent().parent().removeClass("psevalidationerror");
	}
	$(ev.target).unbind("click", removeValErrClass);
};
var nothingSlctd = true;
var solutionOptionsEmptyCheck = function() {
	var ret = true;
	if (opDetails.childparent != undefined) {
		for (ach in opDetails.childparent) {
			if (opDetails.childparent[ach] != 4) {
				if (opDetails.itemVal != undefined) {
					//check the parent data, if it is no then we have to check child data for validation.
					if (opDetails.itemVal[opDetails.childparent[ach]].toLowerCase() == "yes") {
						//check child data if it is null or empty then we have to raise error.
						nothingSlctd = false;
						if (opDetails.itemVal[ach] == "" || opDetails.itemVal[ach] == undefined ||
								opDetails.itemVal[ach].length == 0) {
							//check if there is anything related to radio or text box is there then save the border of it and mark that in red color like red 1px solid;
							ret = false;
							if ($("#t" + ach).length != 0) {
								// we got a text box, make border red.
								$("#t" + ach).addClass("psevalidationerror");
								$("#t" + ach).unbind("click", removeValErrClass);
								$("#t" + ach).bind("click", removeValErrClass);
							} else if ($("#chk" + ach).length != 0) {
								//we got check box,
								$("#chk" + ach).parent().addClass("psevalidationerror");
								$("#chk" + ach).unbind("click", removeValErrClass);
								$("#chk" + ach).bind("click", removeValErrClass);

							}
						}
					}
				}
			}
		}
	}
	return ret;
};

var noOptionsSelected = function() {
	return nothingSlctd;
};