$(document).ready(function() {
	cvUtil.loadPage(cvUtil.getContextPath() + '/server/customerList', null, function(data) {
		$("#holder").html(data);
		var cDiv = 0;
		$("#holder").children().each(function() {
			cDiv += $(this).children().length;
		});
		if (cDiv == 0) {
			$(".nocustomer").show();
		}
	});

	cvUtil.loadPage(cvUtil.getContextPath() + '/server/addcustomerscreen.do', null, function(data) {
		$("#calladdcust").html(data);
	});
});

var initializeAllCustomerTable = function() {
	customertable = $('#customertable').dataTable({
		"sAjaxSource" : createBrowseAjaxUrl(null, null, null, tableTrcData),
		"bServerSide" : true,
		"sDom" : "Rlfrtip",
		"oColReorder" : {
			"iFixedColumns" : 1
		},
		"bLengthChange" : false,
		"sPaginationType" : 'input',
		"bRetrieve" : true,
		"bAutoWidth" : false,
		"bFilter" : false,
		"iDisplayLength" : PAGE_LENGTH,
		"aoColumnDefs" : getColumnDefs(currentViewId),
		"oLanguage" : {
			"oPaginate" : {
				"sFirst" : '&nbsp;',
				"sNext" : '&nbsp;',
				"sPrevious" : '&nbsp;',
				"sLast" : '&nbsp;'
			},
			"sEmptyTable" : localMsg.noDataAvailable
		},
		//"fnDrawCallback" : tableLoaded,
		"fnServerData" : function(sSource, aoData, fnCallback) {
			// console.debug("fnServerData - reinitializingTable=" + reinitializingTable);
			if (reinitializingTable) {
				return;
			}

			var emptyExpected = emptyBrowseExpected(browsePath);
			setShowingEmptyBrowse(emptyExpected);

			if (emptyExpected) {
				/*
				 * This will return true only for exchange apptype, if showOnlyFilesInTable is true, and if
				 * the browse request is for the mailbox root. In this case, since there are never emails in
				 * the mailbox root, we just construct and use an empty response instead of sending out a
				 * query:
				 */
				fakeEmptyTableResponse(aoData, fnCallback);

				// Move selection to root node:
				var rootNode = $("#browsetree").dynatree("getRoot");
				if (rootNode != null) {
					rootNode.activateSilently();
				}
			} else if (tableDataCache !== null) {

				/*
				 * This is our second pass - the first one needed to abort to change views and reinitialize
				 * the table. Proceed using the cached data we kept from the first pass.
				 */
				console.debug("Processing table data lfrom tableDataCache");
				processTableBrowseData(tableDataCache, fnCallback);
			} else {
				/*
				 * Load the requested data. If the result contains a viewId different from our current viewId
				 * then we will need to reinitialize the table to change views, and we will end up back here
				 * again to process the data we load
				 */
				console.debug("Requesting data for table population");

				var ajaxData = createBrowseAjaxUrl(null, null, aoData, tableTrcData);
				// Send any queued selections before we process the load, in case we just changed pages
				sendQueuedSelectActions(function() {
					loadBrowseData(true, ajaxData["data"], ajaxData["url"], function(json) {
						extractSessionId(json, false);
						processTableBrowseData(json, fnCallback);
					});
				});
			}
		}
	});

	function tableLoaded() {
		CVTable.styleIt();
		preview.resetGuids();
		if (preview.isPopupOpen()) {
			$("#customertable").find("tr:nth-child(1)").click();
		}
	}
};

var showAddDiv = function(doload, customerid) {
	if (doload) {
		//load from the server.
		showCustModDiv();
		$(".addcontent > div,.bbar").addClass("chide");
		$("#ajaxBusyMail").removeClass("chide");
		getCustomerDetails(customerid);
	} else {
		$(".addcust").attr("customer-id", 0);
		$(".addl").text("Add Customer");
		$("#saveb").text("Save");
		showCustModDiv();
		$("#address").val("");
		$("#cprsn").val("");
		$("#phone").val("");
		$("#email").val("");
		$("#cname").val("");
	}

};

var getCustomerDetails = function(customerid) {
	params = {};
	params.custid = customerid;
	$(".addcust").attr("customer-id", customerid);
	cvUtil.loadPage(cvUtil.getContextPath() + '/server/customerDetails', params, function(data) {
		$(".addcontent > div,.bbar").removeClass("chide");
		$("#ajaxBusyMail").addClass("chide");
		$("#cname").val(data.cname);
		selectOptionVasedOnText("#rgns option", data.region);
		selectOptionVasedOnText("#ind option", data.industry);
		//$("#rgns").val(data.region);
		//$("#ind").val(data.industry);#saveb, .blocktitle,addl
		//customersList>div>div>div>ul.secrows
		var ism = false;
		$("#myCustomersList > div > div > div > ul.secrows > li:first-child").each(function(index) {
			if ($(".addcust").attr("customer-id") === $(this).attr('value').toString()) {
				$(".addl").text("Modify Customer");
				$("#saveb").text("Save");
				ism = true;
			}
		});
		if (!ism) {
			$(".addl").text("Add To My List");
			$("#saveb").text("Add");
		}
		$("#address").val(data.address);
		$("#cprsn").val(data.contactPers);
		$("#phone").val(data.phone);
		$("#email").val(data.email);
	});
};

var saveCustomerDetails = function() {
	params = {};
	params.custid = 0;
	if (!($(".addcust").attr("customer-id") == undefined || $(".addcust").attr("customer-id") == 0)) {
		//send this to server to create an entry in the op db and update the customer details.
		params.custid = $(".addcust").attr("customer-id");
	}
	//send this to server to make an entry in the c table and laso create an op.

	var doAlert = false;
	if ($("#cname").val().replace(/^\s+|\s+$/g, '').length == 0) {
		doAlert = true;
		mandatoryFieldValidation("#cname");
	}
	if ($("#rgns").val().replace(/^\s+|\s+$/g, '').length == 0) {
		doAlert = true;
		mandatoryFieldValidation("#rgns");
	}
	if ($("#address").val().replace(/^\s+|\s+$/g, '').length == 0) {
		doAlert = true;
		mandatoryFieldValidation("#address");
	}
	if ($("#cprsn").val().replace(/^\s+|\s+$/g, '').length == 0) {
		doAlert = true;
		mandatoryFieldValidation("#cprsn");
	}
	if ($("#phone").val().replace(/^\s+|\s+$/g, '').length == 0) {
		doAlert = true;
		mandatoryFieldValidation("#phone");
	}
	if ($("#email").val().replace(/^\s+|\s+$/g, '').length == 0) {
		doAlert = true;
		mandatoryFieldValidation("#email");
	}
	if ($("#ind").val().replace(/^\s+|\s+$/g, '').length == 0) {
		doAlert = true;
		mandatoryFieldValidation("#ind");
	}
	if (doAlert) {
		alert("please check inputs, those are in red.");
		return;
	}

	if (!cvUtil.isEmailValid($("#email").val())) {
		mandatoryFieldValidation("#email");
		alert("Email is not valid.");
		return;
	}
	params.cname = $("#cname").val();
	params.region = $("#rgns").val();
	params.address = $("#address").val();
	params.contactPers = $("#cprsn").val();
	params.phone = $("#phone").val();
	params.email = $("#email").val();
	params.industry = $("#ind").val();
	cvUtil.loadPage(cvUtil.getContextPath() + '/server/saveCustomerDetails', params, function(data) {
		closeCustModDiv();
		$("#holder").html(data);
	}, function(errdata) {
		alert(errdata);
	});

};

var selectOptionVasedOnText = function(selector, textvalue) {
	$(selector).filter(function() {
		return this.text == textvalue;
	}).prop('selected', true);
};
