<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<jsp:include page="../../common/header.jsp">
	<jsp:param value="PS_Estimator" name="title" />
	<jsp:param value="../../common/css/headerstyles.css" name="css" />
	<jsp:param value="css/psecommon.css" name="css" />
	<jsp:param value="css/psecommonbutton.css" name="css" />
	<jsp:param value="true" name="includeSecHeader" />
	<jsp:param value="PS_Estimator" name="headerTitle" />
	
</jsp:include>

<style>
#searchDiv {
    position: absolute;
    top: 70px;
    right: 20px;
}
#searchDiv {
    width: 250px;
}

#grpSearch {
    width: 250px;
}
#searchDiv label {
    display: inline-block;
    line-height: 1.5;
    padding: 5px 0 3px 5px;
}

#closeSearch {
	width: 12px;
	height: 12px;
	position: absolute;
	right: 5px;
	background: url(../../common/css/images/ui-icons_222222_256x240.png);
	background-position: -80px -128px;
	cursor:pointer;
}

.customersForSearch select  {
	position: absolute;
    border: 1px solid #CCCCCC;
    border-radius: 4px 4px 4px 4px;
    display: block;
    margin: 0 10px;
    width: 250px;

}

#searchDiv .customSelection {
	text-overflow: ellipsis;
	overflow-x: hidden;
}

.customerSearch {
	padding: 5px 15px 0 5px;
	background: #f6f6f6;
	font-size: 0.875em;
	border: 1px solid #ccc;
	border-top: 0;
	box-shadow: 0 1px 8px 0px rgba(20,20,20,0.2);
	color: #888;
	width: 234px;
}

.customersForSearch li {
	width: 100%;
	padding: 5px;
	color: #333;
	cursor: pointer;
}

#searchDiv .customersForSearch label {
	width: 60px;
  	overflow-x: hidden;
	padding: 5px 0 0 5px;
}

.customersForSearch li.selectedcustomer {
	background: #ddd;
}


</style>

<div id="holder">
<div id="ajaxBusyMail" class="center_it"><img src="../../common/img/loader.gif" /></div>
</div>
<fmt:message key="Search" var="searchKey"/>
<div id="searchDiv">
	<input type="search" id="grpSearch" placeholder="${searchKey}" />
	<div class="hidden" id="closeSearch"></div>
	<img class="deleteText" alt="x" src="../../common/img/close.png">
	<div class="hidden customerSearch">Search in All Customer..<img id="searchload" src="../../common/img/loader_20.gif"/><img id="searchClose" src="../../common/img/clodse.png" style="color: red;float:right;cursor: pointer;" title="Close" alt="x"><ul class="customersForSearch"></ul></div>
</div>

<div class="hidden nocustomer">
	<fmt:message key="nocustomer" />
</div>

<script nonce="${sessionScope.cspNonce}" >

function managecustomerList(data){
	$("#searchload").hide();
	$(".customersForSearch").html(data);
	if($(".customerSearch").is(':hidden')){
		$(".customerSearch").show();
	}
}
var fVal = "";
$("#grpSearch").focus(function(){
	if(fVal == "")
		fVal = $.trim($("#grpSearch").val());
	else{
		if(fVal != $.trim($("#grpSearch").val())){
			searchCustomer();
		}else{
			if($(".customerSearch").is(':hidden')){
				$(".customerSearch").show();
			}
		}
	}
});


$("#searchClose").click(function(){
	$(".customerSearch").hide();
});
var ajaxTout=0;
$("#grpSearch").keyup(function(event){
	if(ajaxTout != 0){
		clearTimeout(ajaxTout);
	}
	ajaxTout = setTimeout(searchCustomer,500);
});
function searchCustomer(){
	ajaxTout = 0;
	fVal = $.trim($("#grpSearch").val());
	params = {};
	params.Name=$.trim($("#grpSearch").val());
	$("#searchload").show();
	$(".customersForSearch").html("");
	cvUtil.loadPage(cvUtil.getContextPath()+"/server/searchAllCustomer", params, managecustomerList);
}

$("#closeSearch").on("click", function() {
	$(".customersForSearch").hide();
	$("#closeSearch").hide();
});
</script>
<div id="calladdcust"></div>
<!--<jsp:include page="addCustomer.jsp"/>!-->
<jsp:include page="../../common/footer.jsp">
	<jsp:param value="js/psecommon.js" name="js" />
	<jsp:param value="js/customers.js" name="js" />
	<jsp:param value="../../common/js/jquery.corner.js" name="js" />
</jsp:include>

<c:if test="${not empty sessionScope.LOCALIZED_ERROR_MSG}">
	<script nonce="${sessionScope.cspNonce}" >
		cvUtil.errorToast("${sessionScope.LOCALIZED_ERROR_MSG}", null, null, true);
	</script>
	<c:set var="LOCALIZED_ERROR_MSG" value="" scope="session" />
</c:if>
