<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:message key="summary.link.computers" var="computersText" />
<fmt:message key="summary.link.sync" var="syncText" />
<fmt:message key="summary.link.email" var="emailText" />
<fmt:message key="summary.link.vms" var="vmsText" />
<fmt:message key="summary.link.sharedFolder" var="sharedFolderText" />
<fmt:message key="summary.link.sharepoint" var="sharepointText" />
<fmt:message key="summary.link.drive" var="driveText" />
<fmt:message key="common.label.loading" var="loading" />


<label class="vw-js-nav-trigger" for="vw-nav-trigger" title="Collapse/Open navigation" class="hidden-xs"><svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24"><path d="M3,1v22h20V1H3z M7,21H5V3h2V21z M9,21V3h12v8h-7V8l-4.5,4l4.5,4v-3h7v8H9z" class="vw-close"/><path d="M3,1v22h20V1H3z M7,21H5V3h2V21z M21,21H9v-8h7v3l4.5-4L16,8v3H9V3h12V21z" class="vw-open"/></svg></label>
<c:if test="${param.browsePage != null && param.browsePage == 'true'}">
	<c:set var="collapseNav" value="checked" scope="page" />
</c:if>

<input type="checkbox" id="vw-nav-trigger" class="vw-nav-trigger" ${collapseNav}>

<nav class="vw-side-nav">
	<ul class="nav vw-apps-list js-records-apps">

		<li class="true"  id="MyData" ><a href="#">
			<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25"><polygon points="16 1 16 4 19 4 16 1"/><polygon points="20 14 20 16 18 16 18 24 21 14 20 14"/><path d="M18,15h1V5H15V1H9V12h9ZM10,6h8V7H10Zm0,2h8V9H10Zm0,3V10h8v1Z"/><polygon points="8.8 13 8 11 3 11 2.2 13 1 13 1 24 17 24 17 13 8.8 13"/></svg>
			<span class="vw-text">My Data</span>
		</a></li>

		<li class="true"  id="Reports"><a href="#">
			<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25"><polygon points="13 23 16 22 21.3 16.7 18.3 14.7 13 20 13 23"/><polygon points="24 14 21 12 19 14 22 16 24 14"/><polygon points="16.5 22.9 13.2 24 20 24 20 19.4 16.5 22.9"/><path d="M1,1V24H12V20H5V19h7.6l2-2H5V16H15v.6l5-5V1ZM4,20H3V19H4Zm0-3H3V16H4Zm0-3H3V13H4Zm0-3H3V10H4ZM4,8H3V7H4ZM4,5H3V4H4Zm11,9H5V13H15Zm0-3H5V10H15Zm0-3H5V7H15Zm0-3H5V4H15Z"/></svg>
			<span class="vw-text">Reports</span>
		</a></li>

		<li class="true"  id="CloudApplications"><a href="${pageContext.request.contextPath}/applications/cloudApps.jsp">
			<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="25" height="25" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 160 200" xml:space="preserve"><path d="M111.4,38.5a36.6,36.6,0,0,1,30.1,30.1H111.4V38.5m-3-3.4V71.6h36.4a39.6,39.6,0,0,0-36.4-36.4h0Z"></path><polygon points="133.7 137 122.4 137 122.4 160 111.1 160 111.1 125 99.8 125 99.8 160 88.5 160 88.5 91 77.2 91 77.2 160 65.9 160 65.9 102 54.6 102 54.6 160 43.3 160 43.3 70 32 70 32 160 20 160 20 35 15 35 15 165 145 165 145 160 133.7 160 133.7 137"></polygon><path d="M74.2,88H91.5v23.6a39.6,39.6,0,0,0,53.5-37H105.4V35A39.6,39.6,0,0,0,74.2,98.8V88Z"></path></svg>
			<span class="vw-text">Cloud Applications</span>
		</a></li>
	</ul>
</nav>
<script nonce="${sessionScope.cspNonce}"  type="text/javascript">

$("body").on("click", ".js-records-apps a", function(event){
	var thisLink = $(this).parent("li");
	var thisLinkId = thisLink.attr("id");
	event.preventDefault();
	// if same tab do not call
	loadPage(thisLinkId);
});
$(".js-records-apps li").show();

/* Hack: This needs to be cleaned up. */
function loadPage(thisLinkId) {
	if(!thisLinkId) {
		thisLinkId = "contracts";
	}

	var isBrowsePage = ( cvUtil.getParameterByName("n") === "rec");
	if (thisLinkId == "CloudApplications") {
		if(!isBrowsePage) {
			cvUtil.getTopWindow().location = "${pageContext.request.contextPath}/applications/cloudApps.jsp";
		}
	} else if (thisLinkId == "Reports"){

			cvUtil.getTopWindow().location = "${pageContext.request.contextPath}/reports/index.jsp?page=Reports";

	} else if (thisLinkId == "MyData"){

			cvUtil.getTopWindow().location = "${pageContext.request.contextPath}/summary/index.do";

		}
	}




$(document).on("ready", function(){
	var page = "${param.page}";
	loadPage(page);
		if(cvUtil.getParameterByName("page") !== ""){
			$("#"+cvUtil.getParameterByName("page")).addClass("nav-selected");
		}
		else{
			$($(".js-records-apps li")[0]).addClass("nav-selected");
		}

		// Bottom Sidebar nav: change the open/close SVG status
		if ($("#vw-nav-trigger").prop("checked") == true) { // checked = truncated version
			$(".vw-js-nav-trigger svg .vw-open").show();
			$(".vw-js-nav-trigger svg .vw-close").hide();
		} else { // unchecked = wide version
			$(".vw-js-nav-trigger svg .vw-close").show();
			$(".vw-js-nav-trigger svg .vw-open").hide();
		}

	$(".vw-js-nav-trigger").on("click", function(){
		if ($("#vw-nav-trigger").prop("checked") == true) { // checked = truncated version
			$(".vw-js-nav-trigger svg .vw-open").hide();
			$(".vw-js-nav-trigger svg .vw-close").show();
		} else { // unchecked = wide version
			$(".vw-js-nav-trigger svg .vw-close").hide();
			$(".vw-js-nav-trigger svg .vw-open").show();
		}
	})

});

</script>