<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>


<fmt:bundle basename="localization.messages">

<div id="allCustomersList">

		<div class="sub-section">
			<ul class="subsec-head">
				<li><img src="img/pse_customer_list.png" alt="allcust"></li>
				<li class="subsec-title">${requestScope.PSE_ALLCUSTOMER_GRID_LABEL}</li>
			</ul>
			<div class="subsec-body clientJobs">
				<ul class="secrowhead secrows">
					<c:forEach var="items" items="${requestScope.PSE_MYCUSTOMER_GRID_COLUMNS}" varStatus="itemLoop">
					<li class="li${itemLoop.index+1}" style="width:${items.width}">${items.colLabel}</li>
					</c:forEach>
				</ul>
				<c:choose>
				<c:when test="${fn:length(requestScope.PSE_ALLCUSTOMERS) > 0}">
					<div class="browseDataRows">
						<c:forEach var="cust" items="${requestScope.PSE_ALLCUSTOMERS}">
							<ul class="secrows">
								<c:forEach var="labels" items="${requestScope.PSE_MYCUSTOMER_GRID_COLUMNS}" varStatus="itemLoop">
									<c:set var="lvalue" value="${cust[fn:toLowerCase(fn:replace(labels.colName,' ',''))]}" />
									<li class="customeritem li${itemLoop.index+1}" id="allcust${lvalue}" value="${cust.id}" style="width:${labels.width};" onclick="showAddDiv(true,${cust.id});">${lvalue}</li>
								</c:forEach>
							</ul>
						</c:forEach>
						<c:if test="${fn:length(requestScope.FS_BK_LIST) > 3}">
						<ul class="secrows lastrow">

						</ul>
						</c:if>
					</div>
				</c:when>
				<c:otherwise>
					<div ><fmt:message key="pse.msg.nocustomers" /></div>
				</c:otherwise>
				</c:choose>
			</div>
		</div>

</div>
</fmt:bundle>