<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.recordsMessages">
	<jsp:include page="../../common/header.jsp">
		<jsp:param value="true" name="includeTableSupport" />
		<jsp:param value="true" name="includeLatestDatatable" />
		<jsp:param value="true" name="includeMask" />

		<jsp:param value="../common/smartwizard/css/smart_wizard_vertical.css"
			name="css" />
		<jsp:param value="../customproperties/css/common-style.css" name="css" />
		<jsp:param value="../customproperties/css/wizard-style.css" name="css" />
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="../cloud/pse/cloudNav.jsp" name="navPage" />
		<jsp:param value="${headerTitle}" name="titleLocalized" />
		<jsp:param value="${headerTitle}" name="headerTitleLocalized" />
		<jsp:param value="${pageContext.request.contextPath}/common/css/jquery.loadmask.css" name="css"/>
		<jsp:param value="../common/js/custom-cb.js" name="js" />
		<jsp:param value="../common/css/custom-cb.css" name="css" />
		<jsp:param value="../edc/js/betRequestUtils.js" name="js" />
		<jsp:param value="../edc/js/jquery.form.js" name="js" />
		<jsp:param value="../pse/css/bet.css" name="css" />
		<jsp:param value="true" name="includeHistory" />
	</jsp:include>

	<div class="row">
	<div class="col-sm-12">
	<div class="replInfo vw-form-horizontal row" id="replTempTemp" style="display:none;padding:15px">

		<div class="">
		<div class="col-md-12">

			<div class="form-group" style="">


				<div class="col-xs-12 col-md-6 col-lg-6" style="">
				<label class="label control-label col-form-label pull-left padding-left-0" id="labelreplSiteTempTemp" for="replSiteTempTemp">Replication site</label>

				<select id="replSiteTempTemp" class="customSelection bet-data form-control" name="replicationSites" style=""><option id="-1" value="-1">None</option></select>
				</div>

				<div class="col-xs-12 col-md-6 col-lg-6" style="">
				<label class="label control-label col-form-label pull-left" id="labelreplPercTempTemp" for="replPercTempTemp">Percentage of data to be copied</label>
				<input type="number" id="replPercTempTemp" name="replicationPercents" class="textbox form-control bet-data replPerc" data-validation="^[0-9][0-9]?$|^100$" data-msg="Max 100 suported" autocomplete="off" value="0" style="">
				</div>

			</div>
			<div class="row" >
			<div class="col-md-12 ">
				<h4 class="betH5" style=""> Replication Retention</h4>

							<div class="form-group">
							<div class="col-lg-3 col-md-6 col-xs-12">
								<label class="label control-label " id="labelrepl_ret_DTemp" for="repl_ret_DTemp">Daily backups</label>
								<div class="input_with_appended_unit">
								<input type="number" id="repl_ret_DTemp" title="Specify the number of daily backups that you want to retain." name="repl_ret_D" value="30" data-validation="^\d*[1-9]\d*$" class="textbox form-control bet-data form-with-suffix" data-msg="Invalid number of days" autocomplete="off"></input>
								<span> &nbsp;days</span>
								</div>
								<label class="error" for="repl_ret_DTemp">&nbsp;</label>

							</div>



							<div class="col-lg-3 col-md-6 col-xs-12">
								<label class="label control-label" id="labelrepl_ret_WTemp" for="repl_ret_WTemp">Weekly backups</label>

									<div class="input_with_appended_unit">
									<input type="number" id="repl_ret_WTemp" title="Specify the number of weekly backups that you want to retain." name="repl_ret_W" value="0" data-validation="^\d+$" class="textbox form-control bet-data form-with-suffix" data-msg="Invalid number of weeks" autocomplete="off"/>
									<span class="input-suffix">weeks</span>
									</div>
								<label class="error" for="repl_ret_WTemp">&nbsp;</label>

							</div>
							<div class="col-lg-3 col-md-6 col-xs-12">
								<label class="label control-label" id="labelrepl_ret_MTemp" for="repl_ret_MTemp">Monthly backups</label>

									<div class=" input_with_appended_unit">
									<input type="number" id="repl_ret_MTemp" title="Specify the number of monthly backups that you want to retain. Upto 12 backups supported in this tool." max="12" name="repl_ret_M" value="0" data-validation="^(\d{1}|[0-1][1-2])$" class="textbox form-control bet-data form-with-suffix" data-msg="More than 12 not supported" autocomplete="off">
									<span class="input-suffix">months</span>
									</div>
								<label class="error" for="repl_ret_MTemp">&nbsp;</label>

							</div>
							<div class="col-lg-3 col-md-6 col-xs-12">
								<label class="label control-label" id="labelrepl_ret_numYearly_BkpsTemp" for="repl_ret_numYearly_BkpsTemp">Yearly backups</label>

									<div class="input_with_appended_unit">
									<input type="number" id="repl_ret_numYearly_BkpsTemp" value="0" name="repl_ret_numYearly_Bkps" data-validation="^[0-5]{1}$" data-msg="Number of years can be [0-5]" class="textbox form-control bet-data form-with-suffix" autocomplete="off">
									<span class="input-suffix">years</span>
									</div>
								<label class="error" for="repl_ret_numYearly_BkpsTemp">&nbsp;</label>

							</div>
							</div>

				</div>  <!--end of col-->
				</div> <!-- end of roe -->

		</div>
		</div>

	</div>
	<div class="stickyheader clearfix" id="pgHeader">
		<span class="sectiontitle vw-page-title">Total Backup Storage Calculator</span>
		<div class="btns-right">
		<c:set var="hideSDTBtn" value="hidden" scope="page" />
		<c:if test="${param.requestId != null && param.requestId > 0}">
			<c:set var="hideSDTBtn" value="" scope="page" />
		</c:if>
		<a class="vw-btn vw-btn-default headerBtns ${hideSDTBtn}" href="SDT.jsp?requestId=${param.requestId}" target="SDT ${param.requestId}">
							<span class="sprite icon-settings-mydata">
							</span>&nbsp;Back to SDT
		</a>

		<a class="vw-btn vw-btn-default importCsv"  id="importCsvButton">
							<span class="sprite icon-import">
							</span>&nbsp;Import
		</a>
		<form id="importCsv" class="hidden hideOnExportFriendly" enctype="multipart/form-data" method="post" name="m">
		<input id="browseImportFile" type="file" 	name="logfile" size="60" accept=".csv"/>
		<input type="hidden" id="actionTyp" name="action" value="import">
		<input id="uploadFileBtn" type="submit"/>
		<div class="form-group hidden" >
					<INPUT TYPE="text" style="" NAME="Request" id="reqTyp"
					class="textbox edc-data" readonly VALUE="BET Prediction">
					</div>
		</form>
		<a class="vw-btn vw-btn-default exportToCsv"  id="exportToCsvBtn">
							<span class="sprite icon-export-csv">
							</span>&nbsp;Save

		</a>
		<a class="vw-btn vw-btn-default addSiteBtn"  id="addSiteBtn">
							<span class="sprite icon-plus">
							</span>&nbsp;Add another site

		</a>

		<button id="submitBtn" class="mainBtn vw-btn vw-btn-primary" name="submit" type="button" style="">
			<span class="vw-btn-text">Calculate</span>
			<svg xmlns="http://www.w3.org/2000/svg" width="23px" height="23px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="uil-spin"><g transform="translate(50 50)"><g transform="rotate(0) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.02571 1.02571)"><animate attributeName="opacity" from="1" to="0.1" begin="0s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(45) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.08571 1.08571)"><animate attributeName="opacity" from="1" to="0.1" begin="0.12s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.12s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(90) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.15071 1.15071)"><animate attributeName="opacity" from="1" to="0.1" begin="0.25s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.25s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(135) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.21071 1.21071)"><animate attributeName="opacity" from="1" to="0.1" begin="0.37s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.37s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(180) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.27571 1.27571)"><animate attributeName="opacity" from="1" to="0.1" begin="0.5s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.5s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(225) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.33571 1.33571)"><animate attributeName="opacity" from="1" to="0.1" begin="0.62s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.62s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(270) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.40071 1.40071)"><animate attributeName="opacity" from="1" to="0.1" begin="0.75s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.75s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(315) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.46071 1.46071)"><animate attributeName="opacity" from="1" to="0.1" begin="0.87s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.87s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g></g></svg>
		</button>
		</div>
	</div>
	<div class="assumptions">

		<h6 class="toggleHeading">Assumptions:</h6>
		<a href="#" id="toggleBtn" class="ui-dialog-titlebar-close ui-corner-all" role="button" style="float:right;margin-top:-25px"><span class="ui-icon ui-icon-minusthick"></span></a>
		<div class="toggleText" id="id2">
			<ul>
				<li>Change rates are defaulted to the numbers given in the form. Users can change them according to the customer case.</li>
				<li>Output is not dependent on the frequency of the Fulls/Synthetic Fulls.</li>
				<li>Weekly change rates are not 7 times the daily change rate. It is rather double as the changes may happen on the same set of data. Similarly monthly change rate is not 4 times the weekly change rate.</li>
				<li>The change rates will reduce when the data size to protect increases based on buckets: 0-300 TB (1.0* change rate selected), 300-800 TB (0.5 * change rate selected), 800 and above TB (0.25 * change rate selected).</li>
				<li>Extended mode deduplication large media agent capacity is upto 300TB and XL media agent capacity is upto 500TB.</li>
				<li>Compression % must be between 0 and 60.</li>

			</ul>
		</div>

	</div><!--  END .assumptions  -->
		<form id="betRequestForm" class=" bootstrap-wrapper form-horizontal">
		<input type="hidden" id="action" name="action" value="calculate">
		<div id="holderTemp" class="vw-loading-area col-sm-12 row-eq-height" style="display:none">

			<div class="subsec-body col  vw-comp-tile inpCol" id="inpDetailsTemp" style="">

				<form class="vw-form">
				<div class="row">
				<div class="form-group">
					<div class="col-md-6 col-xs-10 col-lg-6 padding-left-30">
					<input type="text" id="siteNameTemp" name="siteName" class="textbox form-control bet-data siteName"  data-msg="Site name cannot contain #&quot;%$@()*\/|" autocomplete="off" placeholder="Site Name" data-validation="^([A-Za-z0-9]){1,}$">
					<label class="error" for="siteNameTemp">&nbsp;</label>
					</div>
					<div class="col-md-6 col-xs-2 col-lg-6">
					<a href="#" id="delBtnTemp" class="ui-dialog-titlebar-close ui-corner-all" role="button" style="float:right;"><span class="stretch">X</span></a>
					</div>
				</div>
				</div>

				<div class="row " id="temp">
					<div class="col-md-12">
						<div class="row" style="">
						<div class="col-md-12">
						<h4 class="vw-comp-name betH4">Files / VM Backups</h4>

					    <div class="form-group">
					    <div class="col-lg-3 col-md-4 col-xs-12">
							<label class="label control-label" id="labelfs_FETTemp" for="fs_FETTemp">FET</label>
							<input type="number" id="fs_FETTemp" name="fs_FET" value="0" class="textbox form-control bet-data" data-validation="^([0-9]){1,}$" data-msg="Invalid FET" autocomplete="off">
							<label class="error " for="fs_FETTemp"></label>
				   		</div>
						<div class="col-lg-3 col-md-4 col-xs-12">
							<label class="label control-label" id="labelfs_unFETTemp" for="fs_compRatio">Compression %</label>
							<input type="number" id="fs_compRatioTemp" name="fs_compRatio" value="50" class="textbox form-control bet-data" data-validation="^(60|[0-5]?[0-9])$" data-msg="Invalid compression ratio" autocomplete="off">
							<label class="error  " for="fs_compRatioTemp">&nbsp;</label>
				   		</div>
					    <div class="col-lg-3 col-md-4 col-xs-12">
							<label class="label control-label" id="labelfs_CRTemp" for="fs_CRTemp">Daily change rate %</label>
							<input type="number" id="fs_CRTemp" name="fs_CR" value="1.6" class="textbox form-control bet-data" data-validation="^\d+(\.\d{0,2})?$" data-msg="Invalid change rate" autocomplete="off">
							<label class="error  " for="fs_CRTemp">&nbsp;</label>
				   		</div>

				   		<div class="col-lg-3 col-md-4 col-xs-12">
							<label class="label control-label " id="labelfs_gTemp" for="fs_gTemp">Yearly growth rate %</label>
							<input type="number" id="fs_gTemp" name="fs_g" value="10" data-validation="^\d+(\.\d{0,2})?$" class="textbox form-control bet-data" data-msg="Invalid change rate" autocomplete="off">
							<label class="error  " for="fs_gTemp">&nbsp;</label>
				   		</div>
						</div>
						<!--<div class="form-group col-sm-2 " style="display:none">
							<label class="label control-label " id="labelfs_wCRTemp" for="fs_wCRTemp">Weekly change rate %</label>
							<input type="text" id="fs_wCRTemp" name="fs_wCR" value="3.2" data-validation="^\d+(\.\d{0,2})?$" class="textbox form-control bet-data" autocomplete="off">
							<label class="error error1 alert vw-alert-danger hidden" for="fs_wCRTemp">&nbsp;</label>
				   		</div>
						<div class=" form-group col-sm-2 " style="display:none">
							<label class="label control-label" id="labelfs_mCRTemp" for="fs_mCRTemp">Monthly change rate %</label>
							<input type="text" id="fs_mCRTemp" name="fs_mCR" value="6.4" data-validation="^\d+(\.\d{0,2})?$" class="textbox form-control bet-data" autocomplete="off">
							<label class="error error1 alert vw-alert-danger hidden" for="fs_mCRTemp">&nbsp;</label>
				   		</div>
					    <div class="form-group col-sm-2 " style="display:none">
							<label class="label control-label" id="labelfs_yCRTemp" for="fs_yCRTemp">Yearly change rate %</label>
							<input type="text" id="fs_yCRTemp" name="fs_yCR" value="12.8" data-validation="^\d+(\.\d{0,2})?$" class="textbox form-control bet-data" autocomplete="off">
							<label class="error error1 alert vw-alert-danger hidden" for="fs_yCRTemp">&nbsp;</label>
				   		</div> -->


				   		</div>
						</div><!---End FS/VM Backups -->
						<!---DB Backups -->
						<div class="row" style="">
						<div class="col-md-12">
						<h4 class="vw-comp-name betH4">Database Backups</h4>
						<div class="form-group">
						<div class="col-lg-3 col-md-4 col-xs-12">
							<label class="label control-label" id="labeldb_FETTemp" for="db_FETTemp">FET</label>
							<input type="number" id="db_FETTemp" name="db_FET" value="0" class="textbox form-control bet-data" data-validation="^([0-9]){1,}$" data-msg="Invalid FET" autocomplete="off">
							<label class="error " for="db_FETTemp">&nbsp;</label>
				   		</div>
						<div class="col-lg-3 col-md-4 col-xs-12">
							<label class="label control-label" id="labeldb_compRatioemp" for="db_compRatio">Compression %</label>
							<input type="number" id="db_compRatioTemp" name="db_compRatio" value="50" class="textbox form-control bet-data" data-validation="^(60|[0-5]?[0-9])$" data-msg="Invalid compression ratio" autocomplete="off">
							<label class="error  " for="db_compRatioTemp">&nbsp;</label>
				   		</div>
					   <div class="col-lg-3 col-md-4 col-xs-12">
							<label class="label control-label" id="labeldb_CRTemp" for="db_CRTemp">Daily change rate %</label>
							<input type="number" id="db_CRTemp" name="db_CR" value="2.8" data-validation="^\d+(\.\d{0,2})?$" class="textbox form-control bet-data" data-msg="Invalid change rate" autocomplete="off">
							<label class="error  " for="db_CRTemp">&nbsp;</label>
				   		</div>
				   		<div class="col-lg-3 col-md-4 col-xs-12">
							<label class="label control-label " id="labeldb_gTemp" for="db_gTemp">Yearly growth rate %</label>
							<input type="number" id="db_gTemp" name="db_g" value="10"  data-validation="^\d+(\.\d{0,2})?$" class="textbox form-control bet-data" data-msg="Invalid change rate" autocomplete="off">
							<label class="error  " for="db_gTemp">&nbsp;</label>
				   		</div>
						</div>
						<!--
						<div class="form-group col-sm-2 " style="display:none">
							<label class="label control-label " id="labeldb_wCRTemp" for="db_wCRTemp">Weekly change rate %</label>
							<input type="text" id="db_wCRTemp" name="db_wCR" value="8.4" data-validation="^\d+(\.\d{0,2})?$" class="textbox form-control bet-data" autocomplete="off">
							<label class="error error1 alert vw-alert-danger hidden" for="db_wCRTemp">&nbsp;</label>
				   		</div>
						<div class="form-group col-sm-2 " style="display:none">
							<label class="label control-label" id="labeldb_mCRTemp" for="db_mCRTemp">Monthly change rate %</label>
							<input type="text" id="db_mCRTemp" name="db_mCR" value="16.8"  data-validation="^\d+(\.\d{0,2})?$" class="textbox form-control bet-data" autocomplete="off">
							<label class="error error1 alert vw-alert-danger hidden" for="db_mCRTemp">&nbsp;</label>
				   		</div>
					    <div class="form-group col-sm-2 " style="display:none">
							<label class="label control-label" id="labeldb_yCRTemp" for="db_yCRTemp">Yearly change rate %</label>
							<input type="text" id="db_yCRTemp" name="db_yCR" value="33.6" data-validation="^\d+(\.\d{0,2})?$" class="textbox form-control bet-data" autocomplete="off">
							<label class="error error1 alert vw-alert-danger hidden" for="db_yCRTemp">&nbsp;</label>
				   		</div>
						-->
				   		</div>
						</div>  <!--End DB Backups -->


					<div class="row" style="">
					<div class="col-md-12">
						<h4 class="vw-comp-name betH4">Retention</h4>
						<div class="form-group">

							<div class="col-lg-3 col-md-6 col-xs-12">
								<label class="label control-label " id="labelret_DTemp" for="ret_DTemp">Daily backups</label>
								<div class="input_with_appended_unit">
								<input type="number" id="ret_DTemp" title="Specify the number of daily backups that you want to retain." name="ret_D" value="30" data-validation="^\d*[1-9]\d*$" class="textbox form-control bet-data form-with-suffix" data-msg="Invalid days for daily backups" autocomplete="off"></input>
								<span> &nbsp;days</span>
								</div>
								<label class="error " for="ret_DTemp">&nbsp;</label>

							</div>



							<div class="col-lg-3 col-md-6 col-xs-12">
								<label class="label control-label" id="labelret_WTemp" for="ret_WTemp">Weekly backups</label>

									<div class="input_with_appended_unit">
									<input type="number" id="ret_WTemp" title="Specify the number of weekly backups that you want to retain." name="ret_W" value="0" data-validation="^\d+$" class="textbox form-control bet-data form-with-suffix" data-msg="Invalid number of weeks" autocomplete="off"/>
									<span class="input-suffix">weeks</span>
									</div>
								<label class="error  " for="ret_WTemp">&nbsp;</label>

							</div>
							<div class="col-lg-3 col-md-6 col-xs-12">
								<label class="label control-label" id="labelret_MTemp" for="ret_MTemp">Monthly backups</label>

									<div class=" input_with_appended_unit">
									<input type="number" id="ret_MTemp" name="ret_M" max="12" value="0" data-validation="^(\d{1}|[0-1][1-2])$" class="textbox form-control bet-data form-with-suffix" data-msg="More than 12 not supported" title="Specify the number of monthly backups that you want to retain. Upto 12 backups supported in this tool." autocomplete="off">
									<span class="input-suffix">months</span>
									</div>
								<label class="error  " for="ret_MTemp">&nbsp;</label>

							</div>
							<div class="col-lg-3 col-md-6 col-xs-12">
								<label class="label control-label" id="labelret_numYearly_BkpsTemp" for="ret_numYearly_BkpsTemp">Yearly backups</label>

									<div class="input_with_appended_unit">
									<input type="number" id="ret_numYearly_BkpsTemp" title="Specify the number of yearly backups that you want to retain." value="0" name="ret_numYearly_Bkps" data-validation="^[0-5]{1}$" class="textbox form-control bet-data form-with-suffix" data-msg="Number of years can be [0-5]" autocomplete="off">
									<span class="input-suffix">years</span>
									</div>
								<label class="error  " for="ret_numYearly_BkpsTemp">&nbsp;</label>

							</div>
							</div>
							<div class="form-group">
							<div class="col-lg-3 col-md-6 col-xs-12">
								<label class="label control-label" id="labelret_YTemp" for="ret_YTemp">Years to model</label>
								<input type="number" id="ret_YTemp" name="ret_Y" value="1" data-validation="^[1-5]{1}$" class="textbox form-control bet-data yrs_to_model" data-msg="Number of years can be [1-5]" autocomplete="off">
								<label class="error  " for="ret_YTemp">&nbsp;</label>
							</div>
							<div class="col-lg-3 col-md-6 col-xs-12">
								<label class="label control-label " id="labelret_DgapTemp" for="ret_DTemp">Frequency of Full/Synthetic Full backups</label>
								<div class="input_with_appended_unit">
								<input type="number" id="ret_DgapTemp" name="ret_Dgap" value="7" data-validation="^\d*[1-9]\d*$" class="textbox form-control bet-data form-with-suffix ret_Dgap" data-msg="Invalid number of days between backups" autocomplete="off"></input>
								<span> &nbsp;days</span>
								</div>
								<label class="error " for="ret_DgapTemp">&nbsp;</label>

							</div>
							</div>

					</div>
					</div>
					<div class="row"  style="">
						<div class="col-md-12">
							<h4 class="vw-comp-name betH4">Hardware</h4>


							<div class="form-group">

									<div class="col-xs-12">
										<div class="multiple-radio-group">
											<label for="hrd_TrdTemp"><input type="radio" id="hrd_TrdTemp" name="hrd_TypeTemp" class="form-check-input bet-data hrd_Type" value="trd">
											<span class="block-indent">Traditional</span></label>
										</div>
										<div class="multiple-radio-group">
											<label for="hrd_RoboTemp"><input type="radio" id="hrd_RoboTemp" name="hrd_TypeTemp" class="form-check-input bet-data hrd_Type" value="robo">
											<span class="block-indent">RO1200</span></label>
										</div>
										<!--  <div class="multiple-radio-group">
											<label for="hrd_HSTemp"><input type="radio" id="hrd_HSTemp" name="hrd_TypeTemp" class="form-check-input bet-data hrd_Type" value="hs">
											<span class="block-indent">Hyperscale Appliance</span></label>
										</div>-->
										<div class="multiple-radio-group">
											<label for="hrd_HRATemp"><input type="radio" id="hrd_HRATemp" name="hrd_TypeTemp" class="form-check-input bet-data hrd_Type" value="hra">
											<span class="block-indent">Hyperscale Reference Architecture</span></label>
										</div>
										<div class="multiple-radio-group">
											<label for="hrd_HRAXTemp"><input type="radio" id="hrd_HRAXTemp" name="hrd_TypeTemp" class="form-check-input bet-data hrd_Type" value="hrax">
											<span class="block-indent">Hyperscale X Reference Architecture</span></label>
										</div>
										<div class="multiple-radio-group">
											<label for="hrd_HRA2Temp"><input type="radio" id="hrd_HRA2Temp" name="hrd_TypeTemp" class="form-check-input bet-data hrd_Type" value="hsax">
											<span class="block-indent">Hyperscale X Appliance</span></label>
										</div>
										<div class="hra_Details hrax_Details padding-left-15" style="display:none">
											<div class="row">
											<div class="form-group">
											<div class="col-lg-3 col-md-6 col-xs-12">
													<label class="label control-label  col-form-label" id="labelnumDisksTemp" for="numDisks">Number of disks</label>
	
													<select id="numDisksTemp" class="customSelection bet-data form-control" name="numDisks" style=""><option id="12" value="12">12</option><option id="24" value="24">24</option></select>
											</div>
	
											<div class="col-lg-3 col-md-6 col-xs-12">
													<label class="label control-label  col-form-label" id="labeldiskSizeTemp" for="diskSizeTemp">Size of disks(TB)</label>
	
													<select id="diskSizeTemp" class="customSelection bet-data form-control" name="diskSize" style=""><option id="4" value="4">4</option><option id="6" value="6">6</option><option id="8" value="8">8</option><option id="10" value="10">10</option><option id="12" value="12">12</option><option id="14" value="14">14</option><option id="16" value="16">16</option><option id="18" value="18">18</option></select>
											</div>
											</div>
											</div>
										</div>	 <!--end of hra -->
										
										<div class="hsax_Details padding-left-15" style="display:none">
											<div class="row"><div class="form-group">
												<div class="col-lg-3 col-md-6 col-xs-12">
													<label class="label control-label  col-form-label" id="labelHra2" for="diskSize">Model</label>
	
													<select id="hsxModels" class="bet-data form-control" name="diskSize" style="">
														<option id="25" value="25" data-mname="2348">2348 (Usable 25TB)</option><option id="50" value="50" data-mname="2396">2396 (Usable 50TB)</option>
														<option id="88" value="88" data-mname="23168">23168 (Usable 88TB)</option><option id="151" value="151" data-mname="43288">43288 (Usable 151TB)</option>
														<option id="264" value="264" data-mname="43504">43504 (Usable 264TB)</option>
													</select>
												</div>											
											</div></div>
										</div>	 <!--end of hra2 -->
									</div>
							</div>


						</div>
					</div> <!--end of hardware  -->
				</div>

			</div>
			<div class="row ">
					<div class="col-md-12">
					<p class="margin-top" >Replication allocation (allocate amount of data per site)</p>
					</div>
			</div>
			<div class="replSites">
				<!--  ADD replication sites  -->
			</div>
			<div class="erMsg" id="erTemp">Please provide site name</div>

			<a class="vw-btn vw-btn-default pull-right addreplSiteBtn"  id="addreplSiteBtnTemp">
			<span class="sprite icon-plus">
			</span>
				&nbsp;Add replication site

			</a>
			</form>

		</div>
			<div class="subsec-body col vw-comp-tile opCol vw-position-relative" id="opDetailsTemp">
			<h4 class="vw-comp-name betH4"></h4>
			<br/>
			<table class="table vw-table-borderless" id="opTblTemp">
				<!--<thead>
					<tr>
						<th>Years</th>
						<th>Storage(TB)</th>
						<th>Large Media Agents</th>
						<th>XL Media Agents</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td></td>
						<td></td>
						<td></td>
						<td></td>
					</tr>
				</tbody> -->
			</table>
			<div class="hsDetails" style="display:none">

			</div>
		</div> <!--  END #opDetails  -->
	</div><!--  END #holder  -->


		<!-- Second site --->

		</form>
	</div> <!--END of col -->
	</div><!--  END .row  -->
</fmt:bundle>
<jsp:include page="../../common/footer.jsp">
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="${pageContext.request.contextPath}/common/js/jquery.loadmask.min.js" name="js"/>
	<jsp:param value="../common/smartwizard/js/jquery.smartWizard.js"
		name="js" />
</jsp:include>