<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<script nonce="${sessionScope.cspNonce}"  type="text/javascript">
	window.uploadAjaxRequests = [];
	var localMsg = localMsg || {};
</script>
	
<%@include file="../../upload/index.jsp" %>

<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="js/requestsUtil.js"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="js/requestsUploadFile.js"></script>


<c:set var="tdclass" value="colName" scope="page" />
<c:if test="${param.ismigrate != null && param.ismigrate == 'true'}">
	<c:set var="tdclass" value="" scope="page" />
</c:if>
<c:set var="upldclass" value="uploadNow" scope="page" />
<c:if test="${param.uploaddivclass != null}">
	<c:set var="upldclass" value="uploadNow ${fn:escapeXml(param.uploaddivclass)}" scope="page" />
</c:if>

<c:set var="ver" value="${fn:split('9,10,11', ',')}" scope="page" />
<c:if test="${param.versions != null}">
	<c:set var="ver" value="${fn:split(fn:escapeXml(param.versions), ',')}" scope="page" />
</c:if>

<form id="${fn:escapeXml(param.formid)}" class="uploadForm textcenter" accept-charset="UTF-8">
	<table>
	<tr><td class="${tdclass}">
	<label class="custView">Company:&nbsp;&nbsp;</label></td><td><INPUT TYPE="text" class="custView Company edc-data" NAME="Company" id="${fn:escapeXml(param.companyid)}"
	VALUE="" data-msg="Please enter a valid Company Name, maximum length is 30." data-validation="^([0-9]*[A-Za-z&._ \-][A-Za-z0-9&._ \-]*){1,30}$"></td>
	</tr>
	<c:if test="${param.isversion != null && param.isversion == 'true'}">
	<tr><td class="${tdclass}"><label>Version:&nbsp;&nbsp;</label></td><td><select NAME="version" id="${fn:escapeXml(param.versionid)}" class="versionselection edc-data"><option value=""></option>
		<c:forEach var="v" items="${ver}">
		  	<option value="${v}">${v}</option>
		</c:forEach>
		</select></td>
	</tr>
	</c:if>
	<tr><td class="${tdclass}"><label>Request:&nbsp;&nbsp;</label></td><td><INPUT TYPE="text" NAME="Request" id="reqTyp"
	class="textbox edc-data" readonly VALUE="${fn:escapeXml(param.requestvalue)}"></td>
	</tr>
	<tr>
		<td class="${tdclass}">
		<label>Also notify:&nbsp;&nbsp;</label></td><td><INPUT TYPE="text" class="NotifyEmail edc-data" NAME="notifyEmail" id="notifyEmail" placeholder="comma separated multiple values"
		VALUE="" data-msg="Please enter valid email address"></td>
	</tr>
	<c:choose>
		<c:when test="${param.ismigrate != null && param.ismigrate == 'true'}">
			<tr><td class="${tdclass}"><label>Destination CommCell:&nbsp;&nbsp;</label></td>
			<td><input name="ccmdstFile" type="file" id="ccmdstFile" class="edc-filedata"/></td>
			</tr>
			<tr><td class="${tdclass}"><label>Source CommCell:&nbsp;&nbsp;</label></td><td>
			<table class="addFilesTbl">
			<tr><td><input name="ccmsrcFile" type="file" id="ccmsrcFile" class="edc-filedata"/></td></tr>
			</table>
			</td></tr>
		</c:when>
		<c:otherwise>
			<tr><td>
			<c:if test="${param.fileTypeText != null && param.fileTypeText != ''}">
				<label>${param.fileTypeText}</label>
			</c:if>
			</td><td>
			<table id="${fn:escapeXml(param.addfilestableid)}" class="addFilesTbl">
			<tr><td><input name="inpFileSys" type="file" id="inpFileSys" class="edc-filedata"/></td></tr>
			</table>
			</td></tr>
		</c:otherwise>
	</c:choose>
	<tr><td></td>
		<c:if test="${param.addfiles != null && param.addfiles == 'true'}">
			<td>
			<a class="AddFiles addNewItemA">
				<span class="addWF"><img src="img/add_16px.png">
					&nbsp;Add Another File
				</span>
			</a>
			</td>
		</c:if>

	</tr>
	</table>
</form>
<div class="${upldclass}"><a id="${fn:escapeXml(param.uploadnowdivid)}" class="cloudBtn uploadNowBtn">Upload Now</a>
	<div class="progress hidden">
			<div class="bar"></div >
			<div class="percent">0%</div >
		</div>
</div>