var edcHandler = edcHandler || {
	app : "sdt",
	appType : "SDT"
};
edcHandler.sdt = {};
edcHandler.sdt.loadercounter = 0;
edcHandler.sdt.model = {};
edcHandler.sdt.view = {};
edcHandler.sdt.controller = {};

//************************************************************************************/
//Model part start
//************************************************************************************/

edcHandler.sdt.model.request;
edcHandler.sdt.model.setRequest = function(req) {
	edcHandler.sdt.model.request = req;
}
edcHandler.sdt.model.getRequest = function() {
	return edcHandler.sdt.model.request;
}

edcHandler.sdt.model.setQuestions = function(serverData) {
	var d = edcHandler.sdt.model.getRequest().getData();
	if (serverData) {
		if (serverData.data.isErrorResponse === false && $.isArray(serverData.data.qList)) {
			d.qList = serverData.data.qList;
		}
	} else {
		if (typeof d.qList === "string") {
			d.qList = JSON.parse(d.qList);
		}
	}
}
edcHandler.sdt.model.getQuestions = function() {
	var d = edcHandler.sdt.model.getRequest().getData();
	return d.qList;
}

edcHandler.sdt.model.getQuestionsFromServer = function(callBack) {
	$("#content").mask("");
	edcHandler.sdt.loadercounter++;
	cvUtil.loadPageWithGET(cvUtil.getContextPath() + '/getSDTQuestions.do', "", function(data) {
		console.log(data);
		edcHandler.sdt.loadercounter--;
		if(edcHandler.sdt.loadercounter <= 0){
			$("#content").unmask();
			edcHandler.sdt.loadercounter = 0;
		}
		edcHandler.sdt.model.setQuestions(data);
		callBack();
	});
}

edcHandler.sdt.model.getPPTDataGUID = function() {
	var d = edcHandler.sdt.model.getRequest().getData();
	return d.documentguid;
}
edcHandler.sdt.model.getCSVData = function() {
	var reqData = edcHandler.sdt.model.getRequest().getData();
	if (reqData.output && reqData.output.csvData) {
		return reqData.output.csvData;
	}
	return null;
}
edcHandler.sdt.model.exportPPT = function() {

	var localdataguid = edcHandler.sdt.model.getPPTDataGUID();
	edcExportServices.exportLocalPpt("147379e3-65d4-4e98-972e-791bf1d4fb2b", "SDT PPT ", localdataguid);
}
edcHandler.sdt.model.exportCSV = function() {
	var d = edcHandler.sdt.model.getCSVData();
	if (d != null) {
		edcExportServices.exportToCSV(d, "SDT CSV", edcHandler.app.toUpperCase());
	}
}
//************************************************************************************/
//view part start
//************************************************************************************/
edcHandler.sdt.view.showEditButton = function() {
	$(".editReq").removeClass("hidden");
	edcHandler.sdt.view.hideNewSite();
};
edcHandler.sdt.view.hideEditButton = function() {
	$(".editReq").addClass("hidden");
	edcHandler.sdt.view.showNewSite();
};
edcHandler.sdt.view.xxxshowAgents = function(siteId) {
	$("#"+siteId +" .sdt-row").addClass("hidden");
	$("#agents-" + siteId).removeClass("hidden");
};
edcHandler.sdt.view.showSolutions = function(siteId) {
	$("#"+siteId +" .sdt-row").addClass("hidden");
	$("#solutions-" + siteId).removeClass("hidden");
};
edcHandler.sdt.view.showQuestions = function(siteId) {
	$("#"+siteId +" .sdt-row").addClass("hidden");
	$("#questions-" + siteId).removeClass("hidden");
};
edcHandler.sdt.view.hideCalculateButton = function() {
	$("#sdtmainBtn").addClass("hidden");
};
edcHandler.sdt.view.showNewSite = function() {
	$(".newSite").removeClass("hidden");
};
edcHandler.sdt.view.hideNewSite = function() {
	$(".newSite").addClass("hidden");
};
edcHandler.sdt.view.showCalculateButton = function() {
	$("#sdtmainBtn").removeClass("hidden");
};

edcHandler.sdt.view.hideGenPPTButton = function() {
	$(".genppt, .gencsv").addClass("hidden");
};
edcHandler.sdt.view.showGenPPTButton = function() {
	$(".genppt, .gencsv").removeClass("hidden");
};
edcHandler.sdt.view.hideGenButtons = function() {
	edcHandler.sdt.view.hideGenPPTButton();
};
edcHandler.sdt.view.showGenButtons = function() {
	edcHandler.sdt.view.showGenPPTButton();
};
edcHandler.sdt.view.showResponse = function(){
	$(".sdt-row, .site-div").addClass("hidden");
	$(".sdt-response").removeClass("hidden");
}
edcHandler.sdt.view.showSites = function() {
	$(".site-div").removeClass("hidden");
};

edcHandler.sdt.view.showUsersDetails = function(d){
	if(d.createdby){
		$("#createdby").text(d.createdby);
	}
	if(d.lastmodifieduser){
		$("#lastmodifiedby").text(d.lastmodifieduser);
	}
	$(".userdtls").removeClass("hidden");
};

edcHandler.sdt.view.showOutput = function() {
	edcHandler.sdt.view.showCalculateButton();
	edcHandler.sdt.view.showGenButtons();
	edcHandler.sdt.view.showEditButton();
	var req = edcHandler.sdt.model.getRequest();
	req.populateResponse();
	edcHandler.sdt.view.showResponse();
};
edcHandler.sdt.view.appendToSitesDiv = function(anEl){
	var sitesDiv = $(".sdt-sites");
	anEl.appendTo(sitesDiv);
},

edcHandler.sdt.view.renderASite = function(aSite) {
	//var sitesDiv = $(".sdt-sites");
	var aSiteDiv = aSite.populateSiteDiv();
	edcHandler.sdt.view.appendToSitesDiv(aSiteDiv);//.appendTo(sitesDiv);
	//aSite.generateBreadCrumb("agent");
	//edcHandler.sdt.view.showAgents(aSite.getId());
};
edcHandler.sdt.view.renderSites = function() {
	edcHandler.sdt.view.showNewSite();
	var req = edcHandler.sdt.model.getRequest();
	//edcHandler.sdt.view.generateBreadCrumb("agent");
	var sitesDiv = $(".sdt-sites").empty();
	req.loopThroughSites(function(aSite) {
		edcHandler.sdt.view.renderASite(aSite);
		edcHandler.sdt.controller.showSelectedSolutionsQuestions(aSite);
	});
	edcHandler.sdt.view.showSites();
};

edcHandler.sdt.view.addSite = function() {
	var site = edcHandler.sdt.model.getRequest().addASite();
	edcHandler.sdt.view.renderASite(site);
};
edcHandler.sdt.view.removeASite = function(siteObj) {
	edcHandler.sdt.model.getRequest().removeASite(siteObj);
	edcHandler.sdt.view.renderSites();
};
edcHandler.sdt.view.generateDataForCloudRequest = function() {
    return JSON.stringify(edcHandler.sdt.view.populatePostDataForCloudRequest())
}
edcHandler.sdt.view.populatePostDataForCloudRequest = function() {
	var d = [];
	var req = edcHandler.sdt.model.getRequest();
	d = req.populatePostData();
	return d;
}
edcHandler.sdt.view.validateForm = function() {
	return true;
}

edcHandler.sdt.view.populateQuestions = function(site, solId) {
	site.populateQuestions(solId);
	edcHandler.sdt.view.showQuestions(site.getId());
};
edcHandler.sdt.view.setAccName = function(accname){
	$("#accountname").val(accname);
};
edcHandler.sdt.view.setSummary = function(sum){
	$("#summary").val(sum);
};
//************************************************************************************/
//View Part end
//************************************************************************************/

//************************************************************************************/
//Class model part start
//************************************************************************************/

function CloudRequest(id) {
	this.id = id;
	this.data = null;
	this.accountname = "";
	this.sites = [];
	this.summary="";
}

function Site(id, name) {
	this.id = id;
	this.name = name;
	this.agents = [];
	this.siteDiv = $('<div class="row site-div">').attr("id", this.getId());
	this.agentDiv = $('<div class="row sdt-row agent-headers-div assumptions hidden">').attr("id",
			"agents-" + this.getId());
	this.solutionDiv = $('<div class="row sdt-row agent-solution-headers-div assumptions">').attr("id",
			"solutions-" + this.getId());
	this.questionDiv = $('<div class="row sdt-row agent-solution-questions-div">').attr("id",
			"questions-" + this.getId());
	this.brCrumb = [ {
			name : "Agents",
			id : "agent",
			isActive : false,
			callBack : function(siteObj){
				siteObj.populateAgentsDivAndAppendToSite();
			}
		}, {
			name : "Solutions",
			id : "solution",
			isActive : false,
			callBack : function(siteObj){
				siteObj.populateSolutions();
			}
		}, {
			name : "Questions",
			id : "question",
			isActive : false,
			callBack : function(siteObj){
				siteObj.populateQuestions();
			}
		}, {
			name : "Output",
			id : "output",
			isActive : false
		} ];

}

function Agent(id, name) {
	this.id = id;
	this.name = name;
	this.tileTemplate = "";
	this.description = "";
	this.solutions = [];
	this.selected = false;
}
function Solution(id, name) {
	this.id = id;
	this.name = name;
	this.description = "";
	this.selected = false;
	this.questions = [];
	this.fet = 0;
	this.fetFunc = "";
}

function Question(q, type, id, calF) {
	this.question = q;
	this.type = type;
	this.id = id;
	this.answer = 0;
	this.qCalF = calF;
}
CloudRequest.prototype = {
	constructor : CloudRequest,
	getId : function() {
		return this.id;
	},
	getData : function() {

		if (this.data === null) {
			if (!edcHandler.cloudRequest) {
				edcHandler.cloudRequest = {};
				edcHandler.cloudRequest.data = {};
			}
			this.data = edcHandler.cloudRequest.data;
		}
		return this.data;

	},
	setAccName : function(accname){
		this.accountname = accname;
	},
	getSummary: function(){
		return this.summary;
	},
	setSummary: function(summary){
		this.summary = summary;
	},
	clearSites: function(){
		this.sites = [];
	},
	getQuestions : function() {
		return this.getData().qList;
	},
	setData : function(data) {
		this.data = data;
	},
	addSite : function(aSite) {
		if (aSite instanceof Site) {
			this.sites.push(aSite);
		}
	},
	loopThroughSites : function(callBack) {
		for (var st = 0; st < this.sites.length; st++) {
			var aSite = this.sites[st];
			callBack(aSite, st);
		}
	},
	removeSite: function(aSite){
		if(this.sites.length == 1){
			return;
		}
		var siteIndx = -1;
		if (aSite instanceof Site) {
			this.loopThroughSites(function(site, indx) {
				if (site.getId() === aSite.getId()) {
					siteIndx = indx;
				}
			});
		}
		if(siteIndx !== -1){
			this.sites.splice(siteIndx, 1);
			this.rearrangeSiteIDs();
		}
	},
	rearrangeSiteIDs: function(aSite){
		this.loopThroughSites(function(aSite, indx) {
			aSite.setId("site"+indx);
		});
	},
	populatePostData : function() {
		var d = {};
		d.salesFId = this.getAccName();
		d.summary = this.getSummary();
		this.loopThroughSites(function(aSite) {
			d[aSite.getId()] = {};
			d[aSite.getId()].data = [];
			d[aSite.getId()].name = aSite.getName();
			aSite.loopThroughAgents(function(anAgent) {
				var aD = anAgent.populateDataForCloudRequest();
				if (!$.isEmptyObject(aD)) {
					d[aSite.getId()].data.push(aD);
				}
			});
		});

		return d;
	},
	getSiteById : function(siteId) {
		var siteById = null;
		this.loopThroughSites(function(aSite) {
			if (aSite.getId() === siteId) {
				siteById = aSite;
			}
		});
		return siteById;

	},
	setSiteData : function(data) {
		this.setData(data);
		edcHandler.sdt.loadercounter--;
		if(edcHandler.sdt.loadercounter <= 0){
			$("#content").unmask();
			edcHandler.sdt.loadercounter = 0;
		}
		this.loadSites();
	},
	loadSites : function() {
		if (this.getId() > 0) {
			//load all sites from existing data
			//edcHandler.sdt.view.populateAgentsFromData(edcHandler.sdt.model.getQuestions());
			this.clearSites();
			var rd = this.getData();

			var needToPopulateOutput = false;
			requestData = rd.output;
			edcHandler.sdt.view.showEditButton();
			if (requestData && requestData.input) {
				//first add sites
				for(var site in requestData.input){
					if(site === "salesFId"){
						this.setAccName(requestData.input[site]);
						continue;
					}
					if(site === "summary"){
						this.setSummary(requestData.input[site]);
						continue;
					}
					this.addSite(this.addASiteFromData(site, requestData.input[site]));
				}
				//now modify agents
				this.loopThroughSites(function(aSite){
					siteData = requestData.input[aSite.getId()];
					aSite.loopThroughAgents(function(anAgent){
						for (var i = 0; i < siteData.data.length; i++) {
							if (!$.isEmptyObject(siteData.data[i][anAgent.getId()])) {
								if (anAgent.populateDataFromCloudRequest(siteData.data[i][anAgent.getId()]) === true) {
									needToPopulateOutput = true;
								}
							}
						}
					});
				});

				if(rd.details){
					edcHandler.sdt.view.showUsersDetails(rd.details);
				}

				//show output
				edcHandler.sdt.view.showOutput();
				if(rd.recalculate == 1){
					edcHandler.sdt.controller.reCalculate();
				}

			}else{
				this.loadDefaultSite();
				edcHandler.sdt.view.renderSites();
			}



		} else {
			//load default site
			this.loadDefaultSite();
		}
	},
	loadDefaultSite : function() {
		return this.addASite();
	},
	createASite: function(siteId, siteName){
		return new Site(siteId, siteName);
	},
	removeASite: function(siteObj){
		this.removeSite(siteObj);
	},
	addASite : function() {
		var siteL = this.sites.length;
		var aSite = this.createASite("site" + siteL, "Site " + (siteL + 1));
		var qData = this.getQuestions();
		for (var i = 0; i < qData.length; i++) {
			var anAgent = new Agent(qData[i].id, qData[i].name);
			var sols = qData[i].solutions;
			if (sols.length > 0) {
				for (var s = 0; s < sols.length; s++) {
					var aSol = new Solution(sols[s].id, sols[s].name);
					var qs = sols[s].questions;
					for (var q = 0; q < qs.length; q++) {
						aSol.addQuestion(qs[q].question, qs[q].type, qs[q].id, qs[q].qCalF);
					}
					aSol.setFetCalFunction(sols[s].fetF);
					anAgent.addSolution(aSol);
				}
				aSite.addAgent(anAgent);
			}
		}
		this.addSite(aSite);
		return aSite;
	},
	addASiteFromData : function(siteId, siteData) {
		var aSite = this.createASite(siteId, siteData.name);
		var agents = this.getAgentsFromQuestions();

			for(var l=0; l < agents.length; l++){
				anAgent = agents[l];
				aSite.addAgent(anAgent);
			}


		return aSite;
	},
	getAgentsFromQuestions : function(){

		var agents = [];
		var qData = this.getQuestions();
		for (var i = 0; i < qData.length; i++) {
			var anAgent = new Agent(qData[i].id, qData[i].name);
			var sols = qData[i].solutions;
			if (sols.length > 0) {
				for (var s = 0; s < sols.length; s++) {
					var aSol = new Solution(sols[s].id, sols[s].name);
					var qs = sols[s].questions;
					for (var q = 0; q < qs.length; q++) {
						aSol.addQuestion(qs[q].question, qs[q].type, qs[q].id, qs[q].qCalF);
					}
					aSol.setFetCalFunction(sols[s].fetF);
					anAgent.addSolution(aSol);
				}
				agents.push(anAgent);
			}
		}
		return agents;
	},
	loadData : function() {
		$("#content").mask("");
		edcHandler.sdt.loadercounter++;
		var reqObj = this;
		edcHandler.getRequestData(this.getId(), edcHandler.appType, function(d){
			edcHandler.sdt.loadercounter--;
			if(edcHandler.sdt.loadercounter <= 0){
				$("#content").unmask();
				edcHandler.sdt.loadercounter = 0;
			}
			if(d.requestData){
				d.output = JSON.parse(d.requestData);
				d.requestData = null;
			}
			reqObj.setSiteData(d);
		});
	},
	getAccName : function(){
		return this.accountname;
	},
	populateResponse : function() {
		edcHandler.sdt.view.setAccName(this.getAccName());
		edcHandler.sdt.view.setSummary(this.getSummary());
		var rData = this.getData();
		if (rData && rData.output && rData.output.output) {
			rData = rData.output.output;
		} else if (rData && rData.output) {
			rData = rData.output;
		}
		if (!$.isEmptyObject(rData)) {
			edcHandler.sdt.view.showEditButton();
			$(".sdt-response").remove();
			var d = $('<div class="col-md-12 sdt-row sdt-response">');
			var s = $('<div class="col-md-12 sdt-summary">');
			var st = $('<div class="summ-req col-md-12">');
			$("<h4>Summary of questions </h4>").appendTo(st);
			st.appendTo(s);
			this.loopThroughSites(function(aSite) {
				aSite.populateSummary().appendTo(s);
			});
			d.append(s);
			edcHandler.sdt.view.appendToSitesDiv(d);

			var r = $('<div class="col-md-12 sdt-recom">');
			var aD = $('<div class="col-md-12">');
			aD.append($('<h4>Recommendations</h4>'));
			var outputD = $('<div class="col-md-12 sdt-output">');
			if (rData.html) {
				outputD.html(rData.html);
			} else {
				outputD.html("Somthing went wrong, please check with site administrator");
			}
			outputD.appendTo(aD);
			aD.appendTo(r);
			r.appendTo(d);
		}
	}
}

Site.prototype = {
	constructor : Site,
	getId : function() {
		return this.id;
	},
	setId: function(id){
		this.id = id;
	},
	getName : function() {
		return this.name
	},
	getAgents : function() {
		return this.agents;
	},
	addAgent : function(idata) {
		if (idata instanceof Agent) {
			this.agents.push(idata);
		}
	},
	setName: function(name){
		this.name = name;
	},
	loopThroughAgents : function(callBack) {
		for (var ag = 0; ag < this.agents.length; ag++) {
			var anAgent = this.agents[ag];
			callBack(anAgent);
		}
	},
	getAgentById : function(agentId) {
		var agentById = null;
		this.loopThroughAgents(function(agent) {
			if (agent.getId() === agentId) {
				agentById = agent;
			}
		});
		return agentById;
	},
	xxxgetBreadCrumbDiv : function(){
		var d = $('<div class="row sdt-bcrumb-div">').attr("id", "brdcrmb-" + this.getId());
		var olEl = $('<ol class="breadcrumb sdt-bcrumb">');
		olEl.appendTo(d);
		return d;
	},
	xxxgenerateBreadCrumb : function(brCrumbId) {
		var isFound = false;

		var d = $("#brdcrmb-" + this.getId()+" .sdt-bcrumb").empty();
		for (var i = 0; i < this.brCrumb.length; i++) {
			var aBr = this.brCrumb[i];
			aBr.isActive = false;
			if (aBr.id === brCrumbId) {
				aBr.isActive = true;
				isFound = true;
			}
			var brs = this.getBreadCrumbHTML(aBr);
			d.append(brs);
			if (aBr.isActive) {
				return;
			}
		}

		if (isFound === false) {
			$("#brdcrmb-"+this.getId()).empty();
			$("#brdcrmb-"+this.getId()).addClass("hidden");
		} else {
			$("#brdcrmb-"+this.getId()).removeClass("hidden");
		}
	},
	xxxgetBreadCrumbHTML : function(aBr) {
		var thisSite = this;
		if (aBr.isActive === true) {
			return $('<li class="active"></li>').text(aBr.name);
		} else {
			var liHtml = $('<li/>').on("click", function() {
				thisSite.generateBreadCrumb(aBr.id);
				aBr.callBack(thisSite);
			})
			$('<a class=""></a>').text(aBr.name).attr("id", aBr.id).appendTo(liHtml);
			return liHtml;
		}
	},
	populateSolutionsDialog: function(){
		var agentSelected = [];
		var dialogid = "solutions-"+this.getId();
		$(".agent-solution-popup-div").remove();
		var solsDiv = $("<div class='agent-solution-popup-div'>").attr("id", dialogid);
		var thisSite = this;
		this.loopThroughAgents(function(anAgent) {
			solsDiv.append(anAgent.populateListForSolutions(thisSite.getId()));
		});
		//edcHandler.sdt.controller.onClickSolution(this, siteId);
		cvUtil.showInfoDialog({title: "Add Solution to "+this.getName(), width: "auto"}, solsDiv, function(){
			edcHandler.sdt.controller.showSelectedSolutionsQuestions(thisSite);
		});
	},
	xxxpopulateSolutions : function() {
		//var agentSolDiv = $('<div class="row sdt-row agent-solution-headers-div assumptions">').attr("id",
		//		"solutions-" + this.getId());
		var agentSelected = [];
		this.clearSolutionDiv();
		this.generateBreadCrumb("solution");
		//edcHandler.sdt.view.showSolutions();
		this.loopThroughAgents(function(anAgent) {
			if (anAgent.isSelected()) {
				agentSelected.push(anAgent);
			}
		});
		var showSol = true;
		if (agentSelected.length === 1) {
			if (agentSelected[0].getSolutions().length > 1) {
				this.appendToSolutionDiv(agentSelected[0].populateHeadersForSolutions(this.getId()));
			} else {
				showSol = false;
				edcHandler.sdt.view.populateQuestions(this, agentSelected[0].getSolutions()[0].getId());
			}
		} else {
			for (var i = 0; i < agentSelected.length; i++) {
				this.appendToSolutionDiv(agentSelected[i].populateHeadersForSolutions(this.getId()));
			}
		}
		if(showSol){
			this.appendToSiteDiv(this.solutionDiv);
			edcHandler.sdt.view.showSolutions(this.getId());
		}
	},
	populateQuestions : function(solId) {
		this.clearQuestionDiv();
		var thisObj = this;
		var siteId = this.getId();
		//var qDiv = $('<div class="row sdt-row agent-solution-questions-div">').attr("id", "questions-" + this.getId());
		edcHandler.sdt.view.showCalculateButton();
		//edcHandler.sdt.view.generateBreadCrumb("question");

		this.loopThroughAgents(function(anAgent) {
			thisObj.appendToQuestionDiv(anAgent.populateQuestionsForSolutions(siteId,solId));
		});
		var siteDiv = $("#" + this.getId());
		this.appendToSiteDiv(this.questionDiv);
		//this.generateBreadCrumb("question");
		edcHandler.sdt.view.showQuestions();
	},
	appendToSiteDiv : function(anEl) {
		if(anEl && anEl != "")
			anEl.appendTo(this.siteDiv);
	},
	xxxappendToAgentDiv : function(anEl) {
		if(anEl && anEl != "")
			anEl.appendTo(this.agentDiv);
	},
	xxxappendToSolutionDiv : function(anEl) {
		if(anEl && anEl != "")
			anEl.appendTo(this.solutionDiv);
	},
	appendToQuestionDiv : function(anEl) {
		if(anEl && anEl != "")
			anEl.appendTo(this.questionDiv);
	},
	reInitSiteDiv : function() {
		this.siteDiv = $('<div class="row site-div">').attr("id", this.getId());
	},
	xxxreInitAgentDiv : function() {
		this.agentDiv = $('<div class="row sdt-row agent-headers-div assumptions hidden">').attr("id",
				"agents-" + this.getId());
	},
	xxxreInitSolutionDiv : function() {
		this.solutionDiv = $('<div class="row sdt-row agent-solution-headers-div assumptions">').attr("id",
				"solutions-" + this.getId());
	},
	reInitQuestionDiv : function() {
		this.questionDiv = $('<div class="row sdt-row agent-solution-questions-div">').attr("id",
				"questions-" + this.getId());
	},
	reInitDivs : function() {
		this.reInitSiteDiv();
		//this.reInitAgentDiv();
		//this.reInitSolutionDiv();
		this.reInitQuestionDiv();
	},
	clearSiteDiv : function() {
		//this.clearAgentDiv();
		this.reInitSiteDiv();
		$("#" + this.getId()).remove();
	},
	xxxclearAgentDiv : function() {
		//this.clearSolutionDiv();
		this.reInitAgentDiv();
		$("#agents-" + this.getId()).remove();
	},
	xxxclearSolutionDiv : function() {
		this.clearQuestionDiv();
		this.reInitSolutionDiv();
		$("#solutions-" + this.getId()).remove();
	},
	clearQuestionDiv : function() {
		this.reInitQuestionDiv();
		$("#questions-" + this.getId()).remove();
	},
	showSolutionsPopup: function(){
		console.log("add solution pop up");
		this.populateSolutionsDialog();
	},
	populateSiteDiv : function() {
		var thisSite = this;
		this.clearSiteDiv();
		var header = $('<div class="vw-comp-name betH4"/>');
		//header.append($('<h4 class="vw-comp-name betH4"/>').text("Site - "));
		var inp = $('<input/>', {
				type : "text",
				"class" : "textbox sdt-data"
			}).attr("id", "siteinp-"+this.id).appendTo(header);
			inp.val(this.getName());
			inp.on("change", function() {
				thisSite.setName($(this).val());
			});

		var solBtn = $('<a class="vw-btn vw-btn-default addSol"/>').text("Add Solution").appendTo(header);
		solBtn.on('click', function(){
			thisSite.showSolutionsPopup();
		});
		header.on('mouseover', function(ev) {
			$(this).children("a.remSite").removeClass("hidden");
		});
		header.on('mouseout', function(ev) {
			$(this).children("a.remSite").addClass("hidden");
		});
		var remvTag = $('<a class="remSite hidden" title="Remove this Site">x</a>');
		var siteId = this.getId();
		remvTag.on("click", function(ev) {
			edcHandler.sdt.view.removeASite(thisSite);
		});
		header.append(remvTag);
		this.appendToSiteDiv(header);
		//this.appendToSiteDiv(this.getBreadCrumbDiv());
		//this.populateAgentsDivAndAppendToSite();
		return this.siteDiv;
	},
	xxxpopulateAgentsDivAndAppendToSite : function() {
		var siteObj = this;
		this.clearAgentDiv();
		this.loopThroughAgents(function(anEntity) {
			var h2el = $("<h2/>").text(anEntity.getName());
			var colDiv = $("<div class='col-xs-6 col-lg-4 assumptions'>").attr("id", anEntity.getId());
			colDiv.data("siteid", siteObj.getId());
			h2el.appendTo(colDiv);
			colDiv.click(function(el) {
				edcHandler.sdt.controller.onClickAgent(siteObj, anEntity, this);
			});
			siteObj.appendToAgentDiv(colDiv);
		});

		this.appendToSiteDiv(this.agentDiv);
		//edcHandler.sdt.view.showAgents(this.getId());
	},
	populateSummary: function() {
		var d = $('<div class="summ-site col-md-12">');
		d.append($('<h4>'+this.getName()+'</h4>'));
		this.loopThroughAgents(function(agent) {
			agent.populateSummary().appendTo(d);
		});
		return d;
	}
}

Agent.prototype = {
	constructor : Agent,
	getId : function() {
		return this.id;
	},
	getName : function() {
		return this.name
	},
	getDescription : function() {
		return this.description;
	},
	getTemplate : function() {
		return this.tileTemplate;
	},
	getSolutions : function() {
		return this.solutions;
	},
	setTemplate : function(tp) {
		this.tileTemplate = tp;
	},
	isSelected : function() {
		return this.selected;
	},
	setIsSelected : function(bSel) {
		if (bSel === true) {
			this.selected = true;
		} else {
			this.selected = false;
		}
	},
	addSolution : function(sol) {
		if (sol instanceof Solution) {
			this.solutions.push(sol);
		}
	},
	loopThroughSolutions : function(callBack) {
		for (var a = 0; a < this.solutions.length; a++) {
			var aSol = this.solutions[a];
			callBack(aSol);
		}
	},
	isAnySolutionSelected: function(){
		var isSelected = false;
		this.loopThroughSolutions(function(aSol) {
			if (aSol.isSelected()) {
				isSelected = true;
			}
		});
		return isSelected;
	},
	selectSolutionById : function(solId) {
		var isSelected = false;
		this.loopThroughSolutions(function(aSol) {
			if (aSol.getId() === solId) {
				aSol.setIsSelected(true);
				isSelected = true;
			}
		});
		return isSelected;
	},
	populateSummary : function() {
		var sumDiv = $("<div/>");//$("<div class=\"summ-agent col-md-12\"/>");
		//$("<h4>Summary of questions </h4>").appendTo(sumDiv);
		this.loopThroughSolutions(function(aSol) {
			if (aSol.isSelected()) {
				aSol.populateSummary().appendTo(sumDiv);
			}
		});
		return sumDiv;
	},
	populateListForSolutions : function(siteId) {
		var thisAgent = this;
		var agentHeaderDiv = $('<div class="col-sm-6"/>');
		var upperUl = $('<ul class="flex-column">');
		var liH = $('<li class="sol-item">');
		var l = $('<label class="" href="#">').text(this.getName());
		var ul = $('<ul class="flex-column">');
		agentHeaderDiv.append(upperUl);
		upperUl.append(liH,l,ul);
		this.loopThroughSolutions(function(aSol) {
			var litag = $('<li class="sol-item">');
			var chk = $('<input class="" type="checkbox"/>');
			chk.appendTo(litag);
			var lbl = $('<label class="">').text(aSol.getName());
			lbl.appendTo(litag);
			if(aSol.isSelected()){
				chk.attr("checked", "checked");
			}
			litag.click(function(el) {
				if(aSol.isSelected()){
					aSol.setIsSelected(false);
					chk.removeAttr("checked", "checked");
				}else{
					aSol.setIsSelected(true);
					chk.attr("checked", "checked");
				}
			});
			litag.appendTo(ul);
		});
		return agentHeaderDiv;

	},
	xxxpopulateHeadersForSolutions : function(siteId) {
		var thisAgent = this;
		var agentHeaderDiv = $('<div class="col-sm-12"/>');
		var header = $('<h4 class="vw-comp-name betH4"/>').text(this.getName());
		header.on('mouseover', function(ev) {
			$(this).children("a.remAgent").removeClass("hidden");
		});
		header.on('mouseout', function(ev) {
			$(this).children("a.remAgent").addClass("hidden");
		});
		var remvAgent = $('<a class="remAgent hidden" title="Remove this Agent from selection">x</a>');
		remvAgent.on("click", function(ev) {
			thisAgent.setIsSelected(false);
			agentHeaderDiv.remove();
			edcHandler.sdt.view.checkAndShowAgents();
		});
		header.append(remvAgent);
		agentHeaderDiv.append(header);
		this.loopThroughSolutions(function(aSol) {
			var h2el = $("<h2/>").text(aSol.getName());
			var pel = $("<p/>").text(aSol.getDescription());
			var colDiv = $("<div class='col-xs-6 col-lg-4 assumptions'>").attr("id", aSol.getId()).data("siteid",
					siteId);
			h2el.appendTo(colDiv);
			pel.appendTo(colDiv);
			colDiv.click(function(el) {
				edcHandler.sdt.controller.onClickSolution(this, siteId);
			});
			colDiv.appendTo(agentHeaderDiv);
		});
		return agentHeaderDiv;

	},
	populateQuestionsForSolutions : function(siteId, solId) {
		var solDiv = $('<div class="col-md-12 sol-questions sol-q-'+siteId+'">');
		var agentDiv = $('<div class="agent-div-questions"/>');
		this.selectSolutionById(solId);
		var isThere = false;
		this.loopThroughSolutions(function(aSol) {
			if (aSol.isSelected()) {
				isThere = true;
				aSol.populateQuestionsDiv(siteId).appendTo(agentDiv);
			}
		});
		if(isThere){
			agentDiv.appendTo(solDiv);
			return solDiv;
		}else{
			return "";
		}

	},
	populateDataForCloudRequest : function() {
		var isThere = false;
		var d = {};
		d.ids = [];
		var a = this;
		this.loopThroughSolutions(function(aSol) {
			if (aSol.isSelected()) {
				isThere = true;
				if (!d[a.getId()]) {
					d[a.getId()] = {};
				}
				d[a.getId()][aSol.getId()] = aSol.populateQuestionsData();
				var k = Object.keys(d[a.getId()][aSol.getId()]);
				//remove 'fet' from the keys
				var ind = k.indexOf('fet');
				if (ind > -1) {
					k.splice(ind, 1);
				}
				d.ids = d.ids.concat(k);
			}
		});
		if(isThere===false){
			return null;
		}
		return d;

	},
	populateDataFromCloudRequest : function(reqData) {
		var isNotEmpty = false;
		this.loopThroughSolutions(function(aSol) {
			if (!$.isEmptyObject(reqData[aSol.getId()])) {
				//that means we have that solution selected.
				aSol.setIsSelected(true);
				aSol.populateDataFromCloudRequest(reqData[aSol.getId()]);
				isNotEmpty = true;
			}
		});
		if (isNotEmpty) {
			this.setIsSelected(true);
		}
		return isNotEmpty;

	}
}
Question.prototype = {
	constructor : Question,
	getId : function() {
		return this.id;
	},
	setAnswer : function(ans) {
		//we can check the type and error out
		this.ans = ans;
	},
	getAnswer : function() {
		return this.ans;
	},
	getCalculationFunction : function() {
		return this.qCalF;
	},
	getQuestion : function() {
		return this.question;
	},
	getDivElement : function(siteId) {
		var q = this;
		var ans = this.getAnswer();
		var d = $('<div class="col-lg-6 col-md-4 col-xs-12"/>');
		var l = $('<label/>', {
			"for" : this.id,
			"class" : "",
			text : this.getQuestion()
		}).appendTo(d);
		if (this.type === "number") {
			var inp = $('<input/>', {
				type : "number",
				"class" : "textbox form-control sdt-data " + siteId
			}).attr("id", this.id).attr("min", 1).attr("data-site", siteId).appendTo(d);
			if (ans && (ans != "" || ans != "0")) {
				inp.val(ans);
			}
			inp.on("change", function() {
				q.setAnswer($(this).val());
				var tel = this;
				var f = q.getCalculationFunction();
				if (f && f !== "") {
					f = new Function('el, q', '"use strict";' + f);
					f(tel, q);
				}
			});
		}
		return d;
	},
	getSummaryDivElement : function() {
		var ans = this.getAnswer();
		var d = null;
		if (ans && (ans != "" || ans != "0")) {
			d = $('<div class="col-md-3"/>');
			var qL = $('<label/>', {
				"for" : this.id,
				"class" : "col-md-10",
				text : this.getQuestion() + ": "
			}).appendTo(d);
			var aL = $('<label/>', {
				"class" : "col-md-2",
				text : this.getAnswer()
			}).appendTo(d);
		}
		return d;
	}
}

Solution.prototype = {
	constructor : Solution,
	getId : function() {
		return this.id;
	},
	getName : function() {
		return this.name;
	},
	addQuestion : function(question, type, id, calF) {
		q1 = new Question(question, type, id, calF);
		this.questions.push(q1);
	},
	getQuestions : function() {
		return this.questions;
	},
	getDescription : function() {
		return this.description;
	},
	isSelected : function() {
		return this.selected;
	},
	setIsSelected : function(bSel) {
		if (bSel === true) {
			this.selected = true;
		} else {
			this.selected = false;
		}
	},
	getFet : function() {
		return this.fet;
	},
	loopThroughQuestions : function(callBack) {
		for (var i = 0; i < this.questions.length; i++) {
			var q = this.questions[i];
			callBack(q);
		}
	},
	setFetCalFunction : function(fnc) {
		var e = document.createElement('div');
		e.innerHTML = fnc;
		this.fetFunc = e.childNodes[0].nodeValue;
	},
	getFetCalFunction : function() {
		return this.fetFunc;
	},
	calculateFET : function() {
		var f = this.getFetCalFunction();
		if (f && f !== "") {
			var sol = this;
			var func = new Function('sol', '"use strict";' + f);
			func(sol);
		}
		return this.getFet();
	},
	populateQuestionsData : function() {

		var qd = {};
		this.loopThroughQuestions(function(q) {
			var anss = q.getAnswer();
			if (anss) {
				qd[q.getId()] = q.getAnswer();
			}
		});
		qd['fet'] = this.calculateFET();
		return qd;

	},
	populateQuestionsDiv : function(siteId) {
		var solDiv = $('<div class="row padding-bottom"/>');
		var colDiv = $('<div class="col-md-12"/>');
		colDiv.appendTo(solDiv);
		var thisSol = this;
		var header = $('<h4 class="vw-comp-name betH4"/>').text(this.getName());
		header.on('mouseover', function(ev) {
			$(this).children("a.remSol").removeClass("hidden");
		});
		header.on('mouseout', function(ev) {
			$(this).children("a.remSol").addClass("hidden");
		});
		var remvSol = $('<a class="remSol hidden" title="Remove this solution">x</a>');
		remvSol.on("click", function(ev) {
			thisSol.setIsSelected(false);
			solDiv.remove();
		});
		header.append(remvSol);
		header.appendTo(colDiv);

		var formDiv = $('<div class="form-group col-md-12 qs-div-'+siteId+'"/>');
		formDiv.appendTo(colDiv);

		this.loopThroughQuestions(function(q) {
			q.getDivElement(siteId).appendTo(formDiv);
		});
		return solDiv;

	},
	populateDataFromCloudRequest : function(reqData) {
		this.loopThroughQuestions(function(q) {
			if (reqData[q.getId()]) {
				q.setAnswer(reqData[q.getId()]);
			}
		});

	},
	populateSummary : function() {
		var sumDiv = $("<div class=\"summ-sol col-md-12\"/>");
		var header = $('<h5 class="vw-comp-name betH4 col-md-1"/>').text(this.getName());
		header.appendTo(sumDiv);
		var qsDiv = $("<div class=\"col-md-11 sdt-summ-qs\"/>");
		this.loopThroughQuestions(function(q) {
			var qDiv = q.getSummaryDivElement();
			if (qDiv != null) {
				qDiv.appendTo(qsDiv);
			}
		});
		qsDiv.appendTo(sumDiv);
		return sumDiv;
	},
	getQVal : function(qId) {
		var qVal = 0;
		this.loopThroughQuestions(function(q) {
			if (q.getId() === qId) {
				qVal = q.getAnswer();
			}
		});
		return qVal;
	},
	setQVal : function(qId, qVal) {
		if (!qVal) {
			qVal = "";
		}
		this.loopThroughQuestions(function(q) {
			if (q.getId() === qId) {
				q.setAnswer(qVal);
			}
		});
		return qVal;
	},
	setFetVal : function(fetVal) {
		this.fet = fetVal;
	}
}
//************************************************************************************/
//Class model part end
//************************************************************************************/

//************************************************************************************/
//controller part start
//************************************************************************************/
edcHandler.sdt.controller.regsiterOnClickButtons = function() {
	$("#sdtmainBtn").click(function() {
		if(edcHandler.sdt.controller.anythigSelected()){
			$("#content").mask("");
			edcHandler.sdt.loadercounter++;
			$('.sdtForm').submit();
		}else{
			cvUtil.errorToast("Please add solutions to the site for calculations.");
		}
	});
	$(".editReq").click(function(){
		edcHandler.sdt.view.renderSites();
		edcHandler.sdt.view.hideEditButton();
	});
	$(".genppt").click(function() {
		edcHandler.sdt.model.exportPPT();
	});

	$(".gencsv").click(function() {
		edcHandler.sdt.model.exportCSV();
	});
	$(".newSite").click(function() {
		edcHandler.sdt.view.addSite();
	});

	$("#accountname").on('change',function(){
		edcHandler.sdt.model.getRequest().setAccName($(this).val());
		$("#company").val($(this).val());
	});
	$("#summary").on('change',function(){
		edcHandler.sdt.model.getRequest().setSummary($(this).val());
		$("#comments").val($(this).val());
	});

}
edcHandler.sdt.controller.onClickSolution = function(el, siteId) {
	console.log("Solution clicked:", el);
	var solId = $(el).attr("id");
	var req = edcHandler.sdt.model.getRequest();
	var site = req.getSiteById(siteId);
	edcHandler.sdt.view.populateQuestions(site, solId);
}
edcHandler.sdt.controller.showSelectedSolutionsQuestions = function(siteObj, siteId){
	edcHandler.sdt.view.populateQuestions(siteObj);
}
edcHandler.sdt.controller.onClickAgent = function(site, el) {
	console.log("Agent clicked:", el);
	var agentId = $(el).attr("id");
	var agent = site.getAgentById(agentId);
	agent.setIsSelected(true);
	site.populateSolutions();

}
edcHandler.sdt.controller.anythigSelected = function(){
	 var agents = edcHandler.sdt.model.getRequest().sites[0].getAgents();
	 for(var i = 0; i < agents.length; i++){
		 if(agents[i].isAnySolutionSelected()){
			 return true;
		 }
	 }
	 return false;
 };
edcHandler.sdt.controller.loadSites = function() {
	var req = edcHandler.sdt.model.getRequest();
	req.loadSites();
	edcHandler.sdt.view.renderSites();
};
edcHandler.sdt.controller.loadQuestionsFromServer = function() {
	edcHandler.sdt.model.getQuestionsFromServer(edcHandler.sdt.controller.loadSites);

}
edcHandler.sdt.controller.processCloudRequestResponse = function(d) {
	d = JSON.parse(d);
	console.log(d);
	//edcHandler.sdt.model.requestData.output = {};
	var reqD = edcHandler.sdt.model.getRequest().getData();
	console.log(edcHandler.sdt.model.getRequest());
	edcHandler.sdt.loadercounter--;
	if(edcHandler.sdt.loadercounter <= 0){
		$("#content").unmask();
		edcHandler.sdt.loadercounter = 0;
	}
	if (d.documentguid) {
		reqD.documentguid = d.documentguid;
	}
	if (d.sdtOutPut) {
		d.sdtOutPut = JSON.parse(d.sdtOutPut);
		reqD.output = JSON.parse(d.sdtOutPut.errorMessage);
		edcHandler.sdt.view.showOutput();
		updateParamToUrl("requestId", d.cloudReqID);
	}

}

edcHandler.sdt.controller.prepare = function() {
	var reqId = parseInt(cvUtil.getParameter("requestId", 0));
	var cloudReq = new CloudRequest(reqId);
	edcHandler.sdt.model.setRequest(cloudReq);
	if (cloudReq.getId() > 0) {
		cloudReq.loadData();
	} else {
		edcHandler.sdt.view.hideCalculateButton();
		//edcHandler.sdt.view.hideNewReqButton();
		edcHandler.sdt.view.hideGenButtons();
		edcHandler.sdt.controller.loadQuestionsFromServer();
	}
}
edcHandler.sdt.controller.reCalculate = function(){
	$("#sdtmainBtn").click();
};
//************************************************************************************/
//controller part end
//************************************************************************************/

$(document).ready(function() {
	edcHandler.sdt.controller.prepare();
	edcHandler.sdt.controller.regsiterOnClickButtons();
});
