(function(requestUploadExports) {
	'use restrict';

	var requestUploader = null;
	var within_enter = false;
	var fileprogressMap = null;
	var isfieluploaded = true;

	function init() {

		requestUploader = new Uploader({
			target : requestsUploadAppType.getUploadApi(),
			duplicateFile : false
		});

		if ($(".fileProgressContainer").length == 0) {
			var contentDiv = document.createElement("DIV");
			var params = {};

			params.showNoteText = true;

			$(contentDiv).load(cvUtil.getContextPath() + "/upload/fileprogress.jsp?csrf=" + cvUtil.readCookie('csrf'),
					params,
					function() {
						$("#progressContainer").append($(contentDiv).find(".fileProgressContainer"));
					});
		}

	}

	function doReStartableUpload() {
		console.debug("Start Setting the Uploader...");

		var uploadQueryParams = {};
		uploadQueryParams["reqType"] = requestsUploadMain.reqType;
		uploadQueryParams["cloudReqID"] = requestsUploadMain.cloudReqID;
		uploadQueryParams["Source"] = "";
		uploadQueryParams["Destination"] = "";
		if ((requestsUploadMain.reqType != "") &&
				(requestsUploadMain.reqType != null) &&
				((requestsUploadMain.reqType == "V10 CommCell Migration") || (requestsUploadMain.reqType == "V11 CommCell Migration"))) {
			var srcFileName = $("#ccmsrcFile").val();
			farr = (srcFileName).split('\\');
			sfileName = farr[(farr.length) - 1];
			uploadQueryParams["Source"] = sfileName;

			var destFileName = $("#ccmdstFile").val();
			destfarr = (destFileName).split('\\');
			dfileName = destfarr[(destfarr.length) - 1];
			uploadQueryParams["Destination"] = dfileName;
		}

		if (requestUploader != null && requestUploader.isSupported()) {
			console.debug("Upload Params: " + JSON.stringify(uploadQueryParams));
			requestUploader.setOptions("query", uploadQueryParams);
			attachDownloadProgressBar();
		}
		console.debug("Setting the Uploader Completed.");
	}

	function attachDownloadProgressBar() {
		attachDownloadProgressBarListeners();
	}

	function attachDownloadProgressBarListeners() {
		if (requestUploader != null && requestUploader.isSupported()) {
			requestUploader.onEvent(requestUploader.EventEnum.UPLOAD_START, function() {
				onUploadStart();
			});

			requestUploader.onEvent(requestUploader.EventEnum.READY_FOR_UPLOAD, function() {
				onUploadReady();
			});

			requestUploader.onEvent(requestUploader.EventEnum.UPLOAD_PROGRESS, function(event, uploadProgress) {
				onUploadProgress(uploadProgress);
			});

			requestUploader.onEvent(requestUploader.EventEnum.FILE_ADDED, function(fileItem) {
				onUploadFileAdd(fileItem);
			});

			requestUploader.onEvent(requestUploader.EventEnum.FILE_ADD_ERROR, function(fileItem) {
				onUploadFileAddError(fileItem);
			});

			requestUploader.onEvent([
					requestUploader.EventEnum.FILE_UPLOAD_STARTING,
					requestUploader.EventEnum.FILE_UPLOAD_INPROGRESS,
					requestUploader.EventEnum.FILE_UPLOAD_CANCELED,
					requestUploader.EventEnum.FILE_UPLOAD_CANCEL_ERROR ], function(fileItem) {
				onProgress(fileItem);
			});

			requestUploader.onEvent(requestUploader.EventEnum.FILE_UPLOAD_COMPLETED, function(fileItem) {
				onUploadFileComplete(fileItem);
			});

			requestUploader.onEvent(requestUploader.EventEnum.FILE_UPLOAD_ERROR, function(fileItem) {
				onUploadFileError(fileItem);
			});

			requestUploader.onEvent(requestUploader.EventEnum.UPLOAD_END, function() {
				onUploadComplete();
			});
		}
	}

	function onUploadStart() {
		fileProgress.initProgressDialog();
	}

	function onUploadFileAdd(fileItem) {
		if (typeof fileItem !== "undefined" && fileItem !== null) {
			if (fileprogressMap == null) {
				fileprogressMap = new HashMap();
			}
			fileprogressMap.put(fileItem.fileID, fileItem);
			if (fileprogressMap.size() % 50 == 0) {
				fileProgress.updateProgress(fileprogressMap);
				fileprogressMap.clear();
				delete fileprogressMap;
				fileprogressMap = null;
			}
		}
	}

	function onUploadFileAddError(fileItem) {
		if (typeof fileItem !== "undefined" && fileItem !== null) {
			if (fileprogressMap == null) {
				fileprogressMap = new HashMap();
			}
			fileprogressMap.put(fileItem.fileID, fileItem);
			fileProgress.updateProgress(fileprogressMap);
			fileprogressMap.clear();
			delete fileprogressMap;
			fileprogressMap = null;
		}
	}

	function onUploadReady() {
		if (requestUploader != null && requestUploader.isSupported()) {
			console.debug("Ready for Upload");
			fileProgress.updateProgress(fileprogressMap);
			delete fileprogressMap;
			fileprogressMap = null;
			console.debug("Starting Upload...");
			requestUploader.startUpload();
			$("#browsetable_info").hide();
		}
	}

	function onProgress(fileItem) {
		if (typeof fileItem !== "undefined" && fileItem !== null) {
			fileProgress.updateRow(fileItem);
		}
	}

	function onUploadProgress(uploadProgress) {
		if (typeof uploadProgress !== "undefined" && uploadProgress !== null) {
			fileProgress.updateHeader(uploadProgress);
		}
	}

	function onUploadFileComplete(fileItem) {
		if (typeof fileItem !== "undefined" && fileItem !== null) {
			if (requestUploader != null && requestUploader.isSupported() &&
					requestUploader.isSameParentPath(fileItem.fileID, requestsUploadMain.browsePath)) {
				requestsUploadMain.addUploadFilePlaceholder(fileItem);
			}
			fileProgress.updateRow(fileItem);
		}
	}

	function onUploadFileError(fileItem) {
		isfieluploaded = false;
		fileProgress.updateRow(fileItem);

		$("#content").unmask();
		requestsUploadMain.edcForm.closest('.uploadDiv').siblings(".uploadMsg")
				.removeClass("cloudalert cloudalert-error cloudalert-success").addClass("cloudalert cloudalert-error")
				.html("We're sorry, something went wrong. Please try to upload again.");
		$('.uploadNowBtn').removeClass('disabled');
		$('.uploadNowBtn').bind('click', true);
		cancelAll();
	}

	function onUploadComplete() {
		setTimeout(function() {
			$(".fileProgressContainer").removeClass("expanded").addClass("collapsed");
			$("#progressContainer").hide().addClass("hidden");
		}, 6000);
		cleanUp();
		if (isfieluploaded) {
			updateCloudEDCRequest();
		} else {
			msg = "We're sorry, something went wrong. Please try to upload again."
			requestsUploadMain.edcForm.closest('.uploadDiv').siblings(".uploadMsg")
					.removeClass("cloudalert cloudalert-error cloudalert-error")
					.addClass("cloudalert cloudalert-success").html(msg);
		}
		window.clearInterval(requestsUploadMain.intervalId);
	}

	function updateCloudEDCRequest() {
		if (requestsUploadMain.edcForm != null) {
			var data = {};
			msg = "Upload completed, sending mail."
			curForm = requestsUploadMain.edcForm;
			curForm.closest('.uploadDiv').siblings(".uploadMsg")
					.removeClass("cloudalert cloudalert-error cloudalert-error")
					.addClass("cloudalert cloudalert-success").html(msg);
			data["files"] = "";
			data["CloudRequestID"] = requestsUploadMain.cloudReqID;
			curForm.find(".edc-filedata").each(function(i) {
				var fileName = (this.value) ? (this.value) : (this.name);
				var farr = (fileName).split('\\');
				fileName = farr[(farr.length) - 1];
				data["files"] = fileName + "," + data["files"];
			});
			cvUtil.loadPageWithPOST(cvUtil.getContextPath() + '/updateCloudRequest.do', data, function(data) {
				data = cvUtil.parseJSON(data);
				if (data.returnCode != 'Error') {
					msg = requestsUploadMain.msg;
				} else {
					msg = "We're sorry, something went wrong. Please try to upload again."
				}
				requestsUploadMain.edcForm.closest('.uploadDiv').siblings(".uploadMsg")
						.removeClass("cloudalert cloudalert-error cloudalert-error")
						.addClass("cloudalert cloudalert-success").html(msg);
				$('.uploadNowBtn').removeClass('disabled');
				$('.uploadNowBtn').bind('click', true);
			}, function() {
				$("#content").unmask();
				curForm.closest('.uploadDiv').siblings(".uploadMsg")
						.removeClass("cloudalert cloudalert-error cloudalert-success")
						.addClass("cloudalert cloudalert-error")
						.html("We're sorry, something went wrong. Please try to upload again.");
				$('.uploadNowBtn').removeClass('disabled');
				$('.uploadNowBtn').bind('click', true);
			});
		}
	}

	function updatePreviewStatus(previewStatus, curForm) {
		if (previewStatus != "") {
			var statusArray = previewStatus.split(";");
			for (i = 0; i < statusArray.length - 1; i++) {
				var busyCol = $("#" + "prvwBusy" + i);
				$("#" + "prvwBusy" + i).removeClass("prvwBusy");
				if (statusArray[i] != 'failed') {
					var innerHTML = '<a class="prvwLnk" target="_blank" href="' + window.location.protocol + '//' +
							window.location.host + cvUtil.getContextPath() + statusArray[i] +
							'"><img alt="success" src="../../cloud/edc/img/success-icon.png"></a>';
				} else {
					var innerHTML = '<img alt="preview failed" class="prvwFail" src="../../cloud/edc/img/error-icon.png">';
				}
				busyCol.html(innerHTML);
			}
		}
	}

	function pause(fileId) {
		if (requestUploader != null && requestUploader.isSupported()) {
			requestUploader.pause(fileId);
		}
	}

	function resume(fileId) {
		if (requestUploader != null && requestUploader.isSupported()) {
			requestUploader.resume(fileId);
		}
	}

	function cancel(fileId) {
		if (requestUploader != null && requestUploader.isSupported()) {
			console.debug("Cancelling Upload Request for " + fileId + "...");
			requestUploader.cancel(fileId);
		}
	}

	function cancelAll() {
		if (requestUploader != null && requestUploader.isSupported()) {
			console.debug("Cancelling All Upload Request...");
			requestUploader.cancelAll();
		}
		window.clearInterval(requestsUploadMain.intervalId);
	}

	function cleanUp() {
		within_enter = false;
	}

	function isUploadsInProgress() {
		if (requestUploader != null && requestUploader.isSupported()) {
			if (requestUploader != null && requestUploader.uploadProgress != null) {
				return true;
			}
		} else {
			var uploadsInProgress = $(".uploadInProgress");
			for (var i = 0; i < uploadsInProgress.length; i++) {
				if ($(uploadsInProgress[i]).is(":visible")) {
					return true;
				}
			}
		}
	}
	init();

	requestUploadExports.requestsUploadFile = {
		requestUploader : requestUploader,
		doReStartableUpload : doReStartableUpload,
		isUploadsInProgress : isUploadsInProgress
	};

})(window);