function PopulateDropdown() {

	if (userView != 1) {
		$("select#PhaseDrp option").each(function() {
			this.selected = (this.text.toLowerCase() == PhaseName.toLowerCase());
		});
		var selPhase = $('#PhaseDrp').val();
		populateSubPhase(selPhase);
		$("select#subPhaseStatusDrp option").each(function() {
			this.selected = (this.text.toLowerCase() == subPhaseStatus.toLowerCase());
		});
		$("select#subPhaseDrp option").each(function() {
			this.selected = (this.text.toLowerCase() == subPhaseName.toLowerCase());
		});
	}

}

function getURLParam(param) {
	var querystring = location.search.replace('?', '').split('&');
	var queryObj = {};
	for (var i = 0; i < querystring.length; i++) {
		// get name and value
		var name = querystring[i].split('=')[0];
		var value = querystring[i].split('=')[1];
		// populate object
		queryObj[name] = value;
	}
	return queryObj[param];
}

function populateDetails() {

	if (vmName == '') {
		vmName = "NA";
		$("#vmName").html('NA');
	} else {
		$("#vmName").html(vmName);
	}
}

function populateSubPhase(selPhase) {
	$('#subPhaseDrp').empty();
	var select = $('#subPhaseDrp')[0];
	switch (selPhase) {
	case "1":
		select.add(new Option("Request Submitted", 1));
		break;
	case "2":
		select.add(new Option("Data Download", 2));
		select.add(new Option("Data Validation", 11));
		break;
	case "3":
		select.add(new Option("VM Creation", 3));
		select.add(new Option("Rename VM Host", 4));
		select.add(new Option("CS Namechange", 5));
		break;
	case "4":
		select.add(new Option("Datacopy to VM", 6));
		select.add(new Option("Data Preprocess", 7));
		break;
	case "5":
		select.add(new Option("Data Import", 8));
		break;
	case "6":
		select.add(new Option("Report Generation", 9));
		break;
	case "8":
	case "9":
	case "10":
		select.add(new Option("Metrics Operation Request", 20));
		break;
	default:
		break;
	}
}

$(document).ready(function() {
	populateDetails();
	PopulateDropdown();

	var reqId = getURLParam('id');
	var a = false, b = false, c = false;
	$('#updateDets').click(function() {

		$('#updateDets').addClass('disabled');
		$('#updateDets').bind('click', false);

		cvUtil.loadPageWithPOST(cvUtil.getContextPath() + '/setrequestDetails.do?', {
			colName : "Phase",
			value : $('#PhaseDrp').val(),
			reqId : reqId
		}, function(data) {

			if (data < 0) {
				alert('Unable to update request details');
				$('#updateDets').removeClass('disabled');
				$('#updateDets').bind('click', true);
				return;
			} else {
				cvUtil.loadPageWithPOST(cvUtil.getContextPath() + '/setrequestDetails.do?', {
					colName : "SubPhase",
					value : $('#subPhaseDrp').val(),
					reqId : reqId
				}, function(data) {
					if (data < 0) {
						alert('Unable to update request details');
						$('#updateDets').removeClass('disabled');
						$('#updateDets').bind('click', true);
						return;
					} else {
						cvUtil.loadPageWithPOST(cvUtil.getContextPath() + '/setrequestDetails.do?', {
							colName : "SubPhaseStatus",
							value : $('#subPhaseStatusDrp').val(),
							reqId : reqId
						}, function(data) {
							if (data < 0) {
								alert('Unable to update request details');
								$('#updateDets').removeClass('disabled');
								$('#updateDets').bind('click', true);
								return;
							} else {
								console.log('Successfully updated request details');
								$('#updateDets').removeClass('disabled');
								$('#updateDets').bind('click', true);
								return;
							}
						});
					}
				});
			}
		});

	});

	$('#PhaseDrp').change(function() {
		var selPhase = $('#PhaseDrp').val();
		populateSubPhase(selPhase);
		$('#updateDets').show();

	});

	$('#subPhaseDrp').change(function() {
		$('#updateDets').show();

	});
	$('#subPhaseStatusDrp').change(function() {
		$('#updateDets').show();

	});

});
