var edcHandler = edcHandler || {
	app : ""
};
edcHandler = $.extend(edcHandler, {
	userDetails : {},
	loggedinUser : "",
	loggedinEmail : "",
	isCvEmp : true,
	hyperscaleoptions : {
		N_FOR_INTERNAL : "1",
		N_FOR_CUSTOMER : "2"
	},
	appsList : {
		stage : "stagecommserver",
		branding : "branding",
		cvsys : "unixsystemdisc",
		dbupgrade : "dbupgrade",
		edc : "edc",
		migrate : "migrate",
		preview : "preview",
		hyperscaletrial : "hyperscaletrial",
		sdt : "sdt"
	},
	usernamereg : /^(edc|sys|syscrawl)\d+$/i
});
edcHandler.handleHyperOptions = function(ev, el) {
	if (edcHandler.hyperscaleoptions.N_FOR_INTERNAL === $(el).val()) {
		$(".trial-for-customer").addClass("hidden");
	} else if (edcHandler.hyperscaleoptions.N_FOR_CUSTOMER === $(el).val()) {
		$(".trial-for-customer").removeClass("hidden");
	}
};
edcHandler.hyperscaleTrialOptionsEvent = function() {
	$("input[name='trialoption']").change(function(ev) {
		edcHandler.handleHyperOptions(ev, this);
	});
	edcHandler.handleHyperOptions(null, $("input[name='trialoption'][checked='checked']"));
};

edcHandler.getRequestData = function(reqId, type, callBack) {
	$("#content").mask("");
	var d = {};
	d.requestId = reqId;
	d.type = type;
	edcHandler.cloudRequest = {};
	edcHandler.cloudRequest.id = reqId;
	edcHandler.cloudRequest.data = {};
	cvUtil.loadPageWithPOST(cvUtil.getContextPath() + "/server/getCloudRequestData.do", d, function(data) {
		if (data.isClientResp === true) {
			if (data.data) {
				edcHandler.cloudRequest.data = data.data;
			}
		} else {
			console.log("unable to get data.");
		}
		//edcHandler.cloudRequest.data = data;
		if (callBack) {
			callBack(edcHandler.cloudRequest.data);
		} else {
			$("#content").unmask();
		}
	}, function() {
		$("#content").unmask();
	});
};
edcHandler.validateHyperScaleTrialFileds = function() {
	var isProceed = true;
	if ($("input[name='trialoption']:checked").val() === edcHandler.hyperscaleoptions.N_FOR_INTERNAL) {
		$(".forminp").removeClass("edc-data");
		return true;
	} else {
		$(".forminp").addClass("edc-data");
	}
	$(".forminp").each(function() {
		var tx = $(this);
		if (tx.hasClass("email")) {
			var eml = tx.val();
			if (eml != null && eml.trim().length > 0) {
				var mails = eml.split(",");
				for (var i = 0; i < mails.length; i++) {
					if (!cvUtil.isEmailValid(mails[i])) {
						cvUtil.errorToast("Invalid email: " + encodeURIComponent(mails[i]));
						isProceed = false;
					}
				}
			} else {
				if (tx.data("required") !== false) {
					isProceed = false;
				}
			}

		} else {
			var reg = new RegExp(tx.data("validation"));
			if (tx.val().trim() != '' && tx.val().trim().match(reg)) {
				isProceed = true;
			} else {
				isProceed = false;
			}
		}

		if (!isProceed) {
			tx.removeClass('input-success').addClass('input-error');
			tx.closest('.uploadDiv').siblings(".uploadMsg")
					.removeClass("cloudalert cloudalert-error cloudalert-success")
					.addClass("cloudalert cloudalert-error").html(tx[0].attributes['data-msg'].value);
			return false;
		} else {
			tx.removeClass('input-error').addClass('input-success');
			tx.closest('.uploadDiv').siblings(".uploadMsg").removeClass("cloudalert cloudalert-error").html('');
		}
	});

	return isProceed;

};
edcHandler.getUserDetails = function() {
	$("#content").mask("");
	cvUtil.loadPageWithPOST(cvUtil.getContextPath() + "/server/getuserDetails.do", {}, function(data) {
		edcHandler.userDetails = cvUtil.parseJSON(data);
		edcHandler.loggedinUser = edcHandler.userDetails.name;
		if (edcHandler.userDetails.email && edcHandler.userDetails.email !== "") {
			edcHandler.loggedinEmail = edcHandler.userDetails.email;
		}

		if (edcHandler.userDetails.referreremail && edcHandler.userDetails.referreremail !== "") {
			if (edcHandler.loggedinEmail && edcHandler.loggedinEmail !== "") {
				edcHandler.loggedinEmail += ",";
			}
			edcHandler.loggedinEmail += edcHandler.userDetails.referreremail;
		}

		if (edcHandler.loggedinUser !== '' && edcHandler.loggedinUser.match(edcHandler.usernamereg)) {
			edcHandler.isCvEmp = false;
			$('#togglecustView').hide();
		}
		$("#content").unmask();
	}, function() {
		$("#content").unmask();
	});

};

edcHandler.getSPList = function() {
	$("#content").mask("");
	cvUtil.loadPageWithGET(cvUtil.getContextPath() + "/server/getSPListForStaging.do", {}, function(resp) {
		//console.log(resp);
		if (resp.data.isErrorResponse) {
			cvUtil.errorToast(resp.data.errorMessage);
		} else {
			edcHandler.spList = resp.data.splist;
			//remove 11 from dropdown.
			$("#stgVersion option[value='11']").remove();
			for (var i = 0; i < edcHandler.spList.length; i++) {
				$('#stgVersion').append($('<option>', {
					value : edcHandler.spList[i],
					text : edcHandler.spList[i]
				}));
			}
		}
		$("#content").unmask();
	}, function() {
		$("#content").unmask();
	});

};

$(document)
		.ready(function() {
			edcHandler.getUserDetails();
			if (edcHandler.app === edcHandler.appsList.stage) {
				edcHandler.getSPList();
			}
			if (edcHandler.app === edcHandler.appsList.hyperscaletrial) {
				edcHandler.hyperscaleTrialOptionsEvent();
			}

			$("#edctabs").tabs();

			var isCompressedFile = false;
			var tempAccRefId = '';

			$(':file').on('fileselect',
					function(event, numFiles, label) {

						var input = $(this).parents('.input-group').find(':text'), log = numFiles > 1 ? numFiles +
								' files selected' : label;

						if (input.length) {
							input.val(log);
						} else {
							if (log) {
								alert(log);
							}
						}

					});

			uploadDataToDisk();

			window.onbeforeunload = function() {
				if (requestsUploadFile && requestsUploadFile.isUploadsInProgress()) {
					return "";
				}
			};

			$('.uploadForm, .formHyper, .sdtForm').submit(function(e) {
				var form = $(this);
				var reqType = "";
				var isFormValid = false;
				if (edcHandler.app === edcHandler.appsList.sdt) {
					isFormValid = edcHandler.sdt.view.validateForm();
				} else if (edcHandler.app === edcHandler.appsList.hyperscaletrial) {
					isFormValid = edcHandler.validateHyperScaleTrialFileds();
				} else {
					isFormValid = validateForm(form);
				}
				if (isFormValid) {
					var files = [];
					form.find("input[type=file]").each(function(i) {
						if ($.trim(this.value) != '') {
							files.push(this.files[0]);
						}
					});
					reqType = form.find('#reqTyp').val();

					$(".unsupported").hide();

					//create cloud request id
					createCloudRequest(form, files, reqType);

					return false;
				} else {
					return false;
				}
			});

			$('select').change(function() {
				var csVer = this.value;
				if (csVer) {
					if ($(this).attr('id') == 'brandVersion') {
						$(this).closest('.uploadForm').find('#reqTyp').val('V' + csVer + ' Branding');
					} else if ($(this).attr('id') == 'ccmVersion') {
						$(this).closest('.uploadForm').find('#reqTyp').val('V' + csVer + ' CommCell Migration');
					} else {
						var sp = csVer.split(" ");
						if (sp.length > 1) {
							csVer = sp[0];
						}
						$(this).closest('.uploadForm').find('#reqTyp').val('V' + csVer + ' CommServe Staging');
					}
				} else {
					$(this).val('');
				}
			});

			$('#cvPlatforms')
					.change(function() {
						var selPlatform = this.value;
						if (!selPlatform) {
							$('#dwldLink').hide();
						} else if (selPlatform == 'Linux_x86') {
							$('#dwldLink').show();
							$('#dwldLink')
									.attr("href",
											'https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1923%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A2101%2C%22id%22%3A5%2C%22downloadType%22%3A%7B%22name%22%3A%22Script%22%7D%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%7D%5D%7D');
							$('#dwldLink').html('Linux Scripts');
						} else if (selPlatform == 'Linux_x86_64') {
							$('#dwldLink').show();
							$('#dwldLink')
									.attr("href",
											'https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1924%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A2102%2C%22id%22%3A6%2C%22downloadType%22%3A%7B%22name%22%3A%22Script%22%7D%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%7D%5D%7D');
							$('#dwldLink').text('Linux Scripts');
						} else if (selPlatform == 'AIX_ppc') {
							$('#dwldLink').show();
							$('#dwldLink')
									.attr("href",
											'https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1921%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A2099%2C%22id%22%3A3%2C%22downloadType%22%3A%7B%22name%22%3A%22Script%22%7D%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%7D%5D%7D');
							$('#dwldLink').text('AIX Scripts');
						} else if (selPlatform == 'Solaris_sparc') {
							$('#dwldLink').show();
							$('#dwldLink')
									.attr("href",
											'https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1925%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A2103%2C%22id%22%3A21%2C%22downloadType%22%3A%7B%22name%22%3A%22Script%22%7D%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%7D%5D%7D');
							$('#dwldLink').text('Solaris Scripts');
						} else if (selPlatform == 'Solaris_x86') {
							$('#dwldLink').show();
							$('#dwldLink')
									.attr("href",
											'https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1927%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A2105%2C%22id%22%3A20%2C%22downloadType%22%3A%7B%22name%22%3A%22Script%22%7D%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%7D%5D%7D');
							$('#dwldLink').text('Solaris Scripts');
						} else if (selPlatform == 'HP-UX_ia') {
							$('#dwldLink').show();
							$('#dwldLink')
									.attr("href",
											'https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1922%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A2100%2C%22id%22%3A17%2C%22downloadType%22%3A%7B%22name%22%3A%22Script%22%7D%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%7D%5D%7D');
							$('#dwldLink').text('HP-UX Scripts');
						}
					});

			$('.recToggle').click(function() {
				$(this).siblings('.toggleText').toggle();
				if ($(this).find('span').hasClass("toggledown")) {
					$(this).find('span').removeClass("toggledown").addClass("toggleup");
				} else {
					$(this).find('span').removeClass("toggleup").addClass("toggledown");
				}
			});

			$('.gotoTab').click(function() {
				var tabId = $(this).attr('tabid');
				tabId = '#tabs-' + tabId;
				$("#edctabs").tabs("select", tabId);
			});

			$("#edctabs").bind('tabsselect', function(event, ui) {
				window.location.href = ui.tab;
			});

			$('.target_Upl').click(function() {
				var originalContent;
				if (!edcHandler.isCvEmp) {
					$(this).next('.uploadDiv').children().find('.custView').each(function(e) {
						$(this).hide();
					});
				}
				$(this).hide();
				$(this).next('.uploadDiv').show();
				event.preventDefault();
			});

			/*
			 * $('.changeTab').bind("click", function(e){ console.log(e); $(e.target).attr("tabid") $(); });
			 */

			$('.target_createAcc').click(function() {
				var originalContent;
				var refId = $(this).attr('id');
				var openD = true;
				if (refId == 'edc') {
					$("#custacctype option[value='EDC'").prop("selected", true);
				} else if (refId == 'sys') {
					$("#custacctype option[value='SYS'").prop("selected", true);
				} else if (refId == 'sitesurvey') {
					$("#custacctype option[value='SYSCRAWL'").prop("selected", true);
				} else {
					openD = false;
					cvUtil.errorToast("Unknown account type, please check with administrator.");
				}
				if (openD) {
					$('#createAcc').dialog({
						modal : true,
						width : 500,
						height : "auto",
						open : function(event, ui) {
							originalContent = $("#createAcc").html();
						},
						close : function(event, ui) {
							$("#createAcc").html(originalContent);
						}
					});
					bindEDCCreateAccount();
				}
			});

			$('.AddFiles')
					.click(function(e) {
						var numFilesLimit = 5;
						if ($(this).closest('.uploadDiv').attr('id') == "uplContentSys") {
							numFilesLimit = 10;
						}

						if ($(this).closest('.uploadDiv').find('input[type=file]').length < numFilesLimit) {
							if ($(this).closest('.uploadDiv').attr('id') == "uplContentCi") {
								var numFiles = $('#uplContentCi input[type=file]').length;
								$(this)
										.closest('tr')
										.prev()
										.children('td')
										.children('table.addFilesTbl')
										.append('<tr><td><input name="inpFileCI" type="file" id="inpFileCI" class="edc-filedata"/></td><td id="prvwBusy' +
												numFiles +
												'"><img id="prvwBusy" class="prvwBusy" src="../edc/img/spinner.gif" alt="busy" style="display:none"></td></tr>');
							} else if ($(this).closest('.uploadDiv').attr('id') == "uplContentCcm") {
								var numSrc = $('#uplContentCcm input[id=ccmsrcFile]').length;
								if (numSrc < 4) {
									$(this)
											.closest('tr')
											.prev()
											.children('td')
											.children('table.addFilesTbl')
											.append('<tr><td><input name="ccmsrcFile" type="file" id="ccmsrcFile" class="edc-filedata" /></td></tr>');

								}
								if (numSrc === 3) {
									$(this).addClass('disabled');
								}
							} else {
								$(this)
										.closest('tr')
										.prev()
										.children('td')
										.children('table.addFilesTbl')
										.append('<tr><td><input name="inpFileSys" type="file" id="inpFileSys" class="edc-filedata" /></td></tr>');
							}
							return false;
						} else {
							$(this).closest('.uploadDiv').siblings(".uploadMsg")
									.removeClass("cloudalert cloudalert-error cloudalert-success")
									.addClass("cloudalert cloudalert-error").html('Maximum file upload limit reached.');
							return false;
						}
					});

			$('.uploadNowBtn').click(function() {
				//var formId = $(this).parent().prev('.uploadForm').attr('id');
				//alert(formId);
				$(this).parent().prev('.uploadForm').submit();
			});

			function getUniqueUsername() {
				var date = new Date();
				var components = [ date.getDate(), date.getSeconds(), date.getMilliseconds() ];
				return components.join("");
			}

			function checkEntityFilesSize(ext, size) {
				var compressedFiles = false;

				//7z|bz2|gz|tar|zip|zipx|rar|Z|cab|gif|jpe?g|png
				if (ext == '7z' || ext == 'bz2' || ext == 'gz' || ext == 'tar' || ext == 'zip' || ext == 'zipx' ||
						ext == 'rar' || ext == 'Z' || ext == 'cab') {
					isCompressedFile = true;
					if (size >= 1073741824) {
						return false;
					}
				} else {
					isCompressedFile = false;
					if (size >= 52428800) {
						return false;
					}

				}
				return true;
			}

			function ValidateField(tx) {
				var isProceed = true;
				if (tx.hasClass("NotifyEmail")) {
					var eml = tx.val();
					if (eml != null && eml.trim().length > 0) {
						var mails = eml.split(",");
						for (var i = 0; i < mails.length; i++) {
							if (!cvUtil.isEmailValid(mails[i])) {
								cvUtil.errorToast("Invalid email: " + encodeURIComponent(mails[i]));
								isProceed = false;
							}
						}
					}

				} else {
					var reg = new RegExp(tx.data("validation"));
					if (tx.val().trim() != '' && tx.val().trim().match(reg)) {
						isProceed = true;
					} else {
						isProceed = false;
					}
				}
				if (!isProceed) {
					tx.removeClass('input-success').addClass('input-error');
					tx.closest('.uploadDiv').siblings(".uploadMsg")
							.removeClass("cloudalert cloudalert-error cloudalert-success")
							.addClass("cloudalert cloudalert-error").html(tx[0].attributes['data-msg'].value);
					return false;
				} else {
					tx.removeClass('input-error').addClass('input-success');
					tx.closest('.uploadDiv').siblings(".uploadMsg").removeClass("cloudalert cloudalert-error").html('');
					return true;
				}
			}

			function ValidateVersion(tx) {
				var reg = '^[0-9]{1,2}(\\s{0,1}SP[0-9]{1,2}){0,1}$';
				if (tx.val() != '' && tx.val().match(reg)) {
					tx.removeClass('input-error').addClass('input-success');
					if (tx.closest('.uploadDiv').html() == '') {
						tx.closest('.uploadDiv').siblings(".uploadMsg").removeClass("cloudalert cloudalert-error")
								.html('');
					}
					return true;
				} else {
					tx.removeClass('input-success').addClass('input-error');
					tx.closest('.uploadDiv').siblings(".uploadMsg")
							.removeClass("cloudalert cloudalert-error cloudalert-success")
							.addClass("cloudalert cloudalert-error").html('Please choose the CommServe version.');
					return false;
				}
			}

			function validateForm(curForm) {
				//alert('validating form');
				var validName = false;
				var validFiles = false;
				var validVersion = true;
				curForm.find('.Company').each(function(e) {
					if (edcHandler.isCvEmp) {
						validName = ValidateField($(this));
					} else {
						validName = true;
					}

					if (!validName) {
						return false;
					}
				});
				if (!validName) {
					return false;
				}

				curForm.find('.NotifyEmail').each(function(e) {
					if (!ValidateField($(this))) {
						validVersion = false;
					}
				});
				if (!validVersion) {
					return false;
				}

				if (curForm.attr('id') == "uploadformBranding" || curForm.attr('id') == 'uploadformStg') {
					curForm.find('select').each(function(e) {
						validVersion = ValidateVersion($(this));
					});
				}

				if (validName && validVersion) {
					validFiles = validateFiles(curForm);
				}
				if (validFiles && validName && validVersion) {
					$('.uploadNowBtn').addClass('disabled');
					$('.uploadNowBtn').bind('click', false);
					//curForm.parent().find('img').show();

					return true;
				}

				return false;
			}
			function enableButton() {
				console.log('in enable button');
			}

			function updatePreviewStatus(previewStatus, curForm) {
				if (previewStatus != "") {
					var statusArray = previewStatus.split(";");
					for (i = 0; i < statusArray.length - 1; i++) {
						var busyCol = $("#" + "prvwBusy" + i);
						$("#" + "prvwBusy" + i).removeClass("prvwBusy");
						if (statusArray[i] != 'failed') {
							var innerHTML = '<a class="prvwLnk" target="_blank" href="' + window.location.protocol +
									'//' + window.location.host + cvUtil.getContextPath() + statusArray[i] +
									'"><img alt="success" src="../../cloud/edc/img/success-icon.png"></a>';
						} else {
							var innerHTML = '<img alt="preview failed" class="prvwFail" src="../../cloud/edc/img/error-icon.png">';
						}
						busyCol.html(innerHTML);
					}
				}
			}

			function getUniqueUsername() {
				var date = new Date();
				var components = [ date.getDate(), date.getSeconds(), date.getMilliseconds() ];
				return components.join("");
			}

			function uploadDataToDisk() {

				$("#surveyuploadform").click(function() {
					$("#uploadformMetrics").submit();
				});

				$("#uploadCi").click(function() {
					$("#uploadformCi").submit();
				});

				$("#uploadformMetrics,#uploadformCi")
						.ajaxForm({
							url : cvUtil.getContextPath() + '/edcdiskfileupload.do',
							dataType : 'json',
							uploadProgress : function(event, position, total, percentComplete) {
								var percentVal = percentComplete + '%';
								bar.width(percentVal)
								percent.html(percentVal);
							},
							beforeSubmit : function(arr, $form, options) {
								//alert('beforesend');
								if (validateForm($form)) {
									status.empty();
									var percentVal = '0%';
									bar.width(percentVal)
									percent.html(percentVal);
									$(".unsupported").hide();
									$(".progress").show();
									$("#content").mask("");
									return true;
								} else {
									return false;
								}
							},
							success : function(html, status, xhr, curForm) {
								var percentVal = '100%';
								bar.width(percentVal)
								percent.html(percentVal);
								var formId = curForm[0].id;
								$(".progress").hide();
								$("#content").unmask();
								curForm.parent().find('.uploadNowBtn').removeClass('disabled');
								curForm.parent().find('.uploadNowBtn').bind('click', true);
								var msg = "";
								if (html != '') {

									if (html.returnCode != 'Error') {
										if (html.message && html.message !== "") {
											msg = html.message;
										} else if (html.JID && html.JID.trim()) {
											//window.location.replace(window.location.protocol + '//' + window.location.host +
											//cvUtil.getContextPath() + '/' + html.URL);
											msg = "Thank you for your upload. You will receive an email along with the analysis report within 15 minutes."
										} else {
											msg = "Thank you for your upload. You will receive an email with the token number to track."
										}

										curForm.closest('.uploadDiv').siblings(".uploadMsg")
												.removeClass("cloudalert cloudalert-error cloudalert-error")
												.addClass("cloudalert cloudalert-success").html(msg);

									} else {
										if (html.message && html.message !== "") {
											msg = html.message;
										} else {
											msg = "We're sorry, something went wrong. Please try to upload again.";
										}
										curForm.closest('.uploadDiv').siblings(".uploadMsg")
												.removeClass("cloudalert cloudalert-error cloudalert-success")
												.addClass("cloudalert cloudalert-error").html(msg);
									}
									if (html.previewStatus && html.previewStatus.trim()) {
										updatePreviewStatus(html.previewStatus, $(this));
									}
								}
							},
							error : function(html, status, xhr, curForm) {
								$(".progress").hide();
								$("#content").unmask();
								curForm.closest('.uploadDiv').siblings(".uploadMsg")
										.removeClass("cloudalert cloudalert-error cloudalert-success")
										.addClass("cloudalert cloudalert-error")
										.html("We're sorry, something went wrong. Please try to upload again.");
								curForm.parent().find('.uploadNowBtn').removeClass('disabled');
								curForm.parent().find('.uploadNowBtn').bind('click', true);
							},
							complete : function(html, status, curForm) {
								$(".progress").hide();
								$("#content").unmask();
								if (html.responseText) {
									var retFlds = JSON.parse(html.responseText);

									if (status != 'error' && retFlds && retFlds.returnCode &&
											retFlds.returnCode != 'Error') {
										if (retFlds.message && retFlds.message !== "") {
											curForm.closest('.uploadDiv').siblings(".uploadMsg")
													.removeClass("cloudalert cloudalert-error cloudalert-error")
													.addClass("cloudalert cloudalert-success").html(retFlds.message);
										} else {
											curForm
													.closest('.uploadDiv')
													.siblings(".uploadMsg")
													.removeClass("cloudalert cloudalert-error cloudalert-error")
													.addClass("cloudalert cloudalert-success")
													.html("Thank you for your upload. You will receive an email with the token number to track.");
										}
										curForm.parent().find('.uploadNowBtn').removeClass('disabled');
										curForm.parent().find('.uploadNowBtn').bind('click', true);
									}
								} else {
									curForm.closest('.uploadDiv').siblings(".uploadMsg")
											.removeClass("cloudalert cloudalert-error cloudalert-success")
											.addClass("cloudalert cloudalert-error")
											.html("We're sorry, something went wrong. Please try to upload again.");
									curForm.parent().find('.uploadNowBtn').removeClass('disabled');
									curForm.parent().find('.uploadNowBtn').bind('click', true);
								}
							}
						});

			}

			function createCloudRequest(curForm, files, reqType) {

				var data = {};

				curForm.find(".edc-data").each(function(i) {
					data[$(this).attr("name")] = $(this).val();
				});
				if (edcHandler.app === edcHandler.appsList.sdt) {
					data.sdt = edcHandler.sdt.view.generateDataForCloudRequest();
				}
				data.reqId = parseInt(cvUtil.getParameter("requestId", cvUtil.getParameter("reqId", 0)));
				data["files"] = "";
				curForm.find(".edc-filedata").each(function(i) {
					var fileName = (this.value) ? (this.value) : (this.name);
					var farr = (fileName).split('\\');
					fileName = farr[(farr.length) - 1];
					data["files"] = fileName + "," + data["files"];
				});
				msg = "Creating request.";
				curForm.closest('.uploadDiv').siblings(".uploadMsg")
						.removeClass("cloudalert cloudalert-error cloudalert-error")
						.addClass("cloudalert cloudalert-success").html(msg);

				cvUtil
						.loadPageWithPOST(cvUtil.getContextPath() + '/createcloudrequest.do',
								data,
								function(data) {
									if (edcHandler.app === edcHandler.appsList.sdt) {
										edcHandler.sdt.controller.processCloudRequestResponse(data);
										return;
									}
									var formId = curForm[0].id;
									var msg = "";
									if (data != '') {
										data = cvUtil.parseJSON(data);
										if (data.returnCode != 'Error') {

											if (data.message && data.message !== "") {
												msg = data.message;
											} else if (data.JID && data.JID.trim()) {
												msg = "Thank you for your upload. You will receive an email along with the analysis report within 15 minutes."
											} else {
												msg = "Thank you for your upload. You will receive an email with the token number to track."
											}

											curForm.closest('.uploadDiv').siblings(".uploadMsg")
													.removeClass("cloudalert cloudalert-error cloudalert-error")
													.addClass("cloudalert cloudalert-success")
													.html("Uploading files(s) to cloud.");
											if (edcHandler.app === edcHandler.appsList.hyperscaletrial) {
												curForm
														.closest('.uploadDiv')
														.siblings(".uploadMsg")
														.html("Successfully created request. You will receive an email with the token number to track.");
											} else {

												intervalId = cvUtil.addTimerTask(cvUtil.isSessionAlive, 300000);
												requestsUtil.uploadDocuments(files,
														data.cloudReqID,
														reqType,
														intervalId,
														curForm,
														msg);
											}

										} else {
											$("#content").unmask();
											$('.uploadNowBtn').removeClass('disabled');
											$('.uploadNowBtn').bind('click', true);
											if (data.message && data.message !== "") {
												msg = data.message;
											} else {
												msg = "We're sorry, something went wrong. Please try to upload again.";
											}
											curForm.closest('.uploadDiv').siblings(".uploadMsg")
													.removeClass("cloudalert cloudalert-error cloudalert-success")
													.addClass("cloudalert cloudalert-error").html(msg);
										}
										if (data.previewStatus && data.previewStatus.trim()) {
											updatePreviewStatus(data.previewStatus, $(this));
										}
									}
								},
								function() {
									$("#content").unmask();
									curForm.closest('.uploadDiv').siblings(".uploadMsg")
											.removeClass("cloudalert cloudalert-error cloudalert-success")
											.addClass("cloudalert cloudalert-error")
											.html("We're sorry, something went wrong. Please try to upload again.");
									$('.uploadNowBtn').removeClass('disabled');
									$('.uploadNowBtn').bind('click', true);
								});
			}

			function validateFiles(curForm) {
				var isfiletypesupported = true;
				var isfilesizelarge = false;
				var fileName;
				var missingFiles = 0;

				var curFormId = curForm.attr('id');
				var sel = '#' + curFormId + ' input[type=file]';
				var supportedFileTypes = '';
				var fileExtName = [];
				var selectedFiles;
				if (curFormId == 'uploadformMetrics') {
					selectedFiles = $(sel)[0].files;
				} else {
					selectedFiles = $(sel).filter(function() {
						return $.trim(this.value) != '';
					});
				}

				for (var i = 0; i < selectedFiles.length; i++) {
					var fileName;
					if ($.browser.msie) {
						fileName = (selectedFiles[i].value) ? selectedFiles[i].value : selectedFiles[i].name;
						farr = (fileName).split('\\');
						fileName = farr[(farr.length) - 1];
					} else {
						fileName = selectedFiles[i].value ? selectedFiles[i].value : selectedFiles[i].name;
						size = selectedFiles[i].size;
					}

					extarr = (fileName).split('.');
					ext = extarr[(extarr.length) - 1];
					ext = ext.toLowerCase();
					if (curFormId == 'uploadformSnap') {
						supportedFileTypes = '(7z|bz2|gz|tar|zip|zipx|rar|Z|cab|xml)';
						switch (ext) {
						//7z|bz2|gz|tar|zip|zipx|rar|Z|cab|gif|jpe?g|png
						case '7z':
						case 'bz2':
						case 'gz':
						case 'tar':
						case 'zip':
						case 'zipx':
						case 'z':
						case 'cab':
						case 'rar':
						case 'xml':
							continue;
						default:
							fileExtName.push(ext);
							isfiletypesupported = false;
							break;
						}
					} else if (curFormId == 'uploadformBranding') {

						supportedFileTypes = '(7z|bz2|gz|tar|zip|zipx|rar|Z|cab)';
						switch (ext) {
						//7z|bz2|gz|tar|zip|zipx|rar|Z|cab|gif|jpe?g|png
						case '7z':
						case 'bz2':
						case 'gz':
						case 'tar':
						case 'zip':
						case 'zipx':
						case 'z':
						case 'cab':
						case 'rar':
							continue;
						default:
							fileExtName.push(ext);
							isfiletypesupported = false;
							break;
						}
					} else if (curFormId == 'uploadformCi' || curFormId == 'uploadformEnty') {

						supportedFileTypes = '(exe|msi|dmp)';
						switch (ext) {
						//7z|bz2|gz|tar|zip|zipx|rar|Z|cab|gif|jpe?g|png
						case 'exe':
						case 'msi':
						case 'dmp':
							fileExtName.push(ext);
							isfiletypesupported = false;
							break;
						default:
							if (curFormId == 'uploadformEnty') {
								if (!checkEntityFilesSize(ext, size)) {
									isfilesizelarge = true;
									break;
								}
							} else {
								continue;
							}
						}
					} else if (curFormId == 'uploadformMetrics') {

						supportedFileTypes = '(xml|csv|zip)';
						switch (ext) {
						//7z|bz2|gz|tar|zip|zipx|rar|Z|cab|gif|jpe?g|png
						case 'xml':
						case 'csv':
						case 'zip':
							continue;
						default:
							if ($.inArray(ext, fileExtName) === -1) {
								fileExtName.push(ext);
							}
							isfiletypesupported = false;
							break;
						}
					} else {
						supportedFileTypes = '(7z|bz2|gz|tar|zip|zipx|rar|Z|cab|dmp)';
						switch (ext) {
						//7z|bz2|gz|tar|zip|zipx|rar|Z|cab|gif|jpe?g|png
						case '7z':
						case 'bz2':
						case 'gz':
						case 'tar':
						case 'zip':
						case 'zipx':
						case 'z':
						case 'cab':
						case 'rar':
						case 'dmp':
							continue;
						default:
							fileExtName.push(ext);
							isfiletypesupported = false;
							break;
						}
					}
				}
				if (selectedFiles.length == 0) {
					curForm.closest('.uploadDiv').siblings(".uploadMsg")
							.removeClass("cloudalert cloudalert-error cloudalert-success")
							.addClass("cloudalert cloudalert-error").html('Please select atleast one file.');
					return false;
				} else if (isfilesizelarge) {
					if (isCompressedFile) {
						curForm.closest('.uploadDiv').siblings(".uploadMsg")
								.removeClass("cloudalert cloudalert-error cloudalert-success")
								.addClass("cloudalert cloudalert-error")
								.html('Please provide compressed file less than 1GB in size.');
					} else {
						curForm.closest('.uploadDiv').siblings(".uploadMsg")
								.removeClass("cloudalert cloudalert-error cloudalert-success")
								.addClass("cloudalert cloudalert-error").html('Please provide file upto 50MB in size.');
					}
					return false;
				}

				if (isfiletypesupported) {
					curForm.closest('.uploadDiv').siblings(".uploadMsg")
							.removeClass("cloudalert cloudalert-error cloudalert-success").html('');
					return true;
				} else {
					curForm.closest('.uploadDiv').siblings(".uploadMsg")
							.removeClass("cloudalert cloudalert-error cloudalert-success")
							.addClass("cloudalert cloudalert-error").html('Unsupported File Types: ' +
									fileExtName.join(", ") + '. Supported File Types: ' + supportedFileTypes);
					return false;
				}
			}
			var datatype = 'text';
			if (!$.browser.msie) {
				datatype = 'json';
			}
			var bar = $('.bar');
			var percent = $('.percent');
			var status = $('#status');

			/*
			 * $('.uploadForm') .ajaxForm({ url : cvUtil.getContextPath() + '/uploadedcfiles.do', dataType :
			 * 'json', beforeSubmit : function(arr, $form, options) { //alert('beforesend'); if
			 * (validateForm($form)) { status.empty(); var percentVal = '0%'; bar.width(percentVal)
			 * percent.html(percentVal); $(".unsupported").hide(); $(".progress").show();
			 * $("#content").mask(""); $(".prvwBusy").show(); return true; } else { return false; } },
			 * uploadProgress : function(event, position, total, percentComplete) { var percentVal =
			 * percentComplete + '%'; bar.width(percentVal) percent.html(percentVal); }, success :
			 * function(html, status, xhr, curForm) { var percentVal = '100%'; bar.width(percentVal)
			 * percent.html(percentVal); var formId = curForm[0].id; $(".progress").hide();
			 * $("#content").unmask(); curForm.parent().find('.uploadNowBtn').removeClass('disabled');
			 * curForm.parent().find('.uploadNowBtn').bind('click', true); var msg = ""; if (html != '') {
			 * 
			 * if (html.returnCode != 'Error') { if (html.message && html.message !== "") { msg =
			 * html.message; } else if (html.JID && html.JID.trim()) {
			 * //window.location.replace(window.location.protocol + '//' + window.location.host +
			 * //cvUtil.getContextPath() + '/' + html.URL); msg = "Thank you for your upload. You will receive
			 * an email along with the analysis report within 15 minutes." } else { msg = "Thank you for your
			 * upload. You will receive an email with the token number to track." }
			 * 
			 * curForm.closest('.uploadDiv').siblings(".uploadMsg") .removeClass("cloudalert cloudalert-error
			 * cloudalert-error") .addClass("cloudalert cloudalert-success").html(msg); } else { if
			 * (html.message && html.message !== "") { msg = html.message; } else { msg = "We're sorry,
			 * something went wrong. Please try to upload again."; }
			 * curForm.closest('.uploadDiv').siblings(".uploadMsg") .removeClass("cloudalert cloudalert-error
			 * cloudalert-success") .addClass("cloudalert cloudalert-error").html(msg); } if
			 * (html.previewStatus && html.previewStatus.trim()) { updatePreviewStatus(html.previewStatus,
			 * $(this)); } } }, error : function(html, status, xhr, curForm) { $(".progress").hide();
			 * $("#content").unmask(); curForm.closest('.uploadDiv').siblings(".uploadMsg")
			 * .removeClass("cloudalert cloudalert-error cloudalert-success") .addClass("cloudalert
			 * cloudalert-error") .html("We're sorry, something went wrong. Please try to upload again.");
			 * curForm.parent().find('.uploadNowBtn').removeClass('disabled');
			 * curForm.parent().find('.uploadNowBtn').bind('click', true); }, complete : function(html,
			 * status, curForm) { $(".progress").hide(); $("#content").unmask(); if (html.responseText) { var
			 * retFlds = JSON.parse(html.responseText);
			 * 
			 * if (status != 'error' && retFlds && retFlds.returnCode && retFlds.returnCode != 'Error') { if
			 * (retFlds.message && retFlds.message !== "") {
			 * curForm.closest('.uploadDiv').siblings(".uploadMsg") .removeClass("cloudalert cloudalert-error
			 * cloudalert-error") .addClass("cloudalert cloudalert-success").html(retFlds.message); } else {
			 * curForm .closest('.uploadDiv') .siblings(".uploadMsg") .removeClass("cloudalert
			 * cloudalert-error cloudalert-error") .addClass("cloudalert cloudalert-success") .html("Thank you
			 * for your upload. You will receive an email with the token number to track."); }
			 * curForm.parent().find('.uploadNowBtn').removeClass('disabled');
			 * curForm.parent().find('.uploadNowBtn').bind('click', true); } } else {
			 * curForm.closest('.uploadDiv').siblings(".uploadMsg") .removeClass("cloudalert cloudalert-error
			 * cloudalert-success") .addClass("cloudalert cloudalert-error") .html("We're sorry, something
			 * went wrong. Please try to upload again.");
			 * curForm.parent().find('.uploadNowBtn').removeClass('disabled');
			 * curForm.parent().find('.uploadNowBtn').bind('click', true); } } });
			 */
		});
function isEmailValid(e) {
	return cvUtil.isEmailValid(e);
}
function bindEDCCreateAccount() {
	$('#createAccBtn').off();
	$('#createAccBtn').on('click',
			function() {
				var data = {};
				var go = true;
				$('#createAccForm .accinpdiv .accinp').each(function() {
					var v = $(this).data("validation");
					var vtyp = $(this).data("vtype");
					if (typeof vtyp !== "undefined" && vtyp === "function") {
						var req = $(this).data("required");
						var val = $(this).val();
						if (typeof req !== "undefined" && val.trim() === "" && req === false) {
							return true;
						}
						if (!window[v](val)) {
							$(".createAccMsg").removeClass("cloudalert cloudalert-error cloudalert-success")
									.addClass("cloudalert cloudalert-error").html($(this).data("msg"));
							go = false;
							return false;
						}
					} else if (v) {
						var regex = new RegExp(v);
						if (!$(this).val().match(regex)) {
							$(".createAccMsg").removeClass("cloudalert cloudalert-error cloudalert-success")
									.addClass("cloudalert cloudalert-error").html($(this).data("msg"));
							go = false;
							return false;
						}
					}
					data[$(this).data("pname")] = $(this).val();
				});

				if (!go) {
					return false;
				}
				$(".createAccMsg").removeClass("cloudalert cloudalert-error").html('');
				$('#createBusy').show();
				$(this).addClass("hideel");
				cvUtil.loadPage(cvUtil.getContextPath() + '/server/createedcsysacc', data, function(data) {
					if (typeof data.error === "undefined") {
						if (data.workflowresponse.response.errorCode === 0) {
							$('#createAcc').dialog('close');
							$('#createAccResp').dialog({
								modal : true,
								width : 400
							});
						} else {
							alert(data.workflowresponse.response.errorMessage);
							$('#createBusy').hide();
							$("#createAccBtn").removeClass("hideel");
						}
					} else {
						alert(data.error);
						$('#createBusy').hide();
						$("#createAccBtn").removeClass("hideel");
					}
				});
			});
}
