var edcExportServices = edcExportServices || {
	EXPORT_TYPE_PPT : 'customppt',
	EXPORT_TYPE_CUSTOM_DOC : 'customdoc',
	EXPORT_TYPE_CSV : "csv"
};

edcExportServices.getSubscriptionId = function() {
	return window.sessionStorage.getItem("export_subscriptionID");
}
edcExportServices.exportLocalDoc = function(guid, filePrefix, localdataguid) {

	var subscriptionId = edcExportServices.getSubscriptionId();

	var expLink = "directDownload=false&exportType=" + edcExportServices.EXPORT_TYPE_CUSTOM_DOC + "&documentGUID=" +
			guid + "&subscriptionID=" + subscriptionId + "&filePrefix=" + filePrefix + "&localdataguid=" +
			localdataguid;

	var csExportURL = parent.cvUtil.getContextPath() + '/reports/exp.do?' + expLink;
	cvUtil.getTopWindow().cvUtil.loadPageWithPOST(csExportURL, "");

};
edcExportServices.exportLocalPpt = function(guid, filePrefix, localdataguid) {

	var subscriptionId = edcExportServices.getSubscriptionId();

	var expLink = "directDownload=false&exportType=" + edcExportServices.EXPORT_TYPE_PPT + "&documentGUID=" + guid +
			"&subscriptionID=" + subscriptionId + "&filePrefix=" + filePrefix + "&localdataguid=" + localdataguid;

	var csExportURL = parent.cvUtil.getContextPath() + '/reports/exp.do?' + expLink;
	cvUtil.getTopWindow().cvUtil.loadPageWithPOST(csExportURL, "");

};
edcExportServices.exportToCSV = function(data, filePrefix, app) {
	var subscriptionId = edcExportServices.getSubscriptionId();
	var d = {};
	d.csvData = JSON.stringify(data);
	var expLink = "directDownload=true&exportType=" + edcExportServices.EXPORT_TYPE_CSV + "&app=" + app +
			"&subscriptionID=" + subscriptionId + "&filePrefix=" + filePrefix;

	var csExportURL = parent.cvUtil.getContextPath() + '/edcexport.do?' + expLink;
	cvUtil.getTopWindow().cvUtil.loadPageWithPOST(csExportURL, d, edcExportServices.afterExportToCSV);

};
edcExportServices.afterExportToCSV = function(serverData) {
	if (serverData.data) {
		if (serverData.data.fileName) {
			edcExportServices.downloadFile(serverData.data.fileName);
		}
	}
}
edcExportServices.downloadFile = function(fileName) {
	var finalLink = cvUtil.getContextPath() + "/reportsplus/downloadTableCsv.do?type=report&fileName=" +
			window.encodeURIComponent(fileName);
	var iframeId = "iframe" + Date.now();
	var iframeDOM = document.createElement("iframe");
	iframeDOM.setAttribute("style", "display:none;");
	iframeDOM.id = iframeId;
	document.body.appendChild(iframeDOM);
	iframeDOM.src = finalLink;
}
//overwrite downloadUnclaimedExportFiles function defined in reportsBase.js, we dont need now.
function downloadUnclaimedExportFiles() {
	return;
}