$(document)
		.ready(function() {
			var sitesArr = new Array();
			var numsites = 1;
			var numreplSites = 1;
			//var trd_opTbl = "<thead><tr><th>Years</th><th>Storage(TB)</th><th>Small Media Agents</th><th>Medium Media Agents</th><th>Large Media Agents</th><th>XL Media Agents</th></tr></thead><tbody><tr><td></td><td></td><td></td><td></td><td></td></tr></tbody>";
			var trd_opTbl = "<thead><tr><th>Years</th><th>Storage(TB)</th><th>Large Media Agents</th><th>XL Media Agents</th></tr></thead><tbody><tr><td></td><td></td><td></td><td></td><td></td></tr></tbody>";
			var hs_opTbl = "<thead><tr><th>Years</th><th>Storage(TB)</th><th>HS1300</th><th>HS3300</th></tr></thead><tbody><tr><td></td><td></td></tr></tbody>";
			var robo_opTbl = "<thead><tr><th>Years</th><th>Storage(TB)</th><th>RO1200</th></tr></thead><tbody><tr><td></td></tr></tbody>";
			var hra_opTbl = "<thead><tr><th>Years</th><th>Storage(TB)</th><th>Reference Architecture count</th></tr></thead><tbody><tr><td></td></tr></tbody>";
			var hrax_opTbl = "<thead><tr><th>Years</th><th>Storage(TB)</th><th>Hyperscale X Reference Architecture Nodes</th></tr></thead><tbody><tr><td></td></tr></tbody>";
			var hsax_opTbl = "<thead><tr><th>Years</th><th>Storage(TB)</th><th>HSXMODEL Nodes</th></tr></thead><tbody><tr><td></td></tr></tbody>";

			$('#temp').show();
			$('.erMsg').text(''); //set empty error msg
			loadSite();

			$("#submitBtn").on("click", function(event) {
				$('input[type=hidden]').attr('value', 'calculate');
				$('#betRequestForm').submit();
			});

			$("#importCsvButton").on("click", function(evt) {

				$("#browseImportFile").click();
			});

			$("#browseImportFile").on("change", function() {
				$("#content").mask("");

				uploadDataToDisk();
			});

			function uploadDataToDisk() {
				$("#importCsv").submit();

			}

			function validateImportFiles(curForm) {
				var fileName = curForm.find("input:file").val(); //$("#browseImportFile").val();
				if (($("#browseImportFile")[0].files[0].size == 0) ||
						(fileName.substr((fileName.lastIndexOf('.') + 1)).toLowerCase() != "csv")) {

					return false;
				}
				return true;

			}
			function getReqIDfromUrl() {
				return parseInt(cvUtil.getParameter("requestId", 0));
			}
			$("#importCsv")
					.ajaxForm({
						url : cvUtil.getContextPath() + '/edcdiskfileupload.do',
						dataType : 'json',
						beforeSubmit : function(arr, $form, options) {

							if (validateImportFiles($form)) {
								return true;
							} else {
								cvUtil.errorToast("Invalid file to import. Please select a valid csv file.");
								$("#content").unmask();
								return false;
							}
						},
						success : function(data) {

							$("#content").unmask();
							$('.uploadNowBtn').removeClass('disabled');
							$('.uploadNowBtn').bind('click', true);
							var msg = "";
							var fileName = "";
							if (data != '') {
								if (data.returnCode != 'Error') {
									if (data.fields && data.fields !== "") {
										populateDatafields(data.fields);

									} else {
										msg = "Thank you for your upload. You will receive an email with the token number to track."
									}

								} else {
									if (data.message && data.message !== "") {
										msg = data.message;
									} else {
										msg = "We're sorry, something went wrong. Please try to upload again.";
									}

								}

							}
						},
						error : function(html, status, xhr, curForm) {
							console.log("in error");
						},
						complete : function(html, status, curForm) {
							console.log("in complete");
						}
					});

			//load import csv data on page
			function populateDatafields(fields) {
				console.log(fields);

				if (fields.length > 0) {

					$.each(fields, function(k, v) {

						var replSitesArr, replPercArr = [];

						if (k > 0) {
							//add another site before loading data
							$('.addSiteBtn').click();
						}
						$.each(v, function(key, value) {
							console.log(key, value);

							if (key == 'hrd_Type') //load hardware type
							{
								$("#inpDetails" + (k + 1)).find("input[type='radio'][value='" + value + "']")
										.prop("checked", true).change();
							} else if (key == 'replicationPercents') {
								value = "" + value;
								replPercArr = value.split(",");

							} else if (key == 'replicationSites') {
								value = "" + value;
								replSitesArr = value.split(",");

							} else {
								$("#inpDetails" + (k + 1)).find(".bet-data[name='" + key + "']").val(value);
								if (key == 'siteName') {
									$("#siteName" + (k + 1)).change();
								}
							}
						});

						if (replSitesArr.length > 0 && replPercArr.length > 0) {
							//load details incase of pne repl site
							$("#replSite" + (k + 1) + (1)).val(replSitesArr[0]).attr("selected", "selected");
							$("#inpDetails" + (k + 1)).find(".bet-data[name='replicationPercents']:visible")
									.val(replPercArr[0]);

							//add repl site if there are more than 1
							for (var len = 1; len < replSitesArr.length; len++) {
								$(".addreplSiteBtn").click();
								$("#replSite" + (k + 1) + (len + 1)).val('"' + replSitesArr[len] + '"');
								$("#inpDetails" + (k + 1)).find("[id='replSite" + (k + 1) + (len + 1) + "']:visible")
										.val(replPercArr[len]);
							}
						}

					});
				}
			}

			$("#inpDetails").on('change', 'select', function() {
				var replSite = this.value;
				if (replSite != "-1") {
					console.log(replSite);
				} else {
					//$(this).val('');
				}

			});

			//Toggle assumptions
			$('.toggleHeading').click(function() {
				$(this).siblings('.toggleText').toggle();
				if ($(this).siblings('.ui-corner-all').find('span').hasClass("ui-icon-minusthick")) {
					$(this).siblings('.ui-corner-all').find('span').removeClass("ui-icon-minusthick")
							.addClass("ui-icon-plusthick");
				} else {
					$(this).siblings('.ui-corner-all').find('span').removeClass("ui-icon-plusthick")
							.addClass("ui-icon-minusthick");
				}
			});

			$(document).on("blur", ".yrs_to_model", function() {

			});

			$(document).on("change", ".ret_Dgap", function() {

			});

			$(document).on("change", ".siteName", function() {
				console.log($(this).val());
				var cursiteName = $(this).val();
				var cursiteID = $(this).attr('id').replace(/[a-zA-Z]/g, "");
				sitesArr[cursiteID] = cursiteName;
				if ($("#replSiteTempTemp").find('[value="' + cursiteID + '"]').length == 0) {
					$("#replSiteTempTemp").append(new Option(cursiteName, cursiteID));
				} else {
					$("#replSiteTempTemp").find('[value="' + cursiteID + '"]').text(cursiteName);
				}

				var opts = $("#replSiteTempTemp").html();
				//traverse through all dropdowns and set the options
				$(document).find("select[name^='replicationSites']:visible").each(function(i) {
					$(this).html(opts);
					var thissiteID = $(this).closest(".vw-comp-tile").attr('id').replace(/[a-zA-Z]/g, "");
					$(this).find('[value="' + thissiteID + '"]').remove();

				});

				var ret_val = validateField($(this));
				var txId = $(this).attr("id");
				var errMsgLbl = $("label.error[for=" + txId + "]");
				if (!ret_val) {
					errMsgLbl.html($(this).data("msg"));
				} else {
					errMsgLbl.html("&nbsp;");
				}
				$(this).closest('.inpCol').siblings('.opCol').find('.betH4').text("Storage for " + cursiteName);

			});

			$(document).on("click", ".customSelection, .replPerc ", function() {
				$(this).closest('.replSites').siblings('.erMsg').text("");

			});

			$(document).on("click",
					".addreplSiteBtn",
					function() {
						//add replications within each site
						var siteName = $(this).parent().find("input[name='siteName']").val();
						var siteID = $(this).parent().find("input[name='siteName']").attr('id')
								.replace(/[a-zA-Z]/g, "");
						$(this).siblings('.erMsg').text("");
						var tempnumreplSites = $('#holder' + siteID).find(".replInfo").length;
						tempnumreplSites++;
						var validReplSite = true;
						var validReplPerc = true;
						var temp = "".concat(siteID, tempnumreplSites);

						$(this).parent().find("select[name^='replicationSites']:visible").each(function(i) {
							if (this.value == '-1' && this.length > 1)////&& $(this).parent().find("input[name='replPerc']:visible").val()){
							{
								validReplSite = false;
								$('#holder' + siteID).find(".erMsg").html('<span class="sprite icon-x"></span> '
										+ "Please select replication site.");
							} else if (this.length <= 1) {
								validReplSite = false;
								$('#holder' + siteID).find(".erMsg").html('<span class="sprite icon-x"></span> '
										+ "Please add another site before adding replication site.");
							}
						});
						$(this).parent().find("input[name^='replicationPercents']:visible").each(function(i) {
							if ($.trim(this.value) == '')////&& $(this).parent().find("input[name='replPerc']:visible").val()){
							{
								validReplPerc = false;
								$('#holder' + siteID).find(".erMsg").html('<span class="sprite icon-x"></span> '
										+ "Please provide replication percentage.");
							}
						});
						if (!siteName) {
							$('#holder' + siteID).find(".erMsg").html('<span class="sprite icon-x"></span> '
									+ "Please provide valid site name.");
						}
						if (siteName && validReplPerc && validReplSite) {

							var htmlText = $("#replTempTemp").html();
							var newOpts = $("#replSite" + siteID + "1").html();
							//console.log(htmlText);
							$(this).siblings(".replSites")
									.append("<div class=\"row replInfo vw-form-horizontal\" id=\"repl" + temp + "\">" +
											htmlText.replace(/TempTemp/g, temp) + "</div>");

							$("#repl" + temp).show();
							$("#replSite" + temp).html(newOpts);
						}
					});

			function loadSite() {
				loadDefaultSite("1", "1");
				var reqId = getReqIDfromUrl();
				if (reqId != 0) {
					loadSiteFromRequest(reqId);
				}
			}
			function loadSiteFromData(data) {
				console.log(data);
				if (data.data && data.data.betInput) {
					if (typeof data.data.betInput === "string") {
						data.data.betInput = JSON.parse(data.data.betInput);
						data.data.betInput = data.data.betInput.value;
						if (!$.isArray(data.data.betInput.siteInfo)) {
							var arr = [];
							arr.push(data.data.betInput.siteInfo);
							data.data.betInput.siteInfo = arr;
						}
					}
					populateDatafields(data.data.betInput.siteInfo);
				} else {
					cvUtil.errorToast("Unable to get data from sever, please talk to admin.");
				}

			}

			function loadSiteFromRequest(reqId) {
				var d = {}
				d.requestId = reqId;
				d.type = "BET Prediction";
				cvUtil.loadPageWithPOST(cvUtil.getContextPath() + '/getCloudRequestData.do', d, loadSiteFromData);
			}

			function loadDefaultSite(numsites, numreplSites) {

				var htmlreplText = $("#replTempTemp").html();
				var htmlRowText = $("#holderTemp").html();
				var temp = "".concat(numsites, numreplSites);
				$("#betRequestForm").append("<div id=\"holder" + numsites +
						"\" class=\"vw-loading-area col-sm-12 row-eq-height\">" +
						htmlRowText.replace(/Temp/g, numsites) + "</div>");
				$('#holder' + numsites).find("div[class=replSites]")
						.append("<div class=\"row replInfo vw-form-horizontal\" id=\"repl" + temp + "\">" +
								htmlreplText.replace(/TempTemp/g, temp) + "</div>");

				$('#holder' + numsites).find("input[id^='hrd_Trd']").prop("checked", true);
				resultsTbl_Handler($('#inpDetails' + numsites), "trd");
				return true;
			}

			$(document).on("click", "#toggleBtn", function() {
				$('.toggleHeading').click();
			});

			$(document).on("change", ".bet-data:visible", function() {
				var ret_val = validateField($(this));
				var txId = $(this).attr("id");
				var errMsgLbl = $("label.error[for=" + txId + "]");
				if (!ret_val) {
					errMsgLbl.html($(this).data("msg"));
				} else {
					errMsgLbl.html("&nbsp;");
				}
			});

			// toggle the Hyperscale Ref Arch details
			// $("input[name^='hrd_Type']").click(function() {
			$(document).on("change", "input[name^='hrd_Type']", function() {
				var hrd_type = $(this).val();
				$(this).parent().parent().siblings('.hra_Details, .hsax_Details').hide();
				$(this).parent().parent().siblings("." + hrd_type + "_Details").show();

				//update the results according to hardware selection
				resultsTbl_Handler($(this), hrd_type);

			});
			$(document).on("change", "#hsxModels", function() {

				resultsTbl_Handler($(this), "hsax");

			});

			function resultsTbl_Handler(elem, hrd_type) {
				var tbl = elem.closest('.inpCol').siblings('.opCol').find('.vw-table-borderless').html();
				var opTbl;
				if (hrd_type == "trd") {
					//console.log("trd hrd");
					opTbl = elem.closest('.inpCol').siblings('.opCol').find('.vw-table-borderless');
					opTbl.html(trd_opTbl);
					opTbl.siblings('.hsDetails').html('').hide();
				} else if (hrd_type == "hs") {
					//console.log("hs hrd");
					opTbl = elem.closest('.inpCol').siblings('.opCol').find('.vw-table-borderless');
					opTbl.html(hs_opTbl);
					opTbl
							.siblings('.hsDetails')
							.html('<br/><p>*Please note that each server for HS1300 and HS3300 refers to a 3-node usable block.</p>')
							.hide();

				} else if (hrd_type == "hra") {
					//console.log("hra hrd");
					opTbl = elem.closest('.inpCol').siblings('.opCol').find('.vw-table-borderless');
					opTbl.html(hra_opTbl);
					opTbl
							.siblings('.hsDetails')
							.html('<br/><p>*Please note that each server for Reference Architecture refers to a 3-node usable block.</p>')
							.hide();

				} else if (hrd_type == "hrax") {

					opTbl = elem.closest('.inpCol').siblings('.opCol').find('.vw-table-borderless');
					opTbl.html(hrax_opTbl);
					opTbl.siblings('.hsDetails').html('<br/><p></p>').hide();
				} else if (hrd_type == "hsax") {
					//console.log("hra hrd");
					opTbl = elem.closest('.inpCol').siblings('.opCol').find('.vw-table-borderless');
					var mname = elem.children(":selected").data("mname");
					if (!mname) {
						mname = elem.closest(".row").find("#hsxModels :selected").data("mname");
					}
					hsax_opTbl2 = hsax_opTbl.replace("MODEL", mname);
					opTbl.html(hsax_opTbl2);
					opTbl.siblings('.hsDetails').html('<br/><p></p>').hide();

				} else if (hrd_type == "robo") {
					//console.log("robo hrd");
					opTbl = elem.closest('.inpCol').siblings('.opCol').find('.vw-table-borderless');
					opTbl.html(robo_opTbl);
					opTbl.siblings('.hsDetails').html('').hide();

				}
			}

			$(document).on("click", ".addSiteBtn", function() {
				numsites++;

				loadDefaultSite(numsites, 1);
			});

			$(document).on("click", ".ui-dialog-titlebar-close", function() {
				if ($(".vw-loading-area:visible").length <= 1) {

				} else {
					var holderID = $(this).attr('id').replace(/[a-zA-Z]/g, "");
					$('#holder' + holderID).remove();
					numsites--;
					//remove the site from replication dropdowns
					if ($("#replSiteTempTemp").find('[value="' + holderID + '"]').length > 0) {

						$("#replSiteTempTemp").find('[value="' + holderID + '"]').remove();
					}

					var opts = $("#replSiteTempTemp").html();
					//traverse through all dropdowns and set the options
					$(document).find("select[name^='replicationSites']:visible").each(function(i) {
						$(this).html(opts);
						var thissiteID = $(this).closest(".vw-comp-tile").attr('id').replace(/[a-zA-Z]/g, "");
						$(this).find('[value="' + thissiteID + '"]').remove();

					});
				}
			});

			$('#betRequestForm').submit(function(e) {
				var form = $(this);
				var action = $('input:hidden[name=action]').val();
				var reqType = "";

				if (validateForm(form)) {

					$("#content").mask();
					var sitesList = [];
					form.find("input[name='siteName']").each(function(i) {
						console.log(this.value);
						if ($.trim(this.value) != '') {
							sitesList.push($.trim(this.value));
						}
					});
					reqType = "BET Prediction";

					createBETRequest(sitesList, form, reqType, action);

					return false;
				} else {
					return false;
				}

			});

			function validateField(tx) {
				var reg = new RegExp(tx.data("validation"));
				var ret_Er = true;
				if (tx.val().trim() != '' && tx.val().trim().match(reg)) {
					tx.removeClass('input-error').addClass('input-success');

					return true;
				} else {
					var txId = tx.attr("id");
					var errMsgLbl = $("label.error[for=" + txId + "]");
					errMsgLbl.html(tx.data("msg"));
					errMsgLbl.show();
					tx.removeClass('input-success').addClass('input-error');
					return false;
				}
			}
			;

			function validateForm(form) {
				var alphanumReg = /^[A-Za-z0-9]+$/;
				var floatReg = /^\d(\.\d{0,2})?$/;
				var intReg = /^[0-9]+$/;
				var ret_val = true;
				var valid_inp = true;
				form.find(".bet-data:visible").each(function(i) {
					ret_val = validateField($(this));
					if (!ret_val) {
						valid_inp = false;
					}
				});
				return valid_inp;
			}

			function updateResultsTable(curForm, tblHTML) {
				var tbl = tblHTML;
				curForm
						.find("[id^='opDetails']:visible")
						.each(function(i) {
							var index = tbl.indexOf("</tbody>");
							var htmlCon = tbl.substring(7, index);
							htmlCon = htmlCon.replace(/''/g, "'");
							tbl = tbl.substring(index + 7, tbl.length);
							var opTbl = $(this).find('table tbody');
							opTbl.html(htmlCon);
							if (opTbl.find(".lgHS").text().trim() > 400) {
								opTbl
										.parent()
										.siblings('.hsDetails')
										.html('<br/><p>* For better ROI, it is recommended to use Hyperscale Reference Architecture instead of Hyperscale Appliance since the data size is large.</p>')
										.show();
							} else if (opTbl.find(".lgHS").text().trim() > 0 &&
									opTbl.find(".lgHS").text().trim() <= 400) {
								opTbl
										.parent()
										.siblings('.hsDetails')
										.html('<br/><p>*Please note that each server for HS1300 and HS3300 refers to a 3-node usable block.</p>')
										.show();
							} else {
								opTbl.parent().siblings('.hsDetails').show();
							}
						});
			}

			//			$('input[type=file]').on('change', function(e) {
			//				var fileName = e.target.files[0].name;
			//				console.log('The file "' + fileName + '" has been selected.');
			//				uploadDataToDisk(fileName);
			//			});

			$(document).on("click", ".exportToCsv", function() {

				$('input[type=hidden]').attr('value', 'export');
				$('#betRequestForm').submit();
			});

			function createBETRequest(sitesList, form, reqType, action) {
				if (form != null) {
					var sitesInfo = {
						sitesInfo : []
					};

					msg = "Creating cloud BET request."
					curForm = form;

					curForm.find("[id^='inpDetails']:visible").each(function(i) {
						var jsonData = {
							replRetention : []
						};
						var replSites = "";
						replPercs = "";
						console.log($(this).attr("id"));
						var replSitesArr = {
							replInfo : []
						};

						$(this).find(".replInfo").each(function(i) {
							var replInfo = {};
							$(this).find(".bet-data").each(function(i) {

								if ($(this).attr("name") == 'replicationSites') {
									replInfo["replicationSite"] = $(this).val();
								} else if ($(this).attr("name") == 'replicationPercents') {
									replInfo["replicationPercent"] = $(this).val();
								} else {
									replInfo[$(this).attr("name")] = $(this).val();
									console.log("id :" + $(this).attr("id") + ",name :" + $(this).attr("name") +
											", value: " + $(this).val());
								}
							});
							jsonData['replRetention'].push(replInfo);

						});

						$(this).find(".bet-data:visible").each(function(i) {
							if ($(this).attr("name") == 'siteName') {
								jsonData[$(this).attr("name")] = $(this).val();
								console.log("id :" + $(this).attr("id") + ",name :" + $(this).attr("name") +
										", value: " + $(this).text());
							} else if ($(this).attr("name") == 'replicationSites') {
								if (replSites != "") {
									replSites = replSites + ",";
								}
								replSites = replSites + $(this).val();
								jsonData[$(this).attr("name")] = replSites;
								console.log("id :" + $(this).attr("id") + ",name :" + $(this).attr("name") +
										", value: " + replSites);
							} else if ($(this).attr("name") == 'replicationPercents') {
								if (replPercs != "") {
									replPercs = replPercs + ",";
								}
								replPercs = replPercs + $(this).val();
								jsonData[$(this).attr("name")] = replPercs;
								console.log("id :" + $(this).attr("id") + ",name :" + $(this).attr("name") +
										", value: " + replPercs);
							} else if ($(this).is('[name^="hrd_Type"]') && $(this).prop('checked') == true) {
								jsonData["hrd_Type"] = $(this).filter(':checked').val();
								console.log("id :" + $(this).attr("id") + ",name :" + $(this).attr("name") +
										", value: " + $(this).filter(':checked').val());

							} else if (!$(this).is('[name^="hrd_Type"]')) {
								jsonData[$(this).attr("name")] = $(this).val();
								console.log("id :" + $(this).attr("id") + ",name :" + $(this).attr("name") +
										", value: " + $(this).val());
							}
						});
						sitesInfo.sitesInfo.push(jsonData);
					});
					var siteData = {
						Request : "BET Prediction",
						Company : "Commvault",
						Action : action,
						reqId : getReqIDfromUrl(),
						sites : JSON.stringify(sitesList),
						sitesInfo : JSON.stringify(sitesInfo.sitesInfo)
					};

					if (action == 'export') {

						cvUtil
								.loadPageWithPOST(cvUtil.getContextPath() + '/createcloudrequest.do',
										siteData,
										function(data) {
											var formId = curForm[0].id;
											$("#content").unmask();
											$('.uploadNowBtn').removeClass('disabled');
											$('.uploadNowBtn').bind('click', true);
											var msg = "";
											var fileName = "";
											if (data != '') {
												data = cvUtil.parseJSON(data);
												if (data.returnCode != 'Error') {
													if (data.fileName && data.fileName !== "") {
														msg = data.fileName;
														fileName = data.fileName;
														if (!fileName || fileName == "" || fileName == 'null') {
															cvUtil.errorToast(localMsg['ExportError']);
														} else {
															var finalLink = cvUtil.getContextPath() +
																	"/reportsplus/downloadTableCsv.do?type=report&fileName=" +
																	window.encodeURIComponent(fileName);
															var iframeId = "iframe" + Date.now();
															var iframeDOM = document.createElement("iframe");
															iframeDOM.setAttribute("style", "display:none;");
															iframeDOM.id = iframeId;
															document.body.appendChild(iframeDOM);
															iframeDOM.src = finalLink;
														}

													} else {

														cvUtil
																.errorToast("We're sorry, something went wrong. Please try to export again.");

													}
												} else {
													if (data.message && data.message !== "") {
														msg = data.message;
													} else {
														msg = "We're sorry, something went wrong. Please try to upload again.";
													}
													cvUtil
															.errorToast("We're sorry, something went wrong. Please try to export again.");
												}

											}
										},
										function() {
											$("#content").unmask();
											cvUtil
													.errorToast("We're sorry, something went wrong. Please try to export again.");
											$('.uploadNowBtn').removeClass('disabled');
											$('.uploadNowBtn').bind('click', true);
										});

					} else {
						cvUtil
								.loadPageWithPOST(cvUtil.getContextPath() + '/createcloudrequest.do',
										siteData,
										function(data) {
											var formId = curForm[0].id;
											$("#content").unmask();
											$('.uploadNowBtn').removeClass('disabled');
											$('.uploadNowBtn').bind('click', true);
											var msg = "";
											if (data != '') {
												data = cvUtil.parseJSON(data);
												if (data.returnCode != 'Error') {
													if (data.message && data.message !== "") {
														msg = data.message;
													} else if (data.BETS && data.BETS.trim()) {
														updateResultsTable(curForm, data.BETS.trim());
													} else {
														msg = "Thank you for your upload. You will receive an email with the token number to track."
													}

													curForm
															.closest('.uploadDiv')
															.siblings(".uploadMsg")
															.removeClass("cloudalert cloudalert-error cloudalert-error")
															.addClass("cloudalert cloudalert-success").html(msg);

												} else {
													if (data.message && data.message !== "") {
														msg = data.message;
													} else {
														msg = "We're sorry, something went wrong. Please try to upload again.";
													}
													curForm
															.closest('.uploadDiv')
															.siblings(".uploadMsg")
															.removeClass("cloudalert cloudalert-error cloudalert-success")
															.addClass("cloudalert cloudalert-error").html(msg);
												}
												if (data.previewStatus && data.previewStatus.trim()) {
													updatePreviewStatus(data.previewStatus, $(this));
												}
											}
										},
										function() {
											//$("#content").unmask();
											curForm
													.closest('.uploadDiv')
													.siblings(".uploadMsg")
													.removeClass("cloudalert cloudalert-error cloudalert-success")
													.addClass("cloudalert cloudalert-error")
													.html("We're sorry, something went wrong. Please try to upload again.");
											$('.uploadNowBtn').removeClass('disabled');
											$('.uploadNowBtn').bind('click', true);
										});
					} //end of else
				}
			}

		});