var report = {};
window.urlParamDelimiter = "-";
$(document).on("ready", function() {

	var width = cvUtil.getParameter("width", null);
	if (width != null) {
		$("#container").width(width);
	}
	$(".AddorRemoveCols").click(function(event) {
		var gridId = $(this).attr('id');
		gridId = gridId.substring(0, gridId.lastIndexOf("_"));
		CR.addOrRemoveColumns(gridId);
		event.stopPropagation();
		event.preventDefault();
	});

	$(".tableFilter").click(function(event) {
		var gridId = $(this).attr('id');
		gridId = gridId.substring(0, gridId.lastIndexOf("_"));
		CR.tableFilterColumns(gridId);
		$(this).toggleClass("filterOn");
	});

});
var mandatoryColList = []; //key:table_id, val:mandatory col list

function updateMandatoryList(gridid, aoColumns) {
	var columns = [];
	$.each(aoColumns, function(intIndex, objValue) {
		var column = objValue["sTitle"];
		var mandatory = objValue["bMandatoryCol"];
		if (mandatory == true) {
			columns.push(column);
		}
	});
	mandatoryColList.push({
		id : gridid,
		val : columns
	});
}
var CR = {
	tableid : '_table',
	MAXROWS_TOPRINT_WITHOUT_DIALOG : 20000,
	requestString : {},
	configureTable : function(gridid, title, data) {
		CR.temp = {
			"data" : data
		};
		var dataTabl = $('#' + gridid + CVTable.table).hasClass('initialized');
		if (dataTabl) {
			$('#' + gridid + CVTable.table).removeClass('initialized');
			$('#' + gridid + CVTable.table).dataTable().fnDestroy();
			$('#' + gridid + CVTable.table).empty();
			$('#' + gridid + CVTable.table + "_length").remove();
			$("#" + gridid + "_FilterButton").removeClass("filterOn");
			$(".toptableInfo").remove();
		}
		updateMandatoryList(gridid, data.aoColumns);
		var firstLoad = true;

		$('#' + gridid + CVTable.table).addClass('initialized').dataTable({
			"bProcessing" : true,
			//			"sScrollX": sScrollX,
			"bServerSide" : true,
			"iDisplayLength" : data.pageSize,
			"aaData" : data.aaData,
			"bFilter" : false,
			"aoColumns" : data.aoColumns,
			"aoColumnDefs" : data.aoColumnDefs,
			//"sAjaxSource": cvUtil.getContextPath() + "/server/getCustomReportData",
			"iTotalRecords" : data.iTotalRecords,
			"sPaginationType" : 'input',
			"bRetrieve" : true,
			"bAutoWidth" : false,
			"aaSorting" : [ data.aaSorting ],
			"sDom" : 'R<"toptableInfo"i>rt<"bottom"flip><"clear">',
			"bLengthChange" : true,
			"aLengthMenu" : [ [ 10, 20, 50, 100, 200, 500 ], [ 10, 20, 50, 100, 200, 500 ] ],
			"oLanguage" : {
				"oPaginate" : {
					"sFirst" : '&nbsp;',
					"sNext" : '&nbsp;',
					"sPrevious" : '&nbsp;',
					"sLast" : '&nbsp;'
				},
				"sLengthMenu" : "Show _MENU_"
			},
			"fnServerData" : function(sSource, aoData, fnCallback) {
				if (firstLoad == true) {
					CR.temp.data.sEcho = CR.fnGetKey(aoData, 'sEcho');
					fnCallback(CR.temp.data);
					firstLoad = false;
					return;
				}
				CR.requestString[gridid] = {};
				var reportId = cvUtil.getParameter("reportId", 0);

				if (reportId) {
					CR.requestString["reportId"] = reportId;
				}
				var pageSize = CR.fnGetKey(aoData, 'iDisplayLength');
				var pageNo = 1;
				if (pageSize != 0) {
					pageNo = (CR.fnGetKey(aoData, 'iDisplayStart') / pageSize) + 1;
				}
				CR.requestString[gridid] = {
					'filterClause' : CR.fnGetSearchString(this.fnSettings()),
					'iSort_Col' : this.fnSettings().aoColumns[CR.fnGetKey(aoData, 'iSortCol_0')].sName,
					'sortDir' : CR.fnGetKey(aoData, 'sSortDir_0'),
					'pageNo' : pageNo,
					'doNotRefreshDataIfExists' : true
				};
				CR.requestString['pageSize'] = pageSize;
				CR.requestString['rowGroupingColumn'] = data.rowGroupingColumn;
				updateHash(true);

				$('#' + gridid).mask();
				CR.unchangedRequestParams = CR.unchangedRequestParams || {};
				var mergedProperties = {};
				$.extend(mergedProperties, CR.unchangedRequestParams, CR.requestString);
				/*
				 * cvUtil.loadPageWithPOST(cvUtil.getContextPath() + "/server/getCustomReportData",
				 * mergedProperties, function(data1) { $('#'+gridid).unmask(); var d =
				 * JSON.parse(data1.tableData); d.sEcho=CR.fnGetKey(aoData, 'sEcho'); fnCallback(d);
				 * $('#'+gridid+CVTable.table+' tr td' ).each( function() { this.setAttribute( 'title',
				 * $(this).text());});
				 * $('.reportColums_container').css('max-height',$('#'+gridid+CVTable.table).css('height')); //
				 * set the height of the column container to the table height },function(xhr, ajaxOptions,
				 * thrownError){ $('#'+gridid).unmask(); var error = $.trim(xhr.responseText); if(error != '')
				 * cvUtil.toast(error,30000);
				 * 
				 * });
				 */
			},
			"fnDrawCallback" : function(oSettings) {
				//				if(window.report.exportType)
				//					window.setTimeout(function(){
				//						var width = $('#'+gridid+CVTable.table + ' tbody').outerWidth();
				//						if(width+22>$("#container").width()){
				//							$("#container").width(width+22);
				//						}
				//					}, 20);
				$('#' + gridid + CVTable.table).addClass("drawn");
			}
		});
		$('#' + gridid + CVTable.table + ' tr td').each(function() {
			this.setAttribute('title', $(this).text());
		});
		$('.reportColums_container').css('max-height', $('#' + gridid + CVTable.table).css('height')); // set the height of the column container to the table height
		$(".dataTables_paginate input").click(function(e) {
			$(this).css("background", "url('../common/img/pging_bg_edit.png') repeat-x 0 0 transparent").css("width",
					"25px");
			e.stopPropagation();
		});
		$('html').click(function() {
			$(".dataTables_paginate input").css("background",
					"url('../common/img/pging_bg.png') repeat-x 0 0 transparent").css("width", "15px")
					.keypress(function(event) {
						var keycode = (event.keyCode ? event.keyCode : event.which);
						if (keycode == '13') {
							$(".dataTables_paginate input").css("background",
									"url('../common/img/pging_bg.png') repeat-x 0 0 transparent").css("width", "15px")
									.blur();
						}
					});
		});
		$(".toptableInfo").insertAfter("#previewTable h1");
		$(".toptableInfo").append("<span class='ulSeparator'> | </span>");
		$("#previewTable_table_length").insertAfter("#previewTable h1");
		$("#previewTable_table_length").addClass("hideOnExportFriendly");

		if (data.rowGroupingColumn && data.rowGroupingColumn != undefined && data.rowGroupingColumn != "") {

			$('#' + gridid + CVTable.table).dataTable().rowGrouping({
				iGroupingColumnIndex : this.getColumnNumber(data.rowGroupingColumn),
				sGroupingColumnSortDirection : data.aaSorting[1],
				iGroupingOrderByColumnIndex : data.aaSorting[0],
				bExpandableGrouping : true
			});
		}
	},
	configureClientSideTableWithPaging : function(gridid, title, data, opt) {
		var options = opt || {};
		var viewDetails = 'userDetails';
		if (isAdminView() == true) {
			viewDetails = 'adminDetails';
		}
		$.each(data.aoColumns, function(intIndex, objValue) {
			objValue.fnRender = CR.Renderers[objValue["rendererType"]];
		});

		updateMandatoryList(gridid, data.aoColumns);

		var dataTabl = $('#' + gridid + CVTable.table).hasClass('initialized');
		if (dataTabl) {
			$('#' + gridid + CVTable.table).removeClass('initialized');
			$('#' + gridid + CVTable.table).dataTable().fnClearTable();
			$('#' + gridid + CVTable.table).dataTable().fnDestroy();
			$('#' + gridid + CVTable.table).empty();

		}

		$('#' + gridid + CVTable.table).addClass('initialized').dataTable({
			"aaData" : data.aaData,
			"aoColumns" : data.aoColumns,
			"aoColumnDefs" : data.aoColumnDefs,
			"aaSorting" : [ [ 0, "desc" ] ],
			"iTotalRecords" : data.iTotalRecords,
			"iDisplayLength" : data.iDisplayLength,
			"bUseRendered" : false,
			"bRetrieve" : true,
			"bServerSide" : false,
			"bFilter" : true,
			"bAutoWidth" : false,
			"sDom" : options.sDom || "Rlfrtip",
			"bLengthChange" : true,
			"aLengthMenu" : [ [ 20, 50, 100, 200, 500, -1 ], [ 20, 50, 100, 200, 500, "All" ] ],
			"bInfo" : true,
			"sPaginationType" : "input",
			//"aaSorting": [data.aaSorting],
			"oLanguage" : {
				"oPaginate" : {
					"sFirst" : '&nbsp;',
					"sNext" : '&nbsp;',
					"sPrevious" : '&nbsp;',
					"sLast" : '&nbsp;'
				},
				"sLengthMenu" : "Show _MENU_",
				"sSearch" : ""
			},
			"fnHeaderCallback" : function(nhead) {
				$('table.dataTable').find('th.requestId').text('Request ID');
				$('table.dataTable').find('th.requestType').text('Request Type');
				$('table.dataTable').find('th.company').text('Company');
				$('table.dataTable').find('th.priority').text('Priority');
				$('table.dataTable').find('th.contact').text('Contact');
				$('table.dataTable').find('th.status').text('Status');
				$('table.dataTable').find('th.phase').text('Phase');
				$('table.dataTable').find('th.createdTime').text('Created Time');
			},
			"fnDrawCallback" : function(oSettings) {
				if (CR.tableDrawCallBack) {
					CR.tableDrawCallBack(oSettings);
				}
				$('.dataTable tbody td').each(function(index) {
					$this = $(this);
					var titleVal = $this.text();
					if (titleVal != '') {
						$this.attr('title', titleVal);
					}
				});
				$('.dataTable tbody tr').each(function() {
					$('td:first-child', this).on('click',
							function() {
								//alert('clicked on id');
								var id = $(this).html();
								window.open(cvUtil.getContextPath() + '/getrequestDetails.do?id=' + id + "&action=" +
										viewDetails);
							});
				});
				$('#' + gridid + CVTable.table).addClass("drawn");
				if (isAdminView() == true) {
					makeRowsEditable(gridid);
				}

			}
		});

		var dataTable = $('#' + gridid + CVTable.table).dataTable();
		$('#' + gridid + CVTable.table + ' thead th').each(function(index, value) {
			$(value).attr('title', $(value).text());
		});

		$.each(dataTable.fnGetNodes(), function(index, value) {
			$.each($('td', $(this)), function(childIndex, childValue) {

				if (data.aoColumns[childIndex]["rendererType"] != undefined) {
					var frRender = data.aoColumns[childIndex]["rendererType"];
					if (frRender.indexOf("editable") == 0) {
						var input = $(this).find('input');
						$(this).find('input').bind('keyup blur', function(event) {
							if (!event.keyCode || event.keyCode == 13) {
								var growth = input.val();
								$.each(capacity.units, function(index, unit) {
									if (endsWith(growth, index)) {
										if (!isNaN(growth.substr(0, growth.length - index.length))) //convert only if it is a number
										{
											growth = parseFloat(growth) * unit;
										}
										return false;
									}
								});
								if (isNaN(growth)) {
									return;
								} else {
									growth = Math.round(parseFloat(growth) * 100) / 100;
								}
								/*
								 * report.editTableCallBack(dataTable, growth, { "colIndex" : childIndex,
								 * "rowIndex" : index, "rowData" : data.aaData[index] });
								 */
							}
						});
					}
				}

			});
		});
		/*
		 * if(report.customizeTable) { report.customizeTable(dataTable); }
		 */

		$("#" + gridid).show();
		/*
		 * if(report.requestString[gridid+"addOrRemoveColumns"] != undefined) CR.showUiSelectColumns(gridid,
		 * report.requestString[gridid+"addOrRemoveColumns"]);
		 */
		CR.showHideAddRemoveColumsIcon(gridid);

		$("#" + gridid + "_table_length").addClass("hideOnExportFriendly");
	},
	fnGetKey : function(aoData, sKey) {
		for (var i = 0, iLen = aoData.length; i < iLen; i++) {
			if (aoData[i].name == sKey) {
				return aoData[i].value;
			}
		}
		return null;
	},
	showUiSelectColumns : function(gridid, columnString) {
		columnString = columnString.substring(0, columnString.lastIndexOf(":"));
		var oTable = $("#" + gridid + CVTable.table).dataTable();
		var items = columnString.split(':');
		$.each(items, function(index) {
			var current = items[index];
			var colNo = current.split("-")[0];
			var bVis = current.split("-")[1];
			var showCol = bVis == "true" ? true : false;
			console.log(colNo + "-" + showCol);
			oTable.fnSetColumnVis(colNo, showCol, false);
		});
	},
	addOrRemoveColumns : function(gridid) {
		var oTable = $("#" + gridid + CVTable.table).dataTable();
		var container = $("#" + gridid + '_Colums');

		var oSettings = oTable.fnSettings();
		var id = 0;
		$("#" + gridid + '_Colums').empty();

		var mandatoryColumns = [];
		$.each(mandatoryColList, function(intIndex, objValue) {
			if (objValue.id == gridid) {
				mandatoryColumns = objValue.val;
				return;
			}
		});
		var p = 0;
		for (var iColumn = 0; iColumn < oSettings.aoColumns.length; iColumn++) {
			var name = oSettings.aoColumns[iColumn].sTitle;
			var mandatoryCol = '';
			if (mandatoryColumns.length > 0) {
				$.each(mandatoryColumns, function(colIndex, column) {
					if (name == column) {
						//Mandatory columns will be disabled in addOrRemove list.
						mandatoryCol = 'disabled';
						return;
					}
				});
			}/*
			 * else{ //If mandatory columns are not there, first 1 visible column will be treated as
			 * mandatory column if(oSettings.aoColumns[iColumn].bVisible==true) { if(p < 1){ mandatoryCol =
			 * 'disabled'; } p++; } }
			 */

			if (mandatoryCol == 'disabled') {
				continue;
			}

			var html = "";
			id = iColumn;
			var visible = (oSettings.aoColumns[iColumn].bVisible == true) ? 'checked' : 'unchecked';
			var rowGroupIngcolNumber = '';
			/*
			 * if(customReport && customReport.rowGroupingColumn != null && customReport.rowGroupingColumn !=
			 * undefined && customReport.rowGroupingColumn != ""){ rowGroupIngcolNumber =
			 * this.getColumnNumber(customReport.rowGroupingColumn); }
			 */
			if (rowGroupIngcolNumber == '' || id != rowGroupIngcolNumber) {
				var dispName = '';
				if (name == 'requestId') {
					dispName = 'Request ID';
				} else if (name == 'requestType') {
					dispName = 'Request Type';
				} else if (name == 'company') {
					dispName = 'Company';
				} else if (name == 'priority') {
					dispName = 'Priority';
				} else if (name == 'contact') {
					dispName = 'Contact';
				} else if (name == 'status') {
					dispName = 'Status';
				} else if (name == 'phase') {
					dispName = 'Phase';
				} else if (name == 'createdTime') {
					dispName = 'Created Time';
				}
				html = '<li class="col1 cb_' + id + '"><div id="' + gridid + ':cb_' + id +
						'" class="custom-cb addOrRemoveCheckBox ' + visible + ' " data-state="' + visible +
						'" data-name="' + name + '"></div><span class="custom-cb-label">' + dispName + '</span></li>';
				container.append($(html));
			}

		}

		$("#" + gridid + '_Colums').slideToggle('fast');
		$("#" + gridid + '_Button').toggleClass('activeNow');
		$(".reportColums_container").off("click");
		$(".reportColums_container").on("click", function(event) {
			var reportId = cvUtil.getParameter("reportId", 0);
			if (reportId) {
				CR.requestString["reportId"] = reportId;
			}
			var el = $(event.target).children(".addOrRemoveCheckBox");
			if (el.length == 0) {
				el = $(event.target);
				if ($(el).hasClass("addOrRemoveCheckBox")) {
					//do nothing
				} else {
					return;
				}
			}

			toggleCb($(el));
			event.stopPropagation();
			var id = $(el).attr('id');
			var columnNum = id.substring(id.lastIndexOf("_") + 1, id.length);
			var columnName = $(el).attr('data-name');
			var bVis = oSettings.aoColumns[columnNum].bVisible;
			bVis = bVis ? false : true;

			if (CR.requestString["tableColumns"] == undefined) {
				CR.requestString["tableColumns"] = "";
			}

			oTable.fnSetColumnVis(columnNum, bVis, false);

			var replaceStr = CR.getTableCols();
			CR.requestString["tableColumns"] = replaceStr;

			updateHash(true);

			var value = $("#" + gridid + "_FilterSelected").attr('value');
			if (value == 'true') {
				/*
				 * $("#"+gridid+"_FilterSelected").val('undefined'); $("#filterRow_"+gridid).remove();
				 * $("#"+gridid+"_FilterButton").trigger('click');
				 */

				$("#" + gridid + "_filterText-" + columnNum + "-td").toggle();

			}
			if ($('.group').length > 0) {
				var visColCount = getVisibleColumnCount(gridid);
				$('.group').attr('colspan', visColCount);
			}

			oTable.fnAdjustColumnSizing(false);
			if (isAdminView() == true) {
				makeRowsEditable(gridid);
			}
			$('table.dataTable').find('th.requestId').text('Request ID');
			$('table.dataTable').find('th.requestType').text('Request Type');
			$('table.dataTable').find('th.company').text('Company');
			$('table.dataTable').find('th.priority').text('Priority');
			$('table.dataTable').find('th.contact').text('Contact');
			$('table.dataTable').find('th.status').text('Status');
			$('table.dataTable').find('th.phase').text('Phase');
			$('table.dataTable').find('th.createdTime').text('Created Time');
		});
		$(".custom-cb-label").on("click", function(e) {
			$(this).prev(".custom-cb").trigger('click');
			e.stopPropagation();
		});
		$(".custom-cb-label").on("touchstart", function(e) {
			//			$(this).prev(".custom-cb").trigger('click');
			e.stopPropagation();
		});
		$(".reportColums_container").on("touchstart", function(e) {
			e.stopPropagation();
		});

		/*
		 * var ua = navigator.userAgent, event = (ua.match(/iPad/i)) ? "touchstart" : "click";
		 */
		$(document).on("click touchstart", function(ev) {
			$("#" + gridid + '_Colums').slideUp('fast');
			$("#" + gridid + '_Button').removeClass('activeNow');
		});

	},
	getTableCols : function() {
		var tableColumns = "";
		var dataTabl = $('#previewTable_table').hasClass('initialized');
		if (dataTabl) {
			var oTable = $("#previewTable_table").dataTable();
			var oSettings = oTable.fnSettings();
			if (oSettings != null) {
				for (var j = 0; j < oSettings.aoColumns.length; j++) {
					tableColumns = tableColumns + oSettings.aoColumns[j].sName + "-" + oSettings.aoColumns[j].bVisible +
							":";
				}
			}
		}
		return tableColumns;
	},
	getSortCols : function() {
		var sortColumns = [];
		var dataTabl = $('#previewTable_table').hasClass('initialized');
		if (dataTabl) {
			var oTable = $("#previewTable_table").dataTable();
			var oSettings = oTable.fnSettings();
			if (oSettings != null && oSettings.aoColumns.length > 0) {
				sortColumns[0] = oSettings.aoColumns[oSettings.aaSorting[0][0]].sName;
				sortColumns[1] = oSettings.aaSorting[0][1];
			}
		}
		return sortColumns;
	},
	getColumnNumber : function(name) {
		var oTable = $("#previewTable_table").dataTable();
		name = name.toLowerCase(); // case insensitive match, cast all to lowercase
		var aoColumns = oTable.fnSettings().aoColumns;
		var numcols = aoColumns.length;

		for (i = 0; i < numcols; i++) {
			col = aoColumns[i].sName.toLowerCase();
			if (col == name) {
				return i;
			}
		}

		return -1;
	},
	fnGetSearchString : function(oSettings) {
		var searchString = "";
		for (var iColumn = 0; iColumn < oSettings.aoColumns.length; iColumn++) {
			if (oSettings.aoColumns[iColumn].bVisible) {
				var operator = 'LIKE';
				var search = oSettings.aoColumns[iColumn].sSearch;
				if (typeof search == 'undefined' || search == "") {
					search = 'undefined';
					continue;
				}
				searchString = searchString + oSettings.aoColumns[iColumn].sName + ',' + search + ';';
			}
		}
		return searchString;
	},
	showHideAddRemoveColumsIcon : function(gridid) {
		var oTable = $("#" + gridid + CVTable.table).dataTable();
		var oSettings = oTable.fnSettings();

		var mandatoryColumns = [];
		$.each(mandatoryColList, function(intIndex, objValue) {
			if (objValue.id == gridid) {
				mandatoryColumns = objValue.val;
				return;
			}
		});
		var showIcon = true;

		if (mandatoryColumns.length == oSettings.aoColumns.length || oSettings.aoColumns.length <= 2) {
			showIcon = false;
		}

		if (showIcon) {
			$("#" + gridid + '_holder').show();
		} else {
			$("#" + gridid + '_holder').hide();
		}

	},//end of showHideAddRemoveColumsIcon()
	tableFilterColumns : function(gridid) {
		var oTable = $("#" + gridid + CVTable.table).dataTable();

		var oSettings = oTable.fnSettings();
		var value = $("#" + gridid + "_FilterSelected").attr('value');
		if (value.trim() == '' || value.trim() == 'undefined' || $('#filterRow_' + gridid).length == 0) {
			$("#" + gridid + "_FilterSelected").val('true');
			var appendTxt = '<tr id="filterRow_' + gridid + '">';
			for (var iColumn = 0; iColumn < oSettings.aoColumns.length; iColumn++) {
				var width = oSettings.aoColumns[iColumn].sWidth;
				var colName = oSettings.aoColumns[iColumn].sName;
				colName = colName.split(' ').join('_').split('(').join('_').split(')').join('_');
				appendTxt = appendTxt + '<td id="' + gridid + '_filterText-' + iColumn + '-td' +
						'"><input type="text" id="' + gridid + '_filterText-' + iColumn +
						'" class="inLineFilter inLineFilter' + colName + '" value="" width="' + width + '"/></td>';
			}
			appendTxt = appendTxt + '</tr>';
			$("tr:first", oTable).after(appendTxt);
			showHideFilterComps();
		} else if (value == 'false') {
			$("#" + gridid + "_FilterSelected").val('true');
			$('#filterRow_' + gridid).show();
			showHideFilterComps();
		} else if (value == 'true') {
			$("#" + gridid + "_FilterSelected").val('false');
			$('#filterRow_' + gridid).hide();
		}

		$(".inLineFilter").keyup(function(event) {
			var serverCall = false;
			if (event.keyCode == 13) {
				for (var i = 0; i < oSettings.aoColumns.length; i++) {
					if (oSettings.aoColumns[i].bVisible) {
						var value = document.getElementById(gridid + "_filterText-" + i).value;
						if (value.trim() != "") {
							oSettings.aoColumns[i].sSearch = value;
							serverCall = true;
						}
					}
				}

				if (serverCall) {
					CR.requestString["filteredTable"] = gridid;
					oTable.fnDraw();
				}

			}

			if (event.keyCode == 46 || event.keyCode == 8) {
				var value = $(this).attr('value');
				if (value.trim() == "") {
					for (var i = 0; i < oSettings.aoColumns.length; i++) {
						if (oSettings.aoColumns[i].bVisible) {
							var value = document.getElementById(gridid + "_filterText-" + i).value;
							oSettings.aoColumns[i].sSearch = value;
							serverCall = true;

						}
					}
				}
				if (serverCall) {
					CR.requestString["filteredTable"] = gridid;
					oTable.fnDraw();
				}
			}
		});

		function adjustSize(oSettings) {
			for (var iColumn = 0; iColumn < oSettings.aoColumns.length; iColumn++) {
				var th = $(oSettings.aoColumns[iColumn].nTh)[0];
				$("#" + gridid + '_filterText-' + iColumn).width(parseInt(oSettings.aoColumns[iColumn].sWidth) - 14); //10 padding and 4 border
			}
		}

		/*
		 * $("input").focusin(function () { $(this).val(""); }); ;
		 */

		function showHideFilterComps() {
			adjustSize(oSettings);
			for (var iColumn = 0; iColumn < oSettings.aoColumns.length; iColumn++) {
				var id = '#' + gridid + '_filterText-' + iColumn + '-td';
				if (oSettings.aoColumns[iColumn].bVisible) {
					//	$(id+' input').width($(oSettings.aoColumns[iColumn].nTh).width()-4);
					$(id).show();
				} else {
					$(id).hide();
				}
			}
		}

	},
	onResize : function(th) {
		var index = $('th', th.parentNode).index(th);
		var inputEl = $($(th).parent().next().children()[index]).find('input');
		inputEl.width($(th).width() - 14);
	},
	Renderers : {
		"test_Priority" : function(o, val, id) {
			return '<select id="year" class="Priority">' + '<option value="2010">2010</option>'
					+ '<option value="2011">2011</option>' + '<option value="2012">2012</option>' + '</select> ';
		},
		"capacityMB" : function(o, val, id) {
			return autoConvertFromMB(o.aData[o.oSettings.aoColumns[o.iDataColumn].mDataProp]);
		},
		"capacityMB_Neg" : function(o, val, id) {
			return autoConvertFromMB(o.aData[o.oSettings.aoColumns[o.iDataColumn].mDataProp], true);
		},
		"capacityMBPercent" : function(o, val, id) {
			return autoConvertFromMB(o.aData[o.oSettings.aoColumns[o.iDataColumn].mDataProp]);
		},
		"percentNA" : function(o, val) {
			return getPercentValue(o.aData[o.oSettings.aoColumns[o.iDataColumn].mDataProp]);
		},
		"editable" : function(o, val) {
			return '<input style="width: 100px; height: 14px; " autocomplete="off" value="' + val + '">';
		},
		"editableCapacity" : function(o, val) {
			val = autoConvert(o.aData[o.oSettings.aoColumns[o.iDataColumn].mDataProp]);
			return '<input style="width: 100px; height: 14px; " autocomplete="off" value="' + val + '">';
		},
		"formattedInteger" : function(o, val, id) {
			var x1 = "" + o.aData[o.oSettings.aoColumns[o.iDataColumn].mDataProp];
			var rgx = /(\d+)(\d{3})/;
			while (rgx.test(x1)) {
				x1 = x1.replace(rgx, '$1' + ',' + '$2');
			}
			return x1;
		}
	}
};

function updateHash(isReplace) {
	report.fireHistoryChange = false;
	var url = requestToUrl(CR.requestString);
	if (url.length != 0) {
		if (isReplace === true) {
			History.replaceState(null, document.title, "?" + url);
		} else {
			History.pushState(null, document.title, "?" + url);
		}
	}
};

function requestToUrl(a1) {
	return objectToUrl(a1).join("&");
}

function objectToUrl(a1, prefix) {
	var u = [];
	var x;
	if (prefix) {
		prefix = prefix + urlParamDelimiter;
	} else {
		prefix = "";
	}
	for (x in a1) {
		if (x == 'invisible') {
			continue;
		}
		var curr = a1[x];
		if (curr === undefined || curr === '') {
			continue;
		}
		if (curr instanceof Array) {
			u = u.concat(arrayToUrl(curr, prefix + x));
		} else if (curr instanceof Object) {
			u = u.concat(objectToUrl(curr, prefix + x));
		} else {
			u.push(prefix + x + "=" + encodeURIComponent(curr));
		}
	}
	return u;
}
function arrayToUrl(curr, prefix) {
	var u = [];
	var index = 0;
	if (prefix) {
		prefix = prefix + urlParamDelimiter;
	}
	for (index = 0; index < curr.length; index++) {
		if (curr[index] instanceof Object) {
			u = u.concat(objectToUrl(curr[index], prefix + index));
		} else if (curr[index] instanceof Array) {
			u = u.concat(arrayToUrl(curr[index], prefix + index));
		} else {
			u.push(prefix + index + "=" + encodeURIComponent(curr[index]));
		}
	}
	return u;
}
function urlToRequest(hash, requestString) {
	var u = hash.split('&');

	$.each(u, function(index, token) {
		var nameValue = token.split('=');
		var name = nameValue[0];
		var hierarchy = name.split(urlParamDelimiter);
		var current = requestString;
		var value = decodeURIComponent(nameValue[1]);
		for (index = 0; index < hierarchy.length; index++) {
			var step = hierarchy[index];
			if (index == hierarchy.length - 1) {
				current[step] = value;
			} else {
				if (isNaN(hierarchy[index + 1])) {
					if (!(current[step] instanceof Object)) {
						current[step] = {};
					}
				} else if (!(current[step] instanceof Array)) {
					current[step] = [];
				}
				current = current[step];
			}
		}
	});
}
function getVisibleColumnCount(gridid) {
	var count = 0;
	var oTable = $("#" + gridid + CVTable.table).dataTable();
	var oSettings = oTable.fnSettings();
	for (var iColumn = 0; iColumn < oSettings.aoColumns.length; iColumn++) {
		if (oSettings.aoColumns[iColumn].bVisible == true) {
			count++;
		}
	}
	return count;
}

function getColName(obj, gridid) {
	var oTable = $('#' + gridid + CVTable.table).dataTable();
	var ret_arr = oTable.fnGetPosition(obj); // returns array of 3 indexes [ row, col_visible, col_all]
	var row = ret_arr[0];
	var col = ret_arr[1];
	var data_row = oTable.fnGetData(row);
	var primary_key = data_row[0];

	var oSettings = oTable.fnSettings(); // you can find all sorts of goodies in the Settings
	var col_id = oSettings.aoColumns[col].sTitle;
	return col_id;
}

function GetStatusbyId(value) {
	var reqStatusVal = '';
	switch (value) {
	case "1":
		reqStatusVal = 'Submitted';
		break;
	case "2":
		reqStatusVal = 'InProgress';
		break;
	case "3":
		reqStatusVal = 'Completed';
		break;
	case "4":
		reqStatusVal = 'Killed';
		break;
	case "6":
		reqStatusVal = 'Suspended';
		break;
	case "8":
		reqStatusVal = 'Failed';
		break;
	default:
		reqStatusVal = 'NA';
		break;

	}
	return reqStatusVal;
}

function makeRowsEditable(gridid) {
	var oTable = $("#" + gridid + CVTable.table).dataTable();
	$('#' + gridid + CVTable.table + ' td:not(:nth-child(1), :nth-child(2))').each(function(i) {
		/* $('#'+gridid+CVTable.table+' td:not(:first-child)').each(function(i){ */
		var colName = getColName(this, gridid);
		if (colName == 'priority') {
			$(this).editable(cvUtil.getContextPath() + '/setrequestDetails.do', {
				data : {
					'0' : '0',
					'1' : '1',
					'2' : '2',
					'3' : '3',
					'4' : '4'
				},
				type : 'select',
				style : 'inherit',
				submit : 'OK',
				callback : function(value, settings) {
					var aPos = oTable.fnGetPosition(this);
					oTable.fnUpdate(value, aPos[0], aPos[1]);
				},
				submitdata : function(value, settings) {
					return {
						"reqId" : $('td:first', $(this).parents('tr')).html(),
						"colName" : 'priority'//oTable.fnGetPosition(this)[2]
					};
				},
				width : "50px",
				height : "15px"
			});
		} else if (colName == 'status') {
			$(this).editable(cvUtil.getContextPath() + '/setrequestDetails.do', {
				data : {
					'1' : 'Submitted',
					'2' : 'InProgress',
					'3' : 'Completed',
					'4' : 'Killed',
					'6' : 'Suspended'
				},
				type : 'select',
				style : 'inherit',
				submit : 'OK',
				callback : function(value, settings) {
					var aPos = oTable.fnGetPosition(this);
					var reqStatusVal = GetStatusbyId(value);
					oTable.fnUpdate(reqStatusVal, aPos[0], aPos[1]);
				},
				submitdata : function(value, settings) {
					return {
						"reqId" : $('td:first', $(this).parents('tr')).html(),
						"colName" : 'status'//oTable.fnGetPosition(this)[2]
					};
				},
				width : '100%',
				height : "15px"
			});
		}
		/*
		 * if(colName == 'Phase'){ $(this).editable(cvUtil.getContextPath() + '/server/setrequestDetails', {
		 * data : " {'1':'Request Submitted','2':'Data Download','3':'VM Configuration','4':'Data
		 * Copy','5':'Data Import','6':'Report generation','7':'Stage Index'}", type : 'select', style:
		 * 'inherit', submit : 'OK', callback : function(value, settings) { var aPos = oTable.fnGetPosition(
		 * this ); var reqStatusVal = GetStatusbyId(value); oTable.fnUpdate( reqStatusVal, aPos[0], aPos[1] ); },
		 * submitdata : function(value,settings){ return{ "reqId" : $('td:first',
		 * $(this).parents('tr')).html(), "colName" :'Phase'//oTable.fnGetPosition(this)[2] }; },
		 * width:($(this).width() + 100) + "px", height:"15px" }); }
		 */
		else if (colName != 'createdTime' && colName != 'phase') {
			$(this).editable(cvUtil.getContextPath() + '/setrequestDetails.do', {
				indicator : 'Saving...',
				tooltip : 'Click to edit...',
				callback : function(value, settings) {
					var aPos = oTable.fnGetPosition(this);
					oTable.fnUpdate(value, aPos[0], aPos[1]);
				},
				submitdata : function(value, settings) {
					return {
						"reqId" : $('td:first', $(this).parents('tr')).html(),
						/*
						 * "company" : $(this).closest('tr').find('td:eq(1)').html(), "priority" :
						 * $(this).closest('tr').find('td:eq(2)').html(), "contact" :
						 * $(this).closest('tr').find('td:eq(3)').html(),
						 */
						"colName" : colName
					//oTable.fnGetPosition(this)[2]
					};
				},
				height : '15px'
			});
		}
	});

}