
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>

<fmt:setBundle basename="localization.CloudMessages"/>

<jsp:include page="../../common/header.jsp">
    	<jsp:param value="External Data Connector" name="title" />
    	<jsp:param value="External Data Connector" name="titleLocalized" />
    	<jsp:param value="css/ui-lightness/jquery-ui-1.8.20.custom.css" name="css" />
		<jsp:param value="../../common/css/templatestyles.css" name="css" />
		<jsp:param value="../../common/css/headerstyles.css" name="css" />
		<jsp:param value="${pageContext.request.contextPath}/common/css/jquery.loadmask.css" name="css" />
    	<jsp:param value="css/cloud.css" name="css" />
    	<jsp:param value="js/edcservices.js" name="js" />
    	<jsp:param value="js/jquery.form.js" name="js" />
    	<jsp:param value="css/edcstyles.css" name="css" />
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="External_Data_Connector" name="headerTitle" />
		<jsp:param value="Cloud Applications:../applications/cloudApps.jsp" name="breadCrumbValues" />
 </jsp:include>

	<div id="edctabs">
	<ul>
		<li><a href="#tabs-1"><fmt:message key="Overview" /></a></li>
		<li><a href="#tabs-2">NetWorker</a></li>
		<li><a href="#tabs-3">TSM</a></li>
		<li><a href="#tabs-4">NetBackup</a></li>
		<li><a href="#tabs-5">Backup Exec</a></li>
		<li><a href="#tabs-6">Veeam</a></li>
		<li><a href="#tabs-7">NetBackup FLA</a></li>
		<li><a href="#tabs-8">Data Protection Advisor</a></li>
	</ul>

	<div id="tabs-1">
	<span class="leftText">
		<fmt:message key="ExternalDataConnectorDescription"/><br/>
		<div id="togglecustView" class="focusText"><fmt:message key="CustomerSelfServiceAccess"/><br><br/>
		<a href="#"  class="cloudBtn target_createAcc" id="edc"><fmt:message key="AuthCode" /></a>
		</div>

		</span>
		<span class="rightText">
		<span class="supportText"><fmt:message key="SupportedBackupVendors"/></span>
		<br><br>
		<a id="2" class="gotoTab">EMC Networker&reg; (Supported for 7.2, 7.6, 7.6.1, 8.0, 8.1 and 18.2 versions, Fujitsu Networker 7.6.2, 7.6.3 and 7.5 versions)<br></a>
		<a id="3" class="gotoTab">IBM Tivoli Storage Manager&reg; (Supported for 5.4, 5.5, 6.1, 6.2, 6.3, 6.4, 7.1 and 8.1 versions)<br> </a>
		<a id="4" class="gotoTab">Symantec NetBackup&trade; (Supported for 5.1, 6.0, 6.5, 7.0, 7.1, 7.5, 7.6 and 7.7 versions)<br> </a>
		<a id="5" class="gotoTab">Symantec BackupExec&trade; (Supported for 2010, 2012, 2012 with SP2, 2014 and 2015 versions)<br> </a>
		<a id="6" class="gotoTab">Veeam&reg;(Supported for 7.0, 8.0, 9.0 and 9.5 versions)<br> </a>
		<a id="7" class="gotoTab">EMC Data Protection Advisor&reg; (Supported for 5.8 version) <br> </a>
		<br><br>
		<fmt:message key="BackupProducts"/><br>
		<a id="sysDisc" class="gotoTab link" href="SystemDiscovery.jsp"><fmt:message key="UseSystemDiscovery"/></a>
		<br><br>
		<fmt:message key="Note"/>
		</span>
	</div>
	<div id="tabs-2">
		<table class="instSetTbl" id="emcInstSet" align="center" width="100%">
			 <tr>
				<td>
					<div class="instRow">
					 <p class="edcText"><fmt:message key="DownloadScripts"/></p>
					 <p class="instDetails"><fmt:message key="DownloadDetails"/></p>

						 <div class="target_Dwnl leftdownload"><span class="downldimg"></span>
						 	<a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1916%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A11639%2C%22id%22%3A9%2C%22downloadType%22%3A%7B%22name%22%3A%22Script%22%7D%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%7D%5D%7D' class="cloudBtn" href="#">Download for Windows</a>
						 </div>
						 <div class="target_Dwnl"><span class="downldimg"></span>
						 	<a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1916%2C%22status%22%3A0%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A11640%2C%22id%22%3A8%2C%22downloadType%22%3A%7B%22name%22%3A%22Script%22%7D%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%7D%5D%7D' class="cloudBtn" href="#">Download for Unix</a>
						 </div>

					 <br><br>
					 </div>
				</td>
			 </tr>
			 <tr>
				 <td>
					<div class="instRow">
					<p class="edcText"><fmt:message key="ScriptsOnServer"/></p>
					<div class="toggleHeading instDetails"><div class="recToggle"><fmt:message key="Windows"/><span class="middleright toggledown"></span></div>
						<div class="toggleText" id="id1">
									<ol>
								  			<li><fmt:message key="ExtractToNWServer"/></li>
								 			<li><fmt:message key="RunCommand"/></br>
								   			<span class="tabspace"><fmt:message key="EDC_Networker"/> <fmt:message key="OutputDirectory"/></span></br>
								   			<fmt:message key="ForExample"/></br>
								    		<span class="tabspace"><fmt:message key="EDC_Networker"/> c:\Temp </span></br></li>
								     		 <li><fmt:message key="OutputFilesCreatedSpecifiedDirectory"/></li>
								      		<!--<li><fmt:message key="UploadCompressedOutput"/></li>-->
									</ol>
						</div>
					 </div>
					 <div class="toggleHeading instDetails"><div class="recToggle"><fmt:message key="Unix"/><span class="middleright toggledown"></span></div>
						 <div class="toggleText" id="id2">
							 <ol>
								 <li><fmt:message key="ExtractToAnyDirectory"/><br>
								 <span class="tabspace">#tar xpvf edc_networker.tar </span>
								 </li>
								 <%-- <li><fmt:message key="RunCommand"/>dos2unix <fmt:message key="UnixFormat"/> <br/>
									 <fmt:message key="DosUnixOldNew"/><br/></li>
								 <li><fmt:message key="RunCommand"/> chmod755 *.sh <fmt:message key="MakeScriptExecutable"/> </li> --%>
								 <li><fmt:message key="ExecuteCommands"/></br>
								  <span class="tabspace">#/edc_networker.sh /<fmt:message key="OutputDirectory"/> </span><br/>
								  <fmt:message key="ForExample"/> <br/>
								  <span class="tabspace">#/edc_networker.sh /temp </span></br> </li>
								  <!--  <li><fmt:message key="UploadCompressedOutput"/></li>-->
							 </ol>
						 </div>
					 </div>
					 <br>
					 </div>
				 </td>
			 </tr>
			 <tr>
				 <td>
					 <div class="instRow">
						 <p class="edcText"><fmt:message key="UploadDataAnalysis"/></p>
						 <p class="instDetails"> <fmt:message key="UploadDataAnalysisInst"/></p>
						 <br><div class="target_Upl"><span class="upldimg"></span><a href="#" class="cloudBtn">Upload</a></div>
						 <div id="uplContentEdcNw" class="uploadDiv hidden"  title="Upload files...">

								<jsp:include page="uploadTemplate.jsp" flush="true">
									<jsp:param value="uploadformedcNw" name="formid" />
									<jsp:param value="CompanyNameEdcNw" name="companyid" />
									<jsp:param value="External Data Connector - Networker" name="requestvalue" />
									<jsp:param value="addfilestblEDC" name="addfilestableid" />
									<jsp:param value="uploadEdcNw" name="uploadnowdivid" />
									<jsp:param value="true" name="addfiles" />
									<jsp:param value="false" name="isversion" />
								</jsp:include>

						 </div>
						 <div class="uploadMsg" id="uplMsg" ></div>

					 </div>
				 </td>
			 </tr>
		</table>
	</div>
	<div id="tabs-3">
		<table class="instSetTbl" id="tsmInstSet" align="center" width="100%">
			<tr>
				<td>
					<div class="instRow">
					<p class="edcText"><fmt:message key="DownloadScripts"/></p>
					<p class="instDetails"><fmt:message key="DownloadDetails"/></p>
					<div class="target_Dwnl leftdownload"><span class="downldimg"></span>
						<a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1917%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A11641%2C%22id%22%3A9%2C%22downloadType%22%3A%7B%22name%22%3A%22Script%22%7D%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%7D%5D%7D' class="cloudBtn" href="#">Download for Windows</a>
					</div>
					<div class="target_Dwnl"><span class="downldimg"></span>
						<a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1917%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A11642%2C%22id%22%3A8%2C%22downloadType%22%3A%7B%22name%22%3A%22Script%22%7D%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%7D%5D%7D' class="cloudBtn" href="#">Download for Unix</a>
					</div>
					<br><br>
					</div>
				</td>
			</tr>
			<tr>
				<td>
				<div class="instRow">
				<p class="edcText"><fmt:message key="ScriptsOnServer"/></p>
				<div class="toggleHeading instDetails"><div class="recToggle"><fmt:message key="Windows"/><span class="middleright toggledown"></span></div>
						<div class="toggleText" id="id1">
							 <ol>
									<li><fmt:message key="Copy_edc.batIntoBaclient">
									   	<fmt:param value='<span class="bold" >baclient</span>'/>
									 </fmt:message><br/>
										<fmt:message key="edc.batOnTivoliServer"/></li>
									<li><fmt:message key="RunCommand"/></br>
										<span class="tabspace">edc_tsm.bat &lt;Tsm_login_id&gt; &lt;TSM_login_password&gt; &lt;Tsm_server_name&gt; &lt;Output_Directory&gt; </span></br>
										<fmt:message key="ForExample"/><br/>
										<span class="tabspace">edc_tsm.bat admin admin tsmserver c:\Temp </span></li>
									 <!-- <li><fmt:message key="UploadCompressedOutput"/></li>-->
							</ol>
						</div>
					 </div>
					 <div class="toggleHeading instDetails"><div class="recToggle">	<fmt:message key="Unix"/><span class="middleright toggledown"></span></div>
						 <div class="toggleText" id="id2">
							 <ol>
							 	<li><fmt:message key="Copy_edc.tsm_tar"/></br>
							 	<span class="tabspace">#tar xpvf edc_tsm.tar</span></li>
								<li><fmt:message key="Copy_edc.shIntoBaclient">
									<fmt:param value='<span class="bold" >baclient</span>'/>
								 </fmt:message>
								<fmt:message key="edc.shOnTivoliServer"/></li>
								<%-- <li><fmt:message key="RunCommand"/> dos2unix <fmt:message key="UnixFormat"/></br>
							    <fmt:message key="DosUnixOldNew"/></li>
								<li><fmt:message key="CHMOD"/></li> --%>
								<li><fmt:message key="ExecuteFromCMD"/></br>
								<span class="tabspace">#./edc_tsm.sh &lt;Tsm_login_id&gt; &lt;TSM_login_password&gt; &lt;Tsm_server_name&gt; &lt;Output_Directory&gt; </span><br/>
								<fmt:message key="ForExample"/></br>
								<span class="tabspace">#./edc_tsm.sh admin admin tivoli /temp</span></br>
								<fmt:message key="edc_data.tarCreated"/> </li>
								<!-- <li><fmt:message key="UploadCompressedOutput"/></li>-->
							</ol>
						 </div>
					 </div>
					 <br>
				</div>
				</td>
			</tr>
			<tr>
				<td>
					 <div class="instRow">
						 <p class="edcText"><fmt:message key="UploadDataAnalysis"/></p>
						 <p class="instDetails"> <fmt:message key="UploadDataAnalysisInst"/></p>
						 <br><div class="target_Upl"><span class="upldimg"></span><a href="#" class="cloudBtn">Upload</a></div>
						 <div id="uplContentEdcTsm" class="uploadDiv hidden" title="Upload files...">

						    <jsp:include page="uploadTemplate.jsp" flush="true">
								<jsp:param value="uploadformEdcTsm" name="formid" />
								<jsp:param value="CompanyNameEdcTsm" name="companyid" />
								<jsp:param value="External Data Connector - TSM" name="requestvalue" />
								<jsp:param value="addfilestblEDC" name="addfilestableid" />
								<jsp:param value="uploadEdcTsm" name="uploadnowdivid" />
								<jsp:param value="true" name="addfiles" />
								<jsp:param value="false" name="isversion" />
							</jsp:include>
						</div>
						<div class="uploadMsg" id="uplMsg" ></div>
					 </div>
				</td>
			</tr>
	</table>
	</div>
	<div id="tabs-4">
		<table class="instSetTbl" id="nbuInstSet" align="center" width="100%">
			<tr>
				<td>
					<div class="instRow">
					<p class="edcText"><fmt:message key="DownloadScripts"/></p>
					<p class="instDetails"><fmt:message key="DownloadDetails"/></p>
					<div class="target_Dwnl leftdownload"><span class="downldimg"></span>
						<a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1918%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A11643%2C%22id%22%3A9%2C%22downloadType%22%3A%7B%22name%22%3A%22Script%22%7D%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%7D%5D%7D' class="cloudBtn" href="#">Download for Windows</a>
					</div>
					<div class="target_Dwnl"><span class="downldimg"></span>
						<a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1918%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A11644%2C%22id%22%3A8%2C%22downloadType%22%3A%7B%22name%22%3A%22Script%22%7D%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%7D%5D%7D' class="cloudBtn" href="#">Download for Unix</a>
					</div>
					<br><br>
					</div>
				</td>
			</tr>
			<tr>
				<td>
				<div class="instRow">
				<p class="edcText"><fmt:message key="ScriptsOnServer"/></p>
				<div class="toggleHeading instDetails"><div class="recToggle"><fmt:message key="Windows"/><span class="middleright toggledown"></span></div>
						<div class="toggleText" id="id1">
							 <ol>
									<li><fmt:message key="edc_nbu.batOnNBServer"/></li>
									<li><fmt:message key="RunCommand"/><br/>
									<span class="tabspace">edc_nbu.bat</span></br>
									<fmt:message key="OutputFilesSaved"/> C:\temp.<br/>
									<!--  <li><fmt:message key="UploadCompressedOutput"/></li>-->
								</ol>
						</div>
					 </div>
					 <div class="toggleHeading instDetails"><div class="recToggle"><fmt:message key="Unix"/><span class="middleright toggledown"></span></div>
						 <div class="toggleText" id="id2">
							 <ol>
									<li><fmt:message key="edc_nbuExtract"> <fmt:param value = "edc_nbu.tar"/></fmt:message><br>
									<span class="tabspace">#tar xpvf edc_nbu.tar</span>
									</li>
									<li><fmt:message key="RunCommand"/><br>
										<span class="tabspace">#./ edc_nbu.sh</span><br>
										<fmt:message key="OutputFilesSaved"/> /tmp/nbdata. </li>
									<!-- <li><fmt:message key="UploadCompressedOutput"/></li>-->
							</ol>
						 </div>
					 </div>
					 <br>
				</div>
				</td>
			</tr>
			<tr>
				<td>
					 <div class="instRow">
						<p class="edcText"><fmt:message key="UploadDataAnalysis"/></p>
						 <p class="instDetails"> <fmt:message key="UploadDataAnalysisInst"/></p>
						 <br><div class="target_Upl"><span class="upldimg"></span><a href="#" class="cloudBtn">Upload</a></div>
						 <div id="uplContentEdcNbu" class="uploadDiv hidden"  title="Upload files...">

						    <jsp:include page="uploadTemplate.jsp" flush="true">
								<jsp:param value="uploadformEdcNbu" name="formid" />
								<jsp:param value="CompanyNameEdcNbu" name="companyid" />
								<jsp:param value="External Data Connector - NBU" name="requestvalue" />
								<jsp:param value="addfilestblEDC" name="addfilestableid" />
								<jsp:param value="uploadEdcNbu" name="uploadnowdivid" />
								<jsp:param value="true" name="addfiles" />
								<jsp:param value="false" name="isversion" />
							</jsp:include>
						</div>
						<div class="uploadMsg" id="uplMsg" ></div>
					 </div>
				</td>
			</tr>
		</table>
	</div>
	<div id="tabs-5">
		<table class="instSetTbl" id="bkpExecInstSet" align="center" width="100%">
			<tr>
				<td>
					<div class="instRow">
					<p class="edcText"><fmt:message key="DownloadScripts"/></p>
					<p class="instDetails"><fmt:message key="OnlyWinDownloadDetails"/></p>
					<div class="target_Dwnl leftdownload"><span class="downldimg"></span>
						<a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1919%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A11645%2C%22id%22%3A9%2C%22downloadType%22%3A%7B%22name%22%3A%22Script%22%7D%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%7D%5D%7D' class="cloudBtn" href="#">Download for Windows</a>
					</div>
					<br><br>
					</div>
				</td>
			</tr>
			<tr>
				<td>
				<div class="instRow">
					<p class="edcText"><fmt:message key="ScriptsOnServer"/></p>
					<div class="toggleHeading instDetails"><div class="recToggle"><fmt:message key="Windows"/><span class="middleright toggledown"></span></div>
						<div class="toggleText" id="id1">
							 <ol>
								 <li><fmt:message key="Copy_edc.backupexecOnBEServer"/></li>
								 <li><fmt:message key="RunCommand"/><br>
							 		<span class="tabspace">edc_backupexec.bat</span><br>
								 <fmt:message key="OutputFilesSaved"/> C:\temp.</li>
								 <!--<li><fmt:message key="UploadCompressedOutput"/></li>-->
							 </ol>
						</div>
					 </div>
					 <br>
				</div>
				</td>
			</tr>
			<tr>
				<td>
					 <div class="instRow">
						 <p class="edcText"><fmt:message key="UploadDataAnalysis"/></p>
						 <p class="instDetails"> <fmt:message key="UploadDataAnalysisInst"/></p>
						 <br><div class="target_Upl"><span class="upldimg"></span><a href="#" class="cloudBtn">Upload</a></div>
						 <div id="uplContentEdcBe" class="uploadDiv hidden" title="Upload files...">
					     	<jsp:include page="uploadTemplate.jsp" flush="true">
								<jsp:param value="uploadformEdcBe" name="formid" />
								<jsp:param value="CompanyNameEdcBe" name="companyid" />
								<jsp:param value="External Data Connector - BackupExec" name="requestvalue" />
								<jsp:param value="addfilestblEDC" name="addfilestableid" />
								<jsp:param value="uploadEdcBe" name="uploadnowdivid" />
								<jsp:param value="true" name="addfiles" />
								<jsp:param value="false" name="isversion" />
							</jsp:include>
						</div>
						<div class="uploadMsg" id="uplMsg" ></div>
					 </div>
				</td>
			</tr>
		</table>
	</div>

	<div id="tabs-6">
		<table class="instSetTbl" id="veeamInstSet" align="center" width="100%">
			<tr>
				<td>
					<div class="instRow">
					<p class="edcText"><fmt:message key="DownloadScripts"/></p>
					<p class="instDetails"><fmt:message key="OnlyWinDownloadDetails"/></p>
					<div class="target_Dwnl leftdownload"><span class="downldimg"></span>
						<a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1920%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A11646%2C%22id%22%3A9%2C%22downloadType%22%3A%7B%22name%22%3A%22Script%22%7D%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%7D%5D%7D' class="cloudBtn" href="#">Download for Windows</a>
					</div>
					<br><br>
					</div>
				</td>
			</tr>
			<tr>
				<td>
				<div class="instRow">
					<p class="edcText"><fmt:message key="ScriptsOnServer"/></p>
					<div class="toggleHeading instDetails"><div class="recToggle"><fmt:message key="Windows"/><span class="middleright toggledown"></span></div>
						<div class="toggleText" id="id1">
							 <ol>
								 <li><fmt:message key="Copy_edc.veeamOnVServer"/></li>
								 <li><fmt:message key="RunCommand"/><br>
								 <span class="tabspace">edc_veeam.bat</span><br>
								 <fmt:message key="OutputFilesSaved"/> C:\temp\EDC. </li>
								 <!--<li><fmt:message key="UploadCompressedOutput"/></li>-->
							 </ol>
						</div>
					 </div>
					 <br>
				</div>
				</td>
			</tr>
			<tr>
				<td>
					 <div class="instRow">
						 <p class="edcText"><fmt:message key="UploadDataAnalysis"/></p>
						 <p class="instDetails"> <fmt:message key="UploadDataAnalysisInst"/></p>
						 <br><div class="target_Upl"><span class="upldimg"></span><a href="#" class="cloudBtn">Upload</a></div>
						 <div id="uplContentEdcV" class="uploadDiv hidden" title="Upload files...">
					    	<jsp:include page="uploadTemplate.jsp" flush="true">
								<jsp:param value="uploadformEdcV" name="formid" />
								<jsp:param value="CompanyNameEdcV" name="companyid" />
								<jsp:param value="External Data Connector - Veeam" name="requestvalue" />
								<jsp:param value="addfilestblEDC" name="addfilestableid" />
								<jsp:param value="uploadEdcV" name="uploadnowdivid" />
								<jsp:param value="true" name="addfiles" />
								<jsp:param value="false" name="isversion" />
							</jsp:include>
						</div>
						<div class="uploadMsg" id="uplMsg" ></div>
					 </div>
				</td>
			</tr>
		</table>
	</div>
	<div id="tabs-7">
		<table class="instSetTbl" id="nbuflaInstSet" align="center" width="100%">
		<tr>
			<td>
				<div class="instRow">
				<p class="edcText"><fmt:message key="DownloadScripts"/></p>
				<p class="instDetails"><fmt:message key="DownloadDetails"/></p>
				<div class="target_Dwnl leftdownload"><span class="downldimg"></span>
					<a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A2258%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A11647%2C%22id%22%3A9%2C%22downloadType%22%3A%7B%22name%22%3A%22Script%22%7D%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%7D%5D%7D'  class="cloudBtn" href="#">Download for Windows</a>
				</div>
				<div class="target_Dwnl"><span class="downldimg"></span>
					<a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A2258%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A11648%2C%22id%22%3A8%2C%22downloadType%22%3A%7B%22name%22%3A%22Script%22%7D%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%7D%5D%7D'  class="cloudBtn" href="#">Download for Unix</a>
				</div>
				<br><br>
				</div>
			</td>
		</tr>
		<tr>
			<td>
			<div class="instRow">
				<p class="edcText"><fmt:message key="ScriptsOnServer"/></p>
				<div class="toggleHeading instDetails"><div class="recToggle"><fmt:message key="Windows"/><span class="middleright toggledown"></span></div>
					<div class="toggleText" id="id1">
						 <ol>
							<li><fmt:message key="Copy_edc_nbu_fla.batOnNBServer"/></li>
							<li><fmt:message key="RunCommand"/><br>
							<span class="tabspace">edc_nbu_fla.bat</span> <br>
							<fmt:message key="OutputFilesSavedSpecifiedDirectory"/></li>
							<!--<li><fmt:message key="UploadCompressedOutput"/></li>-->
						 </ol>
					</div>
				 </div>
					<div class="toggleHeading instDetails"><div class="recToggle"><fmt:message key="Unix"/><span class="middleright toggledown"></span></div>
					 <div class="toggleText" id="id2">
						 <ol>
							<li><fmt:message key="edc_nbuExtract"> <fmt:param value = "edc_nbu_fla.tar"/></fmt:message><br>
									<span class="tabspace">#tar xpvf edc_nbu_fla.tar</span></li>
							<li><fmt:message key="RunCommand"/> <br>
								<span class="tabspace">edc_nbu_fla.sh</span> <br>
								<fmt:message key="OutputFilesSaved"/> /tmp/netbackup-fla.</li>
							<!-- <li><fmt:message key="UploadCompressedOutput"/></li>-->
						</ol>
					 </div>
				 </div>
				 <br>
			</div>
			</td>
		</tr>
		<tr>
			<td>
				 <div class="instRow">
					 <p class="edcText"><fmt:message key="UploadDataAnalysis"/></p>
						 <p class="instDetails"> <fmt:message key="UploadDataAnalysisInst"/></p>
						 <br><div class="target_Upl"><span class="upldimg"></span><a href="#" class="cloudBtn">Upload</a></div>
					 <div id="uplContentEdcNbuFla" class="uploadDiv hidden"  title="Upload files...">
			    		<jsp:include page="uploadTemplate.jsp" flush="true">
							<jsp:param value="uploadformEdcNbuFla" name="formid" />
							<jsp:param value="CompanyNameEdcNbuFla" name="companyid" />
							<jsp:param value="External Data Connector - NBUFLA" name="requestvalue" />
							<jsp:param value="addfilestblEDC" name="addfilestableid" />
							<jsp:param value="uploadEdcV" name="uploadnowdivid" />
							<jsp:param value="true" name="addfiles" />
							<jsp:param value="false" name="isversion" />
						</jsp:include>

					</div>
					<div class="uploadMsg" id="uplMsg" ></div>
				 </div>
			</td>
		</tr>
	</table>

	</div>
	<div id="tabs-8" class="edc-tabs">
		<table class="instSetTbl" id="dpaInstSet" align="center" width="100%">
			<tr>
				<td>
					<div class="instRow">
					<p class="edcText"><fmt:message key="DownloadScripts"/></p>
					<p class="instDetails"><fmt:message key="OnlyUnixDownloadDetails"/></p>
					<div class="target_Dwnl leftdownload"><span class="downldimg"></span>
						<a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A4188%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A11649%2C%22id%22%3A8%2C%22downloadType%22%3A%7B%22name%22%3A%22Script%22%7D%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%7D%5D%7D' class="cloudBtn" href="#">Download for Unix</a>
					</div>

					<br><br>
					</div>
				</td>
			</tr>
			<tr>
				<td>
				<div class="instRow">
					<p class="edcText"><fmt:message key="ScriptsOnServer"/></p>
					<div class="toggleHeading instDetails"><div class="recToggle"><fmt:message key="Unix"/><span class="middleright toggledown"></span></div>
						<div class="toggleText" id="id1">
							 <ol>
								 <li><fmt:message key="edc.emcdpa.extract"/><br>
								 <span class="tabspace">#tar xpvf edc_dpa.tar</span>
								 </li>
								 <li><fmt:message key="edc.emcdpa.copy"/></li>
								 <li><fmt:message key="edc.emcdpa.swtchcmd" >
									   <fmt:param value='<span class="italic bold" >su - oracle</span>'/>
									 </fmt:message><br><span class="italic tabspace">#su - oracle</span>
								 </li>
								 <li><fmt:message key="RunCommand"/>
									 <br><span class="italic tabspace">#./edc_dpa.sh</span>
									 <br><fmt:message key="OutputFilesSaved"/> /home/oracle.
								 </li>
								 <!-- <li><fmt:message key="UploadCompressedOutput"/></li> -->
							 </ol>
						</div>
					 </div>
					 <br>
				</div>
				</td>
			</tr>
			<tr>
				<td>
					 <div class="instRow">
						 <p class="edcText"><fmt:message key="UploadDataAnalysis"/></p>
						 <p class="instDetails"> <fmt:message key="UploadDataAnalysisInst"/></p>
						 <br><div class="target_Upl"><span class="upldimg"></span><a href="#" class="cloudBtn">Upload</a></div>
						 <div id="uplContentEdcBe" class="uploadDiv hidden" title="Upload files...">
					     	<jsp:include page="uploadTemplate.jsp" flush="true">
								<jsp:param value="uploadformEdcDpa" name="formid" />
								<jsp:param value="CompanyNameEdcDpa" name="companyid" />
								<jsp:param value="External Data Connector - EMC DPA" name="requestvalue" />
								<jsp:param value="addfilestblEDCDpa" name="addfilestableid" />
								<jsp:param value="uploadEdcDpa" name="uploadnowdivid" />
								<jsp:param value="true" name="addfiles" />
								<jsp:param value="false" name="isversion" />
							</jsp:include>
						</div>
						<div class="uploadMsg" id="uplMsg" ></div>
					 </div>
				</td>
			</tr>
		</table>
	</div>
</div>

<jsp:include page="generateAccount.jsp" flush="true"/>
<jsp:include page="../../common/footer.jsp" >
	<jsp:param value="${pageContext.request.contextPath}/common/js/jquery.loadmask.cv.js" name="js"/>
</jsp:include>


