<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>

<fmt:setBundle basename="localization.CloudMessages"/>
<jsp:include page="../../common/header.jsp">
    	<jsp:param value="System Discovery" name="title" />
    	<jsp:param value="System Discovery" name="titleLocalized" />
    	<jsp:param value="css/ui-lightness/jquery-ui-1.8.20.custom.css" name="css" />
    	<jsp:param value="../../common/css/templatestyles.css" name="css" />
		<jsp:param value="../../common/css/headerstyles.css" name="css" />
		<jsp:param value="${pageContext.request.contextPath}/common/css/jquery.loadmask.css" name="css" />
    	<jsp:param value="css/cloud.css" name="css" />
    	<jsp:param value="js/edcservices.js" name="js" />
    	<jsp:param value="js/jquery.form.js" name="js" />
    	<jsp:param value="css/edcstyles.css" name="css" />
    	<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="SystemDiscovery" name="headerTitle" />
		<jsp:param value="Cloud Applications:../applications/cloudApps.jsp" name="breadCrumbValues" />
 </jsp:include>

<div id="edctabs">
	<ul class="noleftpadding">
		<li><a href="#tabs-SysFiles"><fmt:message key="Files" /></a></li>
		<li><a href="#tabs-SysExch"><fmt:message key="Emails" /></a></li>
		<li><a href="#tabs-SysDB"><fmt:message key="Databases" /></a></li>
		<li><a href="#tabs-SysHYPV"><fmt:message key="VirtualMachines" /></a></li>
		<li><a href="#tabs-SysApp"><fmt:message key="Application" /></a></li>
	</ul>
	<div id="tabs-SysFiles" class="sys-arch-tab">
		<fmt:message key="SystemDiscoveryArchiveAnalyzerDescrip" />
		<br><br>
		<fmt:message key="SystemDiscoveryArchiveAnalyzerActions" />
		<br>
		<fmt:message key="ImportantUseCases" /><br>
		<span class="infopadding"> <fmt:message key="FileSystemAnalysis" /></span><br/>
		<span class="infopadding"> <fmt:message key="IdentifyFilesArchiving" /> </span><br/>
		<span class="infopadding"> <fmt:message key="AssistDataProtectionEstimates" /></span><br/>
		<br/>
		<fmt:message key="VirtualCommCell" /><br/>
		<span class="infopadding"> <fmt:message key="VC.OperatingSystem" /></span><br/>
		<span class="infopadding"> <fmt:message key="VC.AmountOfSpaceOnServer" /></span><br/>
		<span class="infopadding"> <fmt:message key="VC.TotalMemory" /></span><br/>
		<span class="infopadding"> <fmt:message key="VC.FileInfo" /></span><br/>
		<span class="infopadding"> <fmt:message key="VC.FileTypes" /></span><br/><br/>


		<fmt:message key="CollectAppData"/> <a class="gotoTab link" tabid="SysApp"> <fmt:message key="SystemDiscoveryForApplications"/></a>
		<br/><br/>

		<div id="togglecustView" class="focusText"><fmt:message key="CustomerSelfServiceAccess" /><br/><br/>
		<a href="#"  class="cloudBtn target_createAcc" id="sys"><fmt:message key="AuthCode" /></a>
		</div>
		<br/><fmt:message key="AccessScripts" />
		<table class="instSetTbl" id="SysDiscInstSet" align="center" width="100%">
			 <tr>
				<td>
					<div class="instRow">
					 <p class="edcText"><fmt:message key="DownloadTool" /></p>
					 <p class="instDetails"><fmt:message key="DownloadExeFile" /></p>
					 <a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1913%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A2091%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%2C%22id%22%3A10%2C%22downloadType%22%3A%7B%22name%22%3A%22Exe%22%7D%7D%5D%7D' packageId="1913" runat="server"  class="cloudBtn target_Dwnl">32 bit Download</a><span class="infopadding">&nbsp;</span>
					 <a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1912%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A2090%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%2C%22downloadType%22%3A%7B%22name%22%3A%22Exe%22%7D%2C%22id%22%3A11%7D%5D%7D' runat="server" packageId="1912" class="cloudBtn target_Dwnl">64 bit Download</a>
					 <br><br>
					</div>
				</td>
			 </tr>
			 <tr>
				 <td>
					<div class="instRow">
					<p class="edcText"><fmt:message key="RunTool" /></p>
					<div class="toggleHeading instDetails"><div class="recToggle"><fmt:message key="ArchivePredictionFileDistribution" /><span class="middleright toggledown"></span></div>
						<div class="toggleText" id="id1">
						<span class="bold"><fmt:message key="Notes"/>:</span><span class="infopadding"><fmt:message key="sysdisc.prediction.note"/></span>
						<br><br>
							 <ol>
								 <li class="nobottompadding"><fmt:message key="SystemDiscoveryTool" var="systemdiscoverytool" /> <fmt:message key="OpenThe"> <fmt:param value = "${systemdiscoverytool}"/>.</fmt:message></li>
								 <li class="nobottompadding"><fmt:message key="TypeOfScan" /></li>
								 <li class="nobottompadding"><fmt:message key="SelectOS" />
										<ul>
										<li><fmt:message key="WIN/NAS" /></li>
										<li><fmt:message key="UNIX/LINUX" /></li>
										</ul>
										<fmt:message key="ApplicationData"/>
								</li>
								 <li class="nobottompadding"><fmt:message key="DetectComputers" />
								 	<ol>
								 		<li><fmt:message key="DirectoryServer"/></li>
								 		<li><fmt:message key="DomainName" /> </li>
								 		<li><fmt:message key="DomainAdministrator" /> <br>
								 		<fmt:message key="DomainAdministratorAccess" /></li>
								 	</ol>
								 </li>

								 <li class="nobottompadding"><fmt:message key="ManuallySpecifyComputers" />
									<ol>
									<li><fmt:message key="EnterNamesofComputers" /></br>
									<fmt:message key="OneEntryPerLine" /><br>
									\\file_server\share.
									</li>
									<li><fmt:message key="ImportComputerNames" /><br>
									<fmt:message key="OneHost/UNCPerLine" />
									</li>
									<li><fmt:message key="AdministratorCredentialsInformation" /><br>
										<fmt:message key="AdministratorMustHaveAccess" />
									</li>
									</ol>
								 </li>
								<li class="nobottompadding"><fmt:message key="FileOwnerNames" />
									<ol>
										<li><fmt:message key="User+GroupNames" />.</li>
										<li><fmt:message key="FileNamesUnreadable" />.</li>
										<li><fmt:message key="ClickNext" /></span>.<br>
										<fmt:message key="AdminMustHaveRead/WritePermissions"/></li>
										<li><fmt:message key="DiscoveryComputer"/></li>
									</ol>
								</li>
								<li class="nobottompadding"><fmt:message key="SkipFileLevel" />. </li>
								<li class="nobottompadding"><fmt:message key= "SummaryPage"/>
								<br><fmt:message key="ReturntoPreviousPages" />
								<br><fmt:message key="ZipOfComputerAnalysis" />
								</li>
							</ol><br/>

						</div>
					 </div>
					 <br>
					 </div>
				 </td>
			 </tr>
			 <tr>
				 <td>
					 <div class="instRow">
							<p class="edcText"><fmt:message key="UploadDataAnalysis" /></p>
							<p class="instDetails"><fmt:message key="UploadDataAnalysisInst" />
						 	</p>
							<a href="#" class="cloudBtn target_Upl">Upload</a>
						  <div id="uplContentSys" class="uploadDiv hidden" title="Upload files...">


							<jsp:include page="uploadTemplate.jsp" flush="true">
								<jsp:param value="uploadformSys" name="formid" />
								<jsp:param value="CompanyNameSys" name="companyid" />
								<jsp:param value="System Discovery - Files" name="requestvalue" />
								<jsp:param value="addfilestblSys" name="addfilestableid" />
								<jsp:param value="uploadSys" name="uploadnowdivid" />
								<jsp:param value="true" name="addfiles" />
							</jsp:include>
						</div>
						<div class="uploadMsg"></div>
					 </div>
				 </td>
			 </tr>
		</table>
	</div>
	<div id="tabs-SysExch" class="sys-arch-tab">
		<p><fmt:message key="EmailSystemDiscovery" /><br><br>
		<fmt:message key="KeyFeatures" /><br>
		<span class="infopadding"><fmt:message key="SpecifyRegularExpressions" /></span><br/>
		<span class="infopadding"> <fmt:message key="RunMultipleInstancesOfTool" /></span><br/>
		<br>
		<fmt:message key="ImportantUseCases" /><br>
		<span class="infopadding"> <fmt:message key="IdentifyEmailsForArchiving" /></span><br/>
		<span class="infopadding"> <fmt:message key="AssistDataProtectionEstimates" /></span><br/>
		<span class="infopadding"> <fmt:message key="MailboxLevelAnalysis" /></span><br/>
		<br>
		<div id="togglecustView" class="focusText"><fmt:message key="CustomerSelfServiceAccess" /><br/><br/>
		<a href="#"  class="target_createAcc cloudBtn" id="sys"><fmt:message key="AuthCode" /></a>
		</div>
		<br/><fmt:message key="AccessScripts" />
		<table class="instSetTbl" id="SysDiscInstSetMail" align="center" width="100%">
			<tr>
				<td>
					<div class="instRow">
					 <p class="edcText"><fmt:message key="DownloadTool" /></p>
					 <p class="instDetails"><fmt:message key="DownloadExeFile" /></p>
					 <a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1915%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A2093%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%2C%22downloadType%22%3A%7B%22name%22%3A%22Exe%22%7D%2C%22id%22%3A10%7D%5D%7D' packageId="1915" runat="server"  class="cloudBtn target_Dwnl">32 bit Download</a><span class="infopadding">&nbsp;</span>
					<a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1914%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A2092%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%2C%22downloadType%22%3A%7B%22name%22%3A%22Exe%22%7D%2C%22id%22%3A11%7D%5D%7D' packageId="1914" runat="server"  class="cloudBtn target_Dwnl">64 bit Download</a>
					<br><br>
					 </div>
				</td>
			 </tr>
			 <tr>
				 <td>
					<div class="instRow">
						<p class="edcText"><fmt:message key="RunTool" /></p>
						<div class="toggleHeading instDetails"><div class="recToggle"><fmt:message key="RunScriptinst" /><span class="middleright toggledown"></span></div>
							<div class="toggleText" id="id1">
								 <ol>
									 <li><fmt:message key="ServiceAccount" /> <a href="http://documentation.commvault.com/commvault/v10/article?p=features/cloud_db/email_discovery_tool_getting_started.htm" runat="server" target="blank"><span class="boldunderline"><fmt:message key="Documentation" /></span></a> </li>
									<li><fmt:message key="ToolInputs" />
										<ol class="exchangeinputoptions">
											<li><fmt:message key="ServiceAccountDetails" /></li>
											<li><fmt:message key="ExchangeServerNames" /></li>
											<li><fmt:message key="MailboxNames" /></li>
											<li><fmt:message key="FolderNames" /></li>
											<li><fmt:message key="Age+Size" /></li>
										</ol>
									</li>
								</ol>
							</div>
						 </div>
						 <br>
					 </div>
				 </td>
			 </tr>
			 <tr>
				 <td>
					 <div class="instRow">
						<p class="edcText"><fmt:message key="UploadDataAnalysis" /></p>
						<p class="instDetails"> <fmt:message key="UploadDataAnalysisInst" />
						 </p>
						<a href="#" class="cloudBtn target_Upl">Upload</a>
						<div id="uplContentSysExch" class="uploadDiv hidden"  title="Upload files...">
							<jsp:include page="uploadTemplate.jsp" flush="true">
								<jsp:param value="uploadformSysEmail" name="formid" />
								<jsp:param value="CompanyNameSysEmail" name="companyid" />
								<jsp:param value="System Discovery - Emails" name="requestvalue" />
								<jsp:param value="addfilestblSysEmail" name="addfilestableid" />
								<jsp:param value="uploadSysEmail" name="uploadnowdivid" />
								<jsp:param value="true" name="addfiles" />
							</jsp:include>

						</div>
						<div class="uploadMsg" id="uplMsg"></div>
					 </div>
				 </td>
			 </tr>
		</table>
	</div>
	<div id="tabs-SysDB" class="sys-arch-tab">
			<p><fmt:message key="DatabaseArchivePrediction" /><br/><br/>
		<fmt:message key="KeyFeatures" /> <br>
		<span class="infopadding"> <fmt:message key="DependentTableHierarchyOfDBTables" /></span><br/>
		<span class="infopadding"> <fmt:message key="DefineAdditionalRelations" /></span><br/>
		<span class="infopadding"> <fmt:message key="EstimatedDiskSavings" /></span><br/><br/>
		<div id="togglecustView" class="focusText"><fmt:message key="CustomerSelfServiceAccess" /><br/><br/>
		<a href="#"  class="target_createAcc cloudBtn" id="sys"><fmt:message key="AuthCode" /></a>
		</div>
		<br/><fmt:message key="AccessScripts" />
		<table class="instSetTbl" id="SysDiscInstSet" align="center" width="100%">
			 <tr>
				<td>
					<div class="instRow">
					 <p class="edcText"><fmt:message key="DownloadTool" /></p>
					 <p class="instDetails"><fmt:message key="DownloadSelfExtractingJar" /></p>
					 <a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A2379%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A2565%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%2C%22downloadType%22%3A%7B%22name%22%3A%22Native%20Installer%22%7D%2C%22id%22%3A1%7D%5D%7D' packageId="2379" runat="server"  class="cloudBtn target_Dwnl">Download for Oracle</a>
					<br><br>
					 </div>
				</td>
			 </tr>
			 <tr>
				 <td>
					<div class="instRow">
						<p class="edcText"><fmt:message key="RunTool" /></p>
						<div class="toggleHeading instDetails"><div class="recToggle"><fmt:message key="RunScriptinst" /><span class="middleright toggledown"></span></div>
							<div class="toggleText" id="id1">
								 <ol>
									 <li><fmt:message key="SelectJarFile" /> </li>
									<li><fmt:message key="DBConnectivityInfo" /></li>
									<li><fmt:message key="VirtualForeignKeys" /></li>
									<li><fmt:message key="SelectDrivingTable" /></li>
									<li><fmt:message key="EnterSQLQuery" /></li>
									<li><fmt:message key="RunPrediction" /></li>
									<li><fmt:message key="PredictonResults" /></li>
									<li><fmt:message key="UploadResults" /> </li>

								</ol>
							</div>
						 </div>
						 <br>
					 </div>
				 </td>
			 </tr>
			 <tr>
				 <td>
					 <div class="instRow">
							<p class="edcText"><fmt:message key="UploadDataAnalysis" /></p>
							<p class="instDetails"><fmt:message key="UploadDataAnalysisInst" />
						 </p>
							<a href="#" class="cloudBtn target_Upl">Upload</a>
						  <div id="uplContentSys" class="uploadDiv hidden"  title="Upload files...">
							<jsp:include page="uploadTemplate.jsp" flush="true">
								<jsp:param value="uploadformSysDB" name="formid" />
								<jsp:param value="CompanyNameSysDB" name="companyid" />
								<jsp:param value="System Discovery - Databases" name="requestvalue" />
								<jsp:param value="addfilestblSysDB" name="addfilestableid" />
								<jsp:param value="uploadSysDB" name="uploadnowdivid" />
								<jsp:param value="true" name="addfiles" />
							</jsp:include>

						</div>
						<div class="uploadMsg"></div>
					 </div>
				 </td>
			 </tr>
		</table>
	</div>

	<div id="tabs-SysHYPV" class="sys-arch-tab">
		<p>
			<fmt:message key="SystemDiscoveryDescrip" /><br><br>
			<fmt:message key="SystemDiscoveryHypervisors" /><br><br>
		</p>
		<div class="toggleHeading instDetails"><div class="recToggle bold"><fmt:message key="VCenter" /><span class="middleright toggledown"></span></div>
			<div class="toggleText" id="id1">
				<span class="infopadding"> <fmt:message key="NameVM" /></span><br/>
				<span class="infopadding"> <fmt:message key= "SizeVMwithGuestSize"/></span><br/>
				<span class="infopadding"> <fmt:message key="GuestOS" /></span><br/>
				<span class="infopadding"> <fmt:message key="DaysVMPoweredOff" /></span><br/>
				<span class="infopadding"> <fmt:message key="PerformanceMetrics" /></span><br/>
				<span class="infopadding"> <fmt:message key="CPUSockets" /></span><br/><br/>
			</div>
		</div>
		<div class="toggleHeading instDetails"><div class="recToggle bold"><fmt:message key="HyperV" /><span class="middleright toggledown"></span></div>
			<div class="toggleText" id="id1">
				<span class="infopadding"> <fmt:message key="NameVM" /></span><br/>
				<span class="infopadding"> <fmt:message key="SizeVM"></fmt:message></span><br/>
				<span class="infopadding"> <fmt:message key="GuestOS" /></span><br/>
				<span class="infopadding"> <fmt:message key="CPUSockets" /></span><br/><br/>
			</div>
		</div>
		<div class="toggleHeading instDetails"><div class="recToggle bold"><fmt:message key="Amazon" /><span class="middleright toggledown"></span></div>
			<div class="toggleText" id="id1">
				<span class="infopadding"> <fmt:message key="InstanceName" /></span><br/>
				<span class="infopadding"> <fmt:message key="InstanceType" /></span><br/>
				<span class="infopadding"> <fmt:message key="AvailabilityZone" /></span><br/>
				<span class="infopadding"> <fmt:message key="Region" /></span><br/>
				<span class="infopadding"> <fmt:message key="ProvisionedSize" /></span><br/>
				<span class="infopadding"> <fmt:message key="GuestOS" /></span><br/><br/>
			</div>
		</div>
		<div class="toggleHeading instDetails"><div class="recToggle bold"><fmt:message key="Azure" /><span class="middleright toggledown"></span></div>
			<div class="toggleText" id="id1">
				<span class="infopadding"> <fmt:message key="NameVM" /></span><br/>
				<span class="infopadding"> <fmt:message key="Location" /></span><br/>
				<span class="infopadding"> <fmt:message key="ResourceGroups" /></span><br/>
				<span class="infopadding"> <fmt:message key="StorageAccount" /></span><br/>
				<span class="infopadding"> <fmt:message key="ProvisionedSize" /></span><br/>
				<span class="infopadding"> <fmt:message key="InstanceType" /></span><br/>
				<span class="infopadding"> <fmt:message key="GuestOS" /></span><br/><br/>
			</div>
		</div>
		<br>
		<p><fmt:message key="CollectedData" /></p>
		<ol class="sysVm">
			<li><fmt:message key="VMAnalyticsReport" />
				<br><span class="infopadding"></span> <span class="infopadding"></span> <span class="infopadding"></span> *<fmt:message key="VMArchivingPrediction" /></li>
			<li><fmt:message key="VMDetails" /></li>
		</ol>
		<br>
		<fmt:message key="Prerequisites" /><br/>
			<span class="infopadding"> <fmt:message key="Framework" /></span><br><br>
		<div id="togglecustView" class="focusText"><fmt:message key="CustomerSelfServiceAccess" /><br/><br/>
		<a href="#"  class="target_createAcc cloudBtn" id="sys"><fmt:message key="AuthCode" /></a>
		</div>
		<br/><fmt:message key="AccessTool" />
		<table class="instSetTbl" id="SysDiscInstSet" align="center" width="100%">
			 <tr>
				<td>
					<div class="instRow">
					 <p class="edcText"><fmt:message key="DownloadTool" /></p>
					 <p class="instDetails"><fmt:message key="DownloadExeFileAnyServer" /></p>
					 <a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A2721%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A2908%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%2C%22downloadType%22%3A%7B%22name%22%3A%22Exe%22%7D%2C%22id%22%3A11%7D%5D%7D' packageId="2721" runat="server"  class="cloudBtn target_Dwnl">64 bit Download</a>
					<br><br>
					 </div>
				</td>
			 </tr>
			 <tr>
				 <td>
					<div class="instRow">
						<p class="edcText"><fmt:message key="RunTool" /></p>
						<div class="toggleHeading instDetails"><div class="recToggle"><fmt:message key="RunToolInst" /><span class="middleright toggledown"></span></div>
							<div class="toggleText" id="id1">
								 <ol>
									 <li><fmt:message key="VMSystemDisc" /> <br/>
									<fmt:message key="vmSystemDiscFolder" /> <br/>
									<fmt:message key="CantExtractDirectly" />
									 </li>
									 <li><fmt:message key="vExplore" />
										 <ol>
											<li> <fmt:message key="SelectHypervisor"/></li>
											<li> <fmt:message key="HostNameIPone" /> </li>
											<li> <fmt:message key="ClickOK" /> </li>
											<li> <fmt:message key="NodeMenu" /></li>
											<li> <fmt:message key="RightClickEntity" /></li>
										   <li> <fmt:message key="VMare" />
												<ul>
													<li><fmt:message key="CPU" /></li>
													<li><fmt:message key="Disk" /></li>
													<li><fmt:message key="Network" /></li>
													<li><fmt:message key="VMPoweredOff" /></li>
												</ul>
											</li>
											<li> <fmt:message key="ClickOK" />
											<br> <fmt:message key="ProgressIndicator" />

											</li>
											<li><fmt:message key="SaveCollectedData" />
											<br> <fmt:message key="EnableUploadToCloud"/></li>
											<li><fmt:message key="GenerateReportLocally" /></li>
										</ol>
									</li>
								</ol>
							</div>
						 </div>
						 <br>
					 </div>
				 </td>
			 </tr>
			 <tr>
				 <td>
					 <div class="instRow">
							<p class="edcText"><fmt:message key="UploadDataAnalysis" /></p>
							<div class="toggleText" id="id1">
							<p class="instDetails"><fmt:message key="OptionsToUploadCollectedData" /></p>
							<ol class="hypevV">
								<li><fmt:message key="vExplorerTool" />
								<ol>
									<li><fmt:message key="UploadToCloud" />
									<br><fmt:message key="UseDefaultValue" /></li>
									<li><fmt:message key="EnterUsernamePassword" /></li>
									<li><fmt:message key="NameOfOrganization" /> </li>
									<li><fmt:message key="SpecifyRecipient" /> </li>
									<li><fmt:message key="ClickOK" />.</li>
								</ol></li>
								<li><fmt:message key="UploadToCloudServices" />
									<ol>
										<li><fmt:message key="UploadToCloudServices.step1" />
										<br><fmt:message key="UploadToCloudServices.step2" /></li>
										<li><fmt:message key="UploadToCloudServices.step3" /></li>
									</ol>
								 <br><br>

									  <a href="#" class="cloudBtn target_Upl">Upload</a>
									  <div id="uplContentSys" class="uploadDiv hidden"  title="Upload files...">

									  	<jsp:include page="uploadTemplate.jsp" flush="true">
											<jsp:param value="uploadformSysVM" name="formid" />
											<jsp:param value="CompanyNameSysVM" name="companyid" />
											<jsp:param value="VM System Discovery" name="requestvalue" />
											<jsp:param value="addfilestblSysVM" name="addfilestableid" />
											<jsp:param value="uploadSysVM" name="uploadnowdivid" />
										</jsp:include>

									  </div>
									  <div class="uploadMsg"></div>
								</li>
							</ol>
						</div>
					 </div>
				 </td>
			 </tr>
		</table>
	</div>



	<div id="tabs-SysApp" class="sys-arch-tab">
			<fmt:message key="SystemDiscoveryArchiveAnalyzerDescrip" /><br/><br/>
		<fmt:message key="VirtualCommCellEnvironment" /><br/>
		<fmt:message key="ImportantUseCases" /><br/>
		<span class="infopadding"> <fmt:message key="DetectsInstalledApplication" /></span></span>
		<br><span class="infopadding"> <span class="infopadding"> <fmt:message key="SystemsAlreadyProtected" /></span></span><br/>
		<span class="infopadding"> <fmt:message key="AssistDataProtectionEstimates" /></span><br/><br/>

		<fmt:message key="ViewWebConsoleReports" /><br/>
		<span class="infopadding"> <fmt:message key="TypesAndSizesIfNotProtected" /></span><br/>
		<span class="infopadding"> <fmt:message key="AgentsForDataProtection" /></span><br/><br/>

		<fmt:message key="CollectFileLevelData" /> <a class="gotoTab link" tabid="SysFiles"><fmt:message key="SystemDiscoveryForFileSystem" /></a>.
		<br><br>

		<div id="togglecustView" class="focusText"><fmt:message key="CustomerSelfServiceAccess" /><br/><br/>
		<a href="#"  class="target_createAcc cloudBtn" id="sys"><fmt:message key="AuthCode" /></a>
		</div>
		<br/><fmt:message key="AccessScripts" />
		<table class="instSetTbl" id="SysDiscInstSet" align="center" width="100%">
			 <tr>
				<td>
					<div class="instRow">
					 <p class="edcText"><fmt:message key="DownloadTool" /></p>

					 <p class="instDetails"><fmt:message key="DownloadExeFile" /></p>
					 <a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1913%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A2091%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%2C%22location%22%3A%22%2F11.0%2Fcommon%2FEDC%2FCVSysDiscoveryUI32.exe%22%2C%22downloadType%22%3A%7B%22name%22%3A%22Exe%22%7D%2C%22id%22%3A10%7D%5D%7D' packageId="1913" runat="server"  class="cloudBtn target_Dwnl">32 bit Download</a><span class="infopadding"> &nbsp;</span>
					 <a href='https://cloud.commvault.com/webconsole/downloadcenter/downloadPackage.do?packageData=%7B%22packageId%22%3A1912%2C%22platforms%22%3A%5B%7B%22pkgPlatformMapId%22%3A2090%2C%22pkgRepository%22%3A%7B%22repositoryId%22%3A2%7D%2C%22location%22%3A%22%2F11.0%2Fcommon%2FEDC%2FCVSysDiscoveryUI64.exe%22%2C%22downloadType%22%3A%7B%22name%22%3A%22Exe%22%7D%2C%22id%22%3A11%7D%5D%7D' runat="server" packageId="1912" class="cloudBtn target_Dwnl">64 bit Download</a>
					 <br><br>
					 </div>
				</td>
			 </tr>
			 <tr>
				 <td>
					<div class="instRow">
						<p class="edcText"><fmt:message key="RunTool" /></p>

					 	<div class="toggleHeading instDetails"><div class="recToggle"><fmt:message key="ApplicationDiscovery" /><span class="middleright toggledown"></span></div>
							<div class="toggleText" id="id3">
								 <ol>
									 <li class="nobottompadding"><fmt:message key="OpenSystemDiscovery" /></li>
									 <li class="nobottompadding"><fmt:message key="ApplicationDataScan"/>
									</li>
									 <li class="nobottompadding"><fmt:message key="DetectComputers" />
										<ol>
											<li><fmt:message key="DirectoryServerSelection" /> </li>
											<li><fmt:message key="DomainAdminCredentials" /><br>
											<fmt:message key="AdministratorMustHaveAccess" />
											</li>
										</ol>
									 </li>

									 <li class="nobottompadding"><fmt:message key="ManuallySpecifyComputers" />
										<ol>
										<li><fmt:message key="EnterNamesofComputers" />
											<br><fmt:message key="ComputerSelectionten" />
											<br>\\file_server\share.
										</li>
										<li><fmt:message key="ImportComputerNames" />
										<br><fmt:message key="OneHost/UNCPerLine" />
										</li>
										<li><fmt:message key="AdministratorCredentials" />
											<br><fmt:message key="AdministratorMustHaveAccess" />
										</li>
										</ol>
									 </li>

									<li class="nobottompadding"><fmt:message key="VerifySelectionsSummaryPage"/>
									<br><fmt:message key="ReturntoPreviousPages" />
									<br><fmt:message key="ZipFileCreated" />

									</li>
								</ol><br/>

							</div>
						 </div>
					 <br>
					 </div>
				 </td>
			 </tr>
			 <tr>
				 <td>
					 <div class="instRow">
							<p class="edcText"><fmt:message key="UploadDataAnalysis" /></p>
							<p class="instDetails"><fmt:message key="UploadDataAnalysisInst" /> </p>
							<a href="#" class="cloudBtn target_Upl">Upload</a>
						  <div id="uplContentSys" class="uploadDiv hidden" title="Upload files...">
							<jsp:include page="uploadTemplate.jsp" flush="true">
								<jsp:param value="uploadformSysApp" name="formid" />
								<jsp:param value="CompanyNameSysApp" name="companyid" />
								<jsp:param value="System Discovery - Application" name="requestvalue" />
								<jsp:param value="addfilestblSysApp" name="addfilestableid" />
								<jsp:param value="uploadSysApp" name="uploadnowdivid" />
								<jsp:param value="true" name="addfiles" />
							</jsp:include>
						</div>
						<div class="uploadMsg"></div>
					 </div>
				 </td>
			 </tr>
		</table>
	</div>
</div>
<%@include file="generateAccount.jsp" %>
<jsp:include page="../../common/footer.jsp">
	<jsp:param value="${pageContext.request.contextPath}/common/js/jquery.loadmask.cv.js" name="js"/>
</jsp:include>

