<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.CIReportsMessages">
	<fmt:message key="SysDiscovery_Report" var="headerTitle" />
</fmt:bundle>
<jsp:include page="../common/header.jsp">
	<jsp:param value="true" name="includeSecHeader" />		
	<jsp:param value="${headerTitle}" name="titleLocalized" />
	<jsp:param value="${headerTitle}" name="headerTitleLocalized" />
	<jsp:param value="../common/css/templatestyles.css" name="css" />
	<jsp:param value="../common/css/headerstyles.css" name="css" />
	<jsp:param value="../summary/css/summarystyles.css" name="css" />
	<jsp:param value="true" name="includeHistory" />
	<jsp:param value="true" name="includeTableSupport" />
	<jsp:param value="../common/css/jquery.loadmask.css" name="css" />
	<jsp:param value="../common/css/table.css" name="css" />
	<jsp:param value="css/cireports.css" name="css"/>
	<jsp:param value="true" name="changePage" />
	<jsp:param value="true" name="noSearchReport"/>
	<jsp:param value="${headerTitle}" name="titleLocalized" />
	<jsp:param value="${headerTitle}" name="headerTitleLocalized" />
	<jsp:param value="true" name="includeHistory" />
	<jsp:param value="true" name="includeTableSupport" />
	<jsp:param value="../common/css/custom-cb.css" name="css" />
	<jsp:param value="../facets/css/facetstyles.css" name="css" />
	<jsp:param value="../common/css/headerstyles.css" name="css" />
	<jsp:param value="../common/css/ui.spinner.css" name="css" />
	<jsp:param value="../common/css/jquery.loadmask.css" name="css" />
	<jsp:param value="../reports/css/reports.css" name="css" />		
	<jsp:param value="../common/css/table.css" name="css" />
	<jsp:param value="css/cireports.css" name="css" />
	<jsp:param value="css/fla.css" name="css" />
	<jsp:param value="css/nasAnalytics.css" name="css" />
	<jsp:param value="reports/reportsBase.jsp" name="jsp"/> 
</jsp:include>
<%@ include file="../reports/reportsBaseBody.jsp"%>

<div id="holder">
 <div id="ajaxBusyMail" class="center_it" style="margin:0 auto; display:none;"><img src="../common/img/loader.gif" /></div>
	<!-- Left side faceted menu bar -->
    <jsp:include page="sysDiscoveryFacets.jsp"></jsp:include>
	
	<!-- Container to show error -->
	<div id="errorDivId" class="errorDivClass"></div>	
	
	<!-- Initial summary of clients data -->
	<div id="summaryContent" class="clientSummary">
		<fmt:bundle basename="localization.CIReportsMessages">
			<fmt:message key="flasummary.placeHolder.client" var="placeHolderTextClient" />
			<fmt:message key="flasummary.placeHolder.clientGroup" var="placeHolderTextClientGrp" />
			<table id="sysDiscoveryClientsData_table" class="fsdata tablesorter">			
				<thead>
					<tr>					
						<th class="col-name">Client</th>
						<th class="col-clientType">Vendor</th>
						<th class="col-lastAnalytics">Last Analytics</th>
						<th class="col-action borderless" width='10%'><fmt:message key="flasummary.label.action"/></th> 
					</tr>
				</thead>
				<tbody id="clientsTBody"></tbody>
			</table>
			<!--div id="browsepager"></div-->
		</fmt:bundle>
	</div>
	
	<!-- Aggregate details of a particular client -->
	<div id="maincols" class="reportContent aggregateDetails" style="float:right; width:75%;display:none">
		<div class="ui-layout-center">
			<div class="ui-layout-content fla-layout">
				<div class="ContentWrapper">
					<div class="breadCrumbDiv">
						<div class="toolbar hideOnExportFriendly">					
							<div class="btn-group"> 
								<a class="splitBtn"	id="chartViewAggrs"	title="Chart View"><i class="imageIcon-center"></i></a>
								<a class="splitBtn"	id="fileListAggrs" title="Data View"><i class="imageIcon-right"></i></a>
							</div>
						</div>						
					</div>
					<div class="boxedChart boxed chartPanel">
						<div id="aggregate_chartTitle" class="nasChartTitle">Space Usage Of Aggregates</div>
						<div id="chartContainerAggrs" class="chartContainer"></div>
						<br><br><br>						
					</div>
					<div id="summaryContentAggrs" class="summaryContentDiv">
						<table id="sysDiscoveryAggregatesData_table" class="fsdata tablesorter">							
							<thead>
								<tr>					
									<th class="col-name">Aggregate Name</th>
									<th class="col-action borderless">Volume Count</th> 
									<th class="col-totalSpace borderless">Total Space</th>
									<th class="col-usedSpace borderless">Used Space</th>
									<th class="col-freeSpace borderless">Free Space</th>
									<th class="col-percentUsed borderless">Percent Used</th>
								</tr>
							</thead>
							<tbody id="aggrsTBody"></tbody>
						</table>
						<!--div id="browsepager"></div-->
				 </div>
				</div>
			</div>		
		</div>
			<div class="ui-layout-south">
				<jsp:include page="exportAndFilters.jsp"></jsp:include>
			</div>
		</div>
	
	<!-- Volume details of a particular client and aggregate -->
	<div id="maincols" class="reportContent volumeDetails" style="float:right; width:75%;display:none">
		<div class="ui-layout-center">
			<div class="ui-layout-content fla-layout">
				<div class="ContentWrapper">
					<div class="breadCrumbDiv">
						<div class="toolbar hideOnExportFriendly">					
							<div class="btn-group">
								<a class="splitBtn"	id="customBucketsVols"	title="Customize Categories"><i class="imageIcon-center2"></i></a> 
								<a class="splitBtn"	id="chartViewVols"	title="Chart View"><i class="imageIcon-center"></i></a>
								<a class="splitBtn"	id="fileListVols" title="Data View"><i class="imageIcon-right"></i></a>
							</div>
						</div>						
					</div>
					<div class="boxedChart boxed chartPanel">
						<div id="volume_chartTitle" class="nasChartTitle">Volumes Grouping By Free Space</div>
						<div id="chartContainerVols" class="chartContainer"></div>
						<br><br><br>						
					</div>
					<div id="summaryContentVols">
						<table id="sysDiscoveryVolumesData_table" class="fsdata tablesorter">							
							<thead>
								<tr>						
									<th class="col-volName">Volume Name</th>
									<th class="col-aggrName">Aggregate Name</th>
									<th class="col-totalSpace">Total Space GB</th>
									<th class="col-usedSpace">Used Space GB</th>
									<th class="col-freeSpace">Free Space GB</th>
									<th class="col-percentUsed">Percent Used</th>
									<th class="col-fileCount">File Count</th> 
								</tr>
							</thead>
							<tbody id="volsTBody"></tbody>
						</table>
						<!--div id="browsepager"></div-->
				 </div>
				</div>
			</div>		
		</div>
		</div>
		<!-- This is for customization option of categories for Volumes -->
		<jsp:include page="sysDiscoveryCustomFiltersVols.jsp"></jsp:include>
		
		<!-- LUN details -->	
	<div id="maincols" class="reportContent lunDetails" style="float:right; width:75%;display:none">
		<div class="ui-layout-center">
			<div class="ui-layout-content fla-layout">
				<div class="ContentWrapper">
					<div class="breadCrumbDiv">
						<div class="toolbar hideOnExportFriendly">					
							<div class="btn-group">
								<a class="splitBtn"	id="customBucketsLuns"	title="Customize Categories"><i class="imageIcon-center2"></i></a> 
								<a class="splitBtn"	id="chartViewLuns"	title="Chart View"><i class="imageIcon-center"></i></a>
								<a class="splitBtn"	id="fileListLuns" title="Data View"><i class="imageIcon-right"></i></a>
							</div>							
						</div>					
					</div>
					<div class="boxedChart boxed chartPanel">
						<div id="lun_chartTitle" class="nasChartTitle">LUNs Grouping By Free Space</div><!-- Space Usage Of LUNs -->
						<div id="chartContainerLuns" class="chartContainer"></div>
						<br><br><br>					
					</div>
					<div id="summaryContentLuns">
						<table id="sysDiscoveryLUNsData_table" class="fsdata tablesorter">							
							<thead>
								<tr>						
									<th class="col-lunName">LUN Name</th>
									<th class="col-volName">Volume Name</th>
									<th class="col-totalSpace">Total Space GB</th>
									<th class="col-usedSpace">Used Space GB</th>
									<th class="col-freeSpace">Free Space GB</th>
									<th class="col-percentUsed">Percent Used</th>
									<th class="col-os">OS</th> 
								</tr>
							</thead>
							<tbody id="lunsTBody"></tbody>
						</table>
						<!--div id="browsepager"></div-->
				 </div>
				</div>
			</div>		
		</div>
		</div>
		<!-- This is for customization option of categories for LUNs -->
		<jsp:include page="sysDiscoveryCustomFiltersLUNs.jsp"></jsp:include>
		
		<!-- SNAP details -->	
	<div id="maincols" class="reportContent snapDetails" style="float:right; width:75%;display:none">
		<div class="ui-layout-center">
			<div class="ui-layout-content fla-layout">
				<div class="ContentWrapper">
					<div class="breadCrumbDiv">
						<div class="toolbar hideOnExportFriendly">					
							<div class="btn-group">
								<a class="splitBtn"	id="customBucketsSnaps"	title="Customize Categories"><i class="imageIcon-center2"></i></a> 
								<a class="splitBtn"	id="chartViewSnaps"	title="Chart View"><i class="imageIcon-center"></i></a>
								<a class="splitBtn"	id="fileListSnaps" title="Data View"><i class="imageIcon-right"></i></a>
							</div>							
						</div>					
					</div>
					<div class="boxedChart boxed chartPanel">
						<div id="snap_chartTitle" class="nasChartTitle">SNAPs Grouping By Cumulative % of Used Blocks</div>
						<div id="chartContainerSnaps" class="chartContainer"></div>
						<br><br><br>					
					</div>
					<div id="summaryContentSnaps">
						<table id="sysDiscoverySnapsData_table" class="fsdata tablesorter">							
							<thead>
								<tr>						
									<th class="col-snapName">Snap Name</th>
									<th class="col-volName">Volume Name</th>
									<!-- <th class="col-isSnapBusy">Snap Busy</th>
									<th class="col-containsLunClones">Lun Clones</th> -->
									<th class="col-cumlTotBlocks">Cumul % of Total Blocks</th>
									<th class="col-cumlUsedBlocks">Cumul % of Used Blocks</th>
									<th class="col-totBlocks">% of Total Blocks</th>
									<th class="col-usedBlocks">% of Used Blocks</th>
									<th class="col-dependentApp">Application</th>
								</tr>
							</thead>
							<tbody id="snapsTBody"></tbody>
						</table>
						<!--div id="browsepager"></div-->
				 </div>
				</div>
			</div>		
		</div>
		</div>
		<!-- This is for customization option of categories for LUNs -->
		<jsp:include page="sysDiscoveryCustomFiltersSnaps.jsp"></jsp:include>
</div>

<div class="hidden noClients">
	<fmt:message key="no.computers.backedup" />
</div>
<script nonce="${sessionScope.cspNonce}" >
	var localMsg = localMsg || {};
	localMsg.placeHolderTextClient="${placeHolderTextClient}";
	localMsg.placeHolderTextClientGrp="${placeHolderTextClientGrp}";
	localMsg.showMoreClients="${showMoreClients}";
	localMsg.showLessClients="${showLessClients}";
</script>
<div class="clearFloat"></div>	
<jsp:include page="../common/footer.jsp">
	<jsp:param value="js/sysdiscovery/sysdiscoveryutil.js" name="js" />
	<jsp:param value="js/sysdiscovery/sysdiscoverysummary.js" name="js" />
	<jsp:param value="../common/js/jquery.corner.js" name="js" />
	<jsp:param value="../common/js/jquery.loadmask.min.js" name="js" />
	<jsp:param value="../common/js/jquery-layout.js" name="js" />
	<jsp:param value="../common/js/jquery.loadmask.cv.js" name="js"/>
	<jsp:param value="js/common/multiaccordion.js" name="js" />
	<jsp:param value="../common/js/highcharts/highcharts.js" name="js" />
	<jsp:param value="../common/js/jquery.corner.js" name="js" />
	<jsp:param value="../common/js/ba-debug.min.js" name="js" />
	<jsp:param value="../common/js/ui.spinner.min.js" name="js" />
	<jsp:param value="../common/js/custom-cb.js" name="js" />
	<jsp:param value="js/common/pagelayout.js" name="js" />
	<jsp:param value="js/sysdiscovery/sysdiscoveryaggregates.js" name="js" />
	<jsp:param value="js/sysdiscovery/sysdiscoveryvolumes.js" name="js" />
	<jsp:param value="js/sysdiscovery/sysdiscoveryluns.js" name="js" />
	<jsp:param value="js/sysdiscovery/sysdiscoverysnaps.js" name="js" />	
	<jsp:param value="../settings/settings.js" name="js" />
</jsp:include>