<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<fmt:bundle basename="localization.CIReportsMessages">
	<fmt:message key="File_Ownership" var="title" />
	<c:set var="clientGrp" value="${fn:escapeXml(param.clientGrp)}" />
	<c:set var="client" value="${fn:escapeXml(param.client)}" />
	<c:choose>
		<c:when test='${fn:length(clientGrp) eq 0}'>
			<c:set value="- ${fn:escapeXml(param.client)}" var="headerTitle" />
		</c:when>
		<c:otherwise>
			<c:set value="- ${fn:escapeXml(param.clientGrp)}" var="headerTitle" />
		</c:otherwise>
	</c:choose>
	<jsp:include page="../common/header.jsp">
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="true" name="analyticsChangePage" />
		<jsp:param value="true" name="exportOptions" />
		<jsp:param value="true" name="includeCROptions" />
		<jsp:param value="true" name="noSearchReport" />
		<jsp:param value="${title}" name="titleLocalized" />
		<jsp:param value="${title} ${headerTitle}" name="headerTitleLocalized" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="true" name="includeTableSupport" />
		<jsp:param value="../common/css/custom-cb.css" name="css" />
		<jsp:param value="../facets/css/facetstyles.css" name="css" />
		<jsp:param value="../common/css/headerstyles.css" name="css" />
		<jsp:param value="../common/css/ui.spinner.css" name="css" />
		<jsp:param value="../common/css/jquery.loadmask.css" name="css" />
		<jsp:param value="../reports/css/reports.css" name="css" />
		<jsp:param value="../common/css/table.css" name="css" />
		<jsp:param value="css/cireports.css" name="css" />
		<jsp:param value="css/fla.css" name="css" />
		<jsp:param value="../reports/css/actionButtons.css" name="css"/>
		<jsp:param value="cireports/cireportsBase.jsp" name="jsp" />
		<jsp:param value="facets/facetsBase.jsp" name="jsp" />
	</jsp:include>
	<jsp:include page="../reports/reportImportExport.jsp?${applicationScope.BUILD_TS}"></jsp:include>
	<%@ include file="../reports/reportsBaseBody.jsp"%>

	<div id="maincols" class="reportContent">
	<div class="breadCrumbDiv">
		<ul id="breadCrumbPanel">
		</ul>
	</div>
	<div class="clearFloat"></div>
		<div class="ui-layout-west hideOnExportFriendly" id="facet_pane" style="display:none;">
			<jsp:include page="includeFacet.jsp">
				<jsp:param value="true" name="resetFilterOpts" />
				<jsp:param value="${param.enableFilters}" name="enableFilters" />
			</jsp:include>
		</div>
		<div class="ui-layout-center"  id="content_pane">
			<div class="ui-layout-content fla-layout">
				<div id="ContentWrapper">
					<div>
						<div class="content" style="height: 32px;margin-bottom: 12px; display:none;">
							<ul id="topList">
								<li>
									<div class="fF searchBarDiv">
										<div class=sw_bd>
											<div class=sw_b>
												<INPUT type="text" id="sb_form_q" class="sw_qbox"
													title="Enter your search term" autocomplete="off" /> <input
													id="sb_form_go" class="sw_qbtn" title="Close" tabindex="0"
													type="button" name="go" />
											</div>
											<input class="g-button g-button-submit" name="Search"
												id="btnSearch" value="Search" type="button">

										</div>
									</div>
								</li>
							</ul>

						</div>
					</div>


					<div id="infoDiv" class="flaTools" ></div>
					<div id="tableWrapper" style="display: none;">
						<div>

							<jsp:include page="analyticstable.jsp">
								<jsp:param value="${param.accessTime}" name="accessTime" />
							</jsp:include>
						</div>
						<div id="ownershipInfoTable" style="display: none; margin-top: 10px;">
							<div>
								<fmt:bundle basename="localization.CIReportsMessages">
									<table id="fileOwners_table" class="fsdata tablesorter table dtable cell-border"
										style="text-align: center;">
										<thead>
											<tr>
												<th class="col-cvowner"><fmt:message key="CVOWNER"/></th>
												<th class="col-count"><fmt:message
														key="fla.tableColumn.count" /></th>
												<th class="col-size borderless"><fmt:message
														key="fla.tableColumn.size" /></th>
											</tr>
										</thead>
										<tbody id="filetablebody"></tbody>
									</table>
										<div id="browsepager"></div>
								</fmt:bundle>
							</div>
						</div>
						<jsp:include page="exportAndFilters.jsp"></jsp:include>
					</div>
				</div>
			</div>

		</div>
</div>
</fmt:bundle>
<jsp:include page="../common/footer.jsp">
<jsp:param value="../common/js/jquery.loadmask.cv.js" name="js"/>
	<jsp:param value="js/common/multiaccordion.js" name="js" />
	<jsp:param value="../common/js/ui.spinner.min.js" name="js" />
	<jsp:param value="../common/js/custom-cb.js" name="js" />
	<jsp:param value="js/fileanalytics/flautil.js" name="js" />
	<jsp:param value="js/common/additionalfiltermanager.js" name="js" />
	<jsp:param value="js/common/drilldowns.js" name="js" />
	<jsp:param value="js/common/flalib.js" name="js" />
	<jsp:param value="js/fileanalytics/ownership.js" name="js" />
</jsp:include>
