<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<fmt:bundle basename="localization.CIReportsMessages">
	<fmt:message key="FLA_DuplicateReport" var="headerTitle" />
	<fmt:message key="FLA_Report" var="FLATitle" />
	<fmt:message key="ANALYTICS" var="analyticsTitle" />
	<c:if test="${param.client != null }">
		<c:set var="title"
			value="${headerTitle} - ${fn:escapeXml(param.client)}"
			scope="session" />
	</c:if>
	<c:if test="${param.clientGrp != null }">
		<c:set var="title"
			value="${headerTitle} - ${fn:escapeXml(param.clientGrp)}"
			scope="session" />
	</c:if>
	<jsp:include page="../common/header.jsp">
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param
			value="${analyticsTitle}:dcube.do,${FLATitle}:cireports/index.jsp?component=appClients"
			name="breadCrumbValues" />
		<jsp:param value="true" name="exportOptions" />
		<jsp:param value="true" name="includeCROptions" />
		<jsp:param value="true" name="noSearchReport" />
		<jsp:param value="${title}" name="titleLocalized" />
		<jsp:param value="${title}" name="headerTitleLocalized" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="false" name="includeTableSupport" />
		<jsp:param value="../common/css/custom-cb.css" name="css" />
		<jsp:param value="../facets/css/facetstyles.css" name="css" />
		<jsp:param value="../common/css/headerstyles.css" name="css" />
		<jsp:param value="../common/css/ui.spinner.css" name="css" />
		<jsp:param value="../common/css/jquery.loadmask.css" name="css" />
		<jsp:param value="../common/bootstrap/css/icomoon.css" name="css" />		
		<jsp:param value="../reports/css/reports.css" name="css" />
		<jsp:param value="css/cireports.css" name="css" />
		<jsp:param value="../common/css/table.css" name="css" />
		<jsp:param value="css/fla.css" name="css" />
		<jsp:param value="../reports/css/actionButtons.css" name="css" />
		<jsp:param value="cireports/cireportsBase.jsp" name="jsp" />
		<jsp:param value="facets/facetsBase.jsp" name="jsp" />
	</jsp:include>

	<%@ include file="../reports/reportsBaseBody.jsp"%>
</fmt:bundle>
<div id="maincols" class="reportContent">

	<div class="breadCrumbDiv">
		<ul id="breadCrumbPanel">
		</ul>
		<span> <span class="content"
			style="height: 32px; margin-bottom: 12px; display: none;">
				<ul id="topList">
					<li>
						<div class="fF searchBarDiv">
							<div class=sw_bd>
								<div class=sw_b>
									<INPUT type="text" id="sb_form_q" class="sw_qbox"
										title="Enter your search term" autocomplete="off" /> <input
										id="sb_form_go" class="sw_qbtn" title="Close" tabindex="0"
										type="button" name="go" />
								</div>
								<input class="g-button g-button-submit" name="Search"
									id="btnSearch" value="Search" type="button">

							</div>
						</div>
					</li>
					<li>
						<div class="hideOnExportFriendly groupContent">
							<fmt:bundle basename="localization.CIReportsMessages">
								<span class="groupValue"> <fmt:message key="FLA_PlotDup" />
								</span>
								<select id="groupBy" class="pull-right">
									<option value="1"><fmt:message key="FLA_DupName" /></option>
									<option value="2"><fmt:message key="FLA_DupNameTime" /></option>
									<option value="3"><fmt:message
											key="FLA_DupNameTimeSize" /></option>
									<option value="4"><fmt:message key="FLA_DupContent" /></option>
								</select>
							</fmt:bundle>
						</div>
					</li>

				</ul>
		</span>
		</span>

	</div>
	<div class="clearFloat"></div>

	<div class="ui-layout-west" id="facet_pane" style="display: none;">
		<jsp:include page="includeFacet.jsp">
			<jsp:param value="true" name="resetFilterOpts" />
			<jsp:param value="${param.enableFilters}" name="enableFilters" />
		</jsp:include>
	</div>

	<div class="flaContentPanel ui-layout-center" id="content_pane">
		<div class="ui-layout-content fla-layout">
			<div id="ContentWrapper">
				<div id="infoDiv" class="flaTools"></div>


				<fmt:bundle basename="localization.CIReportsMessages">
					
					<div class="btn-toolbar hideOnExportFriendly" role="toolbar">
						<div class="btn-group cvBtnGroup" role="group" style="float:right;">

							<a class="btn btn-default btnTB active" id="duplicatesView"
								title="<fmt:message key="fla.label.dataView" />"> <span
								class="ico-list3"> </span>
							</a> <a class="btn btn-default btnTB" id="duplicatesTreeView"
								title="<fmt:message key="fla.label.chartView" />"> <span
								class="ico-stats-dots"> </span>
							</a>
						</div>
					</div>
					<div id="tableWrapper" style="display: none;">
						<div id="listInfoTable">
							<jsp:include page="analyticstable.jsp">
								<jsp:param value="${param.accessTime}" name="accessTime" />
							</jsp:include>
						</div>
						
						<div id="extInfoTable" style="display: none; margin-top: 10px;">
							<div>
								<table id="extensionTypes_table"
									class="tablesorter table dtable cell-border"
									style="text-align: center; margin-bottom: 0px">
									<thead>
										<tr>
											<th class="col-clientName"><fmt:message
													key="fla.tableColumn.clientName" /></th>
											<th class="col-extName" style="padding-left: 30px"><fmt:message
													key="table.column.filename" /></th>
											<th class="col-size" width='10%'><fmt:message
													key="fla.tableColumn.totalsize" /></th>
											<th class="col-count"><fmt:message
													key="fla.tableColumn.count" /></th>
										</tr>
									</thead>
									<tbody id="filetablebody"></tbody>
								</table>
							</div>							
						</div>
						<div id="duplicateTreeWrapper" style="display: none; margin-top: 10px;">							
							<div id="duplicatesTree" style="height: 100%;width:100%;"></div>
						</div>
					</div>

					<div id="dupSummary" class="dupStatus">
						<div class="recordsTotal"></div>
						<span> <fmt:message key="fla.files.size" /></span> <span
							class="dupStatusTitle totalflasize"> <span
							class="statusText"> </span> <span class="spinner ico-spinner9">
						</span>
						</span> <span> <fmt:message key="fla.files.count" /></span> <span
							class="dupStatusTitle totalflacount"> <span
							class="statusText"> </span> <span class="spinner ico-spinner9">
						</span>
						</span> <span> <fmt:message key="fla.dup.size" /></span> <span
							class="dupStatusTitle totaldupsize"> <span
							class="statusText"> </span> <span class="spinner ico-spinner9">
						</span>
						</span> <span> <fmt:message key="fla.dup.count" />
						</span> <span class="dupStatusTitle totaldupcount"> <span
							class="statusText"> </span> <span class="spinner ico-spinner9">
						</span>
						</span> <span class="dupStatusTitle partialComputationWarn"> <span
							class="computationWarnIco ico-warning2"></span> <span> <fmt:message
									key="fla.duplicate.computing" />
						</span>
						</span>
						<div style="clear: both;"></div>
					</div>
					<jsp:include page="exportAndFilters.jsp"></jsp:include>
				</fmt:bundle>
			</div>
		</div>

	</div>

</div>
</div>
</div>
<jsp:include page="flacustomfilters.jsp"></jsp:include>

<div class="clearFloat"></div>

<jsp:include page="../common/footer.jsp">
	<jsp:param value="../common/js/jquery-layout.js" name="js" />
	<jsp:param value="../common/js/jquery.loadmask.cv.js" name="js" />
	<jsp:param value="js/common/multiaccordion.js" name="js" />
	<jsp:param value="../common/js/jquery.corner.js" name="js" />
	<jsp:param value="../common/js/ba-debug.min.js" name="js" />
	<jsp:param value="../common/js/ui.spinner.min.js" name="js" />
	<jsp:param value="../common/js/custom-cb.js" name="js" />
	<jsp:param value="js/common/pagelayout.js" name="js" />
	<jsp:param value="js/common/drilldowns.js" name="js" />
	<jsp:param value="js/common/flalib.js" name="js" />
	<jsp:param value="js/fileanalytics/flautil.js" name="js" />
	<jsp:param value="../common/js/highcharts/highcharts.js" name="js" />
	<jsp:param value="../common/js/highcharts/treemap.js" name="js" />
	<jsp:param value="../common/kendoui/kendo.all.min.js" name="js" />
	<jsp:param value="js/fileanalytics/fladuplicates.js" name="js" />
	<jsp:param value="js/common/additionalfiltermanager.js" name="js" />
	<jsp:param value="../settings/settings.js" name="js" />
</jsp:include>
<script type="text/template" id="expandTable_template">
	<table width="100%" class="innerTable">
		<tbody id="expandTableBody">

		</tbody>
	</table>
</script>