<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<fmt:bundle basename="localization.CIReportsMessages">
	<fmt:message key="ANALYTICS" var="analyticsTitle" />
	<c:choose>
		<c:when test='${param.component != "fs"}'>
			<fmt:message key="EX_Analytics" var="title" />
		</c:when>
		<c:otherwise>
			<fmt:message key="FLA_Report" var="title" />
		</c:otherwise>
	</c:choose>
		<c:set var="clientGrp" value="${fn:escapeXml(param.clientGrp)}" />
		<c:set var="client" value="${fn:escapeXml(param.client)}" />
	<c:choose>
		<c:when test='${fn:length(clientGrp) eq 0}'>
			<c:set value="- ${fn:escapeXml(param.client)}" var="headerTitle" />
		</c:when>
		<c:otherwise>
			<c:set value="- ${fn:escapeXml(param.clientGrp)}" var="headerTitle" />
		</c:otherwise>
	</c:choose>
	<c:set var="standAloneReq" value="${fn:escapeXml(param.standAloneReq)}" />
	<c:choose>
		<c:when test="${not empty standAloneReq}">
			<%@ include file="flaBrowseStandAlone.jsp"%>
		</c:when>
		<c:otherwise>
			<c:choose>
				<c:when test='${param.component != "fs"}'>
					<c:set var="component" value="exchClients" />
				</c:when>
				<c:otherwise>
					<c:set var="component" value="appClients" />
				</c:otherwise>
			</c:choose>
			<jsp:include page="../common/header.jsp">
				<jsp:param value="true" name="includeSecHeader" />
				<jsp:param value="${analyticsTitle}:dcube.do,${title}:cireports/index.jsp?component=${component}" name="breadCrumbValues" />
				<jsp:param value="true" name="exportOptions" />
				<jsp:param value="true" name="includeCROptions" />
				<jsp:param value="true" name="noSearchReport" />
				<jsp:param value="${title}" name="titleLocalized" />
				<jsp:param value="${title} ${headerTitle}"
					name="headerTitleLocalized" />
				<jsp:param value="true" name="includeHistory" />
				<jsp:param value="false" name="includeTableSupport" />
				<jsp:param value="../common/css/custom-cb.css" name="css" />
				<jsp:param value="../facets/css/facetstyles.css" name="css" />
				<jsp:param value="../common/css/headerstyles.css" name="css" />
				<jsp:param value="../common/css/ui.spinner.css" name="css" />
				<jsp:param value="../common/css/jquery.loadmask.css" name="css" />
				<jsp:param value="../reports/css/reports.css" name="css" />
				<jsp:param value="../common/css/table.css" name="css" />
				<jsp:param value="css/cireports.css" name="css" />
				<jsp:param value="css/fla.css" name="css" />
				<jsp:param value="../reports/css/actionButtons.css" name="css" />
				<jsp:param value="cireports/cireportsBase.jsp" name="jsp" />
				<jsp:param value="facets/facetsBase.jsp" name="jsp" />
				<jsp:param value="../common/js/jquery.loadmask.cv.js" name="js" />
			</jsp:include>
	
	<%@ include file="../reports/reportsBaseBody.jsp"%>

	<div class="reportContent flaBrowseContent">
		<div class="ui-layout-west" id="facet_tree_pane" style="display:none;">
			<div id="leftcol1">
				<div class="treetitle"></div>
				<div id="browsetree"></div>
			</div>
		</div>
		<div class="ui-layout-center">
			<div class="ui-layout-content fla-browse-layout">
			<div class="flaBrowseInfo">
				<div class="dataAsOf" style="float:left;"></div>
				<div style="float:right">
				<div class="gotoReport hideOnExportFriendly">
					<a class="gotoReportLink disabled"><fmt:message key="fla.label.interactive" /></a>
				</div>
					<c:choose>
						<c:when test='${param.component!= "emails"}'>
					<div class="summaryOptionWrapper  hideOnExportFriendly" style="float:left;">
						<label id="summaryTypeLabel">
					 		<select id="summaryTypeSelect">
					 				<option value="nonStub" selected="selected"><fmt:message key="fla.label.archivable" /></option>
					 				<option value="stub" ><fmt:message key="fla.chart.archiveddata" /></option>
							</select>
					</label>
						</div>
						</c:when>
					</c:choose>
				</div>
			</div>
				<div id="flaBrowseContent">
					<!-- Append summary content here -->
				</div>
			</div>
			<div id="sizeInfo">
				<div class="objectCount"></div>
				<div class="sizeInfoData"></div>
			</div>
		</div>

		<div class="ui-layout-south"></div>
	</div>


<div class="clearFloat"></div>

<jsp:include page="../common/footer.jsp">
	<jsp:param value="js/common/flabrowse.js" name="js" />
</jsp:include>

	</c:otherwise>
</c:choose>

</fmt:bundle>
<script type="text/template" id="flaSummaryTemplate">
	<div class="summaryBox">
		<a class="interactiveLink" target="_blank"></a>
						<div id="ajaxBusyMail" class="center_it"
							style="margin: 0 auto; display: none;">
							<img src="../common/css/images/loading.gif" />
						</div>
<div>
<div class="summaryTitle"></div>
</div>
						<div class="summaryContent">
							<div
								class="flaBrowseBarContainer"
								style="margin-bottom: 10px;"></div>
						</div>
<div class="legendsContainer">
					<table class="summaryLegends"></table>
</div>
	</div>
</script>