<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<fmt:bundle basename="localization.CIReportsMessages">
	<fmt:message key="FLA_Report" var="title" />
	<fmt:message key="ANALYTICS" var="analyticsTitle" />
	<c:set var="clientGrp" value="${fn:escapeXml(param.clientGrp)}" />
	<c:set var="client" value="${fn:escapeXml(param.client)}" />
	<c:choose>
		<c:when test='${fn:length(clientGrp) eq 0}'>
			<c:set value="- ${fn:escapeXml(param.client)}" var="headerTitle" />
		</c:when>
		<c:otherwise>
			<c:set value="- ${fn:escapeXml(param.clientGrp)}" var="headerTitle" />
		</c:otherwise>
	</c:choose>
	<jsp:include page="../common/header.jsp">
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="${analyticsTitle}:dcube.do,${title}:cireports/index.jsp?component=appClients" name="breadCrumbValues" />
		<jsp:param value="true" name="exportOptions" />
		<jsp:param value="true" name="includeCROptions" />
		<jsp:param value="true" name="noSearchReport" />
		<jsp:param value="${title}" name="titleLocalized" />
		<jsp:param value="${title} ${headerTitle}" name="headerTitleLocalized" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="false" name="includeTableSupport" />
		<jsp:param value="../common/css/custom-cb.css" name="css" />
		<jsp:param value="../facets/css/facetstyles.css" name="css" />
		<jsp:param value="../common/css/headerstyles.css" name="css" />
		<jsp:param value="../common/css/ui.spinner.css" name="css" />
		<jsp:param value="../common/css/jquery.loadmask.css" name="css" />
		<jsp:param value="../common/bootstrap/css/icomoon.css" name="css" />
		<jsp:param value="../reports/css/reports.css" name="css" />
		<jsp:param value="../common/css/table.css" name="css" />
		<jsp:param value="css/cireports.css" name="css" />
		<jsp:param value="css/fla.css" name="css" />
		<jsp:param value="../reports/css/actionButtons.css" name="css" />
		<jsp:param value="cireports/cireportsBase.jsp" name="jsp" />
		<jsp:param value="facets/facetsBase.jsp" name="jsp" />
	</jsp:include>
	
	<%@ include file="../reports/reportsBaseBody.jsp"%>

	<div id="maincols" class="reportContent">
		<div class="breadCrumbDiv">
			<ul id="breadCrumbPanel">
			</ul>
			<div class="clearFloat"></div>
			<div class="fF searchBarDiv hideOnExportFriendly">
				<div class=sw_bd>
					<div class=sw_b>
						<INPUT type="text" id="sb_form_q" class="sw_qbox"
							title="Enter your search term" autocomplete="off" /> <input
							id="sb_form_go" class="sw_qbtn" title="Close" tabindex="0"
							type="button" name="go" />
					</div>
					<input class="g-button g-button-submit" name="Search"
						id="btnSearch" value="Search" type="button">

				</div>
			</div>
			<div class="btn-toolbar toolbar hideOnExportFriendly" role="toolbar">
 			<div class="btn-group cvBtnGroup" role="group">
 				<c:if test="${sessionScope.isFileOwnershipReporEnabled eq 'true'}">
				<a class="btn btn-default btnTB"
					id="fileownership_summary"
					title="<fmt:message key="fla.label.fileOwnership" />">
					<span class="ico-users"></span>
				</a>
				</c:if>
				<a class="btn btn-default btnTB"
					id="analytics_summary"
					title="<fmt:message key="fla.label.analyticsSummary" />">
						<span class="ico-content-paste"></span>
					</a>
					<a class="btn btn-default btnTB"
					id="custom_buckets"
					title="<fmt:message key="fla.label.customCategories" />">
					<span class="ico-cog2"></span>
					</a>
					<a class="btn btn-default btnTB" id="chartView_onDemand"
						title="<fmt:message key="fla.label.chartView" />">
						<span class="ico-stats-dots"> </span>
					</a>
					<a class="btn btn-default btnTB"
						id="fileList_onDemand"
						title="<fmt:message key="fla.label.dataView" />">
						<span class="ico-list3"> </span>
					</a>
					<a class="btn btn-default btnTB"	id="sizeDist_summary" title="<fmt:message key="fla.label.sizeDistView" />">
  						<span class="ico-pie-chart"> </span>
  					</a>
			</div>

			</div>
		</div>
		<div class="clearFloat"></div>
		<div class="clearFloat"></div>
		<div class="clearFloat"></div>
		<div class="clearFloat"></div>

		<div class="ui-layout-west hideOnExportFriendly" id="facet_pane"
			style="display: none;">
			<jsp:include page="includeFacet.jsp">
				<jsp:param value="true" name="resetFilterOpts" />
				<jsp:param value="${param.enableFilters}" name="enableFilters" />
			</jsp:include>
		</div>

		<div class="ui-layout-center" id="content_pane">
			<div class="ui-layout-content fla-layout">
				<div id="ContentWrapper">
					<div id="chartPanel" class="boxedChart boxed"
						style="display: none;">
						<div id="fla_chartTitle" class="boxedChartTitle"></div>

						<div id="fla_chartSecTitle"
							class="boxedChartTitle boxedChartSecTitle"></div>
						<div style="height:40px;">
							<div class="customCategoryApplied hideOnExportFriendly">
							Custom categories has been applied. Please click <a
								class="resetCustomCategories" href=""> here</a> to reset.
						</div>
							<div class="groupBySelectDiv hideOnExportFriendly">
							<select id="groupBySelectFLA">

							</select>
							</div>
						</div>


						<div id="chartcontainer_nodata" class="showifnodata">
							<fmt:message key="No_Data" />
						</div>
						<div id="chartcontainer"></div>
						<div class="item-queue top-right">
							<div class="item border-top-right fla-style" id="sticky_div">
								<div class="item-note" id="sticky_div"></div>
							</div>
						</div>

					</div>
					<div id="infoDiv" class="flaTools"></div>
					<div id="tableWrapper" style="display: none;">
						<div>
							<jsp:include page="analyticstable.jsp">
								<jsp:param value="${param.accessTime}" name="accessTime" />
							</jsp:include>
						</div>
						<div id="statsInfoTable" style="display: none; margin-top: 10px;">
							<div>
								<fmt:bundle basename="localization.CIReportsMessages">
									<table id="statsTypes_table" class="fsdata tablesorter table dtable cell-border"
										style="text-align: center;">
										<thead>
											<tr>
												<th class="col-clientName"><fmt:message
														key="fla.tableColumn.clientName" /></th>
												<th class="col-extName"><fmt:message
														key="fla.tableColumn.extension" /></th>
												<th class="col-count"><fmt:message
														key="fla.tableColumn.count" /></th>
												<th class="col-size borderless"><fmt:message
														key="fla.tableColumn.size" /></th>
											</tr>
										</thead>
										<tbody id="filetablebody"></tbody>
									</table>
									<div id="browsepager"></div>
								</fmt:bundle>
							</div>
						</div>
						<div id="categoryInfoDiv" style="display: none;">
							<table class="legendDetails">
								<tbody id="legendTblBody" style="font-size: 12px;">
								</tbody>
							</table>
						</div>
						<jsp:include page="exportAndFilters.jsp"></jsp:include>
					</div>
				</div>
			</div>

		</div>
		<jsp:include page="flacustomfilters.jsp"></jsp:include>

		<script type="text/template" id="statsSelect">
			<div class="statsSelectDiv hideOnExportFriendly">
				<label>
					<select class="statsSelectFLA">
						<option id="grpoption_EXT_NAME" value="grpoption_EXT_NAME"><fmt:message
														key="fla.tableColumn.extension" /></option>
						<option id="grpoption_CLIENTID" value="grpoption_CLIENTID"><fmt:message
														key="fla.tableColumn.clientName" /></option>
					</select>
				</label>
			</div>
		</script>
</fmt:bundle>
<div class="clearFloat"></div>
<jsp:include page="../common/footer.jsp">

	<jsp:param value="../common/js/jquery.loadmask.cv.js" name="js" />
	<jsp:param value="js/common/multiaccordion.js" name="js" />
	<jsp:param value="../common/js/highcharts/highcharts.js" name="js" />
	<jsp:param value="../common/js/jquery.corner.js" name="js" />
	<jsp:param value="../common/js/ba-debug.min.js" name="js" />
	<jsp:param value="../common/js/ui.spinner.min.js" name="js" />
	<jsp:param value="../common/js/custom-cb.js" name="js" />
	<jsp:param value="js/common/flalib.js" name="js" />
	<jsp:param value="js/common/drilldowns.js" name="js" />
	<jsp:param value="js/fileanalytics/flautil.js" name="js" />
	<jsp:param value="js/fileanalytics/fla.js" name="js" />
	<jsp:param value="js/common/flacustomfilter.js" name="js" />
	<jsp:param value="js/common/additionalfiltermanager.js" name="js" />
	<jsp:param value="../settings/settings.js" name="js" />
</jsp:include>
