<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.CIReportsMessages">
	<c:if test='${param.type == "eDiscovery" || param.type=="emailanalytics"}'>
	<div class="exportOptsContainer hideOnExportFriendly">
		<div id="exportUptoLabel">
			<fmt:message key="listing.export.label" />
		</div>
		<p style="float: left;">
			<input id="exportSizeSpinner" name="value" type="text" />
		</p>

	</div>
	</c:if>
	<div class="analyticsSummaryDiv">
		<div id="exportTableWrapper" style="display:none;">						
							<div>
								<fmt:bundle basename="localization.CIReportsMessages">
									<table id="exportStats_table" class="fsdata tablesorter table dtable cell-border">
										<thead>
											<tr>												
												<th class="col-category" rowspan="2"><fmt:message key="fla.category" /></th>
												<th colspan="2"><fmt:message key="fla.nonArchiveData" /></th>
												<th class="borderless" colspan="2"><fmt:message key="fla.archivedData" /></th>												
											</tr>
											<tr>
												<th><fmt:message key="Size_in_KB"/></th>
												<th><fmt:message key="fla.tableColumn.count"/></th>
												<th><fmt:message key="Size_in_KB"/></th>
												<th><fmt:message key="fla.tableColumn.count"/></th>
											</tr>
										</thead>
										<tbody id="filetablebody"></tbody>
									</table>
									<div id="browsepager"></div>
								</fmt:bundle>
							</div>						
		</div>
		<div class="analyticsDataStatus partialComputationWarn">
				<span class="computationWarnIco ico-warning2"></span>
				<span class="warningText"></span>
		</div>
		<div class="appliedFiltersDiv">
			<div class="filterText">
				<fmt:message key="fla.label.filters" />
			</div>
			<div class="summaryDiv summaryList">
				<ul class="fla-filterLst" id="appliedFilterLst">
				</ul>
			</div>
		</div>

		<div class="additionalFilters">
			<div class="additionalFilterText"></div>
			<div class="summaryDiv">
				<ul class="fla-filterLst" id="additionalFilterLst">
				</ul>
			</div>
		</div>
		<c:if test="${param.type != 'eDiscovery'}">
			<div class="searchKeywordDiv" id="searchKeywordid">
				<span class="searchText"><fmt:message key="search.keyword.label" /></span>
				<span class="searchKeywordText summaryDiv summaryList" id="searchKeywordspan"> </span>
			</div>
		</c:if>
		<c:if test="${param.type == 'emailanalytics'}">
			<div class="totalMailboxDiv">
				<span class="totalMailboxText"> <fmt:message key="mailbox.count.label" /></span>
				<span class="totalMailboxCount summaryDiv"> </span>
			</div>
		</c:if>
		<c:if test="${param.type == 'fileanalytics' || param.type == 'emailanalytics'}">
			<div class="filterLstContent archivedData" style="display: none;">
				<div class="filterCategory">
					<div class="filterCategoryHeader">
						<h3>
							<fmt:message key="fla.label.archived.summary" />
						</h3>
					</div>
					<div>
						<table class="filterSummaryTable">
							<tr>
								<td>
									<div class="filterLabel">
										<c:choose>
											<c:when test='${param.type != "emailanalytics"}'>
												<fmt:message key="fla.files.size" />
											</c:when>
											<c:otherwise>
												<fmt:message key="fla.email.size" />
											</c:otherwise>
										</c:choose>
									</div>

								</td>
								<td>
									<div class="summaryDiv">
										<span style="padding-right: 5px;" class="archivedDataSize"></span>
									</div>
								</td>

							</tr>
							<tr>
								<td>
									<div class="filterLabel">
										<c:choose>
											<c:when test='${param.type != "emailanalytics"}'>
												<fmt:message key="fla.files.count" />
											</c:when>
											<c:otherwise>
												<fmt:message key="fla.email.count" />
											</c:otherwise>
										</c:choose>
									</div>

								</td>
								<td>
									<div class="summaryDiv">
										<span style="padding-right: 5px;" class="archivedFileCount"></span>
									</div>
								</td>
								<td></td>
							</tr>
							<tr>
								<td>
									<div class="filterLabel">
										<fmt:message key="fla.data.percentage" />
									</div>

								</td>
								<td>
									<div class="summaryDiv">
										<span style="padding-right: 5px;" class="savingPercent"></span>
									</div>

								</td>
							</tr>
							<tr>
								<td><div class="summaryDiv">
										<span class="costLabel"> <fmt:message
												key="fla.label.cost" /></span><input
											class="costInput archivedDataSizeInByte hideOnExportFriendly"
											type="text" maxlength="5" data-attribute="costSavedInput"><span
											id="archivedCostValue"></span><span class="costLabel">/<fmt:message
												key="fla.size.gb" /></span>
									</div></td>
								<td>
									<div class="summaryDiv2">
										<div class="labelText">
											<span id="storageCostsSaved">NA</span>
										</div>
									</div>
								</td>
							</tr>
						</table>
					</div>
				</div>
			</div>
		
		
			<div class="filterLstContent nonArchivedData" style="display: none;">
				<div class="filterCategory">
					<div class="filterCategoryHeader">
						<h3>
							<fmt:message key="fla.label.summary" />
						</h3>
					</div>
					<div>
						<table class="filterSummaryTable">
							<tr>
								<td><div class="filterLabel">
										<c:choose>
											<c:when test='${param.type != "emailanalytics"}'>
												<fmt:message key="fla.files.size" />
											</c:when>
											<c:otherwise>
												<fmt:message key="fla.email.size" />
											</c:otherwise>
										</c:choose>
									</div></td>
								<td><div class="summaryDiv">
										<span style="padding-right: 5px;" class="totalDataSize"></span>
									</div></td>

							</tr>
							<tr>
								<td><div class="filterLabel">
										<c:choose>
											<c:when test='${param.type != "emailanalytics"}'>
												<fmt:message key="fla.files.count" />
											</c:when>
											<c:otherwise>
												<fmt:message key="fla.email.count" />
											</c:otherwise>
										</c:choose>
									</div></td>
								<td><div class="summaryDiv">
										<span style="padding-right: 5px;" class="totalObjectCount"></span>
									</div></td>

							</tr>

							<c:choose>
								<c:when test='${param.type == "duplicates"}'>
									<tr>
										<td><div class="filterLabel">
												<fmt:message key="fla.files.duplicates" />
											</div></td>
										<td><div class="summaryDiv">
												<span style="padding-right: 5px;"
													class="totalDupObjectCount"></span>
											</div></td>
									</tr>
								</c:when>

							</c:choose>
							<tr>
								<td>
									<div class="filterLabel">
										<fmt:message key="fla.data.percentage" />
									</div>
								</td>
								<td>
									<div class="summaryDiv">
										<span style="padding-right: 5px;"
											class="nonArchivedPercentage"></span>
									</div>
								</td>
							</tr>
							<tr>
								<td><div class="summaryDiv">
										<span class="costLabel"><fmt:message
												key="fla.label.cost" /></span><input
											class="costInput costSavingsInput hideOnExportFriendly"
											type="text" maxlength="5" data-attribute="costSavingsInput"><span
											id="costValue"></span> <span class="costLabel">/<fmt:message
												key="fla.size.gb" /></span>
									</div></td>
								<!-- <td>
								<div class="filterText">
									<fmt:message key="fla.label.storage" />
								</div>
								
							</td> -->
								<td>
									<div class="summaryDiv2">
										<div class="labelText">
											<span id="storageCosts">NA</span>
										</div>
									</div>
								</td>
							</tr>
						</table>
					</div>
				</div>
			</div>			
	</c:if>
</div>


</fmt:bundle>
<ul id="filterTemplate" style="display: none;">
	<li><span class="appliedFilter">#filter_Type#</span>
		<span class="filterValue">#filter_Name#</span></li>
</ul>
<ul id="additionalFilterTemplate" style="display: none;">
	<li><span style="padding-left: 5px;">#filter_Name#</span></li>
</ul>
