<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>


<jsp:include page="../reports/reportsBase.jsp"></jsp:include>
<c:set var="isExport" value="${fn:escapeXml(param.isExport)}" />
<c:choose>
    <c:when test="${param.isExport != null && param.isExport == 'true'}">
       <c:set var="includeColumnResizing" value="false" />
    </c:when>
    <c:otherwise>
        <c:set var="includeColumnResizing" value="true" />
    </c:otherwise>
</c:choose>
<jsp:include page="../common/datatables/dataTables.jsp">
	<jsp:param value="${includeColumnResizing}" name="includeColResize" />
	<jsp:param value="true" name="includeBootstrapCss" />
</jsp:include>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/cireports/js/common/cireportsbase.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/cireports/js/ediscovery/cloudlist.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/reports/js/reportActionButtons.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/js/hashMap.js?${applicationScope.BUILD_TS}"></script>
<link rel="stylesheet" type="text/css" href="${pageContext.request.contextPath}/cireports/css/table.css?${applicationScope.BUILD_TS}"/>
<link rel="stylesheet" type="text/css" href="${pageContext.request.contextPath}/cireports/css/exportOptions.css?${applicationScope.BUILD_TS}"/>


<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/bootstrap/js/moment.min.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/searchcomponents/js/cvSearchMessages.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/js/cvFormatters.js?${applicationScope.BUILD_TS}"></script>
<jsp:include page="exportOptions.jsp"></jsp:include>

<fmt:bundle basename="localization.CIReportsMessages">
	<fmt:message key="Others" var="Others" />
	<fmt:message key="Plot_By" var="Plot_By" />
	<fmt:message key="Enter_Client_Name" var="Enter_Client_Name" />
	<fmt:message key="Total_Num_Found" var="Total_Num_Found" />
	<fmt:message key="Loading" var="Loading" />
	<fmt:message key="Exporting" var="Exporting" />
	<fmt:message key="Close_Pane" var="Close_Pane" />
	<fmt:message key="Open_Pane" var="Open_Pane" />
	<fmt:message key="Resize_Pane" var="Resize_Pane" />
	<fmt:message key="ErrorInFetching" var="ErrorInFetching" />
	<fmt:message key="SearchCloud" var="SearchCloud" />
	<fmt:message key="fla.totalDataSize" var="TotalDataSize" />
	<fmt:message key="fla.table.NoExtFound" var="NoExtFoundText" />
	<fmt:message key="exch.table.NoMBFound" var="NoMBFoundText" />
	<fmt:message key="CLIENTID" var="Client" />
	<fmt:message key="Client_Group" var="Client_Group" />
	<fmt:message key="fla.mailboxFilter.label" var="MailBoxSelected" />
	<fmt:message key="FILE_ACCESSEDTIME" var="FileAccessTime" />
	<fmt:message key="fla.tableColumn.modified" var="ModifiedTime" />
	<fmt:message key="fla.tableColumn.received" var="RecievedTime" />
	<fmt:message key="fla.accessTime.docLabel" var="accessTimeDocLabel" />
	<fmt:message key="fla.navigation.on" var="flaNavigationOn" />
	<fmt:message key="fla.navigation.off" var="flaNavigationOff" />
	<fmt:message key="fla.navigation.loaderror" var="flaNavigationError" />
	<fmt:message key="FLA_Report" var="fileAnalytics" />
    <fmt:message key="EX_Analytics" var="emailAnalytics" />
    <fmt:message key="fla.additionalFilter.client" var="additionalFilterByClient" />
    <fmt:message key="searchresult.export.submitted" var="searchresultExportSubmitted" />
    <fmt:message key="fla.yAxis.sizeLabel" var="fileSize" />
    <fmt:message key="File_Type" var="docType" />
    <fmt:message key="eDiscovery" var="eDiscovery" />
    <fmt:message key="FLA_Duplicate" var="duplicates" />
    <fmt:message key="JOBID" var="jobs" />
    <fmt:message key="CVSTUB" var="archiveStatus" />
    <fmt:message key="No_DupData" var="nodupdata" />
    <fmt:message key="No_Data" var="nodata" />
    <fmt:message key="No_SearchData" var="nosearchdata" />
	<fmt:message key="JOBID" var="jobs" />
    <fmt:message key="exch.byAttachment.label" var="attachment" />
    <fmt:message key="table.column.filename" var="fileName" />
    <fmt:message key="filePath" var="filePath" />
    <fmt:message key="sizeinBytes" var="sizeinBytes" />
    <fmt:message key="CUSTODIAN" var="custodian" />
    <fmt:message key="FLA_DuplicateName" var="byname" />
    <fmt:message key="FLA_DuplicateNameTime" var="bynametime" />
    <fmt:message key="FLA_DuplicateNameTimeSize" var="bynametimesize" />
    <fmt:message key="FLA_DuplicateContent" var="bycontent" />
    <fmt:message key="ownership.table.NoOwnersFound" var="noOwnersFound" />
    <fmt:message key="table.column.subject" var="subject"/>
    <fmt:message key="data.asof" var="dataAsOf"/>
    <fmt:message key="downloadReports.status.NotAvailable" var="NotAvailable"/>
    <fmt:message key="downloadReports.status.Running" var="Running"/>
    <fmt:message key="downloadReports.status.AvailableForDownload" var="AvailableForDownload"/>
    <fmt:message key="downloadReports.status.InProgress" var="InProgress"/>
    <fmt:message key="downloadReports.status.PartiallyCompleted" var="PartiallyCompleted"/>
	<fmt:message key="downloadReports.status.Waiting" var="Waiting"/>
	<fmt:message key="downloadReports.status.Stopped" var="Stopped"/>
	<fmt:message key="downloadReports.status.Queued" var="Queued"/>
	<fmt:message key="downloadReports.status.Unpicked" var="Unpicked"/>
    <fmt:message key="downloadReports.status.UnknownError" var="UnknownError"/>
    <fmt:message key="downloadReports.status.Failed" var="Failed"/>
    <fmt:message key="downloadReports.status.Killed" var="Killed"/>
    <fmt:message key="downloadReports.status.Other" var="Other"/>
	<fmt:message key="downloadReports.status.FileAnalytics" var="FileAnalytics"/>
	<fmt:message key="downloadReports.status.EmailAnalytics" var="EmailAnalytics"/>
	<fmt:message key="downloadReports.status.FileDiscovery" var="FileDiscovery"/>
	<fmt:message key="downloadReports.status.EmailDiscovery" var="EmailDiscovery"/>
	<fmt:message key="downloadReports.status.FileDuplicate" var="FileDuplicate"/>
	<fmt:message key="downloadReports" var="DownloadReports"/>
	<fmt:message key="inputFormatNotSupported" var="InputFormatNotSupported"/>
	<fmt:message key="charatersNotAllowed" var="CharatersNotAllowed"/>
	<fmt:message key="emptyExportNameMsg" var="EmptyExportNameMsg"/>
	<fmt:message key="fla.commcell.summary.error" var="SummaryError"/>
	<fmt:message key="fla.files.size" var="SizeofFiles"/>
	<fmt:message key="fla.chart.toolTip.percentage" var="PercentageDist"/>
	<fmt:message key="fla.files.count" var="FilesCount"/>
	<fmt:message key="FLA_DupName" var="FileName"/>
	<fmt:message key="fla.duplicates" var="DuplicateFiles"/>
	<fmt:message key="fla.partial.report" var="partialReport"/>
	<fmt:message key="fla.tableColumn.backupendtime" var="backupendtime"/>
	
</fmt:bundle>
<script nonce="${sessionScope.cspNonce}" >
	var localMsg = localMsg || {};
	localMsg.plotByLabel = "${Plot_By}";
	localMsg.enterClientLabel = "${Enter_Client_Name}";
	localMsg.chartOthersLabel = "${Others}";
	localMsg.totalNumFoundLabel = "${Total_Num_Found}";
	localMsg.exporting = "${Exporting}";
	localMsg.loading = "${Loading}";
	localMsg.close = "${Close_Pane}";
	localMsg.resize = "${Resize_Pane}";
	localMsg.open = "${Open_Pane}";
	localMsg.ErrorInFetching = "${ErrorInFetching}";
	localMsg.TotalDataSize = "${TotalDataSize}";
	localMsg.SearchCloud = "${SearchCloud}";
	localMsg.NoExtFoundText = "${NoExtFoundText}";
	localMsg.NoDupFoundText = "${nodupdata}";
	localMsg.NoMBFoundText = "${NoMBFoundText}";
	localMsg.NoDataFoundText = "${nodata}";
	localMsg.NoSearchFoundText = "${nosearchdata}";
	localMsg.Client = "${Client}";
	localMsg.Client_Group = "${Client_Group}";
	localMsg.MailBoxSelected = "${MailBoxSelected}";
	localMsg.FileAccessTime = "${FileAccessTime}";
	localMsg.ModifiedTime = "${ModifiedTime}";
	localMsg.RecievedTime = "${RecievedTime}";
	localMsg.accessTimeDocLabel = "${accessTimeDocLabel}";
	localMsg.flaNavigationOn="${flaNavigationOn}";
	localMsg.flaNavigationOff="${flaNavigationOff}";
	localMsg.flaNavigationError="${flaNavigationError}";
	localMsg.fileAnalytics="${fileAnalytics}";
	localMsg.emailAnalytics="${emailAnalytics}";
	localMsg.eDiscovery="${eDiscovery}";
	localMsg.fileduplicates="${duplicates}";
	localMsg.additionalFilterByClient="${additionalFilterByClient}";
	localMsg.searchresultExportSubmitted ="${searchresultExportSubmitted}";
	localMsg.fileSize ="${fileSize}";
	localMsg.docType ="${docType}";
	localMsg.jobs ="${jobs}";
	localMsg.archiveStatus ="${archiveStatus}";
	localMsg.attachment ="${attachment}";
    localMsg.fileName ="${fileName}";
    localMsg.filePath ="${filePath}";
    localMsg.sizeinBytes ="${sizeinBytes}";
    localMsg.accessTime ="${accessTime}";
    localMsg.custodian ="${custodian}";
    localMsg.byname ="${byname}";
    localMsg.bynametime ="${bynametime}";
    localMsg.bynametimesize ="${bynametimesize}";
    localMsg.bycontent ="${bycontent}";
    localMsg.noOwnersFound ="${noOwnersFound}";
    localMsg.subject="${subject}";
    localMsg.dataAsOf="${dataAsOf}";
    localMsg.NotAvailable="${NotAvailable}";
    localMsg.Running="${Running}";
    localMsg.InProgress="${InProgress}";
    localMsg.AvailableForDownload="${AvailableForDownload}";
    localMsg.PartiallyCompleted="${PartiallyCompleted}";
	localMsg.Waiting="${Waiting}";
	localMsg.Stopped="${Stopped}";
	localMsg.Queued="${Queued}";
	localMsg.Unpicked="${Unpicked}";
    localMsg.UnknownError="${UnknownError}";
    localMsg.Failed="${Failed}";
	localMsg.Killed="${Killed}";
	localMsg.Other="${Other}";
	localMsg.FileAnalytics="${FileAnalytics}";
	localMsg.EmailAnalytics="${EmailAnalytics}";
	localMsg.FileDiscovery="${FileDiscovery}";
	localMsg.EmailDiscovery="${EmailDiscovery}";
	localMsg.FileDuplicate="${FileDuplicate}";
	localMsg.DownloadReports="${DownloadReports}";
	localMsg.InputFormatNotSupported="${InputFormatNotSupported}";
	localMsg.CharatersNotAllowed="${CharatersNotAllowed}";
	localMsg.EmptyExportNameMsg="${EmptyExportNameMsg}";
	localMsg.SummaryError="${SummaryError}";
	localMsg.SizeofFiles="${SizeofFiles}";
	localMsg.FilesCount="${FilesCount}";
	localMsg.FileName="${FileName}";
	localMsg.PercentageDist="${PercentageDist}";
	localMsg.DuplicateFiles="${DuplicateFiles}";
	localMsg.partialReport = "${partialReport}";
	localMsg.backupendtime = "${backupendtime}";
</script>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/cireports/js/common/exportFields.js?${applicationScope.BUILD_TS}"></script>
