/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.fonts.fop.fonts.CustomFont;
import org.docx4j.fonts.fop.fonts.EncodingMode;
import org.docx4j.fonts.fop.fonts.FontLoader;
import org.docx4j.fonts.fop.fonts.FontResolver;
import org.docx4j.fonts.fop.fonts.FontSetup;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.AbstractFontPart;
import org.docx4j.openpackaging.parts.PartName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrueTypeFontPart
extends AbstractFontPart {
    private static Logger log = LoggerFactory.getLogger(TrueTypeFontPart.class);

    public TrueTypeFontPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/x-font-ttf"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/font");
    }

    @Override
    public PhysicalFont extract(String fontNameAsInTablePart, String fontFileName, String fontKey, String filenamePrefix) {
        byte[] fontData = this.getBytes();
        log.debug("bytes: " + fontData.length);
        this.setF(new File(TrueTypeFontPart.getTmpFontDir(), filenamePrefix + "-" + fontFileName + ".ttf"));
        this.getF().deleteOnExit();
        String path = null;
        FileOutputStream fos = null;
        try {
            path = this.getF().getCanonicalPath();
            fos = new FileOutputStream(this.getF());
            fos.write(fontData);
            log.debug("wrote: " + fontData.length);
            fos.close();
        }
        catch (IOException e) {
            log.error("Problem with " + path);
            log.error(e.getMessage(), (Throwable)e);
        }
        FontResolver fontResolver = FontSetup.createMinimalFontResolver();
        if (log.isDebugEnabled()) {
            CustomFont customFont = null;
            try {
                log.debug("Loading from: " + path);
                String subFontName = null;
                boolean embedded = true;
                boolean useKerning = true;
                customFont = FontLoader.loadFont("file:" + path, subFontName, embedded, EncodingMode.AUTO, useKerning, fontResolver);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (customFont != null) {
                log.info("Successfully reloaded " + customFont.getFontName());
                if (customFont.isEmbeddable()) {
                    log.debug("confirmed embeddable");
                } else {
                    log.error("this embedded font claims it is not embeddable!");
                }
            }
        }
        try {
            List<PhysicalFont> fonts = PhysicalFonts.getPhysicalFont(fontNameAsInTablePart, new URL("file:" + path));
            return fonts == null || fonts.isEmpty() ? null : fonts.iterator().next();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

