/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.configuration;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.docx4j.fonts.fop.configuration.Configuration;
import org.docx4j.fonts.fop.configuration.ConfigurationException;
import org.docx4j.fonts.fop.configuration.NullConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultConfiguration
implements Configuration {
    static final DocumentBuilderFactory DBF = DocumentBuilderFactory.newInstance();
    private Element element;

    public static String toString(Document document) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    public DefaultConfiguration(String key) {
        DocumentBuilder builder = null;
        try {
            builder = DBF.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        Document doc = builder.newDocument();
        this.element = doc.createElement(key);
        doc.appendChild(this.element);
    }

    DefaultConfiguration(Element element) {
        this.element = element;
    }

    Element getElement() {
        return this.element;
    }

    public void addChild(DefaultConfiguration configuration) {
        Element node = (Element)this.element.getOwnerDocument().importNode(configuration.getElement(), true);
        this.element.appendChild(node);
    }

    String getValue0() {
        String result = this.element.getTextContent();
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public Configuration getChild(String key) {
        NodeList nl = this.element.getElementsByTagName(key);
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(key)) continue;
            return new DefaultConfiguration((Element)n);
        }
        return NullConfiguration.INSTANCE;
    }

    @Override
    public Configuration getChild(String key, boolean required) {
        Configuration result = this.getChild(key);
        if (!required && result == NullConfiguration.INSTANCE) {
            return null;
        }
        if (required && (result == null || result == NullConfiguration.INSTANCE)) {
            return NullConfiguration.INSTANCE;
        }
        return result;
    }

    @Override
    public Configuration[] getChildren(String key) {
        NodeList nl = this.element.getElementsByTagName(key);
        Configuration[] result = new Configuration[nl.getLength()];
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            result[i] = new DefaultConfiguration((Element)n);
        }
        return result;
    }

    @Override
    public String[] getAttributeNames() {
        NamedNodeMap nnm = this.element.getAttributes();
        String[] result = new String[nnm.getLength()];
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node n = nnm.item(i);
            result[i] = n.getNodeName();
        }
        return result;
    }

    @Override
    public String getAttribute(String key) {
        String result = this.element.getAttribute(key);
        if ("".equals(result)) {
            result = null;
        }
        return result;
    }

    @Override
    public String getAttribute(String key, String defaultValue) {
        String result = this.getAttribute(key);
        if (result == null || "".equals(result)) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public boolean getAttributeAsBoolean(String key, boolean defaultValue) {
        String result = this.getAttribute(key);
        if (result == null || "".equals(result)) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(result) || "yes".equalsIgnoreCase(result);
    }

    @Override
    public float getAttributeAsFloat(String key) throws ConfigurationException {
        return Float.parseFloat(this.getAttribute(key));
    }

    @Override
    public float getAttributeAsFloat(String key, float defaultValue) {
        String result = this.getAttribute(key);
        if (result == null || "".equals(result)) {
            return defaultValue;
        }
        return Float.parseFloat(result);
    }

    @Override
    public int getAttributeAsInteger(String key, int defaultValue) {
        String result = this.getAttribute(key);
        if (result == null || "".equals(result)) {
            return defaultValue;
        }
        return Integer.parseInt(result);
    }

    @Override
    public String getValue() throws ConfigurationException {
        String result = this.getValue0();
        if (result == null || "".equals(result)) {
            throw new ConfigurationException("No value in " + this.element.getNodeName());
        }
        return result;
    }

    @Override
    public String getValue(String defaultValue) {
        String result = this.getValue0();
        if (result == null || "".equals(result)) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public boolean getValueAsBoolean() throws ConfigurationException {
        return Boolean.parseBoolean(this.getValue0());
    }

    @Override
    public boolean getValueAsBoolean(boolean defaultValue) {
        String result = this.getValue0().trim();
        if ("".equals(result)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(result);
    }

    @Override
    public int getValueAsInteger() throws ConfigurationException {
        try {
            return Integer.parseInt(this.getValue0());
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Not an integer", e);
        }
    }

    @Override
    public int getValueAsInteger(int defaultValue) {
        String result = this.getValue0();
        if (result == null || "".equals(result)) {
            return defaultValue;
        }
        return Integer.parseInt(result);
    }

    @Override
    public float getValueAsFloat() throws ConfigurationException {
        try {
            return Float.parseFloat(this.getValue0());
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Not a float", e);
        }
    }

    @Override
    public float getValueAsFloat(float defaultValue) {
        String result = this.getValue0();
        if (result == null || "".equals(result)) {
            return defaultValue;
        }
        return Float.parseFloat(this.getValue0());
    }

    @Override
    public String getLocation() {
        ArrayList<String> path = new ArrayList<String>();
        for (Node el = this.element; el != null; el = el.getParentNode()) {
            if (!(el instanceof Element)) continue;
            path.add(el.getTagName());
        }
        Collections.reverse(path);
        StringBuilder sb = new StringBuilder();
        for (String s : path) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    static {
        DBF.setNamespaceAware(false);
        DBF.setValidating(false);
        DBF.setIgnoringComments(true);
        DBF.setIgnoringElementContentWhitespace(true);
        DBF.setExpandEntityReferences(true);
    }
}

