/*
 * Decompiled with CFR 0.152.
 */
package microsoft.aspnet.signalr.client.transport;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

public class NegotiationResponse {
    public static final double INVALID_KEEP_ALIVE_TIMEOUT = -1.0;
    private String mConnectionId;
    private String mConnectionToken;
    private String mUrl;
    private String mProtocolVersion;
    private double mDisconnectTimeout;
    private boolean mTryWebSockets;
    private double mKeepAliveTimeout;

    public NegotiationResponse(String jsonContent, JsonParser parser) {
        if (jsonContent == null || "".equals(jsonContent)) {
            return;
        }
        JsonObject json = parser.parse(jsonContent).getAsJsonObject();
        this.setConnectionId(json.get("ConnectionId").getAsString());
        this.setConnectionToken(json.get("ConnectionToken").getAsString());
        this.setUrl(json.get("Url").getAsString());
        this.setProtocolVersion(json.get("ProtocolVersion").getAsString());
        this.setDisconnectTimeout(json.get("DisconnectTimeout").getAsDouble());
        this.setTryWebSockets(json.get("TryWebSockets").getAsBoolean());
        JsonElement keepAliveElement = json.get("KeepAliveTimeout");
        if (keepAliveElement != null && !keepAliveElement.isJsonNull()) {
            this.setKeepAliveTimeout(keepAliveElement.getAsDouble());
        } else {
            this.setKeepAliveTimeout(-1.0);
        }
    }

    public String getConnectionId() {
        return this.mConnectionId;
    }

    public void setConnectionId(String connectionId) {
        this.mConnectionId = connectionId;
    }

    public String getConnectionToken() {
        return this.mConnectionToken;
    }

    public void setConnectionToken(String connectionToken) {
        this.mConnectionToken = connectionToken;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public String getProtocolVersion() {
        return this.mProtocolVersion;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.mProtocolVersion = protocolVersion;
    }

    public double getDisconnectTimeout() {
        return this.mDisconnectTimeout;
    }

    public void setDisconnectTimeout(double disconnectTimeout) {
        this.mDisconnectTimeout = disconnectTimeout;
    }

    public boolean shouldTryWebSockets() {
        return this.mTryWebSockets;
    }

    public void setTryWebSockets(boolean tryWebSockets) {
        this.mTryWebSockets = tryWebSockets;
    }

    public double getKeepAliveTimeout() {
        return this.mKeepAliveTimeout;
    }

    public void setKeepAliveTimeout(double keepAliveTimeout) {
        this.mKeepAliveTimeout = keepAliveTimeout;
    }
}

