/*
 * Decompiled with CFR 0.152.
 */
package microsoft.aspnet.signalr.client.transport;

import java.util.ArrayList;
import java.util.List;
import microsoft.aspnet.signalr.client.Action;
import microsoft.aspnet.signalr.client.ConnectionBase;
import microsoft.aspnet.signalr.client.ErrorCallback;
import microsoft.aspnet.signalr.client.LogLevel;
import microsoft.aspnet.signalr.client.Logger;
import microsoft.aspnet.signalr.client.NullLogger;
import microsoft.aspnet.signalr.client.SignalRFuture;
import microsoft.aspnet.signalr.client.http.HttpConnection;
import microsoft.aspnet.signalr.client.transport.ClientTransport;
import microsoft.aspnet.signalr.client.transport.ConnectionType;
import microsoft.aspnet.signalr.client.transport.DataResultCallback;
import microsoft.aspnet.signalr.client.transport.HttpClientTransport;
import microsoft.aspnet.signalr.client.transport.LongPollingTransport;
import microsoft.aspnet.signalr.client.transport.ServerSentEventsTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomaticTransport
extends HttpClientTransport {
    private List<ClientTransport> mTransports;
    private ClientTransport mRealTransport;

    public AutomaticTransport() {
        this(new NullLogger());
    }

    public AutomaticTransport(Logger logger) {
        super(logger);
        this.initialize(logger);
    }

    public AutomaticTransport(Logger logger, HttpConnection httpConnection) {
        super(logger, httpConnection);
        this.initialize(logger);
    }

    private void initialize(Logger logger) {
        this.mTransports = new ArrayList<ClientTransport>();
        this.mTransports.add(new ServerSentEventsTransport(logger));
        this.mTransports.add(new LongPollingTransport(logger));
    }

    @Override
    public String getName() {
        if (this.mRealTransport == null) {
            return "AutomaticTransport";
        }
        return this.mRealTransport.getName();
    }

    @Override
    public boolean supportKeepAlive() {
        if (this.mRealTransport != null) {
            return this.mRealTransport.supportKeepAlive();
        }
        return false;
    }

    private void resolveTransport(final ConnectionBase connection, final ConnectionType connectionType, final DataResultCallback callback, final int currentTransportIndex, final SignalRFuture<Void> startFuture) {
        final ClientTransport currentTransport = this.mTransports.get(currentTransportIndex);
        final SignalRFuture<Void> transportStart = currentTransport.start(connection, connectionType, callback);
        transportStart.done(new Action<Void>(){

            @Override
            public void run(Void obj) throws Exception {
                AutomaticTransport.this.mRealTransport = currentTransport;
                startFuture.setResult(null);
            }
        });
        final ErrorCallback handleError = new ErrorCallback(){

            public void onError(Throwable error) {
                if (AutomaticTransport.this.mRealTransport != null) {
                    startFuture.triggerError(error);
                    return;
                }
                AutomaticTransport.this.log(String.format("Auto: Faild to connect using transport %s. %s", currentTransport.getName(), error.toString()), LogLevel.Information);
                int next = currentTransportIndex + 1;
                if (next < AutomaticTransport.this.mTransports.size()) {
                    AutomaticTransport.this.resolveTransport(connection, connectionType, callback, next, startFuture);
                } else {
                    startFuture.triggerError(error);
                }
            }
        };
        transportStart.onError(handleError);
        startFuture.onCancelled(new Runnable(){

            public void run() {
                if (AutomaticTransport.this.mRealTransport != null) {
                    transportStart.cancel();
                    return;
                }
                handleError.onError(new Exception("Operation cancelled"));
            }
        });
    }

    @Override
    public SignalRFuture<Void> start(ConnectionBase connection, ConnectionType connectionType, DataResultCallback callback) {
        SignalRFuture<Void> startFuture = new SignalRFuture<Void>();
        this.resolveTransport(connection, connectionType, callback, 0, startFuture);
        return startFuture;
    }

    @Override
    public SignalRFuture<Void> send(ConnectionBase connection, String data, DataResultCallback callback) {
        if (this.mRealTransport != null) {
            return this.mRealTransport.send(connection, data, callback);
        }
        return null;
    }

    @Override
    public SignalRFuture<Void> abort(ConnectionBase connection) {
        if (this.mRealTransport != null) {
            return this.mRealTransport.abort(connection);
        }
        return null;
    }
}

