/*
 * Decompiled with CFR 0.152.
 */
package microsoft.aspnet.signalr.client.hubs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import microsoft.aspnet.signalr.client.Action;
import microsoft.aspnet.signalr.client.Connection;
import microsoft.aspnet.signalr.client.ConnectionState;
import microsoft.aspnet.signalr.client.InvalidStateException;
import microsoft.aspnet.signalr.client.LogLevel;
import microsoft.aspnet.signalr.client.Logger;
import microsoft.aspnet.signalr.client.hubs.HubInvocation;
import microsoft.aspnet.signalr.client.hubs.HubProxy;
import microsoft.aspnet.signalr.client.hubs.HubResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HubConnection
extends Connection {
    private Map<String, Action<HubResult>> mCallbacks = Collections.synchronizedMap(new HashMap());
    private Map<String, HubProxy> mHubs = Collections.synchronizedMap(new HashMap());
    private Integer mCallbackId = 0;

    public HubConnection(String url, String queryString, boolean useDefaultUrl, Logger logger) {
        super(HubConnection.getUrl(url, useDefaultUrl), queryString, logger);
    }

    public HubConnection(String url) {
        super(HubConnection.getUrl(url, true));
    }

    public HubConnection(String url, boolean useDefaultUrl) {
        super(HubConnection.getUrl(url, useDefaultUrl));
    }

    @Override
    public void onReceived(JsonElement message) {
        super.onReceived(message);
        this.log("Processing message", LogLevel.Information);
        if (this.getState() == ConnectionState.Connected) {
            if (message.isJsonObject() && message.getAsJsonObject().has("I")) {
                this.log("Getting HubResult from message", LogLevel.Verbose);
                HubResult result = (HubResult)this.mGson.fromJson(message, HubResult.class);
                String id = result.getId().toLowerCase(Locale.getDefault());
                this.log("Result Id: " + id, LogLevel.Verbose);
                this.log("Result Data: " + result.getResult(), LogLevel.Verbose);
                if (this.mCallbacks.containsKey(id)) {
                    this.log("Get and remove callback with id: " + id, LogLevel.Verbose);
                    Action<HubResult> callback = this.mCallbacks.remove(id);
                    try {
                        this.log("Execute callback for message", LogLevel.Verbose);
                        callback.run(result);
                    }
                    catch (Exception e) {
                        this.onError(e, false);
                    }
                }
            } else {
                HubInvocation invocation = (HubInvocation)this.mGson.fromJson(message, HubInvocation.class);
                this.log("Getting HubInvocation from message", LogLevel.Verbose);
                String hubName = invocation.getHub().toLowerCase(Locale.getDefault());
                this.log("Message for: " + hubName, LogLevel.Verbose);
                if (this.mHubs.containsKey(hubName)) {
                    HubProxy hubProxy = this.mHubs.get(hubName);
                    if (invocation.getState() != null) {
                        for (String key : invocation.getState().keySet()) {
                            JsonElement value = invocation.getState().get(key);
                            this.log("Setting state for hub: " + key + " -> " + value, LogLevel.Verbose);
                            hubProxy.setState(key, value);
                        }
                    }
                    String eventName = invocation.getMethod().toLowerCase(Locale.getDefault());
                    this.log("Invoking event: " + eventName + " with arguments " + HubConnection.arrayToString(invocation.getArgs()), LogLevel.Verbose);
                    try {
                        hubProxy.invokeEvent(eventName, invocation.getArgs());
                    }
                    catch (Exception e) {
                        this.onError(e, false);
                    }
                }
            }
        }
    }

    private static String arrayToString(JsonElement[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(args[i].toString());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getConnectionData() {
        JsonArray jsonArray = new JsonArray();
        for (String hubName : this.mHubs.keySet()) {
            JsonObject element = new JsonObject();
            element.addProperty("name", hubName);
            jsonArray.add((JsonElement)element);
        }
        String connectionData = jsonArray.toString();
        this.log("Getting connection data: " + connectionData, LogLevel.Verbose);
        return connectionData;
    }

    @Override
    protected void onClosed() {
        this.clearInvocationCallbacks("Connection closed");
        super.onClosed();
    }

    private void clearInvocationCallbacks(String error) {
        this.log("Clearing invocation callbacks: " + error, LogLevel.Verbose);
        HubResult result = new HubResult();
        result.setError(error);
        for (String key : this.mCallbacks.keySet()) {
            try {
                this.log("Invoking callback with empty result: " + key, LogLevel.Verbose);
                this.mCallbacks.get(key).run(result);
            }
            catch (Exception e) {}
        }
        this.mCallbacks.clear();
    }

    @Override
    protected void onReconnecting() {
        this.clearInvocationCallbacks("Reconnecting");
        super.onReconnecting();
    }

    public HubProxy createHubProxy(String hubName) {
        if (this.mState != ConnectionState.Disconnected) {
            throw new InvalidStateException(this.mState);
        }
        if (hubName == null) {
            throw new IllegalArgumentException("hubName cannot be null");
        }
        String hubNameLower = hubName.toLowerCase(Locale.getDefault());
        this.log("Creating hub proxy: " + hubNameLower, LogLevel.Information);
        HubProxy proxy = null;
        if (this.mHubs.containsKey(hubNameLower)) {
            proxy = this.mHubs.get(hubNameLower);
        } else {
            proxy = new HubProxy(this, hubName, this.getLogger());
            this.mHubs.put(hubNameLower, proxy);
        }
        return proxy;
    }

    String registerCallback(Action<HubResult> callback) {
        String id = this.mCallbackId.toString().toLowerCase(Locale.getDefault());
        this.log("Registering callback: " + id, LogLevel.Verbose);
        this.mCallbacks.put(id, callback);
        Integer n = this.mCallbackId;
        Integer n2 = this.mCallbackId = Integer.valueOf(this.mCallbackId + 1);
        return id;
    }

    void removeCallback(String callbackId) {
        this.log("Removing callback: " + callbackId, LogLevel.Verbose);
        this.mCallbacks.remove(callbackId.toLowerCase(Locale.getDefault()));
    }

    private static String getUrl(String url, boolean useDefaultUrl) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        if (useDefaultUrl) {
            return url + "signalr";
        }
        return url;
    }

    @Override
    protected String getSourceNameForLog() {
        return "HubConnection";
    }
}

