/*
 * Decompiled with CFR 0.152.
 */
package microsoft.aspnet.signalr.client.http.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import microsoft.aspnet.signalr.client.LogLevel;
import microsoft.aspnet.signalr.client.Logger;
import microsoft.aspnet.signalr.client.http.HttpConnectionFuture;
import microsoft.aspnet.signalr.client.http.Request;
import microsoft.aspnet.signalr.client.http.StreamResponse;

class NetworkRunnable
implements Runnable {
    HttpURLConnection mConnection = null;
    InputStream mResponseStream = null;
    Logger mLogger;
    Request mRequest;
    HttpConnectionFuture mFuture;
    HttpConnectionFuture.ResponseCallback mCallback;
    Object mCloseLock = new Object();

    public NetworkRunnable(Logger logger, Request request, HttpConnectionFuture future, HttpConnectionFuture.ResponseCallback callback) {
        this.mLogger = logger;
        this.mRequest = request;
        this.mFuture = future;
        this.mCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            int responseCode = -1;
            if (!this.mFuture.isCancelled()) {
                if (this.mRequest == null) {
                    this.mFuture.triggerError(new IllegalArgumentException("request"));
                    return;
                }
                this.mLogger.log("Execute the HTTP Request", LogLevel.Verbose);
                this.mRequest.log(this.mLogger);
                this.mConnection = NetworkRunnable.createHttpURLConnection(this.mRequest);
                this.mLogger.log("Request executed", LogLevel.Verbose);
                responseCode = this.mConnection.getResponseCode();
                this.mResponseStream = responseCode < 400 ? this.mConnection.getInputStream() : this.mConnection.getErrorStream();
            }
            if (this.mResponseStream != null && !this.mFuture.isCancelled()) {
                this.mCallback.onResponse(new StreamResponse(this.mResponseStream, responseCode, this.mConnection.getHeaderFields()));
                this.mFuture.setResult(null);
            }
        }
        catch (Throwable e) {
            if (!this.mFuture.isCancelled()) {
                if (this.mConnection != null) {
                    this.mConnection.disconnect();
                }
                this.mLogger.log("Error executing request: " + e.getMessage(), LogLevel.Critical);
                this.mFuture.triggerError(e);
            }
        }
        finally {
            this.closeStreamAndConnection();
        }
    }

    void closeStreamAndConnection() {
        try {
            if (this.mConnection != null) {
                this.mConnection.disconnect();
            }
            if (this.mResponseStream != null) {
                this.mResponseStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static HttpURLConnection createHttpURLConnection(Request request) throws IOException {
        URL url = new URL(request.getUrl());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(15000);
        connection.setRequestMethod(request.getVerb());
        Map<String, String> headers = request.getHeaders();
        for (String key : headers.keySet()) {
            connection.setRequestProperty(key, headers.get(key));
        }
        if (request.getContent() != null) {
            connection.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
            String requestContent = request.getContent();
            out.write(requestContent);
            out.close();
        }
        return connection;
    }
}

