/*
 * Decompiled with CFR 0.152.
 */
package microsoft.aspnet.signalr.client.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import microsoft.aspnet.signalr.client.Constants;
import microsoft.aspnet.signalr.client.http.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamResponse
implements Response {
    private BufferedReader mReader;
    private int mStatus;
    private InputStream mOriginalStream;
    Map<String, List<String>> mHeaders;

    public StreamResponse(InputStream stream, int status, Map<String, List<String>> headers) {
        this.mOriginalStream = stream;
        this.mReader = new BufferedReader(new InputStreamReader(this.mOriginalStream, Constants.UTF8));
        this.mHeaders = new HashMap<String, List<String>>(headers);
        this.mStatus = status;
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        int bytesRead = this.mOriginalStream.read(buffer, 0, bufferSize);
        while (bytesRead != -1) {
            for (int i = 0; i < bytesRead; ++i) {
                bytes.add(buffer[i]);
            }
            bytesRead = this.mOriginalStream.read(buffer, 0, bufferSize);
        }
        byte[] byteArray = new byte[bytes.size()];
        for (int i = 0; i < bytes.size(); ++i) {
            byteArray[i] = (Byte)bytes.get(i);
        }
        return byteArray;
    }

    @Override
    public String readToEnd() throws IOException {
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = this.mReader.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public int getStatus() {
        return this.mStatus;
    }

    @Override
    public String readLine() throws IOException {
        return this.mReader.readLine();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return new HashMap<String, List<String>>(this.mHeaders);
    }

    @Override
    public List<String> getHeader(String headerName) {
        return this.mHeaders.get(headerName);
    }
}

