/*
 * Decompiled with CFR 0.152.
 */
package microsoft.aspnet.signalr.client;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateSerializer
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    private static final int THREE_MILLISECONDS_DATE_FORMAT_LENGTH = 29;

    public Date deserialize(JsonElement element, Type type, JsonDeserializationContext ctx) throws JsonParseException {
        String strVal = element.getAsString();
        try {
            return DateSerializer.deserialize(strVal);
        }
        catch (ParseException e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    public JsonElement serialize(Date date, Type type, JsonSerializationContext ctx) {
        JsonPrimitive element = new JsonPrimitive(DateSerializer.serialize(date));
        return element;
    }

    public static Date deserialize(String strVal) throws ParseException {
        if (strVal.contains("+00:00")) {
            strVal = strVal.replace("+00:00", "");
        }
        String s = strVal.length() == 19 ? strVal + ".+00:00" : (strVal.contains(".Z") ? strVal.replace(".Z", ".+00:00") : strVal.replace("Z", ".+00:00"));
        try {
            if (s.length() > 29) {
                s = s.substring(0, 23) + s.substring(s.length() - 6);
            } else if (s.length() < 29) {
                int dif = 29 - s.length();
                String zeros = "";
                for (int i = 0; i < dif; ++i) {
                    zeros = zeros + "0";
                }
                s = s.substring(0, 20 + (3 - dif)) + zeros + s.substring(s.length() - 6);
            }
            s = s.substring(0, 26) + s.substring(27);
        }
        catch (IndexOutOfBoundsException e) {
            throw new JsonParseException("Invalid length for: " + s);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSSZ");
        dateFormat.setTimeZone(TimeZone.getDefault());
        Date date = dateFormat.parse(s);
        return date;
    }

    public static String serialize(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'", Locale.getDefault());
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String formatted = dateFormat.format(date);
        return formatted;
    }
}

