/*
 * Decompiled with CFR 0.152.
 */
package net.sf.packtag.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;

public class SafeLogger {
    private static Boolean log4jAvailable = null;
    private static Boolean commonsLoggingAvailable = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isLog4jAvailable() {
        if (log4jAvailable == null) {
            Class clazz = SafeLogger.class;
            synchronized (clazz) {
                if (log4jAvailable == null) {
                    try {
                        log4jAvailable = new Boolean(Class.forName("org.apache.log4j.Logger") != null);
                    }
                    catch (ClassNotFoundException e) {
                        log4jAvailable = Boolean.FALSE;
                    }
                }
            }
        }
        return log4jAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isCommonsLoggingAvailable() {
        if (commonsLoggingAvailable == null) {
            Class clazz = SafeLogger.class;
            synchronized (clazz) {
                if (commonsLoggingAvailable == null) {
                    try {
                        commonsLoggingAvailable = new Boolean(Class.forName("org.apache.commons.logging") != null);
                    }
                    catch (ClassNotFoundException e) {
                        commonsLoggingAvailable = Boolean.FALSE;
                    }
                }
            }
        }
        return commonsLoggingAvailable;
    }

    public static void error(Class sender, String message) {
        SafeLogger.error(sender, message, null);
    }

    public static void error(Class sender, String message, Exception exception) {
        if (SafeLogger.isLog4jAvailable()) {
            Logger.getLogger((Class)sender).error((Object)message, (Throwable)exception);
        } else if (SafeLogger.isCommonsLoggingAvailable()) {
            Log log = LogFactory.getLog((Class)sender);
            log.error((Object)message, (Throwable)exception);
        } else {
            System.err.println(sender.getName() + ": " + message);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }
}

