/*
 * Decompiled with CFR 0.152.
 */
package net.sf.packtag.util;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.servlet.ServletContext;
import net.sf.packtag.cache.provider.DefaultCacheProvider;
import net.sf.packtag.util.CharsetUtil;
import net.sf.packtag.util.SafeLogger;

public class ContextConfiguration {
    private static final String SLASH = "/";
    public static final String CACHE_TYPE_FILE = "file";
    public static final String CACHE_TYPE_SERVLET = "servlet";
    public static final String CACHE_TYPE_DISABLED = "disabled";
    public static final String SCRIPT_ASYNCDEFER_XHTML = "XHTML";
    public static final String SCRIPT_ASYNCDEFER_HTML5 = "HTML5";
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();
    private static Properties properties;
    private static String cacheFilePath;
    private static Charset charset;

    protected static Properties loadPropertyFile(ServletContext context) {
        InputStream is;
        Properties result = new Properties();
        try {
            is = context.getResourceAsStream("/WEB-INF/packtag.properties");
            if (is != null) {
                result.load(is);
            }
        }
        catch (Exception ex) {
            SafeLogger.error(ContextConfiguration.class, "Could not load file: /WEB-INF/packtag.properties", ex);
        }
        try {
            is = context.getResourceAsStream("/WEB-INF/packtag.user.properties");
            if (is != null) {
                result.load(is);
            }
        }
        catch (Exception ex) {
            SafeLogger.error(ContextConfiguration.class, "Could not load file: /WEB-INF/packtag.user.properties", ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Properties getProperties(ServletContext context) {
        if (properties == null) {
            Class clazz = ContextConfiguration.class;
            synchronized (clazz) {
                if (properties == null) {
                    properties = ContextConfiguration.loadPropertyFile(context);
                }
            }
        }
        return properties;
    }

    protected static String getCacheType(ServletContext context) {
        return ContextConfiguration.getProperty(context, "cache.type", CACHE_TYPE_SERVLET);
    }

    public static boolean isCachetypeDisabled(ServletContext context) {
        return CACHE_TYPE_DISABLED.equalsIgnoreCase(ContextConfiguration.getCacheType(context));
    }

    public static boolean isCachetypeServlet(ServletContext context) {
        return CACHE_TYPE_SERVLET.equalsIgnoreCase(ContextConfiguration.getCacheType(context));
    }

    public static boolean isCachetypeFile(ServletContext context) {
        return CACHE_TYPE_FILE.equalsIgnoreCase(ContextConfiguration.getCacheType(context));
    }

    protected static String getScriptAsyncDefer(ServletContext context) {
        return ContextConfiguration.getProperty(context, "script.asyncdefer", SCRIPT_ASYNCDEFER_XHTML);
    }

    public static boolean isScriptAsyncDeferXhtml(ServletContext context) {
        return SCRIPT_ASYNCDEFER_XHTML.equalsIgnoreCase(ContextConfiguration.getScriptAsyncDefer(context));
    }

    public static boolean isScriptAsyncDeferHtml5(ServletContext context) {
        return SCRIPT_ASYNCDEFER_HTML5.equalsIgnoreCase(ContextConfiguration.getScriptAsyncDefer(context));
    }

    public static boolean isFileCheckTimestamps(ServletContext context) {
        return ContextConfiguration.getProperty(context, "resources.checktimestamps", TRUE).equalsIgnoreCase(TRUE);
    }

    public static boolean isHideErros(ServletContext context) {
        return ContextConfiguration.getProperty(context, "hide.errors", FALSE).equalsIgnoreCase(TRUE);
    }

    public static boolean isTrackingResources(ServletContext context) {
        return ContextConfiguration.getProperty(context, "resources.tracking", TRUE).equalsIgnoreCase(TRUE);
    }

    public static boolean isExternalResourcesEnabled(ServletContext context) {
        return ContextConfiguration.getProperty(context, "resources.external", TRUE).equalsIgnoreCase(TRUE);
    }

    public static String getPackStrategyClassName(ServletContext context, String resourceType) {
        return ContextConfiguration.getProperty(context, resourceType + ".strategy");
    }

    protected static String getProperty(ServletContext context, String key) {
        String property = ContextConfiguration.getProperties(context).getProperty(key);
        if (null == property) {
            property = context.getInitParameter("packtag." + key);
        }
        return property;
    }

    protected static String getProperty(ServletContext context, String key, String defaultValue) {
        String property = ContextConfiguration.getProperty(context, key);
        return property != null ? property : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCacheFilePath(ServletContext context) {
        if (cacheFilePath == null) {
            Class clazz = ContextConfiguration.class;
            synchronized (clazz) {
                if (cacheFilePath == null) {
                    String path = ContextConfiguration.getProperty(context, "cache.file.path", "pack");
                    if (path.startsWith(SLASH)) {
                        path = path.substring(1, path.length());
                    }
                    if (path.endsWith(SLASH)) {
                        path = path.substring(0, path.length() - 1);
                    }
                    cacheFilePath = path;
                }
            }
        }
        return cacheFilePath;
    }

    public static String getCacheServletCombinedPath(ServletContext context, String strategyName) {
        String path = ContextConfiguration.getProperty(context, "cache.servlet.combined." + strategyName + ".path", "");
        if (path.startsWith(SLASH)) {
            path = path.substring(1, path.length());
        }
        if (!path.equals("") && !path.endsWith(SLASH)) {
            path = path + SLASH;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset getCharset(ServletContext context) {
        if (charset == null) {
            Class clazz = ContextConfiguration.class;
            synchronized (clazz) {
                if (charset == null) {
                    String resourcesCharsetName = ContextConfiguration.getProperty(context, "resources.charset");
                    String charsetName = ContextConfiguration.getProperty(context, "charset");
                    charset = resourcesCharsetName != null ? Charset.forName(resourcesCharsetName) : (charsetName != null ? Charset.forName(charsetName) : new CharsetUtil().getDefaultCharset());
                }
            }
        }
        return charset;
    }

    public static boolean isUrlRewriteEnabled(ServletContext context) {
        return ContextConfiguration.getProperty(context, "resources.rewrite", FALSE).equalsIgnoreCase(TRUE);
    }

    public static Class getCacheProviderClass(ServletContext context) {
        Class<?> result = null;
        String cacheProvider = ContextConfiguration.getProperty(context, "cache.provider", DefaultCacheProvider.class.getName());
        try {
            result = Class.forName(cacheProvider);
        }
        catch (ClassNotFoundException ex) {
            SafeLogger.error(ContextConfiguration.class, "Could not instantiate CacheProvider", ex);
        }
        return result;
    }

    public static String getCacheProviderPath(ServletContext context) {
        return ContextConfiguration.getProperty(context, "cache.provider.path");
    }
}

