/*
 * Decompiled with CFR 0.152.
 */
package net.sf.packtag.tag;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import net.sf.packtag.cache.PackCache;
import net.sf.packtag.cache.Resource;
import net.sf.packtag.implementation.DisabledPackStrategy;
import net.sf.packtag.strategy.PackException;
import net.sf.packtag.strategy.PackStrategy;
import net.sf.packtag.tag.BaseTag;
import net.sf.packtag.util.FileFetcher;
import net.sf.packtag.util.FilenameUtils;
import net.sf.packtag.util.URIUtils;

public abstract class PackTag
extends BaseTag {
    private static final long serialVersionUID = -3714373962322644845L;

    public int doStartTag() throws JspTagException {
        return 2;
    }

    public int doEndTag() throws JspException {
        String absolutePath = this.determineAbsolutePath(this.getSrc());
        boolean apDefined = absolutePath != null && !absolutePath.equals("");
        try {
            if (apDefined) {
                this.handleSingleResource(absolutePath, true);
            } else {
                this.handleCombinedResource();
            }
        }
        catch (PackException pex) {
            this.promoteError(pex.getMessage(), pex);
        }
        catch (Exception ex) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Pack did not perfom successfull on ");
            buffer.append(apDefined ? "'" + absolutePath + "': " : "combined Resource: ");
            buffer.append(ex.getMessage());
            this.promoteError(buffer.toString(), ex);
        }
        return 6;
    }

    private boolean handleSingleResource(String absolutePath, boolean writePackedResource) throws Exception {
        boolean reloaded = false;
        if (this.isAbsolutePathWildcard(absolutePath)) {
            reloaded = this.handleWildcardResource(absolutePath, writePackedResource);
        } else if (!this.isExternalResourcesEnabled() && this.isExternalResource(absolutePath)) {
            this.writeResouce(this.pageContext.getOut(), absolutePath);
        } else if (this.isEnabled()) {
            reloaded = this.handleSingleResourceDelegate(absolutePath);
            Resource resource = PackCache.getResourceByAbsolutePath(this.getServletContext(), absolutePath);
            if (!(!writePackedResource || this.isTrackingResources() && this.isResourceDelivered(absolutePath))) {
                this.writeResouce(this.pageContext.getOut(), resource.getMappedPath());
                this.addDeliveredResource(resource.getAbsolutePath());
            }
        } else {
            this.writeResouce(this.pageContext.getOut(), absolutePath);
        }
        return reloaded;
    }

    private boolean handleSingleResourceDelegate(String absolutePath) throws Exception {
        boolean reloaded = false;
        Resource resource = null;
        if (PackCache.existResource(this.getServletContext(), absolutePath)) {
            resource = PackCache.getResourceByAbsolutePath(this.getServletContext(), absolutePath);
            if (this.hasResourceChanged(resource)) {
                resource = this.reloadSingleResource(absolutePath);
                reloaded = true;
            }
        } else {
            resource = this.reloadSingleResource(absolutePath);
            reloaded = true;
        }
        return reloaded;
    }

    private boolean handleWildcardResource(String absolutePath, boolean writePackedResource) throws Exception {
        boolean reloaded = false;
        Resource resource = null;
        if (PackCache.existResource(this.getServletContext(), absolutePath)) {
            resource = PackCache.getResourceByAbsolutePath(this.getServletContext(), absolutePath);
            if (this.hasResourceChanged(resource)) {
                resource = this.reloadWildcardResource(absolutePath);
                reloaded = true;
            }
        } else {
            resource = this.reloadWildcardResource(absolutePath);
            reloaded = true;
        }
        if (this.isEnabled()) {
            if (!(!writePackedResource || this.isTrackingResources() && this.isResourceDelivered(absolutePath))) {
                this.writeResouce(this.pageContext.getOut(), resource.getMappedPath());
                this.addDeliveredResource(resource.getAbsolutePath());
            }
        } else {
            String[] aps = resource.getWildcardAbsolutePathsSplitted();
            for (int i = 0; i < aps.length; ++i) {
                this.writeResouce(this.pageContext.getOut(), aps[i]);
            }
        }
        return reloaded;
    }

    protected boolean isAbsolutePathWildcard(String absolutePath) {
        return absolutePath.endsWith("/**") || absolutePath.endsWith("/*");
    }

    private void handleCombinedResource() throws Exception {
        BodyContent bc = this.getBodyContent();
        String bodyString = bc.getString().trim();
        if (bodyString != null && !bodyString.equals("")) {
            boolean reloaded = false;
            List absolutePaths = this.parseBody(bodyString);
            if (absolutePaths.size() == 0) {
                throw new PackException("No resources were specified.");
            }
            Iterator iterAbsolutePaths = absolutePaths.iterator();
            while (iterAbsolutePaths.hasNext()) {
                String currentAbsolutePath = (String)iterAbsolutePaths.next();
                reloaded |= this.handleSingleResource(currentAbsolutePath, false);
                if (this.isExternalResourcesEnabled() || !this.isExternalResource(currentAbsolutePath)) continue;
                iterAbsolutePaths.remove();
            }
            if (this.isEnabled()) {
                Resource resource = this.handleMultipleAbsolutePaths(reloaded, absolutePaths);
                if (!this.isTrackingResources() || !this.areResourcesDelivered(absolutePaths)) {
                    this.writeResouce(this.pageContext.getOut(), resource.getMappedPath());
                    this.addDeliveredResources(absolutePaths);
                }
            }
        } else {
            throw new PackException("No resources were specified");
        }
    }

    private Resource handleMultipleAbsolutePaths(boolean reloaded, List absolutePaths) throws Exception {
        Resource resource = null;
        String combinedAbsolutePaths = absolutePaths.toString();
        resource = PackCache.existResource(this.getServletContext(), combinedAbsolutePaths) && !reloaded ? PackCache.getResourceByAbsolutePath(this.getServletContext(), combinedAbsolutePaths) : this.reloadCombinedResource(absolutePaths);
        return resource;
    }

    private List gatherWildcardAbsolutePaths(String absolutePathWithWildcard) {
        String wildcardLessPath = absolutePathWithWildcard.substring(0, absolutePathWithWildcard.lastIndexOf("/"));
        String startRealPath = this.pageContext.getServletContext().getRealPath(this.getContextlessPath(wildcardLessPath));
        File startDirectory = new File(startRealPath);
        File contextRoot = new File(this.pageContext.getServletContext().getRealPath("/"));
        boolean includeSubdirectories = absolutePathWithWildcard.endsWith("/**");
        FileFetcher ff = new FileFetcher(includeSubdirectories, this.getResourceExtension(), this.getContextPath());
        return ff.fetchFiles(contextRoot, startDirectory);
    }

    private InputStream getResourceStream(String absolutePath) throws PackException {
        InputStream result = null;
        if (this.isExternalResource(absolutePath)) {
            InputStream urlInputStream = null;
            try {
                URL url = new URL(absolutePath);
                URLConnection conn = url.openConnection();
                conn.setRequestProperty("Content-Type", this.getMimeType());
                urlInputStream = conn.getInputStream();
            }
            catch (IOException ioe) {
                throw new PackException("Could not load external resource: " + absolutePath, ioe);
            }
            result = urlInputStream;
        } else {
            String contextlessPath = this.getContextlessPath(absolutePath);
            if (this.isFileCheckTimestamps()) {
                String realPath = this.pageContext.getServletContext().getRealPath(contextlessPath);
                File file = new File(realPath);
                try {
                    result = new BufferedInputStream(new FileInputStream(file));
                }
                catch (FileNotFoundException fnfe) {
                    throw new PackException("Resource not found (" + absolutePath + ")", fnfe);
                }
            } else {
                result = this.pageContext.getServletContext().getResourceAsStream(contextlessPath);
            }
        }
        return result;
    }

    private Resource reloadSingleResource(String absolutePath) throws Exception {
        InputStream stream = this.getResourceStream(absolutePath);
        String rewriteAbsolutePath = this.isUrlRewriteEnabled() ? absolutePath : null;
        String packedResource = this.getPackStrategyDelegate().pack(stream, this.getCharset(), rewriteAbsolutePath);
        stream.close();
        Resource resource = new Resource(false, packedResource.hashCode());
        resource.setMinifedResource(packedResource);
        if (this.isCachetypeServlet()) {
            resource.setGzippedResource(this.gzipString(packedResource, "UTF-8"));
            resource.setMimeType(this.getMimeType());
        } else if (this.isCachetypeFile()) {
            this.storeFile(resource, packedResource);
        }
        if (this.isFileCheckTimestamps()) {
            resource.setFileTimestamp(this.getFileLastModifiedTimeStamp(this.getContextlessPath(absolutePath)));
        }
        resource.setAbsolutePath(absolutePath);
        resource.setMappedPath(this.determineMappedPath(resource));
        PackCache.store(this.getServletContext(), resource, true);
        return resource;
    }

    private Resource reloadWildcardResource(String absolutePath) throws Exception {
        Resource result = null;
        boolean reloaded = false;
        List files = this.gatherWildcardAbsolutePaths(absolutePath);
        Iterator iterFiles = files.iterator();
        while (iterFiles.hasNext()) {
            String file = (String)iterFiles.next();
            reloaded |= this.handleSingleResourceDelegate(file);
        }
        result = this.handleMultipleAbsolutePaths(reloaded, files);
        result = result.cloneObject();
        result.setWildcardAbsolutePaths(result.getAbsolutePath());
        result.setAbsolutePath(absolutePath);
        PackCache.store(this.getServletContext(), result, true);
        return result;
    }

    private Resource reloadCombinedResource(List absolutePaths) throws Exception {
        StringBuffer minifedBuffer = new StringBuffer();
        Iterator iterAps = absolutePaths.iterator();
        while (iterAps.hasNext()) {
            String currentAbsolutePath = (String)iterAps.next();
            Resource resource = PackCache.getResourceByAbsolutePath(this.getServletContext(), currentAbsolutePath);
            minifedBuffer.append(resource.getMinifedResource());
            minifedBuffer.append("\n");
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(minifedBuffer.toString().getBytes("UTF-8"));
        String packedResource = this.getPackStrategyDelegate().pack(stream, this.getCharset(), null);
        Resource resource = new Resource(true, packedResource.hashCode());
        resource.setMinifedResource(packedResource);
        if (this.isCachetypeServlet()) {
            resource.setGzippedResource(this.gzipString(packedResource, "UTF-8"));
            resource.setMimeType(this.getMimeType());
        } else if (this.isCachetypeFile()) {
            this.storeFile(resource, packedResource);
        }
        resource.setAbsolutePath(absolutePaths.toString());
        resource.setMappedPath(this.determineMappedPath(resource));
        PackCache.store(this.getServletContext(), resource, false);
        return resource;
    }

    private void storeFile(Resource resource, String packedResource) throws IOException {
        File fileAbsolutePath;
        String cacheFilePath = "/" + this.getCacheFilePath() + "/";
        String realPath = this.pageContext.getServletContext().getRealPath(cacheFilePath);
        File fileRealPath = new File(realPath);
        if (!fileRealPath.exists()) {
            fileRealPath.mkdirs();
        }
        if ((fileAbsolutePath = new File(FilenameUtils.concat(realPath, this.determineFileName(resource)))).exists()) {
            fileAbsolutePath.delete();
        }
        fileAbsolutePath.createNewFile();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileAbsolutePath), "UTF-8");
        writer.write(packedResource);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public String determineMappedPath(Resource resource) throws Exception {
        StringBuffer buffer = new StringBuffer();
        if (this.isCachetypeDisabled()) {
            buffer.append(resource.getAbsolutePath());
        } else if (this.isCachetypeServlet()) {
            if (resource.isCombined() || this.isExternalResource(resource.getAbsolutePath())) {
                buffer.append(this.getContextPath());
                buffer.append("/");
                buffer.append(this.getCacheServletCombinedPath(this.getStrategyName()));
                if (this.hasPrefix()) {
                    buffer.append(this.getPrefix());
                    buffer.append(".");
                }
                buffer.append(this.isExternalResource(resource.getAbsolutePath()) ? "external." : "combined.");
                buffer.append(this.getResourceExtension());
            } else {
                String cleanPath = URIUtils.cleanRelativePath(resource.getAbsolutePath());
                int indexWebInf = cleanPath.indexOf("/WEB-INF/");
                if (indexWebInf >= 0) {
                    buffer.append(cleanPath.substring(0, indexWebInf));
                    buffer.append(cleanPath.substring(indexWebInf + 8, cleanPath.length()));
                } else {
                    buffer.append(cleanPath);
                }
            }
            buffer.append(".h");
            buffer.append(resource.getMinifiedHashcode());
            buffer.append(".pack");
        } else if (this.isCachetypeFile()) {
            buffer.append(this.getContextPath());
            buffer.append("/");
            buffer.append(this.getCacheFilePath());
            buffer.append("/");
            buffer.append(this.determineFileName(resource));
        }
        return buffer.toString();
    }

    private String determineFileName(Resource resource) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("h");
        buffer.append(resource.getMinifiedHashcode());
        buffer.append(".");
        buffer.append(this.getResourceExtension());
        return buffer.toString();
    }

    private boolean hasResourceChanged(Resource resource) {
        boolean result = false;
        if (this.isFileCheckTimestamps() && !this.isExternalResource(resource.getAbsolutePath())) {
            if (resource.isWildcard()) {
                String[] wildcardAp = resource.getWildcardAbsolutePathsSplitted();
                for (int i = 0; i < wildcardAp.length; ++i) {
                    Resource r = PackCache.getResourceByAbsolutePath(this.getServletContext(), wildcardAp[i]);
                    result |= this.hasResourceChanged(r);
                }
            } else {
                long lastModified = this.getFileLastModifiedTimeStamp(this.getContextlessPath(resource.getAbsolutePath()));
                if (lastModified != resource.getFileTimestamp()) {
                    result = true;
                }
            }
        }
        return result;
    }

    private long getFileLastModifiedTimeStamp(String path) {
        String realPath = this.pageContext.getServletContext().getRealPath(path);
        File file = new File(realPath);
        return file.lastModified();
    }

    protected PackStrategy getPackStrategyDelegate() throws Exception {
        return Boolean.TRUE.equals(this.isMinify()) ? this.getPackStrategy() : new DisabledPackStrategy();
    }

    protected abstract void writeResouce(JspWriter var1, String var2) throws Exception;

    protected PackStrategy getPackStrategy() throws Exception {
        String className = this.getPackStrategyClassName(this.getStrategyName());
        if (className == null || className.equals("")) {
            return this.getResourceDefaultStrategy();
        }
        return (PackStrategy)Class.forName(className).newInstance();
    }

    protected abstract String getStrategyName();

    protected abstract PackStrategy getResourceDefaultStrategy();

    protected abstract String getResourceExtension();

    protected abstract String getMimeType();

    private String getContextlessPath(String absolutePath) {
        return absolutePath.substring(this.getContextPath().length(), absolutePath.length());
    }
}

