/*
 * Decompiled with CFR 0.152.
 */
package net.sf.packtag.servlet;

import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.packtag.cache.PackCache;
import net.sf.packtag.cache.Resource;
import net.sf.packtag.util.RequestUtil;

public class PackServlet
extends HttpServlet {
    private static final long serialVersionUID = 6588877416667767264L;
    private static final long ONE_YEAR = 31536000000L;
    private static final long TEN_YEARS = 315360000000L;
    private static final String ETAG_PREFIX = "pack";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CHARSET_UTF8 = ";charset=utf-8";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Resource resource = PackCache.getResourceByMappedPath(this.getServletContext(), request.getRequestURI());
        if (resource == null) {
            response.sendError(404, "The requested packed resource was not found.");
        } else {
            this.setHeaders(response, resource);
            if (this.isNotModifed(request, resource)) {
                response.setStatus(304);
            } else {
                this.writeResource(request, response, resource);
            }
        }
    }

    private void writeResource(HttpServletRequest request, HttpServletResponse response, Resource resource) throws IOException {
        if (RequestUtil.isGZipSupported(request)) {
            response.setHeader("Content-Encoding", "gzip");
            response.getOutputStream().write(resource.getGzippedResource());
        } else {
            response.getWriter().write(resource.getMinifedResource());
        }
    }

    private boolean isNotModifed(HttpServletRequest request, Resource resource) {
        StringBuffer selfMatch = new StringBuffer();
        selfMatch.append(ETAG_PREFIX);
        selfMatch.append(resource.getMinifiedHashcode());
        String self = selfMatch.toString();
        return self.equals(request.getHeader("If-None-Match"));
    }

    private void setHeaders(HttpServletResponse response, Resource resource) {
        response.setHeader("Cache-Control", "private");
        response.setDateHeader("Expires", new Date().getTime() + 315360000000L);
        response.setHeader("ETag", ETAG_PREFIX + Integer.toString(resource.getMinifiedHashcode()));
        response.setHeader(CONTENT_TYPE, resource.getMimeType() + CHARSET_UTF8);
        response.setHeader("X-Powered-By", "pack:tag");
    }
}

