/*
 * Decompiled with CFR 0.152.
 */
package net.sf.packtag.implementation.barryvan;

import java.util.regex.PatternSyntaxException;
import net.sf.packtag.implementation.barryvan.Value;

class Property
implements Comparable {
    protected String property;
    protected Value[] values;

    public Property(String property) throws Exception {
        try {
            String[] parts = property.split(":");
            if (parts.length < 2) {
                throw new Exception("Warning: Incomplete property: " + property);
            }
            this.property = parts[0].trim().toLowerCase();
            this.values = this.parseValues(parts[1].trim().replaceAll(", ", ","));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.property).append(":");
        for (int i = 0; i < this.values.length; ++i) {
            Value v = this.values[i];
            sb.append(v.toString()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(";");
        return sb.toString();
    }

    public int compareTo(Object other) {
        return this.property.compareTo(((Property)other).property);
    }

    private Value[] parseValues(String contents) {
        String[] parts = contents.split(",");
        Value[] results = new Value[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                results[i] = new Value(parts[i]);
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                results[i] = null;
            }
        }
        return results;
    }
}

