/*
 * Decompiled with CFR 0.152.
 */
package net.sf.packtag.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.packtag.filter.GzipResponseWrapper;
import net.sf.packtag.util.RequestUtil;

public class GzipFilter
implements Filter {
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            response.setHeader("X-Powered-By", "pack:tag");
            if (RequestUtil.isGZipSupported(request)) {
                GzipResponseWrapper wrappedResponse = new GzipResponseWrapper(response);
                chain.doFilter(req, (ServletResponse)wrappedResponse);
                wrappedResponse.finishResponse();
            } else {
                chain.doFilter(req, res);
            }
        } else {
            chain.doFilter(req, res);
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

