/*
 * Decompiled with CFR 0.152.
 */
package net.sf.packtag.cache.provider;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.packtag.cache.Resource;
import net.sf.packtag.cache.provider.AbstractCacheProvider;

public abstract class AbstractEhcacheProvider
extends AbstractCacheProvider {
    private final Cache resourcesAbsolutePath = this.getCacheManager().getCache("packtagResourcesAbsolutePath");
    private final Cache resourcesMappedPath = this.getCacheManager().getCache("packtagResourcesMappedPath");

    protected abstract CacheManager getCacheManager();

    public void clearCache() {
        this.resourcesAbsolutePath.removeAll();
        this.resourcesMappedPath.removeAll();
    }

    public boolean existResource(String absolutePath) {
        return this.resourcesAbsolutePath.isKeyInCache((Object)absolutePath);
    }

    public Resource getResourceByAbsolutePath(String absolutePath) {
        Resource result = null;
        Element elem = this.resourcesAbsolutePath.get((Serializable)((Object)absolutePath));
        if (elem != null) {
            result = (Resource)elem.getValue();
        }
        return result;
    }

    public Resource getResourceByMappedPath(String mappedPath) {
        Resource result = null;
        Element elem = this.resourcesMappedPath.get((Serializable)((Object)mappedPath));
        if (elem != null) {
            result = (Resource)elem.getValue();
        }
        return result;
    }

    public void store(Resource resource, boolean clearDependingCombinedResources) {
        this.resourcesAbsolutePath.put(new Element((Serializable)((Object)resource.getAbsolutePath()), (Serializable)resource));
        this.resourcesMappedPath.put(new Element((Serializable)((Object)resource.getMappedPath()), (Serializable)resource));
        if (clearDependingCombinedResources) {
            this.clearDependingCombinedResources(resource);
        }
    }

    public Set getAbsolutePathKeys() {
        return this.convertList(this.resourcesAbsolutePath.getKeysNoDuplicateCheck());
    }

    public Set getMappedPathKeys() {
        return this.convertList(this.resourcesMappedPath.getKeysNoDuplicateCheck());
    }

    private Set convertList(List list) {
        HashSet result = new HashSet();
        for (int i = 0; i < list.size(); ++i) {
            result.add(list.get(i));
        }
        return result;
    }

    public void removeAbsolutePath(String absolutePath) {
        this.resourcesAbsolutePath.remove((Serializable)((Object)absolutePath));
    }

    public void removeMappedPath(String mappedPath) {
        this.resourcesMappedPath.remove((Serializable)((Object)mappedPath));
    }
}

