/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.tomcat;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.security.FieldLookupAction;
import org.jboss.weld.security.MethodLookupAction;
import org.jboss.weld.security.SetAccessibleAction;

final class SecurityActions {
    private SecurityActions() {
    }

    static Method lookupMethod(Class<?> javaClass, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        if (System.getSecurityManager() != null) {
            try {
                return (Method)AccessController.doPrivileged(new MethodLookupAction(javaClass, methodName, (Class[])parameterTypes));
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)e.getCause();
                }
                throw new WeldException(e.getCause());
            }
        }
        return MethodLookupAction.lookupMethod(javaClass, (String)methodName, (Class[])parameterTypes);
    }

    static Field lookupField(Class<?> javaClass, String fieldName) throws NoSuchFieldException {
        if (System.getSecurityManager() != null) {
            try {
                return (Field)AccessController.doPrivileged(new FieldLookupAction(javaClass, fieldName));
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof NoSuchFieldException) {
                    throw (NoSuchFieldException)e.getCause();
                }
                throw new WeldException(e.getCause());
            }
        }
        return FieldLookupAction.lookupField(javaClass, (String)fieldName);
    }

    static void ensureAccessible(AccessibleObject accessibleObject) {
        if (accessibleObject != null && !accessibleObject.isAccessible()) {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(SetAccessibleAction.of((AccessibleObject)accessibleObject));
            } else {
                accessibleObject.setAccessible(true);
            }
        }
    }
}

